/*
    Scan Tailor - Interactive post-processing tool for scanned pages.
    Copyright (C) 2007-2008  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef FILTERRESULT_H_
#define FILTERRESULT_H_

#include "intrusive_ptr.h"
#include "ref_countable.h"

class AbstractFilter;
class FilterUiInterface;

class FilterResult : public ref_countable {
 public:
  virtual void updateUI(FilterUiInterface* ui) = 0;

  /**
   * \brief Return the filter that generated this result.
   * \note Returning a null smart pointer indicates that the result
   *       was generated by a task that doesn't belong to a filter.
   *       That would be LoadFileTask.
   */

  virtual intrusive_ptr<AbstractFilter> filter() = 0;
};


typedef intrusive_ptr<FilterResult> FilterResultPtr;

#endif
