/* 
    TowBowlTactics: Strategy game for X11

    Copyright (C) 2001-2003 Pascal Bourut (toweld@rocketmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef BALL_H
#define BALL_H

#include "global.h"
#include "Square.h"
#include "Dice.h"

/**
 * Classe representant l'objet ballon
 * @doc 
 * @author Toweld
 * @version 0.5
 */

class Ball{
 public:
  /** Constructeur par defaut */
  Ball();
  /** Constructeur a 1 parametre
   * @param b true si  le ballon est special, false sinon
   */
  Ball(bool);
  /** Destructeur par defaut */
  ~Ball();
  /** Definir si le ballon est special ou non
   * @param s true si  le ballon est special, false sinon
   */
  void set_special(bool);
  /** Placer le ballon dans une case
   * @param s Square dans laquelle on met le ballon
   */
  void place(Square *);
  /** Placer le ballon dans une case
   * @param x pos en x du ballon
   * @param y pos en y du ballon
   */
  void place(int,int);
  /** Recuperer l'endroit ou est le ballon
   * @return la case ou est le ballon
   */
  Square* get_square();
  /** Savoir si le ballon est special
   * @return true si special, false sinon
   */
  bool is_special();
  /** Savoir si le ballon est visible
   * @return true si visible, false sinon
   */
  bool is_visible();
	/** Positionner la visibilite
	* @param visible visibilite
    */
  void set_visible(bool);
  /** Faire rebondir le ballon
   */
  void bounce();

  void move(int,int);

  bool has_bounced(void);
  void set_has_bounced(bool);

  void save_state(FILE *,int);

 protected:
  bool special;
  bool visible;
  bool bounced;
  Square *square;

};

#endif
