/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.utils;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.tinfour.common.Vertex;

public class HilbertSort {
    double xMin;
    double xMax;
    double yMin;
    double yMax;

    private int xy2Hilbert(int px, int py, int n) {
        int x = px;
        int y = py;
        int s = 0;
        for (int i = n - 1; i >= 0; --i) {
            int xi = x >> i & 1;
            int yi = y >> i & 1;
            if (yi == 0) {
                int temp = x;
                x = y ^ -xi;
                y = temp ^ -xi;
            }
            s = 4 * s + 2 * xi + (xi ^ yi);
        }
        return s;
    }

    public boolean sort(List<Vertex> vertexList) {
        if (vertexList.isEmpty()) {
            return false;
        }
        Vertex v = vertexList.get(0);
        this.xMin = v.x;
        this.xMax = v.x;
        this.yMin = v.y;
        this.yMax = v.y;
        for (Vertex vertex : vertexList) {
            if (vertex.x < this.xMin) {
                this.xMin = vertex.x;
            } else if (vertex.x > this.xMax) {
                this.xMax = vertex.x;
            }
            if (vertex.y < this.yMin) {
                this.yMin = vertex.y;
                continue;
            }
            if (!(vertex.y > this.yMax)) continue;
            this.yMax = vertex.y;
        }
        double xDelta = this.xMax - this.xMin;
        double yDelta = this.yMax - this.yMin;
        if (xDelta == 0.0 || yDelta == 0.0) {
            return false;
        }
        if (vertexList.size() < 24) {
            return false;
        }
        double hn = Math.log(vertexList.size()) / 0.693147180559945 / 2.0;
        int nHilbert = (int)Math.floor(hn + 0.5);
        if (nHilbert < 4) {
            nHilbert = 4;
        }
        int[] savedIndices = new int[vertexList.size()];
        Vertex[] savedVertices = new Vertex[vertexList.size()];
        int kVertex = 0;
        Iterator<Vertex> iterator = vertexList.iterator();
        while (iterator.hasNext()) {
            Vertex vh;
            savedVertices[kVertex] = vh = iterator.next();
            savedIndices[kVertex] = vh.getIndex();
            ++kVertex;
        }
        double hScale = (double)(1 << nHilbert) - 1.0;
        for (Vertex vh : vertexList) {
            int ix = (int)(hScale * (vh.x - this.xMin) / xDelta);
            int iy = (int)(hScale * (vh.y - this.yMin) / yDelta);
            vh.setIndex(this.xy2Hilbert(ix, iy, nHilbert));
        }
        Collections.sort(vertexList, new Comparator<Vertex>(){

            @Override
            public int compare(Vertex o1, Vertex o2) {
                return o1.getIndex() - o2.getIndex();
            }
        });
        int k = 0;
        for (Vertex vh : savedVertices) {
            vh.setIndex(savedIndices[k++]);
        }
        return true;
    }
}

