/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.semivirtual;

import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Vertex;
import org.tinfour.edge.QuadEdgePinwheel;
import org.tinfour.semivirtual.SemiVirtualEdgePage;
import org.tinfour.semivirtual.SemiVirtualEdgePool;

public final class SemiVirtualEdge
implements IQuadEdge {
    private static final int LOW_BIT = 1;
    private static final int MASK_LOW_BIT_CLEAR = -2;
    final SemiVirtualEdgePool pool;
    SemiVirtualEdgePage page;
    int index;
    int indexOnPage;

    SemiVirtualEdge(SemiVirtualEdgePool pool, SemiVirtualEdgePage page, int index) {
        this.pool = pool;
        this.index = index;
        this.page = page;
        this.indexOnPage = index & 0x7FF;
    }

    SemiVirtualEdge(SemiVirtualEdgePool pool) {
        this.pool = pool;
    }

    SemiVirtualEdge copy() {
        return new SemiVirtualEdge(this.pool, this.page, this.index);
    }

    SemiVirtualEdge getUnassignedEdge() {
        return new SemiVirtualEdge(this.pool);
    }

    void loadFromEdge(SemiVirtualEdge e) {
        this.page = e.page;
        this.index = e.index;
        this.indexOnPage = e.indexOnPage;
    }

    void loadDualFromEdge(SemiVirtualEdge e) {
        this.page = e.page;
        this.index = e.index ^ 1;
        this.indexOnPage = e.indexOnPage ^ 1;
    }

    void loadDualFromForwardOfEdge(SemiVirtualEdge e) {
        int forwardIndex = e.page.links[e.indexOnPage * 2];
        this.loadEdgeForIndex(forwardIndex ^ 1);
    }

    void loadDualFromReverseOfEdge(SemiVirtualEdge e) {
        int reverseIndex = e.page.links[e.indexOnPage * 2 + 1];
        this.loadEdgeForIndex(reverseIndex ^ 1);
    }

    private void loadEdgeForIndex(int index) {
        this.page = this.pool.pages[index / 2048];
        this.index = index;
        this.indexOnPage = index & 0x7FF;
    }

    public void loadForwardFromEdge(SemiVirtualEdge e) {
        int forwardIndex = e.page.links[e.indexOnPage * 2];
        this.loadEdgeForIndex(forwardIndex);
    }

    public void loadReverseFromEdge(SemiVirtualEdge e) {
        int reverseIndex = e.page.links[e.indexOnPage * 2 + 1];
        this.loadEdgeForIndex(reverseIndex);
    }

    private SemiVirtualEdge getEdgeForIndex(int index) {
        int iPage = index / 2048;
        return new SemiVirtualEdge(this.pool, this.pool.pages[iPage], index);
    }

    @Override
    public Vertex getA() {
        int side = this.index & 1;
        int offset = this.indexOnPage & 0xFFFFFFFE;
        return this.page.vertices[offset | side];
    }

    @Override
    public Vertex getB() {
        int side = this.index & 1;
        int offset = this.indexOnPage & 0xFFFFFFFE;
        return this.page.vertices[offset | side ^ 1];
    }

    @Override
    public SemiVirtualEdge getForward() {
        int forwardIndex = this.page.links[this.indexOnPage * 2];
        return this.getEdgeForIndex(forwardIndex);
    }

    public Vertex getTriangleApex() {
        int forwardIndex = this.page.links[this.indexOnPage * 2];
        SemiVirtualEdgePage fpage = this.pool.pages[forwardIndex / 2048];
        int forwardIndexOnPage = forwardIndex & 0x7FF;
        return fpage.vertices[forwardIndexOnPage ^ 1];
    }

    public boolean isExterior() {
        int forwardIndex = this.page.links[this.indexOnPage * 2];
        SemiVirtualEdgePage fpage = this.pool.pages[forwardIndex / 2048];
        int forwardIndexOnPage = forwardIndex & 0x7FF;
        return fpage.vertices[forwardIndexOnPage | 1] == null;
    }

    @Override
    public SemiVirtualEdge getReverse() {
        int reverseIndex = this.page.links[this.indexOnPage * 2 + 1];
        return this.getEdgeForIndex(reverseIndex);
    }

    @Override
    public SemiVirtualEdge getDualFromReverse() {
        int reverseIndex = this.page.links[this.indexOnPage * 2 + 1];
        int dualIndexOfReverse = reverseIndex ^ 1;
        return this.getEdgeForIndex(dualIndexOfReverse);
    }

    @Override
    public SemiVirtualEdge getDual() {
        int dualIndex = this.index ^ 1;
        return this.getEdgeForIndex(dualIndex);
    }

    public void clear() {
        int offset = this.indexOnPage & 0xFFFFFFFE;
        this.page.vertices[offset] = null;
        this.page.vertices[offset + 1] = null;
        this.page.links[offset *= 2] = 0;
        this.page.links[offset + 1] = 0;
        this.page.links[offset + 2] = 0;
        this.page.links[offset + 3] = 0;
    }

    @Override
    public SemiVirtualEdge getBaseReference() {
        return this.getEdgeForIndex(this.index & 0xFFFFFFFE);
    }

    @Override
    public int getBaseIndex() {
        return this.index & 0xFFFFFFFE;
    }

    @Override
    public SemiVirtualEdge getForwardFromDual() {
        int forwardIndex = this.page.links[(this.indexOnPage ^ 1) * 2];
        return this.getEdgeForIndex(forwardIndex);
    }

    public SemiVirtualEdge getDualFromForward() {
        int forwardIndex = this.page.links[this.indexOnPage * 2];
        int dualIndexOfForward = forwardIndex ^ 1;
        return this.getEdgeForIndex(dualIndexOfForward);
    }

    @Override
    public SemiVirtualEdge getReverseFromDual() {
        int reverseIndex = this.page.links[(this.indexOnPage ^ 1) * 2 + 1];
        return this.getEdgeForIndex(reverseIndex);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public double getLength() {
        Vertex a = this.getA();
        Vertex b = this.getB();
        if (a == null || b == null) {
            return Double.NaN;
        }
        return a.getDistance(b);
    }

    @Override
    public int getSide() {
        return this.index & 1;
    }

    public void setA(Vertex a) {
        this.page.vertices[this.indexOnPage] = a;
    }

    public void setB(Vertex b) {
        this.page.vertices[this.indexOnPage ^ 1] = b;
    }

    public void setDualForward(SemiVirtualEdge forward) {
        int dualIndex = this.index ^ 1;
        int dualIndexOnPage = dualIndex & 0x7FF;
        this.page.links[dualIndexOnPage * 2] = forward.index;
        forward.page.links[forward.indexOnPage * 2 + 1] = dualIndex;
    }

    public void setDualReverse(SemiVirtualEdge reverse) {
        int dualIndex = this.index ^ 1;
        int dualIndexOnPage = dualIndex & 0x7FF;
        this.page.links[dualIndexOnPage * 2 + 1] = reverse.index;
        reverse.page.links[reverse.indexOnPage * 2] = dualIndex;
    }

    public void setForward(SemiVirtualEdge e) {
        this.page.links[this.indexOnPage * 2] = e.index;
        e.page.links[e.indexOnPage * 2 + 1] = this.index;
    }

    public void setReverse(SemiVirtualEdge e) {
        this.page.links[this.indexOnPage * 2 + 1] = e.index;
        e.page.links[e.indexOnPage * 2] = this.index;
    }

    public void setVertices(Vertex a, Vertex b) {
        int side = this.indexOnPage & 1;
        int offset = this.indexOnPage & 0xFFFFFFFE;
        this.page.vertices[offset | side] = a;
        this.page.vertices[offset | side ^ 1] = b;
    }

    public String toString() {
        Vertex a = this.getA();
        Vertex b = this.getB();
        if (a == null && b == null) {
            return String.format("%9d -- Undefined", this.getIndex());
        }
        int r = this.page.links[this.indexOnPage * 2 + 1];
        int f = this.page.links[this.indexOnPage * 2];
        String s = String.format("%9d  %9s <-- (%9s,%9s) --> %9s", this.index, r == 0 ? "null" : Integer.toString(r), a == null ? "gv" : a.getLabel(), b == null ? "gv" : b.getLabel(), f == 0 ? "null" : Integer.toString(f));
        return s;
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + this.index;
        return hash;
    }

    public boolean equals(Object o) {
        if (o instanceof SemiVirtualEdge) {
            return this.index == ((SemiVirtualEdge)o).getIndex();
        }
        return false;
    }

    @Override
    public int getConstraintIndex() {
        if (this.page.constraints == null) {
            return 0;
        }
        int test = this.page.constraints[this.indexOnPage / 2];
        return test & 0xFFFFFF;
    }

    @Override
    public void setConstraintIndex(int constraintIndex) {
        if (constraintIndex < 0 || constraintIndex > 0xFFFFFC) {
            throw new IllegalArgumentException("Constraint index " + constraintIndex + " is out of range [0.." + 0xFFFFFC + "]");
        }
        int ix = this.indexOnPage / 2;
        int[] c = this.page.readyConstraints();
        c[ix] = c[ix] & 0xFF000000 | constraintIndex;
    }

    @Override
    public void setConstrained(int constraintIndex) {
        if (constraintIndex < 0 || constraintIndex > 0xFFFFFC) {
            throw new IllegalArgumentException("Constraint index " + constraintIndex + " is out of range [0.." + 0xFFFFFC + "]");
        }
        int ix = this.indexOnPage / 2;
        int[] c = this.page.readyConstraints();
        c[ix] = Integer.MIN_VALUE | c[ix] & 0xFF000000 | constraintIndex;
    }

    @Override
    public boolean isConstrained() {
        if (this.page.constraints == null) {
            return false;
        }
        return this.page.constraints[this.indexOnPage / 2] < 0;
    }

    @Override
    public boolean isConstrainedRegionBorder() {
        if (this.page.constraints == null) {
            return false;
        }
        int test = this.page.constraints[this.indexOnPage / 2];
        return (test & 0x40000000) != 0;
    }

    @Override
    public boolean isConstrainedRegionInterior() {
        if (this.page.constraints == null) {
            return false;
        }
        return (this.page.constraints[this.indexOnPage / 2] & 0x20000000) != 0;
    }

    @Override
    public boolean isConstrainedRegionMember() {
        if (this.page.constraints == null) {
            return false;
        }
        return (this.page.constraints[this.indexOnPage / 2] & 0x60000000) != 0;
    }

    @Override
    public void setConstrainedRegionBorderFlag() {
        int ix = this.indexOnPage / 2;
        int[] c = this.page.readyConstraints();
        int n = ix;
        c[n] = c[n] | 0x40000000;
    }

    @Override
    public void setConstrainedRegionInteriorFlag() {
        int ix = this.indexOnPage / 2;
        int[] c = this.page.readyConstraints();
        int n = ix;
        c[n] = c[n] | 0x20000000;
    }

    @Override
    public boolean isConstraintLineMember() {
        if (this.page.constraints == null) {
            return false;
        }
        int flags = this.page.constraints[this.indexOnPage / 2];
        return (flags & Integer.MIN_VALUE) != 0 && (this.index & 0x60000000) == 0;
    }

    @Override
    public void setConstraintLineMemberFlag() {
        int ix = this.indexOnPage / 2;
        int[] c = this.page.readyConstraints();
        int n = ix;
        c[n] = c[n] | 0x90000000;
    }

    @Override
    public Iterable<IQuadEdge> pinwheel() {
        return new QuadEdgePinwheel(this);
    }

    @Override
    public void setSynthetic(boolean status) {
        int ix = this.indexOnPage / 2;
        int[] c = this.page.readySynthetic();
        int cIndex = ix / 32;
        int cBit = ix & 0x1F;
        int cMask = 1 << cBit;
        if (status) {
            int n = cIndex;
            c[n] = c[n] | cMask;
        } else {
            int n = cIndex;
            c[n] = c[n] & cMask;
        }
    }

    @Override
    public boolean isSynthetic() {
        int cBit;
        int cMask;
        int cIndex;
        int ix = this.indexOnPage / 2;
        int[] c = this.page.readySynthetic();
        return (c[cIndex = ix / 32] & (cMask = 1 << (cBit = ix & 0x1F))) != 0;
    }

    @Override
    public void setLine2D(AffineTransform transform, Line2D l2d) {
        Vertex A = this.getA();
        Vertex B = this.getB();
        double[] c = new double[8];
        if (A == null && B == null) {
            l2d.setLine(0.0, 0.0, 0.0, 0.0);
            return;
        }
        if (A == null) {
            c[0] = B.getX();
            c[1] = B.getY();
            c[2] = B.getX();
            c[3] = B.getY();
        } else if (B == null) {
            c[0] = A.getX();
            c[1] = A.getY();
            c[2] = A.getX();
            c[3] = A.getY();
        } else {
            c[0] = A.getX();
            c[1] = A.getY();
            c[2] = B.getX();
            c[3] = B.getY();
        }
        transform.transform(c, 0, c, 4, 2);
        l2d.setLine(c[4], c[5], c[6], c[7]);
    }
}

