/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.content.animation.animator;

import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import org.openimaj.content.animation.animator.LinearIntegerValueAnimator;
import org.openimaj.content.animation.animator.ValueAnimator;

public class RandomLinearIntegerValueAnimator
implements ValueAnimator<Integer> {
    private int seed;
    Uniform rng;
    LinearIntegerValueAnimator animator;
    private int min;
    private int max;
    private int duration;

    public RandomLinearIntegerValueAnimator(int min, int max, int duration) {
        this.seed = (int)System.nanoTime();
        this.min = min;
        this.max = max;
        this.duration = duration;
        this.reset();
    }

    public RandomLinearIntegerValueAnimator(int min, int max, int duration, int initial) {
        this(min, max, duration);
        this.setNextAnimator(initial);
    }

    public RandomLinearIntegerValueAnimator(int startWait, int stopWait, int min, int max, int duration) {
        this.seed = (int)System.currentTimeMillis();
        this.min = min;
        this.max = max;
        this.duration = duration;
        this.reset();
    }

    public RandomLinearIntegerValueAnimator(int startWait, int stopWait, int min, int max, int duration, int initial) {
        this(min, max, duration);
        this.setNextAnimator(initial);
    }

    @Override
    public Integer nextValue() {
        if (this.animator.hasFinished()) {
            this.setNextAnimator((Integer)this.animator.nextValue());
        }
        return (Integer)this.animator.nextValue();
    }

    @Override
    public boolean hasFinished() {
        return false;
    }

    @Override
    public void reset() {
        this.rng = new Uniform((RandomEngine)new MersenneTwister(this.seed));
        int v1 = this.rng.nextIntFromTo(this.min, this.max);
        this.setNextAnimator(v1);
    }

    protected void setNextAnimator(int v1) {
        int v2 = this.rng.nextIntFromTo(this.min, this.max);
        this.animator = new LinearIntegerValueAnimator(v1, v2, this.duration);
    }
}

