/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jcodec.common.io.AutoResource;

public class AutoPool {
    private static AutoPool instance = new AutoPool();
    private List<AutoResource> resources = Collections.synchronizedList(new ArrayList());
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    private AutoPool() {
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                long curTime = System.currentTimeMillis();
                List res = AutoPool.this.resources;
                for (AutoResource autoResource : res) {
                    autoResource.setCurTime(curTime);
                }
            }
        }, 0L, 100L, TimeUnit.MILLISECONDS);
    }

    public static AutoPool getInstance() {
        return instance;
    }

    public void add(AutoResource res) {
        this.resources.add(res);
    }
}

