/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.model;

import gov.sandia.cognition.learning.algorithm.bayes.VectorNaiveBayesCategorizer;
import gov.sandia.cognition.learning.data.DefaultInputOutputPair;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.statistics.DataHistogram;
import gov.sandia.cognition.statistics.distribution.UnivariateGaussian;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openimaj.math.model.EstimatableModel;
import org.openimaj.util.pair.IndependentPair;

public class UnivariateGaussianNaiveBayesModel<T>
implements EstimatableModel<Double, T> {
    private VectorNaiveBayesCategorizer<T, UnivariateGaussian.PDF> model;

    public UnivariateGaussianNaiveBayesModel() {
    }

    public UnivariateGaussianNaiveBayesModel(VectorNaiveBayesCategorizer<T, UnivariateGaussian.PDF> model) {
        this.model = model;
    }

    @Override
    public boolean estimate(List<? extends IndependentPair<Double, T>> data) {
        VectorNaiveBayesCategorizer.BatchGaussianLearner learner = new VectorNaiveBayesCategorizer.BatchGaussianLearner();
        ArrayList<DefaultInputOutputPair> cfdata = new ArrayList<DefaultInputOutputPair>();
        for (IndependentPair<Double, T> d : data) {
            DefaultInputOutputPair iop = new DefaultInputOutputPair((Object)VectorFactory.getDefault().createVector1D(((Double)d.firstObject()).doubleValue()), d.secondObject());
            cfdata.add(iop);
        }
        this.model = learner.learn(cfdata);
        return true;
    }

    @Override
    public T predict(Double data) {
        return (T)this.model.evaluate((Vectorizable)VectorFactory.getDefault().createVector1D(data.doubleValue()));
    }

    @Override
    public int numItemsToEstimate() {
        return 0;
    }

    public UnivariateGaussianNaiveBayesModel<T> clone() {
        try {
            return (UnivariateGaussianNaiveBayesModel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public UnivariateGaussian getClassDistribution(T clz) {
        return (UnivariateGaussian)((List)this.model.getConditionals().get(clz)).get(0);
    }

    public Map<T, UnivariateGaussian> getClassDistribution() {
        HashMap clzs = new HashMap();
        for (Object c : this.model.getCategories()) {
            clzs.put(c, ((List)this.model.getConditionals().get(c)).get(0));
        }
        return clzs;
    }

    public DataHistogram<T> getClassPriors() {
        return this.model.getPriors();
    }

    public static void main(String[] args) {
        UnivariateGaussianNaiveBayesModel model = new UnivariateGaussianNaiveBayesModel();
        ArrayList<IndependentPair> data = new ArrayList<IndependentPair>();
        data.add(IndependentPair.pair((Object)0.0, (Object)true));
        data.add(IndependentPair.pair((Object)0.1, (Object)true));
        data.add(IndependentPair.pair((Object)-0.1, (Object)true));
        data.add(IndependentPair.pair((Object)9.9, (Object)false));
        data.add(IndependentPair.pair((Object)10.0, (Object)false));
        data.add(IndependentPair.pair((Object)10.1, (Object)false));
        model.estimate((List)data);
        System.out.println(model.predict(5.1));
        System.out.println(model.model.getConditionals().get(true));
        System.out.println(model.model.getConditionals().get(false));
        System.out.println(((UnivariateGaussian.PDF)((List)model.model.getConditionals().get(true)).get(0)).getMean());
        System.out.println(((UnivariateGaussian.PDF)((List)model.model.getConditionals().get(true)).get(0)).getVariance());
        System.out.println(((UnivariateGaussian.PDF)((List)model.model.getConditionals().get(false)).get(0)).getMean());
        System.out.println(((UnivariateGaussian.PDF)((List)model.model.getConditionals().get(false)).get(0)).getVariance());
        System.out.println(model.model.getPriors());
    }
}

