/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.matrix.algorithm.pca;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import org.openimaj.math.matrix.MatrixUtils;
import org.openimaj.math.matrix.algorithm.pca.PrincipalComponentAnalysis;
import org.openimaj.util.array.ArrayUtils;

public class CovarPrincipalComponentAnalysis
extends PrincipalComponentAnalysis {
    int ndims;

    public CovarPrincipalComponentAnalysis() {
        this(-1);
    }

    public CovarPrincipalComponentAnalysis(int ndims) {
        this.ndims = ndims;
    }

    @Override
    protected void learnBasisNorm(Matrix m) {
        Matrix covar = m.transpose().times(m);
        EigenvalueDecomposition eig = covar.eig();
        Matrix all_eigenvectors = eig.getV();
        this.basis = this.ndims > 0 ? all_eigenvectors.getMatrix(0, all_eigenvectors.getRowDimension() - 1, Math.max(0, all_eigenvectors.getColumnDimension() - this.ndims), all_eigenvectors.getColumnDimension() - 1) : all_eigenvectors;
        this.eigenvalues = eig.getRealEigenvalues();
        double norm = 1.0 / (double)(m.getRowDimension() - 1);
        int i = 0;
        while (i < this.eigenvalues.length) {
            int n = i++;
            this.eigenvalues[n] = this.eigenvalues[n] * norm;
        }
        MatrixUtils.reverseColumnsInplace(this.basis);
        ArrayUtils.reverse((double[])this.eigenvalues);
    }
}

