/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.tree;

import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.procedure.TObjectFloatProcedure;
import jal.objects.BinaryPredicate;
import jal.objects.Sorting;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openimaj.util.array.ArrayUtils;
import org.openimaj.util.array.IntArrayView;
import org.openimaj.util.pair.FloatIntPair;
import org.openimaj.util.pair.IntFloatPair;
import org.openimaj.util.queue.BoundedPriorityQueue;

public class FloatKDTree {
    public final KDTreeNode root;
    public final float[][] data;

    public FloatKDTree(float[][] data) {
        this.data = data;
        this.root = new KDTreeNode(data, new IntArrayView(ArrayUtils.range(0, data.length - 1)), new BBFMedianSplit());
    }

    public FloatKDTree(float[][] data, SplitChooser split) {
        this.data = data;
        this.root = new KDTreeNode(data, new IntArrayView(ArrayUtils.range(0, data.length - 1)), split);
    }

    public float[][] coordinateRangeSearch(float[] lowerExtreme, float[] upperExtreme) {
        final ArrayList results = new ArrayList();
        this.rangeSearch(lowerExtreme, upperExtreme, new TIntObjectProcedure<float[]>(){

            public boolean execute(int a, float[] b) {
                results.add(b);
                return true;
            }
        });
        return (float[][])results.toArray((T[])new float[results.size()][]);
    }

    public int[] indexRangeSearch(float[] lowerExtreme, float[] upperExtreme) {
        final TIntArrayList results = new TIntArrayList();
        this.rangeSearch(lowerExtreme, upperExtreme, new TIntObjectProcedure<float[]>(){

            public boolean execute(int a, float[] b) {
                results.add(a);
                return true;
            }
        });
        return results.toArray();
    }

    public int[] indexRadiusSearch(float[] centre, float radius) {
        final TIntArrayList results = new TIntArrayList();
        this.radiusSearch(centre, radius, new TIntObjectProcedure<float[]>(){

            public boolean execute(int a, float[] b) {
                results.add(a);
                return true;
            }
        });
        return results.toArray();
    }

    public void radiusSearch(final float[] centre, float radius, final TIntObjectProcedure<float[]> proc) {
        float[] lower = (float[])centre.clone();
        float[] upper = (float[])centre.clone();
        int i = 0;
        while (i < centre.length) {
            int n = i;
            lower[n] = lower[n] - radius;
            int n2 = i++;
            upper[n2] = upper[n2] + radius;
        }
        final float radSq = radius * radius;
        this.rangeSearch(lower, upper, new TIntObjectProcedure<float[]>(){

            public boolean execute(int idx, float[] point) {
                float d = FloatKDTree.this.distance(centre, point);
                if (d <= radSq) {
                    return proc.execute(idx, (Object)point);
                }
                return true;
            }
        });
    }

    public void rangeSearch(float[] lowerExtreme, float[] upperExtreme, TIntObjectProcedure<float[]> proc) {
        ArrayDeque<KDTreeNode> stack = new ArrayDeque<KDTreeNode>();
        if (this.root == null) {
            return;
        }
        stack.push(this.root);
        while (!stack.isEmpty()) {
            KDTreeNode tmpNode = (KDTreeNode)stack.pop();
            if (tmpNode.isLeaf()) {
                for (int i = 0; i < tmpNode.indices.length; ++i) {
                    int idx = tmpNode.indices[i];
                    float[] vec = this.data[idx];
                    if (!this.isContained(vec, lowerExtreme, upperExtreme) || proc.execute(idx, (Object)vec)) continue;
                    return;
                }
                continue;
            }
            if (tmpNode.isDisjointFrom(lowerExtreme, upperExtreme)) continue;
            if (tmpNode.isContainedBy(lowerExtreme, upperExtreme)) {
                this.reportSubtree(tmpNode, proc);
                continue;
            }
            if (tmpNode.left != null) {
                stack.push(tmpNode.left);
            }
            if (tmpNode.right == null) continue;
            stack.push(tmpNode.right);
        }
    }

    private final boolean isContained(float[] point, float[] lower, float[] upper) {
        for (int i = 0; i < point.length; ++i) {
            if (!(point[i] < lower[i]) && !(point[i] > upper[i])) continue;
            return false;
        }
        return true;
    }

    private void reportSubtree(KDTreeNode root, TIntObjectProcedure<float[]> proc) {
        ArrayDeque<KDTreeNode> stack = new ArrayDeque<KDTreeNode>();
        stack.push(root);
        while (!stack.isEmpty()) {
            KDTreeNode tmpNode = (KDTreeNode)stack.pop();
            if (tmpNode.isLeaf()) {
                for (int i = 0; i < tmpNode.indices.length; ++i) {
                    int idx = tmpNode.indices[i];
                    if (proc.execute(idx, (Object)this.data[idx])) continue;
                    return;
                }
                continue;
            }
            if (tmpNode.left != null) {
                stack.push(tmpNode.left);
            }
            if (tmpNode.right == null) continue;
            stack.push(tmpNode.right);
        }
    }

    public List<IntFloatPair> nearestNeighbours(float[] qu, int n) {
        BoundedPriorityQueue<IntFloatPair> queue = new BoundedPriorityQueue<IntFloatPair>(n, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);
        this.searchSubTree(qu, this.root, queue);
        return queue.toOrderedListDestructive();
    }

    public IntFloatPair nearestNeighbour(float[] qu) {
        BoundedPriorityQueue<IntFloatPair> queue = new BoundedPriorityQueue<IntFloatPair>(1, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);
        this.searchSubTree(qu, this.root, queue);
        return queue.peek();
    }

    public float[][] coordinateRadiusSearch(float[] centre, float radius) {
        final ArrayList radiusList = new ArrayList();
        this.coordinateRadiusSearch(centre, radius, new TObjectFloatProcedure<float[]>(){

            public boolean execute(float[] a, float b) {
                radiusList.add(a);
                return true;
            }
        });
        return (float[][])radiusList.toArray((T[])new float[radiusList.size()][]);
    }

    public void coordinateRadiusSearch(final float[] centre, float radius, final TObjectFloatProcedure<float[]> proc) {
        float[] lower = (float[])centre.clone();
        float[] upper = (float[])centre.clone();
        int i = 0;
        while (i < centre.length) {
            int n = i;
            lower[n] = lower[n] - radius;
            int n2 = i++;
            upper[n2] = upper[n2] + radius;
        }
        final float radSq = radius * radius;
        this.rangeSearch(lower, upper, new TIntObjectProcedure<float[]>(){

            public boolean execute(int idx, float[] point) {
                float d = FloatKDTree.this.distance(centre, point);
                if (d <= radSq) {
                    return proc.execute((Object)point, d);
                }
                return true;
            }
        });
    }

    private void searchSubTree(float[] qu, KDTreeNode cur, BoundedPriorityQueue<IntFloatPair> queue) {
        ArrayDeque<KDTreeNode> stack = new ArrayDeque<KDTreeNode>();
        while (!cur.isLeaf()) {
            stack.push(cur);
            float diff = qu[cur.discriminantDimension] - cur.discriminant;
            if (diff < 0.0f) {
                cur = cur.left;
                continue;
            }
            cur = cur.right;
        }
        for (int i = 0; i < cur.indices.length; ++i) {
            int idx = cur.indices[i];
            float[] vec = this.data[idx];
            float dist = this.distance(qu, vec);
            queue.add(new IntFloatPair(idx, dist));
        }
        while (!stack.isEmpty()) {
            cur = (KDTreeNode)stack.pop();
            float diff = qu[cur.discriminantDimension] - cur.discriminant;
            float worstDist = queue.peekTail().second;
            if (!(diff * diff <= worstDist) && queue.isFull()) continue;
            if (diff < 0.0f) {
                this.searchSubTree(qu, cur.right, queue);
                continue;
            }
            this.searchSubTree(qu, cur.left, queue);
        }
    }

    private float distance(float[] qu, float[] vec) {
        float d = 0.0f;
        for (int i = 0; i < qu.length; ++i) {
            d += (qu[i] - vec[i]) * (qu[i] - vec[i]);
        }
        return d;
    }

    public List<int[]> leafIndices() {
        ArrayList<int[]> leafInds = new ArrayList<int[]>();
        ArrayDeque<KDTreeNode> nodes = new ArrayDeque<KDTreeNode>();
        nodes.push(this.root);
        while (nodes.size() != 0) {
            KDTreeNode node = (KDTreeNode)nodes.pop();
            if (node.isLeaf()) {
                leafInds.add(node.indices);
                continue;
            }
            nodes.push(node.left);
            nodes.push(node.right);
        }
        return leafInds;
    }

    public static class KDTreeNode {
        public KDTreeNode left;
        public KDTreeNode right;
        public float discriminant;
        public int discriminantDimension;
        public float[] minBounds;
        public float[] maxBounds;
        public int[] indices;

        public KDTreeNode(float[][] pnts, IntArrayView inds, SplitChooser split) {
            this(pnts, inds, split, 0, null, true);
        }

        private KDTreeNode(float[][] pnts, IntArrayView inds, SplitChooser split, int depth, KDTreeNode parent, boolean isLeft) {
            if (parent == null) {
                this.minBounds = new float[pnts[0].length];
                this.maxBounds = new float[pnts[0].length];
                Arrays.fill(this.minBounds, Float.MAX_VALUE);
                Arrays.fill(this.maxBounds, -3.4028235E38f);
                for (int y = 0; y < pnts.length; ++y) {
                    for (int x = 0; x < pnts[0].length; ++x) {
                        if (this.minBounds[x] > pnts[y][x]) {
                            this.minBounds[x] = pnts[y][x];
                        }
                        if (!(this.maxBounds[x] < pnts[y][x])) continue;
                        this.maxBounds[x] = pnts[y][x];
                    }
                }
                Arrays.fill(this.minBounds, -3.4028235E38f);
                Arrays.fill(this.maxBounds, Float.MAX_VALUE);
            } else {
                this.minBounds = (float[])parent.minBounds.clone();
                this.maxBounds = (float[])parent.maxBounds.clone();
                if (isLeft) {
                    this.maxBounds[parent.discriminantDimension] = parent.discriminant;
                } else {
                    this.minBounds[parent.discriminantDimension] = parent.discriminant;
                }
            }
            IntFloatPair spl = split.chooseSplit(pnts, inds, depth, this.minBounds, this.maxBounds);
            if (spl == null) {
                this.indices = inds.toArray();
            } else {
                this.discriminantDimension = spl.first;
                this.discriminant = spl.second;
                int N = inds.size();
                int l = 0;
                int r = N;
                while (l != r) {
                    if (pnts[inds.getFast(l)][this.discriminantDimension] < this.discriminant) {
                        ++l;
                        continue;
                    }
                    int t = inds.getFast(l);
                    inds.setFast(l, inds.getFast(--r));
                    inds.setFast(r, t);
                }
                if (l == 0 || l == N) {
                    this.discriminant = 0.0f;
                    this.discriminantDimension = 0;
                    this.indices = inds.toArray();
                } else {
                    this.left = new KDTreeNode(pnts, inds.subView(0, l), split, depth + 1, this, true);
                    this.right = new KDTreeNode(pnts, inds.subView(l, N), split, depth + 1, this, false);
                }
            }
        }

        public boolean isLeaf() {
            return this.indices != null;
        }

        private final boolean inRange(float value, float min, float max) {
            return value >= min && value <= max;
        }

        public boolean isDisjointFrom(float[] lowerExtreme, float[] upperExtreme) {
            for (int i = 0; i < lowerExtreme.length; ++i) {
                if (this.inRange(this.minBounds[i], lowerExtreme[i], upperExtreme[i]) || this.inRange(lowerExtreme[i], this.minBounds[i], this.maxBounds[i])) continue;
                return true;
            }
            return false;
        }

        public boolean isContainedBy(float[] lowerExtreme, float[] upperExtreme) {
            for (int i = 0; i < lowerExtreme.length; ++i) {
                if (!(this.minBounds[i] < lowerExtreme[i]) && !(this.maxBounds[i] > upperExtreme[i])) continue;
                return false;
            }
            return true;
        }
    }

    public static class RandomisedBBFMeanSplit
    implements SplitChooser {
        private static final int maxLeafSize = 14;
        private static final int varianceMaxPoints = 128;
        private static final int randomMaxDims = 5;
        private Uniform rng;

        public RandomisedBBFMeanSplit() {
            this.rng = new Uniform((RandomEngine)new MersenneTwister());
        }

        public RandomisedBBFMeanSplit(Uniform uniform) {
            this.rng = uniform;
        }

        public RandomisedBBFMeanSplit(int maxLeafSize, int varianceMaxPoints, int randomMaxDims, Uniform uniform) {
            this.rng = uniform;
        }

        @Override
        public IntFloatPair chooseSplit(float[][] pnts, IntArrayView inds, int depth, float[] minBounds, float[] maxBounds) {
            int d;
            if (inds.size() < 14) {
                return null;
            }
            int D = pnts[0].length;
            float[] sumX = new float[D];
            float[] sumXX = new float[D];
            int count = Math.min(inds.size(), 128);
            for (int n = 0; n < count; ++n) {
                for (d = 0; d < D; ++d) {
                    int i = inds.getFast(n);
                    int n2 = d;
                    sumX[n2] = sumX[n2] + pnts[i][d];
                    int n3 = d;
                    sumXX[n3] = sumXX[n3] + pnts[i][d] * pnts[i][d];
                }
            }
            Object[] varPerDim = new FloatIntPair[D];
            for (d = 0; d < D; ++d) {
                varPerDim[d] = new FloatIntPair();
                varPerDim[d].second = d;
                ((FloatIntPair)varPerDim[d]).first = count <= 1 ? 0.0f : (sumXX[d] - 1.0f / (float)count * sumX[d] * sumX[d]) / (float)(count - 1);
            }
            int nrand = Math.min(5, D);
            Sorting.partial_sort((Object[])varPerDim, (int)0, (int)nrand, (int)varPerDim.length, (BinaryPredicate)new BinaryPredicate(){

                public boolean apply(Object arg0, Object arg1) {
                    FloatIntPair p1 = (FloatIntPair)arg0;
                    FloatIntPair p2 = (FloatIntPair)arg1;
                    if (p1.first > p2.first) {
                        return true;
                    }
                    if (p2.first > p1.first) {
                        return false;
                    }
                    return p1.second > p2.second;
                }
            });
            int randd = ((FloatIntPair)varPerDim[this.rng.nextIntFromTo((int)0, (int)(nrand - 1))]).second;
            return new IntFloatPair(randd, sumX[randd] / (float)count);
        }
    }

    public static class ApproximateBBFMedianSplit
    implements SplitChooser {
        int maxBucketSize = 24;

        public ApproximateBBFMedianSplit() {
        }

        public ApproximateBBFMedianSplit(int maxBucketSize) {
            this.maxBucketSize = maxBucketSize;
        }

        @Override
        public IntFloatPair chooseSplit(float[][] pnts, IntArrayView inds, int depth, float[] minBounds, float[] maxBounds) {
            if (inds.size() < this.maxBucketSize) {
                return null;
            }
            int dim = 0;
            float maxVar = maxBounds[0] - minBounds[0];
            for (int d = 1; d < pnts[0].length; ++d) {
                float var = maxBounds[d] - minBounds[d];
                if (!(var > maxVar)) continue;
                maxVar = var;
                dim = d;
            }
            if (maxVar == 0.0f) {
                return null;
            }
            float[] data = new float[inds.size()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = pnts[inds.getFast(i)][dim];
            }
            float median = ArrayUtils.quickSelect(data, data.length / 2);
            return IntFloatPair.pair(dim, median);
        }
    }

    public static class BBFMedianSplit
    implements SplitChooser {
        int maxBucketSize = 24;

        public BBFMedianSplit() {
        }

        public BBFMedianSplit(int maxBucketSize) {
            this.maxBucketSize = maxBucketSize;
        }

        @Override
        public IntFloatPair chooseSplit(float[][] pnts, IntArrayView inds, int depth, float[] minBounds, float[] maxBounds) {
            if (inds.size() < this.maxBucketSize) {
                return null;
            }
            int D = pnts[0].length;
            float[] sumX = new float[D];
            float[] sumXX = new float[D];
            int count = inds.size();
            for (int n = 0; n < count; ++n) {
                for (int d = 0; d < D; ++d) {
                    int i = inds.getFast(n);
                    int n2 = d;
                    sumX[n2] = sumX[n2] + pnts[i][d];
                    int n3 = d;
                    sumXX[n3] = sumXX[n3] + pnts[i][d] * pnts[i][d];
                }
            }
            int dim = 0;
            float maxVar = (sumXX[0] - 1.0f / (float)count * sumX[0] * sumX[0]) / (float)(count - 1);
            for (int d = 1; d < D; ++d) {
                float var = (sumXX[d] - 1.0f / (float)count * sumX[d] * sumX[d]) / (float)(count - 1);
                if (!(var > maxVar)) continue;
                maxVar = var;
                dim = d;
            }
            if (maxVar == 0.0f) {
                return null;
            }
            float[] data = new float[inds.size()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = pnts[inds.getFast(i)][dim];
            }
            float median = ArrayUtils.quickSelect(data, data.length / 2);
            return IntFloatPair.pair(dim, median);
        }
    }

    public static class BasicMedianSplit
    implements SplitChooser {
        int maxBucketSize = 24;

        public BasicMedianSplit() {
        }

        public BasicMedianSplit(int maxBucketSize) {
            this.maxBucketSize = maxBucketSize;
        }

        @Override
        public IntFloatPair chooseSplit(float[][] pnts, IntArrayView inds, int depth, float[] minBounds, float[] maxBounds) {
            if (inds.size() < this.maxBucketSize) {
                return null;
            }
            int dim = depth % pnts[0].length;
            float[] data = new float[inds.size()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = pnts[inds.getFast(i)][dim];
            }
            float median = ArrayUtils.quickSelect(data, data.length / 2);
            return IntFloatPair.pair(dim, median);
        }
    }

    public static interface SplitChooser {
        public IntFloatPair chooseSplit(float[][] var1, IntArrayView var2, int var3, float[] var4, float[] var5);
    }
}

