/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.stream.combine;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.openimaj.util.data.Context;
import org.openimaj.util.parallel.GlobalExecutorPool;
import org.openimaj.util.stream.AbstractStream;
import org.openimaj.util.stream.Stream;

public class ContextStreamCombiner
extends AbstractStream<Context> {
    private ThreadPoolExecutor service;
    private Stream<Context> b;
    private Stream<Context> a;
    private String aprefix;
    private String bprefix;

    public ContextStreamCombiner(Stream<Context> a, Stream<Context> b) {
        this.a = a;
        this.b = b;
        this.aprefix = "a";
        this.bprefix = "b";
        this.service = GlobalExecutorPool.getPool();
    }

    public ContextStreamCombiner(Stream<Context> a, Stream<Context> b, String aprefix, String bprefix) {
        this.a = a;
        this.b = b;
        this.aprefix = aprefix;
        this.bprefix = bprefix;
        this.service = GlobalExecutorPool.getPool();
    }

    @Override
    public boolean hasNext() {
        return this.a.hasNext() && this.b.hasNext();
    }

    @Override
    public Context next() {
        Future<Context> futurea = this.service.submit(new Starter(this.a));
        Future<Context> futureb = this.service.submit(new Starter(this.b));
        try {
            Context a = futurea.get();
            Context b = futureb.get();
            return a.combine(b, this.aprefix, this.bprefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Stream<Context> combine(Stream<Context> a, Stream<Context> b) {
        return new ContextStreamCombiner(a, b);
    }

    class Starter
    implements Callable<Context> {
        private Stream<Context> stream;

        public Starter(Stream<Context> a) {
            this.stream = a;
        }

        @Override
        public Context call() throws Exception {
            return (Context)this.stream.next();
        }
    }
}

