/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.array;

import gnu.trove.iterator.TIntFloatIterator;
import gnu.trove.map.TIntFloatMap;
import gnu.trove.map.hash.TIntFloatHashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openimaj.util.array.SparseFloatArray;

public class SparseHashedFloatArray
extends SparseFloatArray {
    TIntFloatHashMap data;

    public SparseHashedFloatArray(float[] values) {
        this(values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == 0.0f) continue;
            this.set(i, values[i]);
        }
    }

    public SparseHashedFloatArray(int length) {
        this(length, 10);
    }

    public SparseHashedFloatArray(int length, int capacity) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity must be > 0");
        }
        this.length = length;
        this.data = new TIntFloatHashMap(capacity);
    }

    public SparseHashedFloatArray(int length, float density) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (density <= 0.0f || density > 1.0f) {
            throw new IllegalArgumentException("density must be > 0 and < 1");
        }
        this.length = length;
        int capacity = (int)(density * (float)length);
        this.data = new TIntFloatHashMap(capacity);
    }

    @Override
    public float increment(int key, float value) {
        return this.data.adjustOrPutValue(key, value, value);
    }

    @Override
    public int[] indices() {
        return this.data.keys();
    }

    @Override
    public float[] values() {
        return this.data.values();
    }

    @Override
    public Iterable<SparseFloatArray.Entry> entries() {
        return new Iterable<SparseFloatArray.Entry>(){

            @Override
            public Iterator<SparseFloatArray.Entry> iterator() {
                return new Iterator<SparseFloatArray.Entry>(){
                    private SparseFloatArray.Entry entry = new SparseFloatArray.Entry();
                    private TIntFloatIterator iterator;
                    {
                        this.iterator = SparseHashedFloatArray.this.data.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public SparseFloatArray.Entry next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        this.iterator.advance();
                        this.entry.index = this.iterator.key();
                        this.entry.value = this.iterator.value();
                        return this.entry;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SparseHashedFloatArray)) {
            return false;
        }
        return this.length == ((SparseHashedFloatArray)obj).length && this.data.equals((Object)((SparseHashedFloatArray)obj).data);
    }

    @Override
    public float get(int key) {
        if (key < 0 || key >= this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(key));
        }
        return this.data.get(key);
    }

    public int hashCode() {
        return this.length ^ this.data.hashCode();
    }

    @Override
    public boolean isUsed(int key) {
        return this.data.contains(key);
    }

    @Override
    public float set(int key, float value) {
        return this.data.put(key, value);
    }

    @Override
    public int used() {
        return this.data.size();
    }

    @Override
    public void compact() {
        this.data.compact();
    }

    @Override
    public SparseFloatArray copy() {
        SparseHashedFloatArray copy = new SparseHashedFloatArray(this.length);
        copy.data = new TIntFloatHashMap((TIntFloatMap)this.data);
        return copy;
    }

    @Override
    public SparseFloatArray reverse() {
        TIntFloatHashMap tmp = new TIntFloatHashMap(this.data.size());
        for (SparseFloatArray.Entry e : this.entries()) {
            tmp.put(this.length - e.index, e.value);
        }
        this.data = tmp;
        return this;
    }
}

