/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.array;

public class DoubleArrayView
implements Cloneable {
    private double[] array;
    private int l;
    private int r;

    public DoubleArrayView(double[] array, int l, int r) {
        this.array = array;
        this.l = l;
        this.r = r;
    }

    public DoubleArrayView(double[] array) {
        this(array, 0, array.length);
    }

    public DoubleArrayView(int n) {
        this(new double[n], 0, n);
    }

    public DoubleArrayView subView(int l1, int r1) {
        if (this.l + l1 < 0 || this.l + r1 > this.r) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new DoubleArrayView(this.array, this.l + l1, this.l + r1);
    }

    public double get(int i) {
        int idx = i + this.l;
        if (idx < 0 || idx >= this.r) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.array[idx];
    }

    public double getFast(int i) {
        return this.array[i + this.l];
    }

    public void set(int i, double v) {
        int idx = i + this.l;
        if (idx < 0 || idx >= this.r) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.array[idx] = v;
    }

    public void setFast(int i, double v) {
        this.array[i + this.l] = v;
    }

    public double[] getUnderlyingStorage() {
        return this.array;
    }

    public int size() {
        return this.r - this.l;
    }

    public double[] toArray() {
        double[] a = new double[this.r - this.l];
        System.arraycopy(this.array, this.l, a, 0, this.r - this.l);
        return a;
    }

    public String toString() {
        String s = "[";
        for (int i = this.l; i < this.r - 1; ++i) {
            s = s + this.array[i] + ",";
        }
        s = s + this.array[this.r - 1] + "]";
        return s;
    }

    public DoubleArrayView clone() {
        return new DoubleArrayView(this.toArray());
    }
}

