/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.projection;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.text.ParseException;
import org.myworldgis.projection.AbstractProjectedProjection;
import org.myworldgis.projection.Ellipsoid;
import org.myworldgis.projection.Gnomonic;
import org.myworldgis.projection.Projection;
import org.myworldgis.projection.ProjectionParameters;
import org.myworldgis.projection.ProjectionUtils;
import org.myworldgis.util.GeometryUtils;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.quantity.Length;

public strictfp abstract class HemisphericalProjection
extends AbstractProjectedProjection {
    private double _hPhi1;
    private double _hLambda0;

    public HemisphericalProjection(Ellipsoid ellipsoid, Coordinate center, Unit<Length> units, double falseEasting, double falseNorthing) {
        super(ellipsoid, center, units, falseEasting, falseNorthing);
    }

    public HemisphericalProjection(Ellipsoid ellipsoid, ProjectionParameters parameters) throws ParseException {
        super(ellipsoid, parameters);
    }

    protected abstract Coordinate getHemisphereCenter();

    protected abstract double getMaxC();

    @Override
    protected Coordinate inversePoint(double x, double y, Coordinate storage) {
        storage = super.inversePoint(x, y, storage);
        Coordinate center = this.getHemisphereCenter();
        double c = GeometryUtils.point_point_greatcircle_distance(center.x, center.y, storage.x, storage.y);
        if (c > this.getMaxC()) {
            storage.x = Double.NaN;
            storage.y = Double.NaN;
        }
        return storage;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            HemisphericalProjection proj = (HemisphericalProjection)obj;
            return StrictMath.abs(proj._hPhi1 - this._hPhi1) < 1.567855942887398E-7 && StrictMath.abs(proj._hLambda0 - this._hLambda0) < 1.567855942887398E-7 && StrictMath.abs(proj.getMaxC() - this.getMaxC()) < 1.567855942887398E-7;
        }
        return false;
    }

    @Override
    public Point process(Point point) {
        if (!point.isEmpty()) {
            Coordinate center = this.getHemisphereCenter();
            double c = GeometryUtils.point_point_greatcircle_distance(center.x, center.y, point.getX(), point.getY());
            if (c > this.getMaxC()) {
                return point.getFactory().createPoint((Coordinate)null);
            }
        }
        return point;
    }

    @Override
    public MultiPolygon process(Polygon poly) {
        if (this._lineType == Projection.LineType.RHUMB) {
            poly = ProjectionUtils.createRhumbPoly(poly);
        } else if (this._lineType == Projection.LineType.GREATCIRCLE && !(this instanceof Gnomonic)) {
            poly = ProjectionUtils.createGreatCirclePoly(poly);
        }
        return ProjectionUtils.clip(poly, this.getHemisphereCenter(), this.getMaxC());
    }

    @Override
    public MultiLineString process(LineString line) {
        if (this._lineType == Projection.LineType.RHUMB) {
            line = ProjectionUtils.createRhumbLine(line);
        } else if (this._lineType == Projection.LineType.GREATCIRCLE && !(this instanceof Gnomonic)) {
            line = ProjectionUtils.createGreatCircleLine(line);
        }
        return ProjectionUtils.clip(line, this.getHemisphereCenter(), this.getMaxC());
    }

    @Override
    protected void computeParameters() {
        Coordinate center = this.getHemisphereCenter();
        this._hPhi1 = center.y;
        this._hLambda0 = center.x;
    }
}

