/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.util.List;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.FigureEnumerator;
import org.jhotdraw.standard.FigureTransferCommand;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class DeleteCommand
extends FigureTransferCommand {
    public DeleteCommand(String string, DrawingEditor drawingEditor) {
        super(string, drawingEditor);
    }

    public void execute() {
        super.execute();
        this.setUndoActivity(this.createUndoActivity());
        FigureEnumeration figureEnumeration = this.view().selection();
        List list = CollectionsFactory.current().createList();
        while (figureEnumeration.hasNextFigure()) {
            Figure figure = figureEnumeration.nextFigure();
            list.add(0, figure);
            FigureEnumeration figureEnumeration2 = figure.getDependendFigures();
            if (figureEnumeration2 == null) continue;
            while (figureEnumeration2.hasNextFigure()) {
                list.add(0, figureEnumeration2.nextFigure());
            }
        }
        figureEnumeration = new FigureEnumerator(list);
        this.getUndoActivity().setAffectedFigures(figureEnumeration);
        this.deleteFigures(this.getUndoActivity().getAffectedFigures());
        this.view().checkDamage();
    }

    protected boolean isExecutableWithView() {
        return this.view().selectionCount() > 0;
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this);
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private FigureTransferCommand myCommand;

        public UndoActivity(FigureTransferCommand figureTransferCommand) {
            super(figureTransferCommand.view());
            this.myCommand = figureTransferCommand;
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (super.undo() && this.getAffectedFigures().hasNextFigure()) {
                this.getDrawingView().clearSelection();
                this.setAffectedFigures(this.myCommand.insertFigures(this.getAffectedFiguresReversed(), 0, 0));
                return true;
            }
            return false;
        }

        public boolean redo() {
            if (this.isRedoable()) {
                this.myCommand.deleteFigures(this.getAffectedFigures());
                this.getDrawingView().clearSelection();
                return true;
            }
            return false;
        }
    }
}

