/*
 * Decompiled with CFR 0.152.
 */
package com.caffeineowl.graphics.bezier.flatnessalgos;

import com.caffeineowl.graphics.DistUtils;
import com.caffeineowl.graphics.bezier.CubicFlatnessAlgorithm;
import com.caffeineowl.graphics.bezier.QuadFlatnessAlgorithm;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.QuadCurve2D;

public class SimpleConvexHullFlatness
implements CubicFlatnessAlgorithm,
QuadFlatnessAlgorithm {
    public final boolean isDegenerationRobust() {
        return false;
    }

    public final boolean isSquaredFlatenessPreferred() {
        return true;
    }

    public final double getFlatness(CubicCurve2D curve) {
        return Math.sqrt(this.getSquaredFlatness(curve));
    }

    public final double getSquaredFlatness(CubicCurve2D curve) {
        double x1 = curve.getX1();
        double y1 = curve.getY1();
        double x2 = curve.getX2();
        double y2 = curve.getY2();
        double sqD1 = DistUtils.pointToLineSqEucDist(curve.getCtrlX1(), curve.getCtrlY1(), x1, y1, x2, y2);
        double sqD2 = DistUtils.pointToLineSqEucDist(curve.getCtrlX2(), curve.getCtrlY2(), x1, y1, x2, y2);
        return Math.max(sqD1, sqD2);
    }

    public final double getFlatness(QuadCurve2D curve) {
        return Math.sqrt(this.getSquaredFlatness(curve));
    }

    public final double getSquaredFlatness(QuadCurve2D curve) {
        return DistUtils.pointToLineSqEucDist(curve.getCtrlX(), curve.getCtrlY(), curve.getX1(), curve.getY1(), curve.getX2(), curve.getY2());
    }
}

