/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io.graphml.parser;

import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.io.GraphIOException;
import edu.uci.ics.jung.io.graphml.ExceptionConverter;
import edu.uci.ics.jung.io.graphml.parser.AbstractElementParser;
import edu.uci.ics.jung.io.graphml.parser.ParserContext;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringElementParser<G extends Hypergraph<V, E>, V, E>
extends AbstractElementParser<G, V, E> {
    public StringElementParser(ParserContext<G, V, E> parserContext) {
        super(parserContext);
    }

    @Override
    public String parse(XMLEventReader xmlEventReader, StartElement start) throws GraphIOException {
        try {
            String str = null;
            while (xmlEventReader.hasNext()) {
                XMLEvent event = xmlEventReader.nextEvent();
                if (event.isStartElement()) {
                    this.getUnknownParser().parse(xmlEventReader, event.asStartElement());
                    continue;
                }
                if (event.isEndElement()) {
                    EndElement end = (EndElement)event;
                    this.verifyMatch(start, end);
                    break;
                }
                if (!event.isCharacters()) continue;
                Characters characters = (Characters)event;
                str = characters.getData();
            }
            return str;
        }
        catch (Exception e) {
            ExceptionConverter.convert(e);
            return null;
        }
    }
}

