/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.graphics;

import com.sun.webkit.graphics.WCGraphicsContext;
import com.sun.webkit.graphics.WCGraphicsManager;
import com.sun.webkit.graphics.WCImage;
import com.sun.webkit.graphics.WCImageDecoder;
import com.sun.webkit.graphics.WCImageFrame;
import java.util.HashMap;
import java.util.Map;

final class RenderMediaControls {
    private static final int PLAY_BUTTON = 1;
    private static final int PAUSE_BUTTON = 2;
    private static final int DISABLED_PLAY_BUTTON = 3;
    private static final int MUTE_BUTTON = 4;
    private static final int UNMUTE_BUTTON = 5;
    private static final int DISABLED_MUTE_BUTTON = 6;
    private static final int TIME_SLIDER_TRACK = 9;
    private static final int TIME_SLIDER_THUMB = 10;
    private static final int VOLUME_CONTAINER = 11;
    private static final int VOLUME_TRACK = 12;
    private static final int VOLUME_THUMB = 13;
    private static final int TimeSliderTrackUnbufferedColor = RenderMediaControls.rgba(236, 135, 125);
    private static final int TimeSliderTrackBufferedColor = RenderMediaControls.rgba(249, 26, 2);
    private static final int TimeSliderTrackThickness = 3;
    private static final int VolumeTrackColor = RenderMediaControls.rgba(208, 208, 208, 128);
    private static final int VolumeTrackThickness = 1;
    private static final int SLIDER_TYPE_TIME = 0;
    private static final int SLIDER_TYPE_VOLUME = 1;
    private static final Map<String, WCImage> controlImages = new HashMap<String, WCImage>();
    private static final boolean log = false;

    private static String getControlName(int control) {
        switch (control) {
            case 1: {
                return "PLAY_BUTTON";
            }
            case 2: {
                return "PAUSE_BUTTON";
            }
            case 3: {
                return "DISABLED_PLAY_BUTTON";
            }
            case 4: {
                return "MUTE_BUTTON";
            }
            case 5: {
                return "UNMUTE_BUTTON";
            }
            case 6: {
                return "DISABLED_MUTE_BUTTON";
            }
            case 9: {
                return "TIME_SLIDER_TRACK";
            }
            case 10: {
                return "TIME_SLIDER_THUMB";
            }
            case 11: {
                return "VOLUME_CONTAINER";
            }
            case 12: {
                return "VOLUME_TRACK";
            }
            case 13: {
                return "VOLUME_THUMB";
            }
        }
        return "{UNKNOWN CONTROL " + control + "}";
    }

    private RenderMediaControls() {
    }

    static void paintControl(WCGraphicsContext gc, int type, int x, int y, int w, int h) {
        switch (type) {
            case 1: {
                RenderMediaControls.paintControlImage("mediaPlay", gc, x, y, w, h);
                break;
            }
            case 2: {
                RenderMediaControls.paintControlImage("mediaPause", gc, x, y, w, h);
                break;
            }
            case 3: {
                RenderMediaControls.paintControlImage("mediaPlayDisabled", gc, x, y, w, h);
                break;
            }
            case 4: {
                RenderMediaControls.paintControlImage("mediaMute", gc, x, y, w, h);
                break;
            }
            case 5: {
                RenderMediaControls.paintControlImage("mediaUnmute", gc, x, y, w, h);
                break;
            }
            case 6: {
                RenderMediaControls.paintControlImage("mediaMuteDisabled", gc, x, y, w, h);
                break;
            }
            case 10: {
                RenderMediaControls.paintControlImage("mediaTimeThumb", gc, x, y, w, h);
                break;
            }
            case 11: {
                break;
            }
            case 13: {
                RenderMediaControls.paintControlImage("mediaVolumeThumb", gc, x, y, w, h);
                break;
            }
        }
    }

    static void paintTimeSliderTrack(WCGraphicsContext gc, float duration, float curTime, float[] bufferedPairs, int x, int y, int w, int h) {
        y += (h - 3) / 2;
        h = 3;
        int thumbWidth = RenderMediaControls.fwkGetSliderThumbSize(0) >> 16 & 0xFFFF;
        w -= thumbWidth;
        x += thumbWidth / 2;
        if (!(duration < 0.0f)) {
            float timeToPixel = 1.0f / duration * (float)w;
            float start = 0.0f;
            for (int i = 0; i < bufferedPairs.length; i += 2) {
                gc.fillRect((float)x + timeToPixel * start, y, timeToPixel * (bufferedPairs[i] - start), h, TimeSliderTrackUnbufferedColor);
                gc.fillRect((float)x + timeToPixel * bufferedPairs[i], y, timeToPixel * (bufferedPairs[i + 1] - bufferedPairs[i]), h, TimeSliderTrackBufferedColor);
                start = bufferedPairs[i + 1];
            }
            if (start < duration) {
                gc.fillRect((float)x + timeToPixel * start, y, timeToPixel * (duration - start), h, TimeSliderTrackUnbufferedColor);
            }
        }
    }

    static void paintVolumeTrack(WCGraphicsContext gc, float curVolume, boolean muted, int x, int y, int w, int h) {
        x += (w + 1 - 1) / 2;
        w = 1;
        int thumbWidth = RenderMediaControls.fwkGetSliderThumbSize(0) & 0xFFFF;
        gc.fillRect(x, y += thumbWidth / 2, w, h -= thumbWidth, VolumeTrackColor);
    }

    private static int fwkGetSliderThumbSize(int type) {
        WCImage image = null;
        switch (type) {
            case 0: {
                image = RenderMediaControls.getControlImage("mediaTimeThumb");
                break;
            }
            case 1: {
                image = RenderMediaControls.getControlImage("mediaVolumeThumb");
            }
        }
        if (image != null) {
            return image.getWidth() << 16 | image.getHeight();
        }
        return 0;
    }

    private static WCImage getControlImage(String resName) {
        WCImage image = controlImages.get(resName);
        if (image == null) {
            WCImageDecoder decoder = WCGraphicsManager.getGraphicsManager().getImageDecoder();
            decoder.loadFromResource(resName);
            WCImageFrame frame = decoder.getFrame(0);
            if (frame != null) {
                image = frame.getFrame();
                controlImages.put(resName, image);
            }
        }
        return image;
    }

    private static void paintControlImage(String resName, WCGraphicsContext gc, int x, int y, int w, int h) {
        WCImage image = RenderMediaControls.getControlImage(resName);
        if (image != null) {
            x += (w - image.getWidth()) / 2;
            w = image.getWidth();
            y += (h - image.getHeight()) / 2;
            h = image.getHeight();
            gc.drawImage(image, x, y, w, h, 0.0f, 0.0f, image.getWidth(), image.getHeight());
        }
    }

    private static int rgba(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    private static int rgba(int r, int g, int b) {
        return RenderMediaControls.rgba(r, g, b, 255);
    }

    private static void log(String s) {
        System.out.println(s);
        System.out.flush();
    }
}

