/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.sw;

import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.pisces.PiscesRenderer;
import com.sun.pisces.Transform6;
import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import com.sun.prism.Texture;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Gradient;
import com.sun.prism.paint.ImagePattern;
import com.sun.prism.paint.LinearGradient;
import com.sun.prism.paint.Paint;
import com.sun.prism.paint.RadialGradient;
import com.sun.prism.paint.Stop;
import com.sun.prism.sw.SWArgbPreTexture;
import com.sun.prism.sw.SWContext;
import com.sun.prism.sw.SWUtils;

final class SWPaint {
    private final SWContext context;
    private final PiscesRenderer pr;
    private final BaseTransform paintTx = new Affine2D();
    private final Transform6 piscesTx = new Transform6();
    private float compositeAlpha = 1.0f;
    private float px;
    private float py;
    private float pw;
    private float ph;

    SWPaint(SWContext context, PiscesRenderer pr) {
        this.context = context;
        this.pr = pr;
    }

    float getCompositeAlpha() {
        return this.compositeAlpha;
    }

    void setCompositeAlpha(float newValue) {
        this.compositeAlpha = newValue;
    }

    void setColor(Color c, float compositeAlpha) {
        if (PrismSettings.debug) {
            System.out.println("PR.setColor: " + c);
        }
        this.pr.setColor((int)(c.getRed() * 255.0f), (int)(255.0f * c.getGreen()), (int)(255.0f * c.getBlue()), (int)(255.0f * c.getAlpha() * compositeAlpha));
    }

    void setPaintFromShape(Paint p, BaseTransform tx, Shape shape, RectBounds nodeBounds, float localX, float localY, float localWidth, float localHeight) {
        this.computePaintBounds(p, shape, nodeBounds, localX, localY, localWidth, localHeight);
        this.setPaintBeforeDraw(p, tx, this.px, this.py, this.pw, this.ph);
    }

    private void computePaintBounds(Paint p, Shape shape, RectBounds nodeBounds, float localX, float localY, float localWidth, float localHeight) {
        if (p.isProportional()) {
            if (nodeBounds != null) {
                this.px = nodeBounds.getMinX();
                this.py = nodeBounds.getMinY();
                this.pw = nodeBounds.getWidth();
                this.ph = nodeBounds.getHeight();
            } else if (shape != null) {
                RectBounds bounds = shape.getBounds();
                this.px = bounds.getMinX();
                this.py = bounds.getMinY();
                this.pw = bounds.getWidth();
                this.ph = bounds.getHeight();
            } else {
                this.px = localX;
                this.py = localY;
                this.pw = localWidth;
                this.ph = localHeight;
            }
        } else {
            this.ph = 0.0f;
            this.pw = 0.0f;
            this.py = 0.0f;
            this.px = 0.0f;
        }
    }

    void setPaintBeforeDraw(Paint p, BaseTransform tx, float x, float y, float width, float height) {
        switch (p.getType()) {
            case COLOR: {
                this.setColor((Color)p, this.compositeAlpha);
                break;
            }
            case LINEAR_GRADIENT: {
                LinearGradient lg = (LinearGradient)p;
                if (PrismSettings.debug) {
                    System.out.println("PR.setLinearGradient: " + lg.getX1() + ", " + lg.getY1() + ", " + lg.getX2() + ", " + lg.getY2());
                }
                this.paintTx.setTransform(tx);
                SWUtils.convertToPiscesTransform(this.paintTx, this.piscesTx);
                float x1 = lg.getX1();
                float y1 = lg.getY1();
                float x2 = lg.getX2();
                float y2 = lg.getY2();
                if (lg.isProportional()) {
                    x1 = x + width * x1;
                    y1 = y + height * y1;
                    x2 = x + width * x2;
                    y2 = y + height * y2;
                }
                this.pr.setLinearGradient((int)(65536.0f * x1), (int)(65536.0f * y1), (int)(65536.0f * x2), (int)(65536.0f * y2), SWPaint.getFractions(lg), SWPaint.getARGB(lg, this.compositeAlpha), SWPaint.getPiscesGradientCycleMethod(lg.getSpreadMethod()), this.piscesTx);
                break;
            }
            case RADIAL_GRADIENT: {
                RadialGradient rg = (RadialGradient)p;
                if (PrismSettings.debug) {
                    System.out.println("PR.setRadialGradient: " + rg.getCenterX() + ", " + rg.getCenterY() + ", " + rg.getFocusAngle() + ", " + rg.getFocusDistance() + ", " + rg.getRadius());
                }
                this.paintTx.setTransform(tx);
                float cx = rg.getCenterX();
                float cy = rg.getCenterY();
                float r = rg.getRadius();
                if (rg.isProportional()) {
                    float dim = Math.min(width, height);
                    float bcx = x + width * 0.5f;
                    float bcy = y + height * 0.5f;
                    cx = bcx + (cx - 0.5f) * dim;
                    cy = bcy + (cy - 0.5f) * dim;
                    r *= dim;
                    if (width != height && (double)width != 0.0 && (double)height != 0.0) {
                        this.paintTx.deriveWithTranslation(bcx, bcy);
                        this.paintTx.deriveWithConcatenation(width / dim, 0.0, 0.0, height / dim, 0.0, 0.0);
                        this.paintTx.deriveWithTranslation(-bcx, -bcy);
                    }
                }
                SWUtils.convertToPiscesTransform(this.paintTx, this.piscesTx);
                float fx = (float)((double)cx + (double)(rg.getFocusDistance() * r) * Math.cos(Math.toRadians(rg.getFocusAngle())));
                float fy = (float)((double)cy + (double)(rg.getFocusDistance() * r) * Math.sin(Math.toRadians(rg.getFocusAngle())));
                this.pr.setRadialGradient((int)(65536.0f * cx), (int)(65536.0f * cy), (int)(65536.0f * fx), (int)(65536.0f * fy), (int)(65536.0f * r), SWPaint.getFractions(rg), SWPaint.getARGB(rg, this.compositeAlpha), SWPaint.getPiscesGradientCycleMethod(rg.getSpreadMethod()), this.piscesTx);
                break;
            }
            case IMAGE_PATTERN: {
                ImagePattern ip = (ImagePattern)p;
                if (ip.getImage().getPixelFormat() == PixelFormat.BYTE_ALPHA) {
                    throw new UnsupportedOperationException("Alpha image is not supported as an image pattern.");
                }
                this.computeImagePatternTransform(ip, tx, x, y, width, height);
                SWArgbPreTexture tex = this.context.validateImagePaintTexture(ip.getImage().getWidth(), ip.getImage().getHeight());
                tex.update(ip.getImage());
                if (this.compositeAlpha < 1.0f) {
                    tex.applyCompositeAlpha(this.compositeAlpha);
                }
                this.pr.setTexture(1, tex.getDataNoClone(), tex.getContentWidth(), tex.getContentHeight(), tex.getPhysicalWidth(), this.piscesTx, tex.getWrapMode() == Texture.WrapMode.REPEAT, tex.getLinearFiltering(), tex.hasAlpha());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown paint type: " + (Object)((Object)p.getType()));
            }
        }
    }

    private static int[] getARGB(Gradient grd, float compositeAlpha) {
        int nstops = grd.getNumStops();
        int[] argb = new int[nstops];
        for (int i = 0; i < nstops; ++i) {
            Stop stop = grd.getStops().get(i);
            Color stopColor = stop.getColor();
            float alpha255 = 255.0f * stopColor.getAlpha() * compositeAlpha;
            argb[i] = (((int)alpha255 & 0xFF) << 24) + (((int)(alpha255 * stopColor.getRed()) & 0xFF) << 16) + (((int)(alpha255 * stopColor.getGreen()) & 0xFF) << 8) + ((int)(alpha255 * stopColor.getBlue()) & 0xFF);
        }
        return argb;
    }

    private static int[] getFractions(Gradient grd) {
        int nstops = grd.getNumStops();
        int[] fractions = new int[nstops];
        for (int i = 0; i < nstops; ++i) {
            Stop stop = grd.getStops().get(i);
            fractions[i] = (int)(65536.0f * stop.getOffset());
        }
        return fractions;
    }

    private static int getPiscesGradientCycleMethod(int prismCycleMethod) {
        switch (prismCycleMethod) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
        }
        return 0;
    }

    Transform6 computeDrawTexturePaintTransform(BaseTransform tx, float dx1, float dy1, float dx2, float dy2, float sx1, float sy1, float sx2, float sy2) {
        this.paintTx.setTransform(tx);
        float scaleX = this.computeScale(dx1, dx2, sx1, sx2);
        float scaleY = this.computeScale(dy1, dy2, sy1, sy2);
        if (scaleX == 1.0f && scaleY == 1.0f) {
            this.paintTx.deriveWithTranslation(-Math.min(sx1, sx2) + Math.min(dx1, dx2), -Math.min(sy1, sy2) + Math.min(dy1, dy2));
        } else {
            this.paintTx.deriveWithTranslation(Math.min(dx1, dx2), Math.min(dy1, dy2));
            this.paintTx.deriveWithTranslation(scaleX >= 0.0f ? 0.0 : (double)Math.abs(dx2 - dx1), scaleY >= 0.0f ? 0.0 : (double)Math.abs(dy2 - dy1));
            this.paintTx.deriveWithConcatenation(scaleX, 0.0, 0.0, scaleY, 0.0, 0.0);
            this.paintTx.deriveWithTranslation(-Math.min(sx1, sx2), -Math.min(sy1, sy2));
        }
        SWUtils.convertToPiscesTransform(this.paintTx, this.piscesTx);
        return this.piscesTx;
    }

    private float computeScale(float dv1, float dv2, float sv1, float sv2) {
        float dv_diff = dv2 - dv1;
        float scale = dv_diff / (sv2 - sv1);
        if (Math.abs(scale) > 32767.0f) {
            scale = Math.signum(scale) * 32767.0f;
        }
        return scale;
    }

    Transform6 computeSetTexturePaintTransform(Paint p, BaseTransform tx, RectBounds nodeBounds, float localX, float localY, float localWidth, float localHeight) {
        this.computePaintBounds(p, null, nodeBounds, localX, localY, localWidth, localHeight);
        ImagePattern ip = (ImagePattern)p;
        this.computeImagePatternTransform(ip, tx, this.px, this.py, this.pw, this.ph);
        return this.piscesTx;
    }

    private void computeImagePatternTransform(ImagePattern ip, BaseTransform tx, float x, float y, float width, float height) {
        Image image = ip.getImage();
        if (PrismSettings.debug) {
            System.out.println("PR.setTexturePaint: " + image);
            System.out.println("imagePattern: x: " + ip.getX() + ", y: " + ip.getY() + ", w: " + ip.getWidth() + ", h: " + ip.getHeight() + ", proportional: " + ip.isProportional());
        }
        this.paintTx.setTransform(tx);
        if (ip.isProportional()) {
            this.paintTx.deriveWithConcatenation(width / (float)image.getWidth() * ip.getWidth(), 0.0, 0.0, height / (float)image.getHeight() * ip.getHeight(), x + width * ip.getX(), y + height * ip.getY());
        } else {
            this.paintTx.deriveWithConcatenation(ip.getWidth() / (float)image.getWidth(), 0.0, 0.0, ip.getHeight() / (float)image.getHeight(), x + ip.getX(), y + ip.getY());
        }
        SWUtils.convertToPiscesTransform(this.paintTx, this.piscesTx);
    }
}

