/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.GraphDecorator;
import edu.uci.ics.jung.graph.event.GraphEvent;
import edu.uci.ics.jung.graph.event.GraphEventListener;
import edu.uci.ics.jung.graph.util.EdgeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservableGraph<V, E>
extends GraphDecorator<V, E> {
    List<GraphEventListener<V, E>> listenerList = Collections.synchronizedList(new LinkedList());

    public ObservableGraph(Graph<V, E> delegate) {
        super(delegate);
    }

    public void addGraphEventListener(GraphEventListener<V, E> l) {
        this.listenerList.add(l);
    }

    public void removeGraphEventListener(GraphEventListener<V, E> l) {
        this.listenerList.remove(l);
    }

    protected void fireGraphEvent(GraphEvent<V, E> evt) {
        for (GraphEventListener<V, E> listener : this.listenerList) {
            listener.handleGraphEvent(evt);
        }
    }

    @Override
    public boolean addEdge(E edge, Collection<? extends V> vertices) {
        boolean state = super.addEdge(edge, vertices);
        if (state) {
            GraphEvent.Edge evt = new GraphEvent.Edge(this.delegate, GraphEvent.Type.EDGE_ADDED, edge);
            this.fireGraphEvent(evt);
        }
        return state;
    }

    @Override
    public boolean addEdge(E e, V v1, V v2, EdgeType edgeType) {
        boolean state = super.addEdge(e, v1, v2, edgeType);
        if (state) {
            GraphEvent.Edge evt = new GraphEvent.Edge(this.delegate, GraphEvent.Type.EDGE_ADDED, e);
            this.fireGraphEvent(evt);
        }
        return state;
    }

    @Override
    public boolean addEdge(E e, V v1, V v2) {
        boolean state = super.addEdge(e, v1, v2);
        if (state) {
            GraphEvent.Edge evt = new GraphEvent.Edge(this.delegate, GraphEvent.Type.EDGE_ADDED, e);
            this.fireGraphEvent(evt);
        }
        return state;
    }

    @Override
    public boolean addVertex(V vertex) {
        boolean state = super.addVertex(vertex);
        if (state) {
            GraphEvent.Vertex evt = new GraphEvent.Vertex(this.delegate, GraphEvent.Type.VERTEX_ADDED, vertex);
            this.fireGraphEvent(evt);
        }
        return state;
    }

    @Override
    public boolean removeEdge(E edge) {
        boolean state = this.delegate.removeEdge(edge);
        if (state) {
            GraphEvent.Edge evt = new GraphEvent.Edge(this.delegate, GraphEvent.Type.EDGE_REMOVED, edge);
            this.fireGraphEvent(evt);
        }
        return state;
    }

    @Override
    public boolean removeVertex(V vertex) {
        ArrayList incident_edges = new ArrayList(this.delegate.getIncidentEdges(vertex));
        for (Object e : incident_edges) {
            this.removeEdge(e);
        }
        boolean state = this.delegate.removeVertex(vertex);
        if (state) {
            GraphEvent.Vertex evt = new GraphEvent.Vertex(this.delegate, GraphEvent.Type.VERTEX_REMOVED, vertex);
            this.fireGraphEvent(evt);
        }
        return state;
    }
}

