/*
 * Decompiled with CFR 0.152.
 */
import org.nlogo.api.Argument;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoListBuilder;
import org.nlogo.api.Reporter;
import org.nlogo.core.Syntax;
import org.nlogo.core.SyntaxJ;

public class ScaleScheme
implements Reporter {
    public Syntax getSyntax() {
        int[] right = new int[]{Syntax.StringType(), Syntax.StringType(), Syntax.NumberType(), Syntax.NumberType(), Syntax.NumberType(), Syntax.NumberType()};
        int ret = Syntax.ListType();
        return SyntaxJ.reporterSyntax((int[])right, (int)ret);
    }

    public Object report(Argument[] args, Context context) throws ExtensionException {
        double max;
        double min;
        double var;
        int size;
        String legendname;
        String schemename;
        try {
            schemename = args[0].getString();
            legendname = args[1].getString();
            size = args[2].getIntValue();
            var = args[3].getDoubleValue();
            min = args[4].getDoubleValue();
            max = args[5].getDoubleValue();
        }
        catch (LogoException e) {
            throw new ExtensionException(e.getMessage());
        }
        int index = 0;
        double perc = 0.0;
        if (max >= min && var <= min || min > max && var > min) {
            index = 0;
        } else if (min > max && var < max || max >= min && var > max) {
            index = size - 1;
        } else {
            double tempval = max > min ? var - min : min - var;
            double tempmax = Math.abs(max - min);
            perc = Math.floor(tempval / (tempmax /= (double)size));
            index = Math.min((int)perc, size - 1);
        }
        int[][] legend = ColorSchemes.getRGBArray(schemename, legendname, size);
        LogoListBuilder list = new LogoListBuilder();
        try {
            list.add((Object)legend[index][0]);
            list.add((Object)legend[index][1]);
            list.add((Object)legend[index][2]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ExtensionException(legendname + " has a maximum of " + String.valueOf(ColorSchemes.getRGBArray(schemename, legendname).length) + " colors, but you have requested " + size);
        }
        catch (NullPointerException e) {
            throw new ExtensionException(legendname + " has a maximum of " + String.valueOf(ColorSchemes.getRGBArray(schemename, legendname).length) + " colors, but you have requested " + size);
        }
        return list.toLogoList();
    }
}

