/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.render;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Base64;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import org.nlogo.api.Color$;
import org.nlogo.api.Dump$;
import org.nlogo.api.Graphics2DWrapper;
import org.nlogo.api.World;
import org.nlogo.core.File;
import org.nlogo.render.LinkDrawer;
import org.nlogo.render.TrailDrawerJ;
import org.nlogo.render.TurtleDrawer;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\t\u0013\u0001eA\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tK\u0001\u0011\t\u0011)A\u0005M!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006C\u0003.\u0001\u0011\u0005a\u0006C\u00034\u0001\u0011\u0005A\u0007C\u0003F\u0001\u0011\u0005c\tC\u0003]\u0001\u0011\u0005S\fC\u0004j\u0001E\u0005I\u0011\u00016\t\u000bq\u0003A\u0011A;\t\r}\u0004A\u0011AA\u0001\u0011\u001d\tY\u0002\u0001C\u0001\u0003;Aq!a\b\u0001\t\u0003\ti\u0002C\u0004\u0002\"\u0001!\t!a\t\t\u000f\u0005}\u0002\u0001\"\u0001\u0002B!9\u0011q\t\u0001\u0005\u0002\u0005%\u0003bBA:\u0001\u0011%\u0011Q\u0004\u0002\f)J\f\u0017\u000e\u001c#sC^,'O\u0003\u0002\u0014)\u00051!/\u001a8eKJT!!\u0006\f\u0002\u000b9dwnZ8\u000b\u0003]\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000e\u0011\u0005maR\"\u0001\n\n\u0005u\u0011\"\u0001\u0004+sC&dGI]1xKJT\u0015!B<pe2$\u0007C\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u0015\u0003\r\t\u0007/[\u0005\u0003I\u0005\u0012QaV8sY\u0012\fA\u0002^;si2,GI]1xKJ\u0004\"aG\u0014\n\u0005!\u0012\"\u0001\u0004+veRdW\r\u0012:bo\u0016\u0014\u0018A\u00037j].$%/Y<feB\u00111dK\u0005\u0003YI\u0011!\u0002T5oW\u0012\u0013\u0018m^3s\u0003\u0019a\u0014N\\5u}Q!q\u0006M\u00193!\tY\u0002\u0001C\u0003\u001f\t\u0001\u0007q\u0004C\u0003&\t\u0001\u0007a\u0005C\u0003*\t\u0001\u0007!&\u0001\nfqB|'\u000f\u001e#sC^Lgn\u001a+p\u0007N3FCA\u001b<!\t1\u0014(D\u00018\u0015\u0005A\u0014!B:dC2\f\u0017B\u0001\u001e8\u0005\u0011)f.\u001b;\t\u000bq*\u0001\u0019A\u001f\u0002\r]\u0014\u0018\u000e^3s!\tq4)D\u0001@\u0015\t\u0001\u0015)\u0001\u0002j_*\t!)\u0001\u0003kCZ\f\u0017B\u0001#@\u0005-\u0001&/\u001b8u/JLG/\u001a:\u0002'%l\u0007o\u001c:u\tJ\fw/\u001b8h\u0005\u0006\u001cXM\u000e\u001b\u0015\u0005U:\u0005\"\u0002%\u0007\u0001\u0004I\u0015A\u00022bg\u00164D\u0007\u0005\u0002K#:\u00111j\u0014\t\u0003\u0019^j\u0011!\u0014\u0006\u0003\u001db\ta\u0001\u0010:p_Rt\u0014B\u0001)8\u0003\u0019\u0001&/\u001a3fM&\u0011!k\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005A;\u0004f\u0001\u0004V7B\u0019aG\u0016-\n\u0005];$A\u0002;ie><8\u000f\u0005\u0002?3&\u0011!l\u0010\u0002\f\u0013>+\u0005pY3qi&|gnI\u0001Y\u00035IW\u000e]8si\u0012\u0013\u0018m^5oOR\u0019QGX2\t\u000b};\u0001\u0019\u00011\u0002\u0005%\u001c\bC\u0001 b\u0013\t\u0011wHA\u0006J]B,Ho\u0015;sK\u0006l\u0007b\u00023\b!\u0003\u0005\r!Z\u0001\t[&lW\rV=qKB\u0019aGZ%\n\u0005\u001d<$AB(qi&|g\u000eK\u0002\b+n\u000bq#[7q_J$HI]1xS:<G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003-T#!\u001a7,\u00035\u0004\"A\\:\u000e\u0003=T!\u0001]9\u0002\u0013Ut7\r[3dW\u0016$'B\u0001:8\u0003)\tgN\\8uCRLwN\\\u0005\u0003i>\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f)\t)d\u000fC\u0003x\u0013\u0001\u0007\u00010\u0001\u0003gS2,\u0007CA=}\u001b\u0005Q(BA>\u0015\u0003\u0011\u0019wN]3\n\u0005uT(\u0001\u0002$jY\u0016D3!C+\\\u0003%\u0019X\r^\"pY>\u00148\u000fF\u00046\u0003\u0007\t\u0019\"a\u0006\t\u000f\u0005\u0015!\u00021\u0001\u0002\b\u000511m\u001c7peN\u0004RANA\u0005\u0003\u001bI1!a\u00038\u0005\u0015\t%O]1z!\r1\u0014qB\u0005\u0004\u0003#9$aA%oi\"9\u0011Q\u0003\u0006A\u0002\u00055\u0011!B<jIRD\u0007bBA\r\u0015\u0001\u0007\u0011QB\u0001\u0007Q\u0016Lw\r\u001b;\u0002\u0019\rdW-\u0019:Ee\u0006<\u0018N\\4\u0015\u0003U\naB]3tG\u0006dW\r\u0012:bo&tw-A\nhKR\fe\u000eZ\"sK\u0006$X\r\u0012:bo&tw\r\u0006\u0003\u0002&\u0005U\u0002\u0003BA\u0014\u0003ci!!!\u000b\u000b\t\u0005-\u0012QF\u0001\u0006S6\fw-\u001a\u0006\u0004\u0003_\t\u0015aA1xi&!\u00111GA\u0015\u00055\u0011UO\u001a4fe\u0016$\u0017*\\1hK\"9\u0011qG\u0007A\u0002\u0005e\u0012!\u00023jeRL\bc\u0001\u001c\u0002<%\u0019\u0011QH\u001c\u0003\u000f\t{w\u000e\\3b]\u0006I!/Z1e\u00136\fw-\u001a\u000b\u0004k\u0005\r\u0003\"B0\u000f\u0001\u0004\u0001\u0007f\u0001\bV7\u0006AAM]1x\u0019&tW\rF\b6\u0003\u0017\n)&!\u0017\u0002^\u0005\u0005\u00141NA8\u0011\u001d\tie\u0004a\u0001\u0003\u001f\n!\u0001_\u0019\u0011\u0007Y\n\t&C\u0002\u0002T]\u0012a\u0001R8vE2,\u0007bBA,\u001f\u0001\u0007\u0011qJ\u0001\u0003sFBq!a\u0017\u0010\u0001\u0004\ty%\u0001\u0002ye!9\u0011qL\bA\u0002\u0005=\u0013AA=3\u0011\u001d\t\u0019g\u0004a\u0001\u0003K\n\u0001\u0002]3o\u0007>dwN\u001d\t\u0004m\u0005\u001d\u0014bAA5o\t1\u0011I\\=SK\u001aDq!!\u001c\u0010\u0001\u0004\ty%A\u0004qK:\u001c\u0016N_3\t\r\u0005Et\u00021\u0001J\u0003\u001d\u0001XM\\'pI\u0016\f\u0011c]3u+B$%/Y<j]\u001eLU.Y4f\u0001")
public class TrailDrawer
extends TrailDrawerJ {
    private final World world;

    @Override
    public void exportDrawingToCSV(PrintWriter writer) {
        if (!this.drawingBlank) {
            String patchSize = Double.toString(this.world.patchSize());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)this.drawingImage, "png", baos);
            baos.flush();
            byte[] bytes = baos.toByteArray();
            baos.close();
            String base64 = new StringBuilder(22).append("data:image/png;base64,").append(Base64.getEncoder().encodeToString(bytes)).toString();
            new $colon$colon<Nothing$>((Nothing$)((Object)"DRAWING"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)patchSize), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)base64), Nil$.MODULE$))).foreach((Function1<String, Object> & Serializable & scala.Serializable)line -> {
                writer.println(Dump$.MODULE$.csv().encode(line));
                return BoxedUnit.UNIT;
            });
        }
        writer.println();
    }

    @Override
    public void importDrawingBase64(String base64) throws IOException {
        String[] pair = base64.split(",");
        byte[] bytes = Base64.getDecoder().decode(pair[1]);
        String contentType = pair[0].replaceFirst("^data:", "").replaceFirst(";base64$", "");
        this.importDrawing(new ByteArrayInputStream(bytes), Option$.MODULE$.apply(contentType));
    }

    @Override
    public void importDrawing(InputStream is, Option<String> mimeType) throws IOException {
        BufferedImage bufferedImage;
        float scaley;
        float scale;
        BufferedImage image;
        if (this.drawingImage == null) {
            this.setUpDrawingImage();
        }
        if ((image = ImageIO.read(is)) == null) {
            throw new IIOException("Unsupported image format.");
        }
        float scalex = (float)this.getWidth() / (float)image.getWidth();
        float f = scale = scalex < (scaley = (float)this.getHeight() / (float)image.getHeight()) ? scalex : scaley;
        if (scale == 1.0f) {
            bufferedImage = image;
        } else {
            AffineTransformOp trans = new AffineTransformOp(AffineTransform.getScaleInstance(scale, scale), 2);
            if (image.getColorModel().getColorSpace().getType() == 6 && !image.getColorModel().hasAlpha()) {
                BufferedImage scaled = trans.createCompatibleDestImage(image, image.getColorModel());
                trans.filter(image, scaled);
                bufferedImage = scaled;
            } else {
                bufferedImage = trans.filter(image, null);
            }
        }
        BufferedImage scaledImage = bufferedImage;
        int xOffset = (this.getWidth() - scaledImage.getWidth()) / 2;
        int yOffset = (this.getHeight() - scaledImage.getHeight()) / 2;
        this.drawingImage.createGraphics().drawImage((Image)scaledImage, xOffset, yOffset, null);
        this.markDirty();
        this.sendPixels = true;
    }

    @Override
    public void importDrawing(File file) throws IOException {
        try {
            this.importDrawing(file.getInputStream(), this.importDrawing$default$2());
            return;
        }
        catch (IIOException ex) {
            throw new IIOException(new StringBuilder(26).append("Unsupported image format: ").append(file.getPath()).toString(), ex);
        }
    }

    @Override
    public Option<String> importDrawing$default$2() {
        return None$.MODULE$;
    }

    @Override
    public void setColors(int[] colors, int width, int height) {
        this.setUpDrawingImage();
        BufferedImage image = new BufferedImage(width, height, 2);
        image.setRGB(0, 0, width, height, colors, 0, width);
        this.drawingImage.createGraphics().drawImage((Image)image, 0, 0, null);
        this.drawingBlank = false;
        this.drawingDirty = true;
        this.sendPixels = true;
    }

    @Override
    public void clearDrawing() {
        if (this.drawingImage != null) {
            this.setUpDrawingImage();
        }
    }

    @Override
    public void rescaleDrawing() {
        BufferedImage oldImage = this.drawingImage;
        this.setUpDrawingImage();
        if (oldImage != null && this.drawingImage != null) {
            this.drawingImage.createGraphics().drawImage(oldImage, 0, 0, this.width, this.height, null);
            this.drawingDirty = true;
        }
    }

    @Override
    public BufferedImage getAndCreateDrawing(boolean dirty) {
        if (this.drawingImage == null) {
            this.setUpDrawingImage();
        }
        if (dirty) {
            this.drawingBlank = false;
            this.drawingDirty = true;
        }
        return this.drawingImage;
    }

    @Override
    public void readImage(InputStream is) throws IOException {
        this.setUpDrawingImage();
        this.readImage(ImageIO.read(is));
    }

    @Override
    public void drawLine(double x1, double y1, double x2, double y2, Object penColor, double penSize, String penMode) {
        if (this.drawingImage == null) {
            this.setUpDrawingImage();
        }
        Graphics2DWrapper tg = new Graphics2DWrapper((Graphics2D)this.drawingImage.getGraphics());
        tg.setPenWidth(penSize);
        if (penMode.equals("erase")) {
            tg.setComposite(AlphaComposite.Clear);
            this.drawWrappedLine(tg, x1, y1, x2, y2, penSize);
            tg.setComposite(AlphaComposite.SrcOver);
            return;
        }
        tg.antiAliasing(true);
        tg.setColor(Color$.MODULE$.getColor(penColor));
        this.drawWrappedLine(tg, x1, y1, x2, y2, penSize);
        tg.antiAliasing(false);
    }

    private void setUpDrawingImage() {
        BufferedImage bufferedImage;
        this.width = (int)StrictMath.round(this.world.patchSize() * (double)this.world.worldWidth());
        this.height = (int)StrictMath.round(this.world.patchSize() * (double)this.world.worldHeight());
        if (this.width > 0 && this.height > 0) {
            this.colorArray = null;
            bufferedImage = new BufferedImage(this.width, this.height, 2);
        } else {
            bufferedImage = null;
        }
        this.drawingImage = bufferedImage;
        this.drawingBlank = true;
    }

    public TrailDrawer(World world, TurtleDrawer turtleDrawer, LinkDrawer linkDrawer) {
        this.world = world;
        super(world, turtleDrawer, linkDrawer);
    }
}

