/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.render;

import com.jogamp.opengl.GL2;
import java.awt.Color;
import java.io.Serializable;
import java.nio.FloatBuffer;
import org.nlogo.api.AgentFollowingPerspective;
import org.nlogo.api.Color$;
import org.nlogo.api.Drawing3D;
import org.nlogo.api.DrawingLine3D;
import org.nlogo.api.LinkStamp3D;
import org.nlogo.api.Perspective;
import org.nlogo.api.TurtleStamp3D;
import org.nlogo.api.World3D;
import org.nlogo.gl.render.DrawingRendererInterface;
import org.nlogo.gl.render.LinkRenderer3D;
import org.nlogo.gl.render.TurtleRenderer3D;
import scala.Function1;
import scala.Predef$;
import scala.UninitializedFieldError;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001y4A\u0001E\t\u00055!AQ\u0005\u0001B\u0001B\u0003%a\u0005\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003.\u0011!\u0001\u0004A!A!\u0002\u0013\t\u0004\"\u0002\u001b\u0001\t\u0003)\u0004b\u0002\u001e\u0001\u0001\u0004%\ta\u000f\u0005\b\u007f\u0001\u0001\r\u0011\"\u0001A\u0011\u00191\u0005\u0001)Q\u0005y!)q\t\u0001C\u0001\u0011\")A\u000b\u0001C\u0005+\")\u0011\f\u0001C\u00015\")A\f\u0001C\u0001;\")q\f\u0001C\u0005A\")q\r\u0001C\u0005Q\")Q\u000f\u0001C\u0005m\")A\u0010\u0001C\u0001{\nyAK]1jYJ+g\u000eZ3sKJ\u001cDI\u0003\u0002\u0013'\u00051!/\u001a8eKJT!\u0001F\u000b\u0002\u0005\u001dd'B\u0001\f\u0018\u0003\u0015qGn\\4p\u0015\u0005A\u0012aA8sO\u000e\u00011c\u0001\u0001\u001cCA\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t1\u0011I\\=SK\u001a\u0004\"AI\u0012\u000e\u0003EI!\u0001J\t\u00031\u0011\u0013\u0018m^5oOJ+g\u000eZ3sKJLe\u000e^3sM\u0006\u001cW-A\u0003x_JdG\r\u0005\u0002(U5\t\u0001F\u0003\u0002*+\u0005\u0019\u0011\r]5\n\u0005-B#aB,pe2$7\u0007R\u0001\te\u0016tG-\u001a:feB\u0011!EL\u0005\u0003_E\u0011\u0001\u0003V;si2,'+\u001a8eKJ,'o\r#\u0002\u00191Lgn\u001b*f]\u0012,'/\u001a:\u0011\u0005\t\u0012\u0014BA\u001a\u0012\u00059a\u0015N\\6SK:$WM]3sg\u0011\u000ba\u0001P5oSRtD\u0003\u0002\u001c8qe\u0002\"A\t\u0001\t\u000b\u0015\"\u0001\u0019\u0001\u0014\t\u000b1\"\u0001\u0019A\u0017\t\u000bA\"\u0001\u0019A\u0019\u0002\u00131Lg.Z%oI\u0016DX#\u0001\u001f\u0011\u0005qi\u0014B\u0001 \u001e\u0005\rIe\u000e^\u0001\u000eY&tW-\u00138eKb|F%Z9\u0015\u0005\u0005#\u0005C\u0001\u000fC\u0013\t\u0019UD\u0001\u0003V]&$\bbB#\u0007\u0003\u0003\u0005\r\u0001P\u0001\u0004q\u0012\n\u0014A\u00037j]\u0016Le\u000eZ3yA\u0005!\u0011N\\5u)\t\t\u0015\nC\u0003\u0015\u0011\u0001\u0007!\n\u0005\u0002L%6\tAJ\u0003\u0002N\u001d\u00061q\u000e]3oO2T!a\u0014)\u0002\r)|w-Y7q\u0015\u0005\t\u0016aA2p[&\u00111\u000b\u0014\u0002\u0004\u000f2\u0013\u0014a\u00023sC^LgnZ\u000b\u0002-B\u0011qeV\u0005\u00031\"\u0012\u0011\u0002\u0012:bo&twm\r#\u0002\u001bI,g\u000eZ3s\tJ\fw/\u001b8h)\t\t5\fC\u0003\u0015\u0015\u0001\u0007!*\u0001\u0007sK:$WM\u001d+sC&d7\u000f\u0006\u0002B=\")Ac\u0003a\u0001\u0015\u0006\t\"/\u001a8eKJ<&/\u00199qK\u0012d\u0015N\\3\u0015\u0007\u0005\u000b'\rC\u0003\u0015\u0019\u0001\u0007!\nC\u0003d\u0019\u0001\u0007A-A\u0001m!\t9S-\u0003\u0002gQ\tiAI]1xS:<G*\u001b8fg\u0011\u000b!B]3oI\u0016\u0014H*\u001b8f)\u0019\t\u0015N\u001b7rg\")A#\u0004a\u0001\u0015\")1.\u0004a\u0001I\u0006!A.\u001b8f\u0011\u0015iW\u00021\u0001o\u0003\u0005A\bC\u0001\u000fp\u0013\t\u0001XD\u0001\u0004E_V\u0014G.\u001a\u0005\u0006e6\u0001\rA\\\u0001\u0002s\")A/\u0004a\u0001]\u0006\t!0A\u0005bY&<g\u000eT5oKR1\u0011i\u001e=zunDQ\u0001\u0006\bA\u0002)CQa\u001b\bA\u0002\u0011DQ!\u001c\bA\u00029DQA\u001d\bA\u00029DQ\u0001\u001e\bA\u00029\fQa\u00197fCJ$\u0012!\u0011")
public class TrailRenderer3D
implements DrawingRendererInterface {
    private final World3D world;
    private final TurtleRenderer3D renderer;
    private final LinkRenderer3D linkRenderer;
    private int lineIndex;
    private volatile boolean bitmap$init$0;

    public int lineIndex() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-gui/src/main/gl/render/TrailRenderer3D.scala: 12");
        }
        return this.lineIndex;
    }

    public void lineIndex_$eq(int x$1) {
        this.lineIndex = x$1;
        this.bitmap$init$0 = true;
    }

    @Override
    public void init(GL2 gl) {
        this.lineIndex_$eq(gl.glGenLists(1));
        gl.glNewList(this.lineIndex(), 4864);
        gl.glBegin(1);
        gl.glNormal3f(0.0f, 0.0f, -1.0f);
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glVertex3f(0.0f, 0.3f, 0.0f);
        gl.glEnd();
        gl.glEndList();
    }

    private Drawing3D drawing() {
        return (Drawing3D)this.world.getDrawing();
    }

    @Override
    public void renderDrawing(GL2 gl) {
        double defaultDist = 1.5 * (double)RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.world.worldWidth()), this.world.worldHeight())), this.world.worldDepth());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.drawing().linkStamps()).asScala()).foreach((Function1<LinkStamp3D, Object> & Serializable & scala.Serializable)stamp -> {
            TrailRenderer3D.$anonfun$renderDrawing$1(this, gl, stamp);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.drawing().turtleStamps()).asScala()).foreach((Function1<TurtleStamp3D, Object> & Serializable & scala.Serializable)stamp -> {
            this.renderer.renderWrappedTurtle(gl, stamp, 0, this.world.patchSize(), false, defaultDist);
            return BoxedUnit.UNIT;
        });
        this.renderTrails(gl);
        gl.glLineWidth(1.0f);
    }

    public void renderTrails(GL2 gl) {
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.drawing().lines()).asScala()).foreach((Function1<DrawingLine3D, Object> & Serializable & scala.Serializable)line -> {
            this.renderWrappedLine(gl, line);
            return BoxedUnit.UNIT;
        });
    }

    private void renderWrappedLine(GL2 gl, DrawingLine3D l) {
        double x = this.world.wrappedObserverX(l.x0());
        double y = this.world.wrappedObserverY(l.y0());
        double z = this.world.wrappedObserverZ(l.z0());
        int worldWidth = this.world.worldWidth();
        int worldHeight = this.world.worldHeight();
        int worldDepth = this.world.worldDepth();
        boolean wrapXRight = false;
        boolean wrapXLeft = false;
        boolean wrapYTop = false;
        boolean wrapYBottom = false;
        this.renderLine(gl, l, x, y, z);
        if (x != l.x0()) {
            double endX = x + l.x1() - l.x0();
            double maxx = (double)this.world.maxPxcor() + 0.5;
            double minx = (double)this.world.minPxcor() - 0.5;
            if (endX > maxx) {
                this.renderLine(gl, l, x - (double)worldWidth, y, z);
                wrapXRight = true;
            }
            if (endX < minx) {
                this.renderLine(gl, l, x + (double)worldWidth, y, z);
                wrapXLeft = true;
            }
        }
        if (y != l.y0()) {
            double endY = y + l.y1() - l.y0();
            double maxy = (double)this.world.maxPycor() + 0.5;
            double miny = (double)this.world.minPycor() - 0.5;
            if (endY > maxy) {
                this.renderLine(gl, l, x, y - (double)worldHeight, z);
                if (wrapXRight) {
                    this.renderLine(gl, l, x - (double)worldWidth, y - (double)worldHeight, z);
                }
                if (wrapXLeft) {
                    this.renderLine(gl, l, x + (double)worldWidth, y - (double)worldHeight, z);
                }
                wrapYTop = true;
            }
            if (endY < miny) {
                this.renderLine(gl, l, x, y + (double)worldHeight, z);
                if (wrapXRight) {
                    this.renderLine(gl, l, x - (double)worldWidth, y + (double)worldHeight, z);
                }
                if (wrapXLeft) {
                    this.renderLine(gl, l, x + (double)worldWidth, y + (double)worldHeight, z);
                }
                wrapYBottom = true;
            }
        }
        if (z != l.z0()) {
            double endZ = z + l.z1() - l.z0();
            double maxz = (double)this.world.maxPzcor() + 0.5;
            double minz = (double)this.world.minPzcor() - 0.5;
            if (endZ > maxz) {
                this.renderLine(gl, l, x, y, z - (double)worldDepth);
                if (wrapXRight) {
                    this.renderLine(gl, l, x - (double)worldWidth, y, z - (double)worldDepth);
                    if (wrapYTop) {
                        this.renderLine(gl, l, x - (double)worldWidth, y - (double)worldHeight, z - (double)worldDepth);
                    }
                    if (wrapYBottom) {
                        this.renderLine(gl, l, x - (double)worldWidth, y + (double)worldHeight, z - (double)worldDepth);
                    }
                }
                if (wrapXLeft) {
                    this.renderLine(gl, l, x + (double)worldWidth, y, z - (double)worldDepth);
                    if (wrapYTop) {
                        this.renderLine(gl, l, x + (double)worldWidth, y - (double)worldHeight, z - (double)worldDepth);
                    }
                    if (wrapYBottom) {
                        this.renderLine(gl, l, x + (double)worldWidth, y + (double)worldHeight, z - (double)worldDepth);
                    }
                }
                if (wrapYTop) {
                    this.renderLine(gl, l, x, y - (double)worldHeight, z - (double)worldDepth);
                }
                if (wrapYBottom) {
                    this.renderLine(gl, l, x, y + (double)worldHeight, z - (double)worldDepth);
                }
            }
            if (endZ < minz) {
                this.renderLine(gl, l, x, y, z + (double)worldDepth);
                if (wrapXRight) {
                    this.renderLine(gl, l, x - (double)worldWidth, y, z + (double)worldDepth);
                    if (wrapYTop) {
                        this.renderLine(gl, l, x - (double)worldWidth, y - (double)worldHeight, z + (double)worldDepth);
                    }
                    if (wrapYBottom) {
                        this.renderLine(gl, l, x - (double)worldWidth, y + (double)worldHeight, z + (double)worldDepth);
                    }
                }
                if (wrapXLeft) {
                    this.renderLine(gl, l, x + (double)worldWidth, y, z + (double)worldDepth);
                    if (wrapYTop) {
                        this.renderLine(gl, l, x + (double)worldWidth, y - (double)worldHeight, z + (double)worldDepth);
                    }
                    if (wrapYBottom) {
                        this.renderLine(gl, l, x + (double)worldWidth, y + (double)worldHeight, z + (double)worldDepth);
                    }
                }
                if (wrapYTop) {
                    this.renderLine(gl, l, x, y - (double)worldHeight, z + (double)worldDepth);
                }
                if (wrapYBottom) {
                    this.renderLine(gl, l, x, y + (double)worldHeight, z + (double)worldDepth);
                    return;
                }
            }
        }
    }

    private void renderLine(GL2 gl, DrawingLine3D line, double x, double y, double z) {
        Color color = Color$.MODULE$.getColor(line.color());
        gl.glPushMatrix();
        this.alignLine(gl, line, x, y, z);
        gl.glColor3fv(FloatBuffer.wrap(color.getRGBColorComponents(null)));
        gl.glLineWidth((float)RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(1.0), line.width()));
        gl.glCallList(this.lineIndex());
        gl.glPopMatrix();
    }

    private void alignLine(GL2 gl, DrawingLine3D line, double x, double y, double z) {
        double length = line.length();
        gl.glTranslated(x * (double)0.3f, y * (double)0.3f, z * (double)0.3f);
        gl.glRotated(-line.heading(), 0.0, 0.0, 1.0);
        gl.glRotated(line.pitch(), 1.0, 0.0, 0.0);
        gl.glScaled(length, length, length);
    }

    @Override
    public void clear() {
    }

    public static final /* synthetic */ void $anonfun$renderDrawing$1(TrailRenderer3D $this, GL2 gl$1, LinkStamp3D stamp) {
        Perspective perspective = $this.world.observer().perspective();
        double d = perspective instanceof AgentFollowingPerspective ? (double)((AgentFollowingPerspective)((Object)perspective)).followDistance() : $this.world.observer().orientation().get().dist();
        double lineScale = 0.0;
        if (d != 0.0) {
            lineScale = (double)package$.MODULE$.max($this.world.worldWidth(), $this.world.worldHeight()) * 1.5 / d;
        }
        $this.linkRenderer.renderWrappedLink(gl$1, stamp, 0, $this.world.patchSize(), false, lineScale);
    }

    public TrailRenderer3D(World3D world, TurtleRenderer3D renderer, LinkRenderer3D linkRenderer) {
        this.world = world;
        this.renderer = renderer;
        this.linkRenderer = linkRenderer;
        this.lineIndex = 0;
        this.bitmap$init$0 = true;
    }
}

