/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.io.Serializable;
import java.text.DecimalFormat;
import org.nlogo.api.AgentException;
import org.nlogo.api.Approximate$;
import org.nlogo.api.Exceptions$;
import org.nlogo.api.LogoListBuilder;
import org.nlogo.core.Color;
import org.nlogo.core.ColorConstants$;
import org.nlogo.core.I18N$;
import org.nlogo.core.LogoList;
import org.nlogo.core.LogoList$;
import org.nlogo.core.Resource$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$mcDI$sp;
import scala.UninitializedFieldError;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.LinkedHashMap;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichFloat$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0$mcD$sp;
import scala.runtime.java8.JFunction0$mcI$sp;
import scala.runtime.java8.JFunction1$mcII$sp;

public final class Color$
implements Color {
    public static Color$ MODULE$;
    private HashMap<Object, Object> colorTranslations;
    private final String[] ColorNames;
    private final java.awt.Color[] AWT_Cache;
    private final double[] ColorNumbers;
    private final LogoList BaseColors;
    private final String ColorTranslations;
    private final int NumHues;
    private final int MaxColor;
    private final Double BoxedBlack;
    private final Double BoxedWhite;
    private final int[] org$nlogo$core$Color$$ColorsRGB;
    private final int[] org$nlogo$core$Color$$ARGB_Cache;
    private final LinkedHashMap<Object, Object> rgbMap;
    private volatile boolean bitmap$0;
    private volatile int bitmap$init$0;

    static {
        new Color$();
    }

    @Override
    public int modulateInteger(int color) {
        return Color.modulateInteger$(this, color);
    }

    @Override
    public double modulateDouble(Double color) {
        return Color.modulateDouble$((Color)this, color);
    }

    @Override
    public double modulateDouble(double color) {
        return Color.modulateDouble$((Color)this, color);
    }

    @Override
    public double findCentralColorNumber(double color) {
        return Color.findCentralColorNumber$(this, color);
    }

    @Override
    public double getClosestColorNumberByARGB(int argb) {
        return Color.getClosestColorNumberByARGB$(this, argb);
    }

    @Override
    public double estimateClosestColorNumberByRGB(int argb) {
        return Color.estimateClosestColorNumberByRGB$(this, argb);
    }

    @Override
    public int getARGBbyPremodulatedColorNumber(double modulatedColor) {
        return Color.getARGBbyPremodulatedColorNumber$(this, modulatedColor);
    }

    @Override
    public int getRGBByName(String name) {
        return Color.getRGBByName$(this, name);
    }

    @Override
    public int getARGBByIndex(int index) {
        return Color.getARGBByIndex$(this, index);
    }

    @Override
    public int getARGBIntByRGBAList(LogoList rgba) {
        return Color.getARGBIntByRGBAList$(this, rgba);
    }

    @Override
    public Double argbToColor(int argb) {
        return Color.argbToColor$(this, argb);
    }

    @Override
    public int getRGBInt(int r, int g, int b) {
        return Color.getRGBInt$(this, r, g, b);
    }

    @Override
    public int getRGBInt(Object c) {
        return Color.getRGBInt$(this, c);
    }

    @Override
    public int NumHues() {
        if ((this.bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-core/src/main/api/Color.scala: 11");
        }
        return this.NumHues;
    }

    @Override
    public int MaxColor() {
        if ((this.bitmap$init$0 & 0x40) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-core/src/main/api/Color.scala: 11");
        }
        return this.MaxColor;
    }

    @Override
    public Double BoxedBlack() {
        if ((this.bitmap$init$0 & 0x80) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-core/src/main/api/Color.scala: 11");
        }
        return this.BoxedBlack;
    }

    @Override
    public Double BoxedWhite() {
        if ((this.bitmap$init$0 & 0x100) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-core/src/main/api/Color.scala: 11");
        }
        return this.BoxedWhite;
    }

    @Override
    public int[] org$nlogo$core$Color$$ColorsRGB() {
        if ((this.bitmap$init$0 & 0x200) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-core/src/main/api/Color.scala: 11");
        }
        return this.org$nlogo$core$Color$$ColorsRGB;
    }

    @Override
    public int[] org$nlogo$core$Color$$ARGB_Cache() {
        if ((this.bitmap$init$0 & 0x400) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-core/src/main/api/Color.scala: 11");
        }
        return this.org$nlogo$core$Color$$ARGB_Cache;
    }

    @Override
    public LinkedHashMap<Object, Object> rgbMap() {
        if ((this.bitmap$init$0 & 0x800) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-core/src/main/api/Color.scala: 11");
        }
        return this.rgbMap;
    }

    @Override
    public void org$nlogo$core$Color$_setter_$NumHues_$eq(int x$1) {
        this.NumHues = x$1;
        this.bitmap$init$0 |= 0x20;
    }

    @Override
    public void org$nlogo$core$Color$_setter_$MaxColor_$eq(int x$1) {
        this.MaxColor = x$1;
        this.bitmap$init$0 |= 0x40;
    }

    @Override
    public void org$nlogo$core$Color$_setter_$BoxedBlack_$eq(Double x$1) {
        this.BoxedBlack = x$1;
        this.bitmap$init$0 |= 0x80;
    }

    @Override
    public void org$nlogo$core$Color$_setter_$BoxedWhite_$eq(Double x$1) {
        this.BoxedWhite = x$1;
        this.bitmap$init$0 |= 0x100;
    }

    @Override
    public final void org$nlogo$core$Color$_setter_$org$nlogo$core$Color$$ColorsRGB_$eq(int[] x$1) {
        this.org$nlogo$core$Color$$ColorsRGB = x$1;
        this.bitmap$init$0 |= 0x200;
    }

    @Override
    public final void org$nlogo$core$Color$_setter_$org$nlogo$core$Color$$ARGB_Cache_$eq(int[] x$1) {
        this.org$nlogo$core$Color$$ARGB_Cache = x$1;
        this.bitmap$init$0 |= 0x400;
    }

    @Override
    public void org$nlogo$core$Color$_setter_$rgbMap_$eq(LinkedHashMap<Object, Object> x$1) {
        this.rgbMap = x$1;
        this.bitmap$init$0 |= 0x800;
    }

    public String[] ColorNames() {
        if ((this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-core/src/main/api/Color.scala: 14");
        }
        return this.ColorNames;
    }

    public String getColorNameByIndex(int index) {
        return this.ColorNames()[index];
    }

    private java.awt.Color[] AWT_Cache() {
        if ((this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-core/src/main/api/Color.scala: 26");
        }
        return this.AWT_Cache;
    }

    private double[] ColorNumbers() {
        if ((this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-core/src/main/api/Color.scala: 31");
        }
        return this.ColorNumbers;
    }

    public double getColorNumberByIndex(int index) {
        return this.ColorNumbers()[index];
    }

    public LogoList BaseColors() {
        if ((this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-core/src/main/api/Color.scala: 41");
        }
        return this.BaseColors;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public java.awt.Color getColor(Object color) {
        boolean bl = false;
        LogoList logoList = null;
        if (color instanceof Double) {
            Double d = (Double)color;
            return this.AWT_Cache()[(int)(d * (double)10)];
        }
        if (color instanceof LogoList) {
            bl = true;
            logoList = (LogoList)color;
            if (logoList.size() == 3) {
                return new java.awt.Color(((Number)logoList.get(0)).intValue(), ((Number)logoList.get(1)).intValue(), ((Number)logoList.get(2)).intValue());
            }
        }
        if (!bl) throw new MatchError(color);
        if (logoList.size() != 4) throw new MatchError(color);
        return new java.awt.Color(((Number)logoList.get(0)).intValue(), ((Number)logoList.get(1)).intValue(), ((Number)logoList.get(2)).intValue(), ((Number)logoList.get(3)).intValue());
    }

    public String getClosestColorNameByARGB(int argb) {
        String string2;
        DecimalFormat formatter = new DecimalFormat("###.####");
        double d = this.getClosestColorNumberByARGB(argb);
        if ((double)ColorConstants$.MODULE$.Black() == d) {
            string2 = this.getColorNameByIndex(14);
        } else if (ColorConstants$.MODULE$.White() == d) {
            string2 = this.getColorNameByIndex(15);
        } else {
            int baseColorNumber = (int)this.findCentralColorNumber(d);
            double difference = d - (double)baseColorNumber;
            String baseColorName = this.getColorNameByIndex((baseColorNumber - 5) / 10);
            string2 = difference == 0.0 ? baseColorName : (difference > 0.0 ? new StringBuilder(3).append(baseColorName).append(" + ").append(formatter.format(StrictMath.abs(difference))).toString() : new StringBuilder(3).append(baseColorName).append(" - ").append(formatter.format(StrictMath.abs(difference))).toString());
        }
        return string2;
    }

    public double getClosestColorNumberByHSB(float h, float s, float b) {
        float hh = RichFloat$.MODULE$.min$extension(Predef$.MODULE$.floatWrapper(RichFloat$.MODULE$.max$extension(Predef$.MODULE$.floatWrapper(0.0f), h)), 360.0f);
        float ss = RichFloat$.MODULE$.min$extension(Predef$.MODULE$.floatWrapper(RichFloat$.MODULE$.max$extension(Predef$.MODULE$.floatWrapper(0.0f), s)), 100.0f);
        float bb = RichFloat$.MODULE$.min$extension(Predef$.MODULE$.floatWrapper(RichFloat$.MODULE$.max$extension(Predef$.MODULE$.floatWrapper(0.0f), b)), 100.0f);
        int argb = java.awt.Color.HSBtoRGB(hh / 360.0f, ss / 100.0f, bb / 100.0f);
        return BoxesRunTime.unboxToDouble(this.rgbMap().get(BoxesRunTime.boxToDouble(argb)).getOrElse((JFunction0$mcD$sp & scala.Serializable)() -> MODULE$.estimateClosestColorNumberByRGB(argb)));
    }

    public LogoList getRGBListByARGB(int argb) {
        LogoListBuilder result = new LogoListBuilder();
        result.add(Predef$.MODULE$.double2Double(Approximate$.MODULE$.approximate(argb >> 16 & 0xFF, 3)));
        result.add(Predef$.MODULE$.double2Double(Approximate$.MODULE$.approximate(argb >> 8 & 0xFF, 3)));
        result.add(Predef$.MODULE$.double2Double(Approximate$.MODULE$.approximate(argb & 0xFF, 3)));
        return result.toLogoList();
    }

    public LogoList getRGBAListByARGB(int argb) {
        LogoListBuilder result = new LogoListBuilder();
        result.add(BoxesRunTime.boxToDouble(Approximate$.MODULE$.approximate(argb >> 16 & 0xFF, 3)));
        result.add(BoxesRunTime.boxToDouble(Approximate$.MODULE$.approximate(argb >> 8 & 0xFF, 3)));
        result.add(BoxesRunTime.boxToDouble(Approximate$.MODULE$.approximate(argb & 0xFF, 3)));
        result.add(BoxesRunTime.boxToDouble(Approximate$.MODULE$.approximate(argb >> 24 & 0xFF, 3)));
        return result.toLogoList();
    }

    public LogoList getHSBListByARGB(int argb) {
        float[] hsb2 = new float[3];
        java.awt.Color.RGBtoHSB(argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF, hsb2);
        LogoListBuilder result = new LogoListBuilder();
        result.add(BoxesRunTime.boxToDouble(Approximate$.MODULE$.approximate(hsb2[0] * 360.0f, 3)));
        result.add(BoxesRunTime.boxToDouble(Approximate$.MODULE$.approximate(hsb2[1] * 100.0f, 3)));
        result.add(BoxesRunTime.boxToDouble(Approximate$.MODULE$.approximate(hsb2[2] * 100.0f, 3)));
        return result.toLogoList();
    }

    public LogoList getHSBListByRGBList(LogoList rgbList) {
        int r = (int)BoxesRunTime.unboxToDouble(rgbList.get(0));
        int g = (int)BoxesRunTime.unboxToDouble(rgbList.get(1));
        int b = (int)BoxesRunTime.unboxToDouble(rgbList.get(2));
        float[] hsbvals = java.awt.Color.RGBtoHSB(StrictMath.max(0, StrictMath.min(255, r)), StrictMath.max(0, StrictMath.min(255, g)), StrictMath.max(0, StrictMath.min(255, b)), null);
        LogoListBuilder llb = new LogoListBuilder();
        llb.add(BoxesRunTime.boxToDouble(Approximate$.MODULE$.approximate(hsbvals[0] * 360.0f, 3)));
        llb.add(BoxesRunTime.boxToDouble(Approximate$.MODULE$.approximate(hsbvals[1] * 100.0f, 3)));
        llb.add(BoxesRunTime.boxToDouble(Approximate$.MODULE$.approximate(hsbvals[2] * 100.0f, 3)));
        return llb.toLogoList();
    }

    public LogoList convertGoodHSBListToDumbOldHSBFormat(LogoList hsbvals) {
        LogoListBuilder hsbList = new LogoListBuilder();
        hsbList.add(BoxesRunTime.boxToDouble(Approximate$.MODULE$.approximate(0.7083333134651184 * Predef$.MODULE$.Double2double((Double)hsbvals.apply(0)), 3)));
        hsbList.add(BoxesRunTime.boxToDouble(Approximate$.MODULE$.approximate((double)2.55f * Predef$.MODULE$.Double2double((Double)hsbvals.apply(1)), 3)));
        hsbList.add(BoxesRunTime.boxToDouble(Approximate$.MODULE$.approximate((double)2.55f * Predef$.MODULE$.Double2double((Double)hsbvals.apply(2)), 3)));
        return hsbList.toLogoList();
    }

    public LogoList getHSBListByColor(double color) {
        double ccolor = color < 0.0 || color >= (double)140 ? this.modulateDouble(color) : color;
        return this.getHSBListByARGB(this.getARGBbyPremodulatedColorNumber(ccolor));
    }

    public java.awt.Color getComplement(java.awt.Color color) {
        float[] rgb = color.getRGBColorComponents(null);
        return new java.awt.Color((rgb[0] + 0.5f) % 1.0f, (rgb[1] + 0.5f) % 1.0f, (rgb[2] + 0.5f) % 1.0f);
    }

    public void validRGBList(LogoList rgb, boolean allowAlpha) throws AgentException {
        if (rgb.size() == 3 || allowAlpha && rgb.size() == 4) {
            try {
                for (int i = 0; i < rgb.size(); ++i) {
                    Color$.validRGB$1(((Double)rgb.get(i)).intValue());
                }
                return;
            }
            catch (ClassCastException e) {
                Exceptions$.MODULE$.ignore(e);
            }
        }
        String key = new StringBuilder(22).append("org.nlogo.agent.Agent.").append((Object)(allowAlpha ? "rgbListSizeError.3or4" : "rgbListSizeError.3")).toString();
        throw new AgentException(I18N$.MODULE$.errors().get(key));
    }

    private String ColorTranslations() {
        if ((this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-core/src/main/api/Color.scala: 220");
        }
        return this.ColorTranslations;
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<Object, Object> colorTranslations$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                void var1_1;
                HashMap map = (HashMap)HashMap$.MODULE$.apply(Nil$.MODULE$);
                Resource$.MODULE$.get(this.ColorTranslations()).getLines().map((Function1<String, String> & Serializable & scala.Serializable)x$1 -> x$1.trim()).filter((Function1<String, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(Color$.$anonfun$colorTranslations$2(x$2))).filter((Function1<String, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean(Color$.$anonfun$colorTranslations$3(x$3))).foreach((Function1<String, HashMap> & Serializable & scala.Serializable)line -> {
                    String[] strs = line.split("\\s+");
                    int index = new StringOps(Predef$.MODULE$.augmentString((String)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])strs)).head())).toInt();
                    return (HashMap)map.$plus$plus$eq(RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])strs)).size()).map((Function1<Object, Tuple2> & Serializable & scala.Serializable)j -> Color$.$anonfun$colorTranslations$5(strs, index, BoxesRunTime.unboxToInt(j)), IndexedSeq$.MODULE$.canBuildFrom()));
                });
                this.colorTranslations = var1_1;
                this.bitmap$0 = true;
            }
        }
        return this.colorTranslations;
    }

    private HashMap<Object, Object> colorTranslations() {
        if (!this.bitmap$0) {
            return this.colorTranslations$lzycompute();
        }
        return this.colorTranslations;
    }

    public int translateSavedColor(int color) {
        return BoxesRunTime.unboxToInt(this.colorTranslations().get(BoxesRunTime.boxToDouble(color)).map((JFunction1$mcII$sp & scala.Serializable)x$4 -> x$4).map((JFunction1$mcII$sp & scala.Serializable)index -> MODULE$.getARGBByIndex(index)).getOrElse((JFunction0$mcI$sp & scala.Serializable)() -> color));
    }

    public static final /* synthetic */ java.awt.Color $anonfun$AWT_Cache$1(int i) {
        return new java.awt.Color(MODULE$.getARGBbyPremodulatedColorNumber((double)i / 10.0));
    }

    public static final /* synthetic */ Double $anonfun$BaseColors$1(int n) {
        return BoxesRunTime.boxToDouble(n * 10 + 5);
    }

    private static final void validRGB$1(int c) {
        if (c < 0 || c > 255) {
            throw new AgentException(I18N$.MODULE$.errors().get("org.nlogo.agent.Agent.rgbValueError"));
        }
    }

    public static final /* synthetic */ boolean $anonfun$colorTranslations$2(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$colorTranslations$3(String x$3) {
        return BoxesRunTime.unboxToChar(new StringOps(Predef$.MODULE$.augmentString(x$3)).head()) != '#';
    }

    public static final /* synthetic */ Tuple2 $anonfun$colorTranslations$5(String[] strs$1, int index$1, int j) {
        return new Tuple2$mcDI$sp(new StringOps(Predef$.MODULE$.augmentString(strs$1[j])).toDouble(), index$1);
    }

    private Color$() {
        MODULE$ = this;
        Color.$init$(this);
        this.ColorNames = (String[])((Object[])new String[]{"gray", "red", "orange", "brown", "yellow", "green", "lime", "turquoise", "cyan", "sky", "blue", "violet", "magenta", "pink", "black", "white"});
        this.bitmap$init$0 |= 1;
        this.AWT_Cache = (java.awt.Color[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.MaxColor() * 10).toArray(ClassTag$.MODULE$.Int()))).map((Function1<Object, java.awt.Color> & Serializable & scala.Serializable)i -> Color$.$anonfun$AWT_Cache$1(BoxesRunTime.unboxToInt(i)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(java.awt.Color.class)));
        this.bitmap$init$0 |= 2;
        this.ColorNumbers = (double[])Array$.MODULE$.apply(Predef$.MODULE$.wrapDoubleArray(new double[]{5.0, 15.0, 25.0, 35.0, 45.0, 55.0, 65.0, 75.0, 85.0, 95.0, 105.0, 115.0, 125.0, 135.0, ColorConstants$.MODULE$.Black(), ColorConstants$.MODULE$.White()}), ClassTag$.MODULE$.Double());
        this.bitmap$init$0 |= 4;
        this.BaseColors = LogoList$.MODULE$.apply(RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 13).map((Function1<Object, Double> & Serializable & scala.Serializable)n -> Color$.$anonfun$BaseColors$1(BoxesRunTime.unboxToInt(n)), IndexedSeq$.MODULE$.canBuildFrom()));
        this.bitmap$init$0 |= 8;
        this.ColorTranslations = "/system/color-translation.txt";
        this.bitmap$init$0 |= 0x10;
    }
}

