// Code generated by sdkgen. DO NOT EDIT.

// nolint
package workflows

import (
	"context"

	"google.golang.org/grpc"

	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	workflows "github.com/yandex-cloud/go-genproto/yandex/cloud/serverless/workflows/v1"
)

//revive:disable

// WorkflowServiceClient is a workflows.WorkflowServiceClient with
// lazy GRPC connection initialization.
type WorkflowServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements workflows.WorkflowServiceClient
func (c *WorkflowServiceClient) Create(ctx context.Context, in *workflows.CreateWorkflowRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return workflows.NewWorkflowServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements workflows.WorkflowServiceClient
func (c *WorkflowServiceClient) Delete(ctx context.Context, in *workflows.DeleteWorkflowRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return workflows.NewWorkflowServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements workflows.WorkflowServiceClient
func (c *WorkflowServiceClient) Get(ctx context.Context, in *workflows.GetWorkflowRequest, opts ...grpc.CallOption) (*workflows.GetWorkflowResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return workflows.NewWorkflowServiceClient(conn).Get(ctx, in, opts...)
}

// List implements workflows.WorkflowServiceClient
func (c *WorkflowServiceClient) List(ctx context.Context, in *workflows.ListWorkflowsRequest, opts ...grpc.CallOption) (*workflows.ListWorkflowsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return workflows.NewWorkflowServiceClient(conn).List(ctx, in, opts...)
}

type WorkflowIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *WorkflowServiceClient
	request *workflows.ListWorkflowsRequest

	items []*workflows.WorkflowPreview
}

func (c *WorkflowServiceClient) WorkflowIterator(ctx context.Context, req *workflows.ListWorkflowsRequest, opts ...grpc.CallOption) *WorkflowIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &WorkflowIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *WorkflowIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Workflows
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *WorkflowIterator) Take(size int64) ([]*workflows.WorkflowPreview, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*workflows.WorkflowPreview

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *WorkflowIterator) TakeAll() ([]*workflows.WorkflowPreview, error) {
	return it.Take(0)
}

func (it *WorkflowIterator) Value() *workflows.WorkflowPreview {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *WorkflowIterator) Error() error {
	return it.err
}

// ListOperations implements workflows.WorkflowServiceClient
func (c *WorkflowServiceClient) ListOperations(ctx context.Context, in *workflows.ListOperationsRequest, opts ...grpc.CallOption) (*workflows.ListOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return workflows.NewWorkflowServiceClient(conn).ListOperations(ctx, in, opts...)
}

type WorkflowOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *WorkflowServiceClient
	request *workflows.ListOperationsRequest

	items []*operation.Operation
}

func (c *WorkflowServiceClient) WorkflowOperationsIterator(ctx context.Context, req *workflows.ListOperationsRequest, opts ...grpc.CallOption) *WorkflowOperationsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &WorkflowOperationsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *WorkflowOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *WorkflowOperationsIterator) Take(size int64) ([]*operation.Operation, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*operation.Operation

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *WorkflowOperationsIterator) TakeAll() ([]*operation.Operation, error) {
	return it.Take(0)
}

func (it *WorkflowOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *WorkflowOperationsIterator) Error() error {
	return it.err
}

// Update implements workflows.WorkflowServiceClient
func (c *WorkflowServiceClient) Update(ctx context.Context, in *workflows.UpdateWorkflowRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return workflows.NewWorkflowServiceClient(conn).Update(ctx, in, opts...)
}
