// Code generated by sdkgen. DO NOT EDIT.

// nolint
package greenplum

import (
	"context"

	"google.golang.org/grpc"

	greenplum "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/greenplum/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// PXFDatasourceServiceClient is a greenplum.PXFDatasourceServiceClient with
// lazy GRPC connection initialization.
type PXFDatasourceServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements greenplum.PXFDatasourceServiceClient
func (c *PXFDatasourceServiceClient) Create(ctx context.Context, in *greenplum.CreatePXFDatasourceRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return greenplum.NewPXFDatasourceServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements greenplum.PXFDatasourceServiceClient
func (c *PXFDatasourceServiceClient) Delete(ctx context.Context, in *greenplum.DeletePXFDatasourceRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return greenplum.NewPXFDatasourceServiceClient(conn).Delete(ctx, in, opts...)
}

// List implements greenplum.PXFDatasourceServiceClient
func (c *PXFDatasourceServiceClient) List(ctx context.Context, in *greenplum.ListPXFDatasourcesRequest, opts ...grpc.CallOption) (*greenplum.ListPXFDatasourcesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return greenplum.NewPXFDatasourceServiceClient(conn).List(ctx, in, opts...)
}

type PXFDatasourceIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *PXFDatasourceServiceClient
	request *greenplum.ListPXFDatasourcesRequest

	items []*greenplum.PXFDatasource
}

func (c *PXFDatasourceServiceClient) PXFDatasourceIterator(ctx context.Context, req *greenplum.ListPXFDatasourcesRequest, opts ...grpc.CallOption) *PXFDatasourceIterator {
	var pageSize int64
	const defaultPageSize = 1000

	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &PXFDatasourceIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *PXFDatasourceIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started {
		return false
	}
	it.started = true

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Datasources
	return len(it.items) > 0
}

func (it *PXFDatasourceIterator) Take(size int64) ([]*greenplum.PXFDatasource, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*greenplum.PXFDatasource

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *PXFDatasourceIterator) TakeAll() ([]*greenplum.PXFDatasource, error) {
	return it.Take(0)
}

func (it *PXFDatasourceIterator) Value() *greenplum.PXFDatasource {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *PXFDatasourceIterator) Error() error {
	return it.err
}

// Update implements greenplum.PXFDatasourceServiceClient
func (c *PXFDatasourceServiceClient) Update(ctx context.Context, in *greenplum.UpdatePXFDatasourceRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return greenplum.NewPXFDatasourceServiceClient(conn).Update(ctx, in, opts...)
}
