/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;

public final class Cursor
extends Resource {
    public long handle;

    Cursor(Device device) {
        super(device);
    }

    public Cursor(Device device, int style) {
        super(device);
        String name1 = null;
        String name2 = null;
        switch (style) {
            case 3: {
                name1 = "left_ptr_watch";
                break;
            }
            case 0: {
                name1 = "left_ptr";
                break;
            }
            case 1: {
                name1 = "watch";
                break;
            }
            case 2: {
                name1 = "crosshair";
                break;
            }
            case 21: {
                name1 = "hand2";
                break;
            }
            case 4: {
                name1 = "question_arrow";
                break;
            }
            case 5: {
                name1 = "fleur";
                break;
            }
            case 6: {
                name1 = "size_bdiag";
                break;
            }
            case 7: {
                name1 = "sb_v_double_arrow";
                break;
            }
            case 8: {
                name1 = "size_fdiag";
                break;
            }
            case 9: {
                name1 = "sb_h_double_arrow";
                break;
            }
            case 10: {
                name1 = "top_side";
                break;
            }
            case 11: {
                name1 = "bottom_side";
                break;
            }
            case 12: {
                name1 = "right_side";
                break;
            }
            case 13: {
                name1 = "left_side";
                break;
            }
            case 14: {
                name1 = "top_right_corner";
                break;
            }
            case 15: {
                name1 = "bottom_right_corner";
                break;
            }
            case 16: {
                name1 = "bottom_left_corner";
                break;
            }
            case 17: {
                name1 = "top_left_corner";
                break;
            }
            case 18: {
                name1 = "sb_up_arrow";
                name2 = "up-arrow";
                break;
            }
            case 19: {
                name1 = "xterm";
                break;
            }
            case 20: {
                name1 = "crossed_circle";
                name2 = "not-allowed";
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        for (String name : new String[]{name1, name2, "left_ptr", "default"}) {
            if (name == null) continue;
            this.handle = GTK.GTK4 ? GDK.gdk_cursor_new_from_name(name, 0L) : GDK.gdk_cursor_new_from_name(GDK.gdk_display_get_default(), name);
            if (this.handle != 0L) break;
        }
        if (this.handle == 0L) {
            SWT.error(2);
        }
        this.init();
    }

    public Cursor(Device device, ImageData source, ImageData mask, int hotspotX, int hotspotY) {
        super(device);
        byte s;
        int i;
        if (source == null) {
            SWT.error(4);
        }
        if (mask == null) {
            if (source.getTransparencyType() != 2) {
                SWT.error(4);
            }
            mask = source.getTransparencyMask();
        }
        if (mask.width != source.width || mask.height != source.height) {
            SWT.error(5);
        }
        if (hotspotX >= source.width || hotspotX < 0 || hotspotY >= source.height || hotspotY < 0) {
            SWT.error(5);
        }
        source = ImageData.convertMask(source);
        mask = ImageData.convertMask(mask);
        byte[] sourceData = new byte[source.data.length];
        byte[] maskData = new byte[mask.data.length];
        byte[] data = source.data;
        for (i = 0; i < data.length; ++i) {
            s = data[i];
            sourceData[i] = (byte)((s & 0x80) >> 7 | (s & 0x40) >> 5 | (s & 0x20) >> 3 | (s & 0x10) >> 1 | (s & 8) << 1 | (s & 4) << 3 | (s & 2) << 5 | (s & 1) << 7);
            sourceData[i] = ~sourceData[i];
        }
        sourceData = ImageData.convertPad(sourceData, source.width, source.height, source.depth, source.scanlinePad, 1);
        data = mask.data;
        for (i = 0; i < data.length; ++i) {
            s = data[i];
            maskData[i] = (byte)((s & 0x80) >> 7 | (s & 0x40) >> 5 | (s & 0x20) >> 3 | (s & 0x10) >> 1 | (s & 8) << 1 | (s & 4) << 3 | (s & 2) << 5 | (s & 1) << 7);
            maskData[i] = ~maskData[i];
        }
        maskData = ImageData.convertPad(maskData, mask.width, mask.height, mask.depth, mask.scanlinePad, 1);
        this.handle = this.createCursor(sourceData, maskData, source.width, source.height, hotspotX, hotspotY, true);
        if (this.handle == 0L) {
            SWT.error(2);
        }
        this.init();
    }

    public Cursor(Device device, ImageData source, int hotspotX, int hotspotY) {
        super(device);
        if (source == null) {
            SWT.error(4);
        }
        if (hotspotX >= source.width || hotspotX < 0 || hotspotY >= source.height || hotspotY < 0) {
            SWT.error(5);
        }
        long display = GDK.gdk_display_get_default();
        int width = source.width;
        int height = source.height;
        PaletteData palette = source.palette;
        long pixbuf = GDK.gdk_pixbuf_new(0, true, 8, width, height);
        if (pixbuf == 0L) {
            SWT.error(2);
        }
        int stride = GDK.gdk_pixbuf_get_rowstride(pixbuf);
        long data = GDK.gdk_pixbuf_get_pixels(pixbuf);
        byte[] buffer = source.data;
        if (!palette.isDirect || source.depth != 24 || stride != source.bytesPerLine || palette.redMask != -16777216 || palette.greenMask != 0xFF0000 || palette.blueMask != 65280) {
            buffer = new byte[source.width * source.height * 4];
            if (palette.isDirect) {
                ImageData.blit(source.data, source.depth, source.bytesPerLine, source.getByteOrder(), source.width, source.height, palette.redMask, palette.greenMask, palette.blueMask, buffer, 32, source.width * 4, 1, source.width, source.height, -16777216, 0xFF0000, 65280, false, false);
            } else {
                RGB[] rgbs = palette.getRGBs();
                int length = rgbs.length;
                byte[] srcReds = new byte[length];
                byte[] srcGreens = new byte[length];
                byte[] srcBlues = new byte[length];
                for (int i = 0; i < rgbs.length; ++i) {
                    RGB rgb = rgbs[i];
                    if (rgb == null) continue;
                    srcReds[i] = (byte)rgb.red;
                    srcGreens[i] = (byte)rgb.green;
                    srcBlues[i] = (byte)rgb.blue;
                }
                ImageData.blit(source.width, source.height, source.data, source.depth, source.bytesPerLine, source.getByteOrder(), srcReds, srcGreens, srcBlues, buffer, 32, source.width * 4, 1, -16777216, 0xFF0000, 65280);
            }
            if (source.maskData != null || source.transparentPixel != -1) {
                ImageData mask = source.getTransparencyMask();
                byte[] maskData = mask.data;
                int maskBpl = mask.bytesPerLine;
                int offset = 3;
                int maskOffset = 0;
                for (int y = 0; y < source.height; ++y) {
                    for (int x = 0; x < source.width; ++x) {
                        buffer[offset] = (maskData[maskOffset + (x >> 3)] & 1 << 7 - (x & 7)) != 0 ? -1 : 0;
                        offset += 4;
                    }
                    maskOffset += maskBpl;
                }
            } else if (source.alpha != -1) {
                byte alpha = (byte)source.alpha;
                for (i = 3; i < buffer.length; i += 4) {
                    buffer[i] = alpha;
                }
            } else if (source.alphaData != null) {
                byte[] alphaData = source.alphaData;
                for (i = 3; i < buffer.length; i += 4) {
                    buffer[i] = alphaData[i / 4];
                }
            } else {
                for (int i = 3; i < buffer.length; i += 4) {
                    buffer[i] = -1;
                }
            }
        }
        C.memmove(data, buffer, (long)(stride * height));
        if (GTK.GTK4) {
            long texture = GDK.gdk_texture_new_for_pixbuf(pixbuf);
            this.handle = GDK.gdk_cursor_new_from_texture(texture, hotspotX, hotspotY, 0L);
            OS.g_object_unref(texture);
        } else {
            this.handle = GDK.gdk_cursor_new_from_pixbuf(display, pixbuf, hotspotX, hotspotY);
        }
        OS.g_object_unref(pixbuf);
        if (this.handle == 0L) {
            SWT.error(2);
        }
        this.init();
    }

    long createCursor(byte[] sourceData, byte[] maskData, int width, int height, int hotspotX, int hotspotY, boolean reverse) {
        long cursor;
        byte s;
        int i;
        for (i = 0; i < sourceData.length; ++i) {
            s = sourceData[i];
            sourceData[i] = (byte)((s & 0x80) >> 7 | (s & 0x40) >> 5 | (s & 0x20) >> 3 | (s & 0x10) >> 1 | (s & 8) << 1 | (s & 4) << 3 | (s & 2) << 5 | (s & 1) << 7);
            sourceData[i] = ~sourceData[i];
        }
        for (i = 0; i < maskData.length; ++i) {
            s = maskData[i];
            maskData[i] = (byte)((s & 0x80) >> 7 | (s & 0x40) >> 5 | (s & 0x20) >> 3 | (s & 0x10) >> 1 | (s & 8) << 1 | (s & 4) << 3 | (s & 2) << 5 | (s & 1) << 7);
            maskData[i] = ~maskData[i];
        }
        PaletteData palette = new PaletteData(new RGB(0, 0, 0), new RGB(255, 255, 255));
        ImageData source = new ImageData(width, height, 1, palette, 1, sourceData);
        ImageData mask = new ImageData(width, height, 1, palette, 1, maskData);
        byte[] data = new byte[source.width * source.height * 4];
        for (int y = 0; y < source.height; ++y) {
            int offset = y * source.width * 4;
            for (int x = 0; x < source.width; ++x) {
                int pixel = source.getPixel(x, y);
                int maskPixel = mask.getPixel(x, y);
                if (pixel == 0 && maskPixel == 0) {
                    data[offset + 3] = -1;
                } else if (pixel == 0 && maskPixel == 1) {
                    data[offset + 3] = -1;
                    data[offset + 2] = -1;
                    data[offset + 1] = -1;
                    data[offset] = -1;
                } else if (pixel != 1 || maskPixel == 0) {
                    // empty if block
                }
                offset += 4;
            }
        }
        long pixbuf = GDK.gdk_pixbuf_new(0, true, 8, width, height);
        if (pixbuf == 0L) {
            SWT.error(2);
        }
        int stride = GDK.gdk_pixbuf_get_rowstride(pixbuf);
        long pixels = GDK.gdk_pixbuf_get_pixels(pixbuf);
        C.memmove(pixels, data, (long)(stride * height));
        if (GTK.GTK4) {
            long texture = GDK.gdk_texture_new_for_pixbuf(pixbuf);
            cursor = GDK.gdk_cursor_new_from_texture(texture, hotspotX, hotspotY, 0L);
            OS.g_object_unref(texture);
        } else {
            cursor = GDK.gdk_cursor_new_from_pixbuf(GDK.gdk_display_get_default(), pixbuf, hotspotX, hotspotY);
        }
        OS.g_object_unref(pixbuf);
        return cursor;
    }

    @Override
    void destroy() {
        OS.g_object_unref(this.handle);
        this.handle = 0L;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Cursor)) {
            return false;
        }
        Cursor cursor = (Cursor)object;
        return this.device == cursor.device && this.handle == cursor.handle;
    }

    public static Cursor gtk_new(Device device, long handle) {
        Cursor cursor = new Cursor(device);
        cursor.handle = handle;
        return cursor;
    }

    public int hashCode() {
        return (int)this.handle;
    }

    @Override
    public boolean isDisposed() {
        return this.handle == 0L;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Cursor {*DISPOSED*}";
        }
        return "Cursor {" + this.handle + "}";
    }
}

