/* game-series.c generated by valac 0.46.3, the Vala compiler
 * generated from game-series.vala, do not modify */

/*  Pasang Emas. Enjoy a unique traditional game of Brunei.
    Copyright (C) 2010  Nor Jaidi Tuah

    This file is part of Pasang Emas.
      
    Pasang Emas is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define PASANG_TYPE_GAME (pasang_game_get_type ())
#define PASANG_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_GAME, PasangGame))
#define PASANG_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_GAME, PasangGameClass))
#define PASANG_IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_GAME))
#define PASANG_IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_GAME))
#define PASANG_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_GAME, PasangGameClass))

typedef struct _PasangGame PasangGame;
typedef struct _PasangGameClass PasangGameClass;
typedef struct _PasangGamePrivate PasangGamePrivate;
typedef enum  {
	PASANG_PIECE_NULL = -999,
	PASANG_PIECE_KAS_0 = 0,
	PASANG_PIECE_KAS_1 = 1,
	PASANG_PIECE_BLACK = 2,
	PASANG_PIECE_WHITE = 3,
	PASANG_PIECE_COUNT = 4,
	PASANG_PIECE_BOARD = 4,
	PASANG_PIECE_GUARD = 5,
	PASANG_PIECE_GUIDE = 6,
	PASANG_PIECE_EMPTY = 100
} PasangPiece;

#define PASANG_TYPE_PIECE (pasang_piece_get_type ())

#define PASANG_TYPE_GAME_SERIES (pasang_game_series_get_type ())
#define PASANG_GAME_SERIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_GAME_SERIES, PasangGameSeries))
#define PASANG_GAME_SERIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_GAME_SERIES, PasangGameSeriesClass))
#define PASANG_IS_GAME_SERIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_GAME_SERIES))
#define PASANG_IS_GAME_SERIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_GAME_SERIES))
#define PASANG_GAME_SERIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_GAME_SERIES, PasangGameSeriesClass))

typedef struct _PasangGameSeries PasangGameSeries;
typedef struct _PasangGameSeriesClass PasangGameSeriesClass;
typedef struct _PasangGameSeriesPrivate PasangGameSeriesPrivate;
enum  {
	PASANG_GAME_SERIES_0_PROPERTY,
	PASANG_GAME_SERIES_NUM_PROPERTIES
};
static GParamSpec* pasang_game_series_properties[PASANG_GAME_SERIES_NUM_PROPERTIES];
typedef enum  {
	PASANG_STAGE_NULL = -999,
	PASANG_STAGE_OPENING = 0,
	PASANG_STAGE_SELECT = 1,
	PASANG_STAGE_SUB_SELECT = 2,
	PASANG_STAGE_MOVE = 3,
	PASANG_STAGE_SUB_MOVE = 4,
	PASANG_STAGE_GAME_OVER = 5
} PasangStage;

#define PASANG_TYPE_STAGE (pasang_stage_get_type ())

#define PASANG_TYPE_MOVE (pasang_move_get_type ())
#define PASANG_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_MOVE, PasangMove))
#define PASANG_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_MOVE, PasangMoveClass))
#define PASANG_IS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_MOVE))
#define PASANG_IS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_MOVE))
#define PASANG_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_MOVE, PasangMoveClass))

typedef struct _PasangMove PasangMove;
typedef struct _PasangMoveClass PasangMoveClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PasangGame {
	GObject parent_instance;
	PasangGamePrivate * priv;
	PasangPiece* board;
	gint board_length1;
	gint* score;
	gint score_length1;
	gint* kas_position;
	gint kas_position_length1;
	gint* first_move;
	gint first_move_length1;
};

struct _PasangGameClass {
	GObjectClass parent_class;
};

struct _PasangGameSeries {
	PasangGame parent_instance;
	PasangGameSeriesPrivate * priv;
	gboolean rotated;
	gint num_wins[2];
	gint num_rounds;
};

struct _PasangGameSeriesClass {
	PasangGameClass parent_class;
};

struct _PasangGameSeriesPrivate {
	gchar** recording;
	gint recording_length1;
	gint _recording_size_;
	gint undo_num_wins[2];
	gint undo_num_rounds;
};

static gint PasangGameSeries_private_offset;
static gpointer pasang_game_series_parent_class = NULL;

GType pasang_game_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangGame, g_object_unref)
GType pasang_piece_get_type (void) G_GNUC_CONST;
GType pasang_game_series_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangGameSeries, g_object_unref)
void pasang_game_series_start_new_series (PasangGameSeries* self);
void pasang_game_series_update_num_wins (PasangGameSeries* self);
GType pasang_stage_get_type (void) G_GNUC_CONST;
PasangStage pasang_game_get_stage (PasangGame* self);
void pasang_game_series_start_recorded (PasangGameSeries* self,
                                        const gchar* starting_pattern);
void pasang_game_start (PasangGame* self,
                        const gchar* starting_pattern);
GType pasang_move_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangMove, g_object_unref)
void pasang_game_series_perform_recorded (PasangGameSeries* self,
                                          PasangMove* move,
                                          gboolean full_move);
void pasang_game_perform (PasangGame* self,
                          PasangMove* move,
                          gboolean full_move);
const gchar* pasang_move_get_notation (PasangMove* self);
static void _vala_array_add9 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
void pasang_game_series_undo (PasangGameSeries* self);
void pasang_game_generate_moves (PasangGame* self);
void pasang_game_perform_from_notation (PasangGame* self,
                                        const gchar* move_notation);
gchar* pasang_game_series_starting_pattern (PasangGameSeries* self);
PasangGameSeries* pasang_game_series_new (void);
PasangGameSeries* pasang_game_series_construct (GType object_type);
PasangGame* pasang_game_new (void);
PasangGame* pasang_game_construct (GType object_type);
static void pasang_game_series_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
pasang_game_series_get_instance_private (PasangGameSeries* self)
{
	return G_STRUCT_MEMBER_P (self, PasangGameSeries_private_offset);
}

/**
     * Start a new series of games rounds
     */
void
pasang_game_series_start_new_series (PasangGameSeries* self)
{
#line 49 "game-series.vala"
	g_return_if_fail (self != NULL);
#line 50 "game-series.vala"
	self->num_rounds = 0;
#line 51 "game-series.vala"
	self->num_wins[0] = 0;
#line 52 "game-series.vala"
	self->num_wins[1] = 0;
#line 198 "game-series.c"
}

/**
     * Update the number of wins. Must be called once only after each move
     */
void
pasang_game_series_update_num_wins (PasangGameSeries* self)
{
	PasangStage _tmp0_;
	PasangStage _tmp1_;
#line 58 "game-series.vala"
	g_return_if_fail (self != NULL);
#line 59 "game-series.vala"
	_tmp0_ = pasang_game_get_stage ((PasangGame*) self);
#line 59 "game-series.vala"
	_tmp1_ = _tmp0_;
#line 59 "game-series.vala"
	if (_tmp1_ == PASANG_STAGE_GAME_OVER) {
#line 217 "game-series.c"
		gint _tmp2_;
		gint _tmp3_ = 0;
		gint top = 0;
		gint bottom = 0;
		gint diff = 0;
		gint* _tmp4_;
		gint _tmp4__length1;
		gint _tmp5_;
		gint* _tmp6_;
		gint _tmp6__length1;
		gint _tmp7_;
#line 60 "game-series.vala"
		_tmp2_ = self->num_rounds;
#line 60 "game-series.vala"
		self->num_rounds = _tmp2_ + 1;
#line 62 "game-series.vala"
		if (self->rotated) {
#line 62 "game-series.vala"
			_tmp3_ = 1;
#line 237 "game-series.c"
		} else {
#line 62 "game-series.vala"
			_tmp3_ = 0;
#line 241 "game-series.c"
		}
#line 62 "game-series.vala"
		top = _tmp3_;
#line 63 "game-series.vala"
		bottom = 1 - top;
#line 64 "game-series.vala"
		_tmp4_ = ((PasangGame*) self)->score;
#line 64 "game-series.vala"
		_tmp4__length1 = ((PasangGame*) self)->score_length1;
#line 64 "game-series.vala"
		_tmp5_ = _tmp4_[top];
#line 64 "game-series.vala"
		_tmp6_ = ((PasangGame*) self)->score;
#line 64 "game-series.vala"
		_tmp6__length1 = ((PasangGame*) self)->score_length1;
#line 64 "game-series.vala"
		_tmp7_ = _tmp6_[bottom];
#line 64 "game-series.vala"
		diff = _tmp5_ - _tmp7_;
#line 65 "game-series.vala"
		if (diff > 0) {
#line 263 "game-series.c"
			gint _tmp8_;
#line 65 "game-series.vala"
			_tmp8_ = self->num_wins[0];
#line 65 "game-series.vala"
			self->num_wins[0] = _tmp8_ + 1;
#line 269 "game-series.c"
		} else {
#line 66 "game-series.vala"
			if (diff < 0) {
#line 273 "game-series.c"
				gint _tmp9_;
#line 66 "game-series.vala"
				_tmp9_ = self->num_wins[1];
#line 66 "game-series.vala"
				self->num_wins[1] = _tmp9_ + 1;
#line 279 "game-series.c"
			}
		}
	}
}

/**
     * Start a game and record its starting pattern
     */
void
pasang_game_series_start_recorded (PasangGameSeries* self,
                                   const gchar* starting_pattern)
{
	gchar* _tmp0_;
	gchar** _tmp1_;
#line 73 "game-series.vala"
	g_return_if_fail (self != NULL);
#line 73 "game-series.vala"
	g_return_if_fail (starting_pattern != NULL);
#line 74 "game-series.vala"
	pasang_game_start ((PasangGame*) self, starting_pattern);
#line 75 "game-series.vala"
	_tmp0_ = g_strdup (starting_pattern);
#line 75 "game-series.vala"
	_tmp1_ = g_new0 (gchar*, 1 + 1);
#line 75 "game-series.vala"
	_tmp1_[0] = _tmp0_;
#line 75 "game-series.vala"
	self->priv->recording = (_vala_array_free (self->priv->recording, self->priv->recording_length1, (GDestroyNotify) g_free), NULL);
#line 75 "game-series.vala"
	self->priv->recording = _tmp1_;
#line 75 "game-series.vala"
	self->priv->recording_length1 = 1;
#line 75 "game-series.vala"
	self->priv->_recording_size_ = self->priv->recording_length1;
#line 76 "game-series.vala"
	self->priv->undo_num_rounds = self->num_rounds;
#line 77 "game-series.vala"
	memcpy (self->priv->undo_num_wins, self->num_wins, 2 * sizeof (gint));
#line 318 "game-series.c"
}

/**
     * Perform a move and record it
     */
static void
_vala_array_add9 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
#line 86 "game-series.vala"
	if ((*length) == (*size)) {
#line 86 "game-series.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 86 "game-series.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 336 "game-series.c"
	}
#line 86 "game-series.vala"
	(*array)[(*length)++] = value;
#line 86 "game-series.vala"
	(*array)[*length] = NULL;
#line 342 "game-series.c"
}

void
pasang_game_series_perform_recorded (PasangGameSeries* self,
                                     PasangMove* move,
                                     gboolean full_move)
{
	gboolean _tmp0_ = FALSE;
	PasangStage _tmp1_;
	PasangStage _tmp2_;
#line 83 "game-series.vala"
	g_return_if_fail (self != NULL);
#line 83 "game-series.vala"
	g_return_if_fail (move != NULL);
#line 84 "game-series.vala"
	pasang_game_perform ((PasangGame*) self, move, full_move);
#line 85 "game-series.vala"
	_tmp1_ = pasang_game_get_stage ((PasangGame*) self);
#line 85 "game-series.vala"
	_tmp2_ = _tmp1_;
#line 85 "game-series.vala"
	if (_tmp2_ != PASANG_STAGE_SUB_MOVE) {
#line 365 "game-series.c"
		PasangStage _tmp3_;
		PasangStage _tmp4_;
#line 85 "game-series.vala"
		_tmp3_ = pasang_game_get_stage ((PasangGame*) self);
#line 85 "game-series.vala"
		_tmp4_ = _tmp3_;
#line 85 "game-series.vala"
		_tmp0_ = _tmp4_ != PASANG_STAGE_SUB_SELECT;
#line 374 "game-series.c"
	} else {
#line 85 "game-series.vala"
		_tmp0_ = FALSE;
#line 378 "game-series.c"
	}
#line 85 "game-series.vala"
	if (_tmp0_) {
#line 382 "game-series.c"
		gchar** _tmp5_;
		gint _tmp5__length1;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
#line 86 "game-series.vala"
		_tmp5_ = self->priv->recording;
#line 86 "game-series.vala"
		_tmp5__length1 = self->priv->recording_length1;
#line 86 "game-series.vala"
		_tmp6_ = pasang_move_get_notation (move);
#line 86 "game-series.vala"
		_tmp7_ = _tmp6_;
#line 86 "game-series.vala"
		_tmp8_ = g_strdup (_tmp7_);
#line 86 "game-series.vala"
		_vala_array_add9 (&self->priv->recording, &self->priv->recording_length1, &self->priv->_recording_size_, _tmp8_);
#line 400 "game-series.c"
	}
}

/**
     * Undo a move (by replaying the game)
     */
void
pasang_game_series_undo (PasangGameSeries* self)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp2_ = FALSE;
	PasangStage _tmp3_;
	PasangStage _tmp4_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
#line 93 "game-series.vala"
	g_return_if_fail (self != NULL);
#line 93 "game-series.vala"
	_tmp0_ = self->priv->recording;
#line 93 "game-series.vala"
	_tmp0__length1 = self->priv->recording_length1;
#line 93 "game-series.vala"
	_vala_return_if_fail (_tmp0__length1 > 0, "recording.length > 0");
#line 95 "game-series.vala"
	_tmp1_ = self->priv->recording;
#line 95 "game-series.vala"
	_tmp1__length1 = self->priv->recording_length1;
#line 95 "game-series.vala"
	if (_tmp1__length1 == 1) {
#line 95 "game-series.vala"
		return;
#line 436 "game-series.c"
	}
#line 96 "game-series.vala"
	self->num_rounds = self->priv->undo_num_rounds;
#line 97 "game-series.vala"
	memcpy (self->num_wins, self->priv->undo_num_wins, 2 * sizeof (gint));
#line 98 "game-series.vala"
	_tmp3_ = pasang_game_get_stage ((PasangGame*) self);
#line 98 "game-series.vala"
	_tmp4_ = _tmp3_;
#line 98 "game-series.vala"
	if (_tmp4_ != PASANG_STAGE_SUB_MOVE) {
#line 448 "game-series.c"
		PasangStage _tmp5_;
		PasangStage _tmp6_;
#line 98 "game-series.vala"
		_tmp5_ = pasang_game_get_stage ((PasangGame*) self);
#line 98 "game-series.vala"
		_tmp6_ = _tmp5_;
#line 98 "game-series.vala"
		_tmp2_ = _tmp6_ != PASANG_STAGE_SUB_SELECT;
#line 457 "game-series.c"
	} else {
#line 98 "game-series.vala"
		_tmp2_ = FALSE;
#line 461 "game-series.c"
	}
#line 98 "game-series.vala"
	if (_tmp2_) {
#line 465 "game-series.c"
		gint _tmp7_;
#line 99 "game-series.vala"
		_tmp7_ = self->priv->recording_length1;
#line 99 "game-series.vala"
		self->priv->recording_length1 = _tmp7_ - 1;
#line 471 "game-series.c"
	}
#line 102 "game-series.vala"
	_tmp8_ = self->priv->recording;
#line 102 "game-series.vala"
	_tmp8__length1 = self->priv->recording_length1;
#line 102 "game-series.vala"
	_tmp9_ = _tmp8_[0];
#line 102 "game-series.vala"
	pasang_game_start ((PasangGame*) self, _tmp9_);
#line 481 "game-series.c"
	{
		gint i = 0;
#line 103 "game-series.vala"
		i = 1;
#line 486 "game-series.c"
		{
			gboolean _tmp10_ = FALSE;
#line 103 "game-series.vala"
			_tmp10_ = TRUE;
#line 103 "game-series.vala"
			while (TRUE) {
#line 493 "game-series.c"
				gchar** _tmp12_;
				gint _tmp12__length1;
				gchar** _tmp13_;
				gint _tmp13__length1;
				const gchar* _tmp14_;
#line 103 "game-series.vala"
				if (!_tmp10_) {
#line 501 "game-series.c"
					gint _tmp11_;
#line 103 "game-series.vala"
					_tmp11_ = i;
#line 103 "game-series.vala"
					i = _tmp11_ + 1;
#line 507 "game-series.c"
				}
#line 103 "game-series.vala"
				_tmp10_ = FALSE;
#line 103 "game-series.vala"
				_tmp12_ = self->priv->recording;
#line 103 "game-series.vala"
				_tmp12__length1 = self->priv->recording_length1;
#line 103 "game-series.vala"
				if (!(i < _tmp12__length1)) {
#line 103 "game-series.vala"
					break;
#line 519 "game-series.c"
				}
#line 104 "game-series.vala"
				pasang_game_generate_moves ((PasangGame*) self);
#line 105 "game-series.vala"
				_tmp13_ = self->priv->recording;
#line 105 "game-series.vala"
				_tmp13__length1 = self->priv->recording_length1;
#line 105 "game-series.vala"
				_tmp14_ = _tmp13_[i];
#line 105 "game-series.vala"
				pasang_game_perform_from_notation ((PasangGame*) self, _tmp14_);
#line 531 "game-series.c"
			}
		}
	}
}

/**
     * Return the starting pattern used to start the game
     */
gchar*
pasang_game_series_starting_pattern (PasangGameSeries* self)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result = NULL;
#line 112 "game-series.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 113 "game-series.vala"
	_tmp0_ = self->priv->recording;
#line 113 "game-series.vala"
	_tmp0__length1 = self->priv->recording_length1;
#line 113 "game-series.vala"
	_vala_assert (_tmp0__length1 > 0, "recording.length > 0");
#line 114 "game-series.vala"
	_tmp1_ = self->priv->recording;
#line 114 "game-series.vala"
	_tmp1__length1 = self->priv->recording_length1;
#line 114 "game-series.vala"
	_tmp2_ = _tmp1_[0];
#line 114 "game-series.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 114 "game-series.vala"
	result = _tmp3_;
#line 114 "game-series.vala"
	return result;
#line 570 "game-series.c"
}

PasangGameSeries*
pasang_game_series_construct (GType object_type)
{
	PasangGameSeries * self = NULL;
#line 24 "game-series.vala"
	self = (PasangGameSeries*) pasang_game_construct (object_type);
#line 24 "game-series.vala"
	return self;
#line 581 "game-series.c"
}

PasangGameSeries*
pasang_game_series_new (void)
{
#line 24 "game-series.vala"
	return pasang_game_series_construct (PASANG_TYPE_GAME_SERIES);
#line 589 "game-series.c"
}

static void
pasang_game_series_class_init (PasangGameSeriesClass * klass,
                               gpointer klass_data)
{
#line 24 "game-series.vala"
	pasang_game_series_parent_class = g_type_class_peek_parent (klass);
#line 24 "game-series.vala"
	g_type_class_adjust_private_offset (klass, &PasangGameSeries_private_offset);
#line 24 "game-series.vala"
	G_OBJECT_CLASS (klass)->finalize = pasang_game_series_finalize;
#line 602 "game-series.c"
}

static void
pasang_game_series_instance_init (PasangGameSeries * self,
                                  gpointer klass)
{
	gchar** _tmp0_;
#line 24 "game-series.vala"
	self->priv = pasang_game_series_get_instance_private (self);
#line 42 "game-series.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 42 "game-series.vala"
	self->priv->recording = _tmp0_;
#line 42 "game-series.vala"
	self->priv->recording_length1 = 0;
#line 42 "game-series.vala"
	self->priv->_recording_size_ = self->priv->recording_length1;
#line 620 "game-series.c"
}

static void
pasang_game_series_finalize (GObject * obj)
{
	PasangGameSeries * self;
#line 24 "game-series.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PASANG_TYPE_GAME_SERIES, PasangGameSeries);
#line 42 "game-series.vala"
	self->priv->recording = (_vala_array_free (self->priv->recording, self->priv->recording_length1, (GDestroyNotify) g_free), NULL);
#line 24 "game-series.vala"
	G_OBJECT_CLASS (pasang_game_series_parent_class)->finalize (obj);
#line 633 "game-series.c"
}

/**
 * Extends Game to support undo and keep track of the number of wins
 */
GType
pasang_game_series_get_type (void)
{
	static volatile gsize pasang_game_series_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_game_series_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PasangGameSeriesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pasang_game_series_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PasangGameSeries), 0, (GInstanceInitFunc) pasang_game_series_instance_init, NULL };
		GType pasang_game_series_type_id;
		pasang_game_series_type_id = g_type_register_static (PASANG_TYPE_GAME, "PasangGameSeries", &g_define_type_info, 0);
		PasangGameSeries_private_offset = g_type_add_instance_private (pasang_game_series_type_id, sizeof (PasangGameSeriesPrivate));
		g_once_init_leave (&pasang_game_series_type_id__volatile, pasang_game_series_type_id);
	}
	return pasang_game_series_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

