/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.List;
import java.util.Optional;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BrokenResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariantSet;
import org.gradle.api.internal.artifacts.transform.ArtifactVariantSelector;
import org.gradle.api.internal.artifacts.transform.ConsumerProvidedVariantFinder;
import org.gradle.api.internal.artifacts.transform.TransformationChainSelector;
import org.gradle.api.internal.artifacts.transform.TransformedVariant;
import org.gradle.api.internal.attributes.AttributeSchemaServices;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.api.internal.attributes.matching.AttributeMatcher;
import org.gradle.internal.component.resolution.failure.ResolutionFailureHandler;

public class AttributeMatchingArtifactVariantSelector
implements ArtifactVariantSelector {
    private final ImmutableAttributesSchema consumerSchema;
    private final AttributesFactory attributesFactory;
    private final AttributeSchemaServices attributeSchemaServices;
    private final ResolutionFailureHandler failureHandler;
    private final TransformationChainSelector transformationChainSelector;

    public AttributeMatchingArtifactVariantSelector(ImmutableAttributesSchema consumerSchema, ConsumerProvidedVariantFinder transformationChainBuilder, AttributesFactory attributesFactory, AttributeSchemaServices attributeSchemaServices, ResolutionFailureHandler failureHandler) {
        this.consumerSchema = consumerSchema;
        this.attributesFactory = attributesFactory;
        this.attributeSchemaServices = attributeSchemaServices;
        this.failureHandler = failureHandler;
        this.transformationChainSelector = new TransformationChainSelector(transformationChainBuilder, failureHandler);
    }

    @Override
    public ResolvedArtifactSet select(ResolvedVariantSet producer, ImmutableAttributes requestAttributes, boolean allowNoMatchingVariants) {
        try {
            return this.doSelect(producer, requestAttributes, allowNoMatchingVariants);
        }
        catch (Exception t) {
            return new BrokenResolvedArtifactSet((Throwable)((Object)this.failureHandler.unknownArtifactVariantSelectionFailure(producer, requestAttributes, t)));
        }
    }

    private ResolvedArtifactSet doSelect(ResolvedVariantSet producer, ImmutableAttributes requestAttributes, boolean allowNoMatchingVariants) {
        AttributeMatcher matcher = this.attributeSchemaServices.getMatcher(this.consumerSchema, producer.getProducerSchema());
        ImmutableAttributes targetAttributes = this.attributesFactory.concat(requestAttributes, producer.getOverriddenAttributes());
        List<ResolvedVariant> matchingVariants = matcher.matchMultipleCandidates(producer.getCandidates(), targetAttributes);
        if (matchingVariants.size() == 1) {
            return matchingVariants.get(0).getArtifacts();
        }
        if (matchingVariants.size() > 1) {
            throw this.failureHandler.ambiguousArtifactsFailure(matcher, producer, targetAttributes, matchingVariants);
        }
        Optional<TransformedVariant> selectedTransformationChain = this.transformationChainSelector.selectTransformationChain(producer, targetAttributes, matcher);
        if (selectedTransformationChain.isPresent()) {
            return producer.transformCandidate(selectedTransformationChain.get().getRoot(), selectedTransformationChain.get().getTransformedVariantDefinition());
        }
        if (allowNoMatchingVariants) {
            return ResolvedArtifactSet.EMPTY;
        }
        throw this.failureHandler.noCompatibleArtifactFailure(matcher, producer, targetAttributes);
    }
}

