// Copyright 2023-2024 Gentoo Authors
// Distributed under the terms of the GNU General Public License v2

namespace Gdmt.Sync.Runners

module Portage =
    open SimpleLog.SimpleLog

    open Gdmt.Shared

    let RunEgencache (jobs: int) (loadAverage: int) : unit =
        let egencacheArgs =
            [ "egencache"
              "--jobs"
              $"{jobs}"
              "--load-average"
              $"{loadAverage}"
              "--repo"
              "gentoo"
              "--update"
              "--update-pkg-desc-index"
              "--update-use-local-desc" ]

        LogMessage Debug "Updating ebuild cache"
        ExecProcess(egencacheArgs).Run().Check()
        LogMessage Success "Cache update succeeded"
