#!/usr/bin/env python3


"""

""" """

Copyright 1999-2023 Gentoo Authors
Distributed under the terms of the GNU General Public License v2
"""


from os import chdir
from os import environ
from os import path

from subprocess import run
from sys import argv


def main():
    """! Main."""

    script_path = path.realpath(__file__)
    script_root = path.dirname(script_path)

    repo_root = path.realpath(path.join(script_root, "..", "..", ".."))
    build_path = path.join(repo_root, "Build")

    build_output_path = path.join(build_path, "v1_meson_BuildDir", "build")

    leftover_args = argv[1::]
    install_command_arguments = [
        "meson",
        "install",
    ] + leftover_args

    print(f" * Entering directory: {build_output_path}")
    chdir(build_output_path)

    command_string = " ".join(install_command_arguments)
    print(f" * Executing command: {command_string}")

    environ["DESTDIR"] = path.expanduser("~/.local")

    run(install_command_arguments, check=True)


if __name__ == "__main__":
    main()
