/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreInformation;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class PostgreCollation
extends PostgreInformation {
    private PostgreDatabase database;
    private PostgreSchema schema;
    private long oid;
    private String name;
    private long ownerId;
    private String provider;
    private long encodingId;
    private String collate;
    private String ctype;

    public PostgreCollation(DBRProgressMonitor monitor, PostgreDatabase database, ResultSet dbResult) throws SQLException, DBException {
        super(database);
        this.database = database;
        this.loadInfo(monitor, dbResult);
    }

    private void loadInfo(DBRProgressMonitor monitor, ResultSet dbResult) throws SQLException, DBException {
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"collname");
        this.schema = this.database.getSchema(monitor, JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"collnamespace"));
        this.ownerId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"collowner");
        if (this.getDataSource().isServerVersionAtLeast(10, 0)) {
            this.provider = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"collprovider");
        }
        this.encodingId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"collencoding");
        this.collate = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"collcollate");
        this.ctype = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"collctype");
    }

    @Property(viewable=true, order=1)
    @NotNull
    public PostgreSchema getSchema() {
        return this.schema;
    }

    @Property(viewable=true, order=2)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=3)
    public PostgreRole getOwnerId(DBRProgressMonitor monitor) throws DBException {
        return this.database.getRoleById(monitor, this.ownerId);
    }

    @Property(viewable=true, order=5)
    public String getProvider() {
        return this.provider;
    }

    @Property(viewable=true, order=6)
    public long getEncodingId() {
        return this.encodingId;
    }

    @Property(viewable=true, order=7)
    public String getCollate() {
        return this.collate;
    }

    @Property(viewable=true, order=8)
    public String getCtype() {
        return this.ctype;
    }

    @Property(viewable=false, order=50)
    public long getObjectId() {
        return this.oid;
    }

    @Override
    @Nullable
    public String getDescription() {
        return null;
    }

    @Override
    public DBSObject getParentObject() {
        return this.database;
    }

    @Override
    @NotNull
    public PostgreDataSource getDataSource() {
        return this.database.getDataSource();
    }

    @Override
    public boolean isPersisted() {
        return true;
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return this.database;
    }
}

