/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Locale;
import org.apache.spark.examples.ml.DecisionTreeExample$;
import org.apache.spark.examples.ml.RandomForestExample;
import org.apache.spark.examples.ml.RandomForestExample$;
import org.apache.spark.examples.ml.RandomForestExample$Params$;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.Transformer;
import org.apache.spark.ml.classification.RandomForestClassificationModel;
import org.apache.spark.ml.classification.RandomForestClassifier;
import org.apache.spark.ml.classification.RandomForestClassifier$;
import org.apache.spark.ml.feature.StringIndexer;
import org.apache.spark.ml.feature.VectorIndexer;
import org.apache.spark.ml.regression.RandomForestRegressionModel;
import org.apache.spark.ml.regression.RandomForestRegressor;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.sys.package$;
import scopt.OptionDef;
import scopt.OptionParser;
import scopt.Read$;

public final class RandomForestExample$ {
    public static RandomForestExample$ MODULE$;

    static {
        new RandomForestExample$();
    }

    public void main(String[] args) {
        RandomForestExample.Params defaultParams = new RandomForestExample.Params(RandomForestExample$Params$.MODULE$.apply$default$1(), RandomForestExample$Params$.MODULE$.apply$default$2(), RandomForestExample$Params$.MODULE$.apply$default$3(), RandomForestExample$Params$.MODULE$.apply$default$4(), RandomForestExample$Params$.MODULE$.apply$default$5(), RandomForestExample$Params$.MODULE$.apply$default$6(), RandomForestExample$Params$.MODULE$.apply$default$7(), RandomForestExample$Params$.MODULE$.apply$default$8(), RandomForestExample$Params$.MODULE$.apply$default$9(), RandomForestExample$Params$.MODULE$.apply$default$10(), RandomForestExample$Params$.MODULE$.apply$default$11(), RandomForestExample$Params$.MODULE$.apply$default$12(), RandomForestExample$Params$.MODULE$.apply$default$13(), RandomForestExample$Params$.MODULE$.apply$default$14());
        OptionParser<RandomForestExample.Params> parser = new OptionParser<RandomForestExample.Params>(defaultParams){

            public static final /* synthetic */ RandomForestExample.Params $anonfun$new$2(int x, RandomForestExample.Params c) {
                int x$15 = x;
                String x$16 = c.copy$default$1();
                String x$17 = c.copy$default$2();
                String x$18 = c.copy$default$3();
                String x$19 = c.copy$default$4();
                int x$20 = c.copy$default$6();
                int x$21 = c.copy$default$7();
                double x$22 = c.copy$default$8();
                int x$23 = c.copy$default$9();
                String x$24 = c.copy$default$10();
                double x$25 = c.copy$default$11();
                boolean x$26 = c.copy$default$12();
                Option<String> x$27 = c.copy$default$13();
                int x$28 = c.copy$default$14();
                return c.copy(x$16, x$17, x$18, x$19, x$15, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28);
            }

            public static final /* synthetic */ RandomForestExample.Params $anonfun$new$3(int x, RandomForestExample.Params c) {
                int x$29 = x;
                String x$30 = c.copy$default$1();
                String x$31 = c.copy$default$2();
                String x$32 = c.copy$default$3();
                String x$33 = c.copy$default$4();
                int x$34 = c.copy$default$5();
                int x$35 = c.copy$default$7();
                double x$36 = c.copy$default$8();
                int x$37 = c.copy$default$9();
                String x$38 = c.copy$default$10();
                double x$39 = c.copy$default$11();
                boolean x$40 = c.copy$default$12();
                Option<String> x$41 = c.copy$default$13();
                int x$42 = c.copy$default$14();
                return c.copy(x$30, x$31, x$32, x$33, x$34, x$29, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42);
            }

            public static final /* synthetic */ RandomForestExample.Params $anonfun$new$4(int x, RandomForestExample.Params c) {
                int x$43 = x;
                String x$44 = c.copy$default$1();
                String x$45 = c.copy$default$2();
                String x$46 = c.copy$default$3();
                String x$47 = c.copy$default$4();
                int x$48 = c.copy$default$5();
                int x$49 = c.copy$default$6();
                double x$50 = c.copy$default$8();
                int x$51 = c.copy$default$9();
                String x$52 = c.copy$default$10();
                double x$53 = c.copy$default$11();
                boolean x$54 = c.copy$default$12();
                Option<String> x$55 = c.copy$default$13();
                int x$56 = c.copy$default$14();
                return c.copy(x$44, x$45, x$46, x$47, x$48, x$49, x$43, x$50, x$51, x$52, x$53, x$54, x$55, x$56);
            }

            public static final /* synthetic */ RandomForestExample.Params $anonfun$new$5(double x, RandomForestExample.Params c) {
                double x$57 = x;
                String x$58 = c.copy$default$1();
                String x$59 = c.copy$default$2();
                String x$60 = c.copy$default$3();
                String x$61 = c.copy$default$4();
                int x$62 = c.copy$default$5();
                int x$63 = c.copy$default$6();
                int x$64 = c.copy$default$7();
                int x$65 = c.copy$default$9();
                String x$66 = c.copy$default$10();
                double x$67 = c.copy$default$11();
                boolean x$68 = c.copy$default$12();
                Option<String> x$69 = c.copy$default$13();
                int x$70 = c.copy$default$14();
                return c.copy(x$58, x$59, x$60, x$61, x$62, x$63, x$64, x$57, x$65, x$66, x$67, x$68, x$69, x$70);
            }

            public static final /* synthetic */ RandomForestExample.Params $anonfun$new$6(int x, RandomForestExample.Params c) {
                int x$71 = x;
                String x$72 = c.copy$default$1();
                String x$73 = c.copy$default$2();
                String x$74 = c.copy$default$3();
                String x$75 = c.copy$default$4();
                int x$76 = c.copy$default$5();
                int x$77 = c.copy$default$6();
                int x$78 = c.copy$default$7();
                double x$79 = c.copy$default$8();
                String x$80 = c.copy$default$10();
                double x$81 = c.copy$default$11();
                boolean x$82 = c.copy$default$12();
                Option<String> x$83 = c.copy$default$13();
                int x$84 = c.copy$default$14();
                return c.copy(x$72, x$73, x$74, x$75, x$76, x$77, x$78, x$79, x$71, x$80, x$81, x$82, x$83, x$84);
            }

            public static final /* synthetic */ RandomForestExample.Params $anonfun$new$8(double x, RandomForestExample.Params c) {
                double x$99 = x;
                String x$100 = c.copy$default$1();
                String x$101 = c.copy$default$2();
                String x$102 = c.copy$default$3();
                String x$103 = c.copy$default$4();
                int x$104 = c.copy$default$5();
                int x$105 = c.copy$default$6();
                int x$106 = c.copy$default$7();
                double x$107 = c.copy$default$8();
                int x$108 = c.copy$default$9();
                String x$109 = c.copy$default$10();
                boolean x$110 = c.copy$default$12();
                Option<String> x$111 = c.copy$default$13();
                int x$112 = c.copy$default$14();
                return c.copy(x$100, x$101, x$102, x$103, x$104, x$105, x$106, x$107, x$108, x$109, x$99, x$110, x$111, x$112);
            }

            public static final /* synthetic */ RandomForestExample.Params $anonfun$new$9(boolean x, RandomForestExample.Params c) {
                boolean x$113 = x;
                String x$114 = c.copy$default$1();
                String x$115 = c.copy$default$2();
                String x$116 = c.copy$default$3();
                String x$117 = c.copy$default$4();
                int x$118 = c.copy$default$5();
                int x$119 = c.copy$default$6();
                int x$120 = c.copy$default$7();
                double x$121 = c.copy$default$8();
                int x$122 = c.copy$default$9();
                String x$123 = c.copy$default$10();
                double x$124 = c.copy$default$11();
                Option<String> x$125 = c.copy$default$13();
                int x$126 = c.copy$default$14();
                return c.copy(x$114, x$115, x$116, x$117, x$118, x$119, x$120, x$121, x$122, x$123, x$124, x$113, x$125, x$126);
            }

            public static final /* synthetic */ RandomForestExample.Params $anonfun$new$11(int x, RandomForestExample.Params c) {
                int x$141 = x;
                String x$142 = c.copy$default$1();
                String x$143 = c.copy$default$2();
                String x$144 = c.copy$default$3();
                String x$145 = c.copy$default$4();
                int x$146 = c.copy$default$5();
                int x$147 = c.copy$default$6();
                int x$148 = c.copy$default$7();
                double x$149 = c.copy$default$8();
                int x$150 = c.copy$default$9();
                String x$151 = c.copy$default$10();
                double x$152 = c.copy$default$11();
                boolean x$153 = c.copy$default$12();
                Option<String> x$154 = c.copy$default$13();
                return c.copy(x$142, x$143, x$144, x$145, x$146, x$147, x$148, x$149, x$150, x$151, x$152, x$153, x$154, x$141);
            }
            {
                String string;
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RandomForestExample: an example random forest app."}));
                this.opt("algo", Read$.MODULE$.stringRead()).text(new StringBuilder(49).append("algorithm (classification, regression), default: ").append(defaultParams$1.algo()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    String x$1 = x;
                    String x$2 = c.copy$default$1();
                    String x$3 = c.copy$default$2();
                    String x$4 = c.copy$default$3();
                    int x$5 = c.copy$default$5();
                    int x$6 = c.copy$default$6();
                    int x$7 = c.copy$default$7();
                    double x$8 = c.copy$default$8();
                    int x$9 = c.copy$default$9();
                    String x$10 = c.copy$default$10();
                    double x$11 = c.copy$default$11();
                    boolean x$12 = c.copy$default$12();
                    Option<String> x$13 = c.copy$default$13();
                    int x$14 = c.copy$default$14();
                    return c.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14);
                });
                this.opt("maxDepth", Read$.MODULE$.intRead()).text(new StringBuilder(32).append("max depth of the tree, default: ").append(defaultParams$1.maxDepth()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$2(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("maxBins", Read$.MODULE$.intRead()).text(new StringBuilder(29).append("max number of bins, default: ").append(defaultParams$1.maxBins()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$3(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("minInstancesPerNode", Read$.MODULE$.intRead()).text(new StringBuilder(85).append("min number of instances required at child nodes to create the parent split,").append(" default: ").append(defaultParams$1.minInstancesPerNode()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$4(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("minInfoGain", Read$.MODULE$.doubleRead()).text(new StringBuilder(51).append("min info gain required to create a split, default: ").append(defaultParams$1.minInfoGain()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$5(BoxesRunTime.unboxToDouble((Object)x), c));
                this.opt("numTrees", Read$.MODULE$.intRead()).text(new StringBuilder(38).append("number of trees in ensemble, default: ").append(defaultParams$1.numTrees()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$6(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("featureSubsetStrategy", Read$.MODULE$.stringRead()).text(new StringBuilder(59).append("number of features to use per node (supported:").append(" ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RandomForestClassifier$.MODULE$.supportedFeatureSubsetStrategies())).mkString(",")).append("),").append(" default: ").append(defaultParams$1.numTrees()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    String x$85 = x;
                    String x$86 = c.copy$default$1();
                    String x$87 = c.copy$default$2();
                    String x$88 = c.copy$default$3();
                    String x$89 = c.copy$default$4();
                    int x$90 = c.copy$default$5();
                    int x$91 = c.copy$default$6();
                    int x$92 = c.copy$default$7();
                    double x$93 = c.copy$default$8();
                    int x$94 = c.copy$default$9();
                    double x$95 = c.copy$default$11();
                    boolean x$96 = c.copy$default$12();
                    Option<String> x$97 = c.copy$default$13();
                    int x$98 = c.copy$default$14();
                    return c.copy(x$86, x$87, x$88, x$89, x$90, x$91, x$92, x$93, x$94, x$85, x$95, x$96, x$97, x$98);
                });
                this.opt("fracTest", Read$.MODULE$.doubleRead()).text(new StringBuilder(102).append("fraction of data to hold out for testing. If given option testInput, ").append("this option is ignored. default: ").append(defaultParams$1.fracTest()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$8(BoxesRunTime.unboxToDouble((Object)x), c));
                this.opt("cacheNodeIds", Read$.MODULE$.booleanRead()).text(new StringBuilder(55).append("whether to use node Id cache during training, ").append("default: ").append(defaultParams$1.cacheNodeIds()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$9(BoxesRunTime.unboxToBoolean((Object)x), c));
                OptionDef optionDef = this.opt("checkpointDir", Read$.MODULE$.stringRead());
                StringBuilder stringBuilder = new StringBuilder(80).append("checkpoint directory where intermediate node Id caches will be stored, ").append("default: ");
                Option<String> option = defaultParams$1.checkpointDir();
                if (option instanceof Some) {
                    String strVal;
                    Some some = (Some)option;
                    string = strVal = (String)some.value();
                } else if (None$.MODULE$.equals(option)) {
                    string = "None";
                } else {
                    throw new MatchError(option);
                }
                optionDef.text(stringBuilder.append((Object)string).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    Some x$127 = new Some(x);
                    String x$128 = c.copy$default$1();
                    String x$129 = c.copy$default$2();
                    String x$130 = c.copy$default$3();
                    String x$131 = c.copy$default$4();
                    int x$132 = c.copy$default$5();
                    int x$133 = c.copy$default$6();
                    int x$134 = c.copy$default$7();
                    double x$135 = c.copy$default$8();
                    int x$136 = c.copy$default$9();
                    String x$137 = c.copy$default$10();
                    double x$138 = c.copy$default$11();
                    boolean x$139 = c.copy$default$12();
                    int x$140 = c.copy$default$14();
                    return c.copy(x$128, x$129, x$130, x$131, x$132, x$133, x$134, x$135, x$136, x$137, x$138, x$139, (Option<String>)x$127, x$140);
                });
                this.opt("checkpointInterval", Read$.MODULE$.intRead()).text(new StringBuilder(52).append("how often to checkpoint the node Id cache, ").append("default: ").append(defaultParams$1.checkpointInterval()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> anon.1.$anonfun$new$11(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("testInput", Read$.MODULE$.stringRead()).text(new StringBuilder(75).append("input path to test dataset. If given, option fracTest is ignored.").append(" default: ").append(defaultParams$1.testInput()).toString()).action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    String x$155 = x;
                    String x$156 = c.copy$default$1();
                    String x$157 = c.copy$default$3();
                    String x$158 = c.copy$default$4();
                    int x$159 = c.copy$default$5();
                    int x$160 = c.copy$default$6();
                    int x$161 = c.copy$default$7();
                    double x$162 = c.copy$default$8();
                    int x$163 = c.copy$default$9();
                    String x$164 = c.copy$default$10();
                    double x$165 = c.copy$default$11();
                    boolean x$166 = c.copy$default$12();
                    Option<String> x$167 = c.copy$default$13();
                    int x$168 = c.copy$default$14();
                    return c.copy(x$156, x$155, x$157, x$158, x$159, x$160, x$161, x$162, x$163, x$164, x$165, x$166, x$167, x$168);
                });
                this.opt("dataFormat", Read$.MODULE$.stringRead()).text("data format: libsvm (default), dense (deprecated in Spark v1.1)").action((Function2 & Serializable & scala.Serializable)(x, c) -> {
                    String x$169 = x;
                    String x$170 = c.copy$default$1();
                    String x$171 = c.copy$default$2();
                    String x$172 = c.copy$default$4();
                    int x$173 = c.copy$default$5();
                    int x$174 = c.copy$default$6();
                    int x$175 = c.copy$default$7();
                    double x$176 = c.copy$default$8();
                    int x$177 = c.copy$default$9();
                    String x$178 = c.copy$default$10();
                    double x$179 = c.copy$default$11();
                    boolean x$180 = c.copy$default$12();
                    Option<String> x$181 = c.copy$default$13();
                    int x$182 = c.copy$default$14();
                    return c.copy(x$170, x$171, x$169, x$172, x$173, x$174, x$175, x$176, x$177, x$178, x$179, x$180, x$181, x$182);
                });
                this.arg("<input>", Read$.MODULE$.stringRead()).text("input path to labeled examples").required().action((Function2 & Serializable & scala.Serializable)(x, c) -> c.copy((String)x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8(), c.copy$default$9(), c.copy$default$10(), c.copy$default$11(), c.copy$default$12(), c.copy$default$13(), c.copy$default$14()));
                this.checkConfig((Function1 & Serializable & scala.Serializable)params -> params.fracTest() < 0.0 || params.fracTest() >= 1.0 ? this.failure(new StringBuilder(46).append("fracTest ").append(params.fracTest()).append(" value incorrect; should be in [0,1).").toString()) : this.success());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1(java.lang.String org.apache.spark.examples.ml.RandomForestExample$Params ), $anonfun$new$2$adapted(java.lang.Object org.apache.spark.examples.ml.RandomForestExample$Params ), $anonfun$new$3$adapted(java.lang.Object org.apache.spark.examples.ml.RandomForestExample$Params ), $anonfun$new$4$adapted(java.lang.Object org.apache.spark.examples.ml.RandomForestExample$Params ), $anonfun$new$5$adapted(java.lang.Object org.apache.spark.examples.ml.RandomForestExample$Params ), $anonfun$new$6$adapted(java.lang.Object org.apache.spark.examples.ml.RandomForestExample$Params ), $anonfun$new$7(java.lang.String org.apache.spark.examples.ml.RandomForestExample$Params ), $anonfun$new$8$adapted(java.lang.Object org.apache.spark.examples.ml.RandomForestExample$Params ), $anonfun$new$9$adapted(java.lang.Object org.apache.spark.examples.ml.RandomForestExample$Params ), $anonfun$new$10(java.lang.String org.apache.spark.examples.ml.RandomForestExample$Params ), $anonfun$new$11$adapted(java.lang.Object org.apache.spark.examples.ml.RandomForestExample$Params ), $anonfun$new$12(java.lang.String org.apache.spark.examples.ml.RandomForestExample$Params ), $anonfun$new$13(java.lang.String org.apache.spark.examples.ml.RandomForestExample$Params ), $anonfun$new$14(java.lang.String org.apache.spark.examples.ml.RandomForestExample$Params ), $anonfun$new$15(org.apache.spark.examples.ml.RandomForestExample$$anon$1 org.apache.spark.examples.ml.RandomForestExample$Params )}, serializedLambda);
            }
        };
        Option option = parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams);
        if (!(option instanceof Some)) {
            throw package$.MODULE$.exit(1);
        }
        Some some = (Some)option;
        RandomForestExample.Params params = (RandomForestExample.Params)some.value();
        this.run(params);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void run(RandomForestExample.Params params) {
        RandomForestClassifier randomForestClassifier;
        BoxedUnit boxedUnit;
        Dataset dataset;
        Dataset test;
        String algo;
        SparkSession spark;
        block22: {
            Tuple2<Dataset<Row>, Dataset<Row>> tuple2;
            block21: {
                spark = SparkSession$.MODULE$.builder().appName(new StringBuilder(25).append("RandomForestExample with ").append(params).toString()).getOrCreate();
                params.checkpointDir().foreach((Function1 & Serializable & scala.Serializable)directory -> {
                    RandomForestExample$.$anonfun$run$1(spark, directory);
                    return BoxedUnit.UNIT;
                });
                algo = params.algo().toLowerCase(Locale.ROOT);
                Predef$.MODULE$.println((Object)new StringBuilder(37).append("RandomForestExample with parameters:\n").append(params).toString());
                tuple2 = DecisionTreeExample$.MODULE$.loadDatasets(params.input(), params.dataFormat(), params.testInput(), algo, params.fracTest());
                if (tuple2 == null) break block21;
                Dataset training = (Dataset)tuple2._1();
                test = (Dataset)tuple2._2();
                if (training == null) break block21;
                dataset = training;
                if (test != null) break block22;
            }
            throw new MatchError(tuple2);
        }
        Dataset dataset2 = test;
        Tuple2 tuple2 = new Tuple2((Object)dataset, (Object)dataset2);
        Tuple2 tuple22 = tuple2;
        Dataset training = (Dataset)tuple22._1();
        Dataset test2 = (Dataset)tuple22._2();
        ArrayBuffer stages = new ArrayBuffer();
        String string = algo;
        String string2 = "classification";
        String labelColName = !(string != null ? !string.equals(string2) : string2 != null) ? "indexedLabel" : "label";
        String string3 = algo;
        String string4 = "classification";
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            StringIndexer labelIndexer = new StringIndexer().setInputCol("label").setOutputCol(labelColName);
            boxedUnit = stages.$plus$eq((Object)labelIndexer);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        VectorIndexer featuresIndexer = new VectorIndexer().setInputCol("features").setOutputCol("indexedFeatures").setMaxCategories(10);
        stages.$plus$eq((Object)featuresIndexer);
        String string5 = algo;
        if ("classification".equals(string5)) {
            randomForestClassifier = ((RandomForestClassifier)new RandomForestClassifier().setFeaturesCol("indexedFeatures").setLabelCol(labelColName)).setMaxDepth(params.maxDepth()).setMaxBins(params.maxBins()).setMinInstancesPerNode(params.minInstancesPerNode()).setMinInfoGain(params.minInfoGain()).setCacheNodeIds(params.cacheNodeIds()).setCheckpointInterval(params.checkpointInterval()).setFeatureSubsetStrategy(params.featureSubsetStrategy()).setNumTrees(params.numTrees());
        } else if ("regression".equals(string5)) {
            randomForestClassifier = ((RandomForestRegressor)new RandomForestRegressor().setFeaturesCol("indexedFeatures").setLabelCol(labelColName)).setMaxDepth(params.maxDepth()).setMaxBins(params.maxBins()).setMinInstancesPerNode(params.minInstancesPerNode()).setMinInfoGain(params.minInfoGain()).setCacheNodeIds(params.cacheNodeIds()).setCheckpointInterval(params.checkpointInterval()).setFeatureSubsetStrategy(params.featureSubsetStrategy()).setNumTrees(params.numTrees());
        } else {
            throw new IllegalArgumentException(new StringBuilder(20).append("Algo ").append(params.algo()).append(" not supported.").toString());
        }
        RandomForestClassifier dt = randomForestClassifier;
        stages.$plus$eq((Object)dt);
        Pipeline pipeline = new Pipeline().setStages((PipelineStage[])stages.toArray(ClassTag$.MODULE$.apply(PipelineStage.class)));
        long startTime = System.nanoTime();
        PipelineModel pipelineModel = pipeline.fit(training);
        double elapsedTime = (double)(System.nanoTime() - startTime) / 1.0E9;
        Predef$.MODULE$.println((Object)new StringBuilder(23).append("Training time: ").append(elapsedTime).append(" seconds").toString());
        String string6 = algo;
        if ("classification".equals(string6)) {
            BoxedUnit boxedUnit2;
            RandomForestClassificationModel rfModel = (RandomForestClassificationModel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pipelineModel.stages())).last();
            if (rfModel.totalNumNodes() < 30) {
                Predef$.MODULE$.println((Object)rfModel.toDebugString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                Predef$.MODULE$.println((Object)rfModel);
                boxedUnit2 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit2;
        } else if ("regression".equals(string6)) {
            BoxedUnit boxedUnit4;
            RandomForestRegressionModel rfModel = (RandomForestRegressionModel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pipelineModel.stages())).last();
            if (rfModel.totalNumNodes() < 30) {
                Predef$.MODULE$.println((Object)rfModel.toDebugString());
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                Predef$.MODULE$.println((Object)rfModel);
                boxedUnit4 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit5 = boxedUnit4;
        } else {
            throw new IllegalArgumentException(new StringBuilder(20).append("Algo ").append(params.algo()).append(" not supported.").toString());
        }
        String string7 = algo;
        if ("classification".equals(string7)) {
            Predef$.MODULE$.println((Object)"Training data results:");
            DecisionTreeExample$.MODULE$.evaluateClassificationModel((Transformer)pipelineModel, (Dataset<Row>)training, labelColName);
            Predef$.MODULE$.println((Object)"Test data results:");
            DecisionTreeExample$.MODULE$.evaluateClassificationModel((Transformer)pipelineModel, (Dataset<Row>)test2, labelColName);
            BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
        } else if ("regression".equals(string7)) {
            Predef$.MODULE$.println((Object)"Training data results:");
            DecisionTreeExample$.MODULE$.evaluateRegressionModel((Transformer)pipelineModel, (Dataset<Row>)training, labelColName);
            Predef$.MODULE$.println((Object)"Test data results:");
            DecisionTreeExample$.MODULE$.evaluateRegressionModel((Transformer)pipelineModel, (Dataset<Row>)test2, labelColName);
            BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
        } else {
            throw new IllegalArgumentException(new StringBuilder(20).append("Algo ").append(params.algo()).append(" not supported.").toString());
        }
        spark.stop();
    }

    public static final /* synthetic */ void $anonfun$run$1(SparkSession spark$1, String directory) {
        spark$1.sparkContext().setCheckpointDir(directory);
    }

    private RandomForestExample$() {
        MODULE$ = this;
    }
}

