/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.linalg;

import com.github.fommil.netlib.BLAS;
import com.github.fommil.netlib.F2jBLAS;
import java.io.Serializable;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.DenseVector$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.SparseVector$;
import org.apache.spark.ml.linalg.Vector;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.runtime.BoxedUnit;

public final class BLAS$
implements scala.Serializable {
    public static BLAS$ MODULE$;
    private transient BLAS _f2jBLAS;
    private transient BLAS _nativeBLAS;
    private final int nativeL1Threshold;

    static {
        new BLAS$();
    }

    private BLAS _f2jBLAS() {
        return this._f2jBLAS;
    }

    private void _f2jBLAS_$eq(BLAS x$1) {
        this._f2jBLAS = x$1;
    }

    private BLAS _nativeBLAS() {
        return this._nativeBLAS;
    }

    private void _nativeBLAS_$eq(BLAS x$1) {
        this._nativeBLAS = x$1;
    }

    private int nativeL1Threshold() {
        return this.nativeL1Threshold;
    }

    public BLAS f2jBLAS() {
        block0: {
            if (this._f2jBLAS() != null) break block0;
            this._f2jBLAS_$eq((BLAS)new F2jBLAS());
        }
        return this._f2jBLAS();
    }

    public BLAS getBLAS(int vectorSize) {
        return vectorSize < this.nativeL1Threshold() ? this.f2jBLAS() : this.nativeBLAS();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void axpy(double a, Vector x, Vector y) {
        Predef$.MODULE$.require(x.size() == y.size());
        Vector vector = y;
        if (!(vector instanceof DenseVector)) throw new IllegalArgumentException(new StringBuilder(58).append("axpy only supports adding to a dense vector but got type ").append(y.getClass()).append(".").toString());
        DenseVector denseVector = (DenseVector)vector;
        Vector vector2 = x;
        if (vector2 instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)vector2;
            this.axpy(a, sparseVector, denseVector);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!(vector2 instanceof DenseVector)) throw new UnsupportedOperationException(new StringBuilder(29).append("axpy doesn't support x type ").append(x.getClass()).append(".").toString());
            DenseVector denseVector2 = (DenseVector)vector2;
            this.axpy(a, denseVector2, denseVector);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void axpy(double a, DenseVector x, DenseVector y) {
        int n = x.size();
        this.getBLAS(n).daxpy(n, a, x.values(), 1, y.values(), 1);
    }

    private void axpy(double a, SparseVector x, DenseVector y) {
        double[] xValues = x.values();
        int[] xIndices = x.indices();
        double[] yValues = y.values();
        int nnz = xIndices.length;
        if (a == 1.0) {
            for (int k = 0; k < nnz; ++k) {
                int n = xIndices[k];
                yValues[n] = yValues[n] + xValues[k];
            }
        } else {
            for (int k = 0; k < nnz; ++k) {
                int n = xIndices[k];
                yValues[n] = yValues[n] + a * xValues[k];
            }
        }
    }

    public void axpy(double a, DenseMatrix X, DenseMatrix Y) {
        Predef$.MODULE$.require(X.numRows() == Y.numRows() && X.numCols() == Y.numCols(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Dimension mismatch: ").append("size(X) = ").append(new Tuple2.mcII.sp(X.numRows(), X.numCols())).append(" but size(Y) = ").append(new Tuple2.mcII.sp(Y.numRows(), Y.numCols())).append(".").toString());
        this.getBLAS(X.values().length).daxpy(X.numRows() * X.numCols(), a, X.values(), 1, Y.values(), 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double dot(Vector x, Vector y) {
        Predef$.MODULE$.require(x.size() == y.size(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(93).append("BLAS.dot(x: Vector, y:Vector) was given Vectors with non-matching sizes: x.size = ").append(x.size()).append(", y.size = ").append(y.size()).toString());
        Tuple2 tuple2 = new Tuple2((Object)x, (Object)y);
        if (tuple2 != null) {
            Vector dx = (Vector)tuple2._1();
            Vector dy = (Vector)tuple2._2();
            if (dx instanceof DenseVector) {
                DenseVector denseVector = (DenseVector)dx;
                if (dy instanceof DenseVector) {
                    DenseVector denseVector2 = (DenseVector)dy;
                    return this.dot(denseVector, denseVector2);
                }
            }
        }
        if (tuple2 != null) {
            Vector sx = (Vector)tuple2._1();
            Vector dy = (Vector)tuple2._2();
            if (sx instanceof SparseVector) {
                SparseVector sparseVector = (SparseVector)sx;
                if (dy instanceof DenseVector) {
                    DenseVector denseVector = (DenseVector)dy;
                    return this.dot(sparseVector, denseVector);
                }
            }
        }
        if (tuple2 != null) {
            Vector dx = (Vector)tuple2._1();
            Vector sy = (Vector)tuple2._2();
            if (dx instanceof DenseVector) {
                DenseVector denseVector = (DenseVector)dx;
                if (sy instanceof SparseVector) {
                    SparseVector sparseVector = (SparseVector)sy;
                    return this.dot(sparseVector, denseVector);
                }
            }
        }
        if (tuple2 == null) throw new IllegalArgumentException(new StringBuilder(25).append("dot doesn't support (").append(x.getClass()).append(", ").append(y.getClass()).append(").").toString());
        Vector sx = (Vector)tuple2._1();
        Vector sy = (Vector)tuple2._2();
        if (!(sx instanceof SparseVector)) throw new IllegalArgumentException(new StringBuilder(25).append("dot doesn't support (").append(x.getClass()).append(", ").append(y.getClass()).append(").").toString());
        SparseVector sparseVector = (SparseVector)sx;
        if (!(sy instanceof SparseVector)) throw new IllegalArgumentException(new StringBuilder(25).append("dot doesn't support (").append(x.getClass()).append(", ").append(y.getClass()).append(").").toString());
        SparseVector sparseVector2 = (SparseVector)sy;
        return this.dot(sparseVector, sparseVector2);
    }

    private double dot(DenseVector x, DenseVector y) {
        int n = x.size();
        return this.getBLAS(n).ddot(n, x.values(), 1, y.values(), 1);
    }

    private double dot(SparseVector x, DenseVector y) {
        double[] xValues = x.values();
        int[] xIndices = x.indices();
        double[] yValues = y.values();
        int nnz = xIndices.length;
        double sum = 0.0;
        for (int k = 0; k < nnz; ++k) {
            sum += xValues[k] * yValues[xIndices[k]];
        }
        return sum;
    }

    private double dot(SparseVector x, SparseVector y) {
        double[] xValues = x.values();
        int[] xIndices = x.indices();
        double[] yValues = y.values();
        int[] yIndices = y.indices();
        int nnzx = xIndices.length;
        int nnzy = yIndices.length;
        int ky = 0;
        double sum = 0.0;
        for (int kx = 0; kx < nnzx && ky < nnzy; ++kx) {
            int ix = xIndices[kx];
            while (ky < nnzy && yIndices[ky] < ix) {
                ++ky;
            }
            if (ky >= nnzy || yIndices[ky] != ix) continue;
            sum += xValues[kx] * yValues[ky];
            ++ky;
        }
        return sum;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void copy(Vector x, Vector y) {
        int n = y.size();
        Predef$.MODULE$.require(x.size() == n);
        Vector vector = y;
        if (!(vector instanceof DenseVector)) throw new IllegalArgumentException(new StringBuilder(32).append("y must be dense in copy but got ").append(y.getClass()).toString());
        DenseVector denseVector = (DenseVector)vector;
        Vector vector2 = x;
        if (vector2 instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)vector2;
            int[] sxIndices = sparseVector.indices();
            double[] sxValues = sparseVector.values();
            double[] dyValues = denseVector.values();
            int nnz = sxIndices.length;
            int i = 0;
            for (int k = 0; k < nnz; ++k) {
                int j = sxIndices[k];
                while (i < j) {
                    dyValues[i] = 0.0;
                    ++i;
                }
                dyValues[i] = sxValues[k];
                ++i;
            }
            while (i < n) {
                dyValues[i] = 0.0;
                ++i;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!(vector2 instanceof DenseVector)) throw new MatchError((Object)vector2);
            DenseVector denseVector2 = (DenseVector)vector2;
            Array$.MODULE$.copy((Object)denseVector2.values(), 0, (Object)denseVector.values(), 0, n);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void scal(double a, Vector x) {
        Vector vector = x;
        if (vector instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)vector;
            this.getBLAS(sparseVector.values().length).dscal(sparseVector.values().length, a, sparseVector.values(), 1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            this.getBLAS(denseVector.size()).dscal(denseVector.values().length, a, denseVector.values(), 1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new IllegalArgumentException(new StringBuilder(34).append("scal doesn't support vector type ").append(x.getClass()).append(".").toString());
        }
    }

    public BLAS nativeBLAS() {
        block0: {
            if (this._nativeBLAS() != null) break block0;
            this._nativeBLAS_$eq(BLAS.getInstance());
        }
        return this._nativeBLAS();
    }

    public void spr(double alpha, Vector v, DenseVector U) {
        this.spr(alpha, v, U.values());
    }

    public void dspmv(int n, double alpha, DenseVector A, DenseVector x, double beta, DenseVector y) {
        this.f2jBLAS().dspmv("U", n, alpha, A.values(), x.values(), 1, beta, y.values(), 1);
    }

    public void spr(double alpha, Vector v, double[] U) {
        SparseVector sparseVector;
        Option<Tuple3<Object, int[], double[]>> option;
        DenseVector denseVector;
        Option<double[]> option2;
        int n = v.size();
        Vector vector = v;
        if (vector instanceof DenseVector && !(option2 = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector)).isEmpty()) {
            double[] values = (double[])option2.get();
            BLAS.getInstance().dspr("U", n, alpha, values, 1, U);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (vector instanceof SparseVector && !(option = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector)).isEmpty()) {
            int[] indices = (int[])((Tuple3)option.get())._2();
            double[] values = (double[])((Tuple3)option.get())._3();
            int nnz = indices.length;
            int colStartIdx = 0;
            int prevCol = 0;
            int col = 0;
            int i = 0;
            double av = 0.0;
            for (int j = 0; j < nnz; ++j) {
                col = indices[j];
                colStartIdx += (col - prevCol) * (col + prevCol + 1) / 2;
                col = indices[j];
                av = alpha * values[j];
                for (i = 0; i <= j; ++i) {
                    int n2 = colStartIdx + indices[i];
                    U[n2] = U[n2] + av * values[i];
                }
                prevCol = col;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new IllegalArgumentException(new StringBuilder(33).append("spr doesn't support vector type ").append(v.getClass()).append(".").toString());
        }
    }

    public void syr(double alpha, Vector x, DenseMatrix A) {
        int nA;
        int mA = A.numRows();
        Predef$.MODULE$.require(mA == (nA = A.numCols()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("A is not a square matrix (and hence is not symmetric). A: ").append(mA).append(" x ").append(nA).toString());
        Predef$.MODULE$.require(mA == x.size(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("The size of x doesn't match the rank of A. A: ").append(mA).append(" x ").append(nA).append(", x: ").append(x.size()).toString());
        Vector vector = x;
        if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            this.syr(alpha, denseVector, A);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (vector instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)vector;
            this.syr(alpha, sparseVector, A);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new IllegalArgumentException(new StringBuilder(33).append("syr doesn't support vector type ").append(x.getClass()).append(".").toString());
        }
    }

    private void syr(double alpha, DenseVector x, DenseMatrix A) {
        int nA = A.numRows();
        int mA = A.numCols();
        this.nativeBLAS().dsyr("U", x.size(), alpha, x.values(), 1, A.values(), nA);
        for (int i = 0; i < mA; ++i) {
            for (int j = i + 1; j < nA; ++j) {
                A.update(j, i, A.apply(i, j));
            }
        }
    }

    private void syr(double alpha, SparseVector x, DenseMatrix A) {
        int mA = A.numCols();
        int[] xIndices = x.indices();
        double[] xValues = x.values();
        int nnz = xValues.length;
        double[] Avalues = A.values();
        for (int i = 0; i < nnz; ++i) {
            double multiplier = alpha * xValues[i];
            int offset = xIndices[i] * mA;
            for (int j = 0; j < nnz; ++j) {
                int n = xIndices[j] + offset;
                Avalues[n] = Avalues[n] + multiplier * xValues[j];
            }
        }
    }

    public void gemm(double alpha, Matrix A, DenseMatrix B, double beta, DenseMatrix C) {
        Predef$.MODULE$.require(!C.isTransposed(), (Function0 & Serializable & scala.Serializable)() -> "The matrix C cannot be the product of a transpose() call. C.isTransposed must be false.");
        if (alpha == 0.0 && beta == 1.0) {
            return;
        }
        if (alpha == 0.0) {
            this.getBLAS(C.values().length).dscal(C.values().length, beta, C.values(), 1);
        } else {
            Matrix matrix = A;
            if (matrix instanceof SparseMatrix) {
                SparseMatrix sparseMatrix = (SparseMatrix)matrix;
                this.gemm(alpha, sparseMatrix, B, beta, C);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (matrix instanceof DenseMatrix) {
                DenseMatrix denseMatrix = (DenseMatrix)matrix;
                this.gemm(alpha, denseMatrix, B, beta, C);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new IllegalArgumentException(new StringBuilder(34).append("gemm doesn't support matrix type ").append(A.getClass()).append(".").toString());
            }
        }
    }

    private void gemm(double alpha, DenseMatrix A, DenseMatrix B, double beta, DenseMatrix C) {
        String tAstr = A.isTransposed() ? "T" : "N";
        String tBstr = B.isTransposed() ? "T" : "N";
        int lda = !A.isTransposed() ? A.numRows() : A.numCols();
        int ldb = !B.isTransposed() ? B.numRows() : B.numCols();
        Predef$.MODULE$.require(A.numCols() == B.numRows(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("The columns of A don't match the rows of B. A: ").append(A.numCols()).append(", B: ").append(B.numRows()).toString());
        Predef$.MODULE$.require(A.numRows() == C.numRows(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("The rows of C don't match the rows of A. C: ").append(C.numRows()).append(", A: ").append(A.numRows()).toString());
        Predef$.MODULE$.require(B.numCols() == C.numCols(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("The columns of C don't match the columns of B. C: ").append(C.numCols()).append(", A: ").append(B.numCols()).toString());
        this.nativeBLAS().dgemm(tAstr, tBstr, A.numRows(), B.numCols(), A.numCols(), alpha, A.values(), lda, B.values(), ldb, beta, C.values(), C.numRows());
    }

    private void gemm(double alpha, SparseMatrix A, DenseMatrix B, double beta, DenseMatrix C) {
        int kB;
        int mA = A.numRows();
        int nB = B.numCols();
        int kA = A.numCols();
        Predef$.MODULE$.require(kA == (kB = B.numRows()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("The columns of A don't match the rows of B. A: ").append(kA).append(", B: ").append(kB).toString());
        Predef$.MODULE$.require(mA == C.numRows(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("The rows of C don't match the rows of A. C: ").append(C.numRows()).append(", A: ").append(mA).toString());
        Predef$.MODULE$.require(nB == C.numCols(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("The columns of C don't match the columns of B. C: ").append(C.numCols()).append(", A: ").append(nB).toString());
        double[] Avals = A.values();
        double[] Bvals = B.values();
        double[] Cvals = C.values();
        int[] ArowIndices = A.rowIndices();
        int[] AcolPtrs = A.colPtrs();
        if (A.isTransposed()) {
            int colCounterForB;
            if (!B.isTransposed()) {
                for (colCounterForB = 0; colCounterForB < nB; ++colCounterForB) {
                    int Cstart = colCounterForB * mA;
                    int Bstart = colCounterForB * kA;
                    for (int rowCounterForA = 0; rowCounterForA < mA; ++rowCounterForA) {
                        int indEnd = AcolPtrs[rowCounterForA + 1];
                        double sum = 0.0;
                        for (int i = AcolPtrs[rowCounterForA]; i < indEnd; ++i) {
                            sum += Avals[i] * Bvals[Bstart + ArowIndices[i]];
                        }
                        int Cindex = Cstart + rowCounterForA;
                        Cvals[Cindex] = beta * Cvals[Cindex] + sum * alpha;
                    }
                }
            } else {
                while (colCounterForB < nB) {
                    int Cstart = colCounterForB * mA;
                    for (int rowCounterForA = 0; rowCounterForA < mA; ++rowCounterForA) {
                        int indEnd = AcolPtrs[rowCounterForA + 1];
                        double sum = 0.0;
                        for (int i = AcolPtrs[rowCounterForA]; i < indEnd; ++i) {
                            sum += Avals[i] * B.apply(ArowIndices[i], colCounterForB);
                        }
                        int Cindex = Cstart + rowCounterForA;
                        Cvals[Cindex] = beta * Cvals[Cindex] + sum * alpha;
                    }
                    ++colCounterForB;
                }
            }
        } else {
            int colCounterForB;
            if (beta != 1.0) {
                this.getBLAS(C.values().length).dscal(C.values().length, beta, C.values(), 1);
            }
            if (!B.isTransposed()) {
                for (colCounterForB = 0; colCounterForB < nB; ++colCounterForB) {
                    int Bstart = colCounterForB * kB;
                    int Cstart = colCounterForB * mA;
                    for (int colCounterForA = 0; colCounterForA < kA; ++colCounterForA) {
                        int indEnd = AcolPtrs[colCounterForA + 1];
                        double Bval = Bvals[Bstart + colCounterForA] * alpha;
                        for (int i = AcolPtrs[colCounterForA]; i < indEnd; ++i) {
                            int n = Cstart + ArowIndices[i];
                            Cvals[n] = Cvals[n] + Avals[i] * Bval;
                        }
                    }
                }
            } else {
                while (colCounterForB < nB) {
                    int Cstart = colCounterForB * mA;
                    for (int colCounterForA = 0; colCounterForA < kA; ++colCounterForA) {
                        int indEnd = AcolPtrs[colCounterForA + 1];
                        double Bval = B.apply(colCounterForA, colCounterForB) * alpha;
                        for (int i = AcolPtrs[colCounterForA]; i < indEnd; ++i) {
                            int n = Cstart + ArowIndices[i];
                            Cvals[n] = Cvals[n] + Avals[i] * Bval;
                        }
                    }
                    ++colCounterForB;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void gemv(double alpha, Matrix A, Vector x, double beta, DenseVector y) {
        Predef$.MODULE$.require(A.numCols() == x.size(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("The columns of A don't match the number of elements of x. A: ").append(A.numCols()).append(", x: ").append(x.size()).toString());
        Predef$.MODULE$.require(A.numRows() == y.size(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("The rows of A don't match the number of elements of y. A: ").append(A.numRows()).append(", y:").append(y.size()).toString());
        if (alpha == 0.0 && beta == 1.0) {
            return;
        }
        if (alpha == 0.0) {
            this.scal(beta, y);
            return;
        }
        Tuple2 tuple2 = new Tuple2((Object)A, (Object)x);
        if (tuple2 != null) {
            Matrix smA = (Matrix)tuple2._1();
            Vector dvx = (Vector)tuple2._2();
            if (smA instanceof SparseMatrix) {
                SparseMatrix sparseMatrix = (SparseMatrix)smA;
                if (dvx instanceof DenseVector) {
                    DenseVector denseVector = (DenseVector)dvx;
                    this.gemv(alpha, sparseMatrix, denseVector, beta, y);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (tuple2 != null) {
            Matrix smA = (Matrix)tuple2._1();
            Vector svx = (Vector)tuple2._2();
            if (smA instanceof SparseMatrix) {
                SparseMatrix sparseMatrix = (SparseMatrix)smA;
                if (svx instanceof SparseVector) {
                    SparseVector sparseVector = (SparseVector)svx;
                    this.gemv(alpha, sparseMatrix, sparseVector, beta, y);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (tuple2 != null) {
            Matrix dmA = (Matrix)tuple2._1();
            Vector dvx = (Vector)tuple2._2();
            if (dmA instanceof DenseMatrix) {
                DenseMatrix denseMatrix = (DenseMatrix)dmA;
                if (dvx instanceof DenseVector) {
                    DenseVector denseVector = (DenseVector)dvx;
                    this.gemv(alpha, denseMatrix, denseVector, beta, y);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (tuple2 == null) throw new IllegalArgumentException(new StringBuilder(62).append("gemv doesn't support running on matrix type ").append(A.getClass()).append(" and vector type ").append(x.getClass()).append(".").toString());
        Matrix dmA = (Matrix)tuple2._1();
        Vector svx = (Vector)tuple2._2();
        if (!(dmA instanceof DenseMatrix)) throw new IllegalArgumentException(new StringBuilder(62).append("gemv doesn't support running on matrix type ").append(A.getClass()).append(" and vector type ").append(x.getClass()).append(".").toString());
        DenseMatrix denseMatrix = (DenseMatrix)dmA;
        if (!(svx instanceof SparseVector)) throw new IllegalArgumentException(new StringBuilder(62).append("gemv doesn't support running on matrix type ").append(A.getClass()).append(" and vector type ").append(x.getClass()).append(".").toString());
        SparseVector sparseVector = (SparseVector)svx;
        this.gemv(alpha, denseMatrix, sparseVector, beta, y);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void gemv(double alpha, DenseMatrix A, DenseVector x, double beta, DenseVector y) {
        String tStrA = A.isTransposed() ? "T" : "N";
        int mA = !A.isTransposed() ? A.numRows() : A.numCols();
        int nA = !A.isTransposed() ? A.numCols() : A.numRows();
        this.nativeBLAS().dgemv(tStrA, mA, nA, alpha, A.values(), mA, x.values(), 1, beta, y.values(), 1);
    }

    private void gemv(double alpha, DenseMatrix A, SparseVector x, double beta, DenseVector y) {
        int mA = A.numRows();
        int nA = A.numCols();
        double[] Avals = A.values();
        int[] xIndices = x.indices();
        int xNnz = xIndices.length;
        double[] xValues = x.values();
        double[] yValues = y.values();
        if (A.isTransposed()) {
            for (int rowCounterForA = 0; rowCounterForA < mA; ++rowCounterForA) {
                double sum = 0.0;
                for (int k = 0; k < xNnz; ++k) {
                    sum += xValues[k] * Avals[xIndices[k] + rowCounterForA * nA];
                }
                yValues[rowCounterForA] = sum * alpha + beta * yValues[rowCounterForA];
            }
        } else {
            for (int rowCounterForA = 0; rowCounterForA < mA; ++rowCounterForA) {
                double sum = 0.0;
                for (int k = 0; k < xNnz; ++k) {
                    sum += xValues[k] * Avals[xIndices[k] * mA + rowCounterForA];
                }
                yValues[rowCounterForA] = sum * alpha + beta * yValues[rowCounterForA];
            }
        }
    }

    private void gemv(double alpha, SparseMatrix A, SparseVector x, double beta, DenseVector y) {
        int[] Acols;
        double[] xValues = x.values();
        int[] xIndices = x.indices();
        int xNnz = xIndices.length;
        double[] yValues = y.values();
        int mA = A.numRows();
        int nA = A.numCols();
        double[] Avals = A.values();
        int[] Arows = !A.isTransposed() ? A.rowIndices() : A.colPtrs();
        int[] nArray = Acols = !A.isTransposed() ? A.colPtrs() : A.rowIndices();
        if (A.isTransposed()) {
            for (int rowCounter = 0; rowCounter < mA; ++rowCounter) {
                int i = Arows[rowCounter];
                int indEnd = Arows[rowCounter + 1];
                double sum = 0.0;
                int k = 0;
                while (i < indEnd && k < xNnz) {
                    if (xIndices[k] == Acols[i]) {
                        sum += Avals[i] * xValues[k];
                        ++k;
                        ++i;
                        continue;
                    }
                    if (xIndices[k] < Acols[i]) {
                        ++k;
                        continue;
                    }
                    ++i;
                }
                yValues[rowCounter] = sum * alpha + beta * yValues[rowCounter];
            }
        } else {
            if (beta != 1.0) {
                this.scal(beta, y);
            }
            int k = 0;
            for (int colCounterForA = 0; colCounterForA < nA && k < xNnz; ++colCounterForA) {
                if (xIndices[k] != colCounterForA) continue;
                int indEnd = Acols[colCounterForA + 1];
                double xTemp = xValues[k] * alpha;
                for (int i = Acols[colCounterForA]; i < indEnd; ++i) {
                    int n = Arows[i];
                    yValues[n] = yValues[n] + Avals[i] * xTemp;
                }
                ++k;
            }
        }
    }

    private void gemv(double alpha, SparseMatrix A, DenseVector x, double beta, DenseVector y) {
        int[] Acols;
        double[] xValues = x.values();
        double[] yValues = y.values();
        int mA = A.numRows();
        int nA = A.numCols();
        double[] Avals = A.values();
        int[] Arows = !A.isTransposed() ? A.rowIndices() : A.colPtrs();
        int[] nArray = Acols = !A.isTransposed() ? A.colPtrs() : A.rowIndices();
        if (A.isTransposed()) {
            for (int rowCounter = 0; rowCounter < mA; ++rowCounter) {
                int indEnd = Arows[rowCounter + 1];
                double sum = 0.0;
                for (int i = Arows[rowCounter]; i < indEnd; ++i) {
                    sum += Avals[i] * xValues[Acols[i]];
                }
                yValues[rowCounter] = beta * yValues[rowCounter] + sum * alpha;
            }
        } else {
            if (beta != 1.0) {
                this.scal(beta, y);
            }
            for (int colCounterForA = 0; colCounterForA < nA; ++colCounterForA) {
                int indEnd = Acols[colCounterForA + 1];
                double xVal = xValues[colCounterForA] * alpha;
                for (int i = Acols[colCounterForA]; i < indEnd; ++i) {
                    int n = Arows[i];
                    yValues[n] = yValues[n] + Avals[i] * xVal;
                }
            }
        }
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BLAS$() {
        MODULE$ = this;
        this.nativeL1Threshold = 256;
    }
}

