/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.metrics.source.HiveCatalogMetrics$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex$;
import org.apache.spark.sql.execution.datasources.PartitionSpec;
import org.apache.spark.sql.execution.datasources.PartitioningAwareFileIndex;
import org.apache.spark.sql.execution.streaming.FileStreamSink$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractIterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t=a\u0001\u0002\u0013&\u0001IB\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A1\u000b\u0001B\u0001B\u0003%A\u000b\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003a\u0011!Q\u0007A!A!\u0002\u0013Y\u0007\u0002\u00038\u0001\u0005\u0003\u0005\u000b\u0011B8\t\u0011M\u0004!Q1A\u0005BQD\u0001\"\u001f\u0001\u0003\u0002\u0003\u0006I!\u001e\u0005\u0006u\u0002!\ta\u001f\u0005\n\u0003\u0013\u0001!\u0019!C!\u0003\u0017A\u0001\"a\u0006\u0001A\u0003%\u0011Q\u0002\u0005\f\u00033\u0001\u0001\u0019!a\u0001\n\u0013\tY\u0002C\u0006\u00020\u0001\u0001\r\u00111A\u0005\n\u0005E\u0002bCA\u001f\u0001\u0001\u0007\t\u0011)Q\u0005\u0003;A1\"a\u0012\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002J!Y\u00111\u000b\u0001A\u0002\u0003\u0007I\u0011BA+\u0011-\tI\u0006\u0001a\u0001\u0002\u0003\u0006K!a\u0013\t\u0017\u0005u\u0003\u00011AA\u0002\u0013%\u0011q\f\u0005\f\u0003C\u0002\u0001\u0019!a\u0001\n\u0013\t\u0019\u0007\u0003\u0006\u0002h\u0001\u0001\r\u0011!Q!\nADq!a\u001b\u0001\t\u0003\ni\u0007C\u0004\u0002p\u0001!\t&a\u0007\t\u000f\u0005E\u0004\u0001\"\u0015\u0002J!9\u00111\u000f\u0001\u0005B\u0005U\u0004bBA<\u0001\u0011%\u0011Q\u000f\u0005\b\u0003s\u0002A\u0011IA>\u0011\u001d\ti\t\u0001C!\u0003\u001fCq!a&\u0001\t\u0003\tIjB\u0004\u0002&\u0016B\t!a*\u0007\r\u0011*\u0003\u0012AAU\u0011\u0019Qh\u0004\"\u0001\u0002>\"A\u0011q\u0018\u0010\u0005\u0002%\n\t\rC\u0005\u0002lz\t\n\u0011\"\u0001\u0002n\"I!1\u0001\u0010\u0012\u0002\u0013\u0005!Q\u0001\u0005\n\u0005\u0013q\u0012\u0013!C\u0001\u0005\u0017\u0011\u0011#\u00138NK6|'/\u001f$jY\u0016Le\u000eZ3y\u0015\t1s%A\u0006eCR\f7o\\;sG\u0016\u001c(B\u0001\u0015*\u0003%)\u00070Z2vi&|gN\u0003\u0002+W\u0005\u00191/\u001d7\u000b\u00051j\u0013!B:qCJ\\'B\u0001\u00180\u0003\u0019\t\u0007/Y2iK*\t\u0001'A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001gA\u0011A'N\u0007\u0002K%\u0011a'\n\u0002\u001b!\u0006\u0014H/\u001b;j_:LgnZ!xCJ,g)\u001b7f\u0013:$W\r_\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003sij\u0011!K\u0005\u0003w%\u0012Ab\u00159be.\u001cVm]:j_:\f!C]8piB\u000bG\u000f[:Ta\u0016\u001c\u0017NZ5fIB\u0019a\bS&\u000f\u0005}*eB\u0001!D\u001b\u0005\t%B\u0001\"2\u0003\u0019a$o\\8u}%\tA)A\u0003tG\u0006d\u0017-\u0003\u0002G\u000f\u00069\u0001/Y2lC\u001e,'\"\u0001#\n\u0005%S%aA*fc*\u0011ai\u0012\t\u0003\u0019Fk\u0011!\u0014\u0006\u0003\u001d>\u000b!AZ:\u000b\u0005Ak\u0013A\u00025bI>|\u0007/\u0003\u0002S\u001b\n!\u0001+\u0019;i\u0003)\u0001\u0018M]1nKR,'o\u001d\t\u0005+fcFL\u0004\u0002W/B\u0011\u0001iR\u0005\u00031\u001e\u000ba\u0001\u0015:fI\u00164\u0017B\u0001.\\\u0005\ri\u0015\r\u001d\u0006\u00031\u001e\u0003\"!V/\n\u0005y[&AB*ue&tw-A\nvg\u0016\u00148\u000b]3dS\u001aLW\rZ*dQ\u0016l\u0017\rE\u0002bE\u0012l\u0011aR\u0005\u0003G\u001e\u0013aa\u00149uS>t\u0007CA3i\u001b\u00051'BA4*\u0003\u0015!\u0018\u0010]3t\u0013\tIgM\u0001\u0006TiJ,8\r\u001e+za\u0016\fqBZ5mKN#\u0018\r^;t\u0007\u0006\u001c\u0007.\u001a\t\u0003i1L!!\\\u0013\u0003\u001f\u0019KG.Z*uCR,8oQ1dQ\u0016\f!$^:feN\u0003XmY5gS\u0016$\u0007+\u0019:uSRLwN\\*qK\u000e\u00042!\u00192q!\t!\u0014/\u0003\u0002sK\ti\u0001+\u0019:uSRLwN\\*qK\u000e\f\u0011#\\3uC\u0012\fG/Y(qgRKW.\u001a(t+\u0005)\bcA1cmB\u0011\u0011m^\u0005\u0003q\u001e\u0013A\u0001T8oO\u0006\u0011R.\u001a;bI\u0006$\u0018m\u00149t)&lWMT:!\u0003\u0019a\u0014N\\5u}QaA0 @\u0000\u0003\u0003\t\u0019!!\u0002\u0002\bA\u0011A\u0007\u0001\u0005\u0006o%\u0001\r\u0001\u000f\u0005\u0006y%\u0001\r!\u0010\u0005\u0006'&\u0001\r\u0001\u0016\u0005\u0006?&\u0001\r\u0001\u0019\u0005\bU&\u0001\n\u00111\u0001l\u0011\u001dq\u0017\u0002%AA\u0002=Dqa]\u0005\u0011\u0002\u0003\u0007Q/A\u0005s_>$\b+\u0019;igV\u0011\u0011Q\u0002\t\u0006\u0003\u001f\t)bS\u0007\u0003\u0003#Q1!a\u0005H\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0004\u0013\u0006E\u0011A\u0003:p_R\u0004\u0016\r\u001e5tA\u0005y1-Y2iK\u0012dU-\u00194GS2,7/\u0006\u0002\u0002\u001eA9\u0011qDA\u0013\u0017\u0006%RBAA\u0011\u0015\u0011\t\u0019#!\u0005\u0002\u000f5,H/\u00192mK&!\u0011qEA\u0011\u00055a\u0015N\\6fI\"\u000b7\u000f['baB\u0019A*a\u000b\n\u0007\u00055RJ\u0001\u0006GS2,7\u000b^1ukN\f1cY1dQ\u0016$G*Z1g\r&dWm]0%KF$B!a\r\u0002:A\u0019\u0011-!\u000e\n\u0007\u0005]rI\u0001\u0003V]&$\b\"CA\u001e\u001b\u0005\u0005\t\u0019AA\u000f\u0003\rAH%M\u0001\u0011G\u0006\u001c\u0007.\u001a3MK\u00064g)\u001b7fg\u0002B3ADA!!\r\t\u00171I\u0005\u0004\u0003\u000b:%\u0001\u0003<pY\u0006$\u0018\u000e\\3\u00029\r\f7\r[3e\u0019\u0016\fg\rR5s)>\u001c\u0005.\u001b7ee\u0016tg)\u001b7fgV\u0011\u00111\n\t\u0006+f[\u0015Q\n\t\u0006C\u0006=\u0013\u0011F\u0005\u0004\u0003#:%!B!se\u0006L\u0018\u0001I2bG\",G\rT3bM\u0012K'\u000fV8DQ&dGM]3o\r&dWm]0%KF$B!a\r\u0002X!I\u00111\b\t\u0002\u0002\u0003\u0007\u00111J\u0001\u001eG\u0006\u001c\u0007.\u001a3MK\u00064G)\u001b:U_\u000eC\u0017\u000e\u001c3sK:4\u0015\u000e\\3tA!\u001a\u0011#!\u0011\u0002'\r\f7\r[3e!\u0006\u0014H/\u001b;j_:\u001c\u0006/Z2\u0016\u0003A\fqcY1dQ\u0016$\u0007+\u0019:uSRLwN\\*qK\u000e|F%Z9\u0015\t\u0005M\u0012Q\r\u0005\t\u0003w\u0019\u0012\u0011!a\u0001a\u0006!2-Y2iK\u0012\u0004\u0016M\u001d;ji&|gn\u00159fG\u0002B3\u0001FA!\u00035\u0001\u0018M\u001d;ji&|gn\u00159fGR\t\u0001/A\u0005mK\u00064g)\u001b7fg\u00061B.Z1g\t&\u0014Hk\\\"iS2$'/\u001a8GS2,7/A\u0004sK\u001a\u0014Xm\u001d5\u0015\u0005\u0005M\u0012\u0001\u0003:fMJ,7\u000f\u001b\u0019\u0002\r\u0015\fX/\u00197t)\u0011\ti(a!\u0011\u0007\u0005\fy(C\u0002\u0002\u0002\u001e\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0002\u0006j\u0001\r!a\"\u0002\u000b=$\b.\u001a:\u0011\u0007\u0005\fI)C\u0002\u0002\f\u001e\u00131!\u00118z\u0003!A\u0017m\u001d5D_\u0012,GCAAI!\r\t\u00171S\u0005\u0004\u0003+;%aA%oi\u0006iA.[:u\u0019\u0016\fgMR5mKN$B!a'\u0002\"B1\u0011qDAO\u0003SIA!a(\u0002\"\tiA*\u001b8lK\u0012D\u0015m\u001d5TKRDa!a)\u001d\u0001\u0004i\u0014!\u00029bi\"\u001c\u0018!E%o\u001b\u0016lwN]=GS2,\u0017J\u001c3fqB\u0011AGH\n\u0006=\u0005-\u0016\u0011\u0017\t\u0004C\u00065\u0016bAAX\u000f\n1\u0011I\\=SK\u001a\u0004B!a-\u0002:6\u0011\u0011Q\u0017\u0006\u0004\u0003o[\u0013\u0001C5oi\u0016\u0014h.\u00197\n\t\u0005m\u0016Q\u0017\u0002\b\u0019><w-\u001b8h)\t\t9+A\tck2\\G*[:u\u0019\u0016\fgMR5mKN$\"\"a1\u0002N\u0006=\u0017q\\Au!\u0011q\u0004*!2\u0011\r\u0005\f9mSAf\u0013\r\tIm\u0012\u0002\u0007)V\u0004H.\u001a\u001a\u0011\tyB\u0015\u0011\u0006\u0005\u0007\u0003G\u0003\u0003\u0019A\u001f\t\u000f\u0005E\u0007\u00051\u0001\u0002T\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\t\u0005U\u00171\\\u0007\u0003\u0003/T1!!7P\u0003\u0011\u0019wN\u001c4\n\t\u0005u\u0017q\u001b\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000f\u0005\u0005\b\u00051\u0001\u0002d\u00061a-\u001b7uKJ\u00042\u0001TAs\u0013\r\t9/\u0014\u0002\u000b!\u0006$\bNR5mi\u0016\u0014\b\"B\u001c!\u0001\u0004A\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0006\u0002\u0002p*\u001a1.!=,\u0005\u0005M\b\u0003BA{\u0003\u007fl!!a>\u000b\t\u0005e\u00181`\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!@H\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0003\t9PA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u00122TC\u0001B\u0004U\ry\u0017\u0011_\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\t5!fA;\u0002r\u0002")
public class InMemoryFileIndex
extends PartitioningAwareFileIndex {
    private final SparkSession sparkSession;
    private final FileStatusCache fileStatusCache;
    private final Option<PartitionSpec> userSpecifiedPartitionSpec;
    private final Option<Object> metadataOpsTimeNs;
    private final Seq<Path> rootPaths;
    private volatile LinkedHashMap<Path, FileStatus> cachedLeafFiles;
    private volatile Map<Path, FileStatus[]> cachedLeafDirToChildrenFiles;
    private volatile PartitionSpec cachedPartitionSpec;

    public static Option<Object> $lessinit$greater$default$7() {
        return InMemoryFileIndex$.MODULE$.$lessinit$greater$default$7();
    }

    public static Option<PartitionSpec> $lessinit$greater$default$6() {
        return InMemoryFileIndex$.MODULE$.$lessinit$greater$default$6();
    }

    public static FileStatusCache $lessinit$greater$default$5() {
        return InMemoryFileIndex$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public Option<Object> metadataOpsTimeNs() {
        return this.metadataOpsTimeNs;
    }

    @Override
    public Seq<Path> rootPaths() {
        return this.rootPaths;
    }

    private LinkedHashMap<Path, FileStatus> cachedLeafFiles() {
        return this.cachedLeafFiles;
    }

    private void cachedLeafFiles_$eq(LinkedHashMap<Path, FileStatus> x$1) {
        this.cachedLeafFiles = x$1;
    }

    private Map<Path, FileStatus[]> cachedLeafDirToChildrenFiles() {
        return this.cachedLeafDirToChildrenFiles;
    }

    private void cachedLeafDirToChildrenFiles_$eq(Map<Path, FileStatus[]> x$1) {
        this.cachedLeafDirToChildrenFiles = x$1;
    }

    private PartitionSpec cachedPartitionSpec() {
        return this.cachedPartitionSpec;
    }

    private void cachedPartitionSpec_$eq(PartitionSpec x$1) {
        this.cachedPartitionSpec = x$1;
    }

    @Override
    public PartitionSpec partitionSpec() {
        if (this.cachedPartitionSpec() == null) {
            if (this.userSpecifiedPartitionSpec.isDefined()) {
                this.cachedPartitionSpec_$eq((PartitionSpec)this.userSpecifiedPartitionSpec.get());
            } else {
                this.cachedPartitionSpec_$eq(this.inferPartitioning());
            }
        }
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Partition spec: ").append(this.cachedPartitionSpec()).toString());
        return this.cachedPartitionSpec();
    }

    @Override
    public LinkedHashMap<Path, FileStatus> leafFiles() {
        return this.cachedLeafFiles();
    }

    @Override
    public Map<Path, FileStatus[]> leafDirToChildrenFiles() {
        return this.cachedLeafDirToChildrenFiles();
    }

    @Override
    public void refresh() {
        this.fileStatusCache.invalidateAll();
        this.refresh0();
    }

    private void refresh0() {
        LinkedHashSet<FileStatus> files = this.listLeafFiles(this.rootPaths());
        this.cachedLeafFiles_$eq((LinkedHashMap<Path, FileStatus>)((LinkedHashMap)new LinkedHashMap().$plus$plus$eq((TraversableOnce)files.map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.getPath()), f), LinkedHashSet$.MODULE$.canBuildFrom()))));
        this.cachedLeafDirToChildrenFiles_$eq((Map<Path, FileStatus[]>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files.toArray(ClassTag$.MODULE$.apply(FileStatus.class)))).groupBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getPath().getParent()));
        this.cachedPartitionSpec_$eq(null);
    }

    public boolean equals(Object other) {
        boolean bl;
        Object object = other;
        if (object instanceof InMemoryFileIndex) {
            InMemoryFileIndex inMemoryFileIndex = (InMemoryFileIndex)object;
            Set set = this.rootPaths().toSet();
            Set set2 = inMemoryFileIndex.rootPaths().toSet();
            bl = !(set != null ? !set.equals(set2) : set2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.rootPaths().toSet().hashCode();
    }

    public LinkedHashSet<FileStatus> listLeafFiles(Seq<Path> paths) {
        long startTime = System.nanoTime();
        LinkedHashSet output = (LinkedHashSet)LinkedHashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayBuffer pathsToFetch = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        paths.foreach((Function1 & Serializable & scala.Serializable)path -> {
            InMemoryFileIndex.$anonfun$listLeafFiles$1(this, output, pathsToFetch, path);
            return BoxedUnit.UNIT;
        });
        PathFilter filter = FileInputFormat.getInputPathFilter((JobConf)new JobConf(this.hadoopConf(), this.getClass()));
        Seq<Tuple2<Path, Seq<FileStatus>>> discovered = InMemoryFileIndex$.MODULE$.bulkListLeafFiles((Seq<Path>)pathsToFetch.toSeq(), this.hadoopConf(), filter, this.sparkSession);
        discovered.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Path path = (Path)tuple2._1();
            Seq leafFiles = (Seq)tuple2._2();
            HiveCatalogMetrics$.MODULE$.incrementFilesDiscovered(leafFiles.size());
            $this.fileStatusCache.putLeafFiles(path, (FileStatus[])leafFiles.toArray(ClassTag$.MODULE$.apply(FileStatus.class)));
            LinkedHashSet linkedHashSet = (LinkedHashSet)output.$plus$plus$eq((TraversableOnce)leafFiles);
            return linkedHashSet;
        });
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("It took ").append((System.nanoTime() - startTime) / 1000000L).append(" ms to list leaf files").append(" for ").append(paths.length()).append(" paths.").toString());
        return output;
    }

    public static final /* synthetic */ void $anonfun$listLeafFiles$1(InMemoryFileIndex $this, LinkedHashSet output$1, ArrayBuffer pathsToFetch$1, Path path) {
        ArrayBuffer arrayBuffer;
        Option<FileStatus[]> option = $this.fileStatusCache.getLeafFiles(path);
        if (option instanceof Some) {
            Some some = (Some)option;
            FileStatus[] files = (FileStatus[])some.value();
            HiveCatalogMetrics$.MODULE$.incrementFileCacheHits(files.length);
            arrayBuffer = (AbstractIterable)output$1.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)));
        } else if (None$.MODULE$.equals(option)) {
            arrayBuffer = pathsToFetch$1.$plus$eq((Object)path);
        } else {
            throw new MatchError(option);
        }
    }

    public InMemoryFileIndex(SparkSession sparkSession, Seq<Path> rootPathsSpecified, Map<String, String> parameters, Option<StructType> userSpecifiedSchema, FileStatusCache fileStatusCache, Option<PartitionSpec> userSpecifiedPartitionSpec, Option<Object> metadataOpsTimeNs) {
        this.sparkSession = sparkSession;
        this.fileStatusCache = fileStatusCache;
        this.userSpecifiedPartitionSpec = userSpecifiedPartitionSpec;
        this.metadataOpsTimeNs = metadataOpsTimeNs;
        super(sparkSession, parameters, userSpecifiedSchema, fileStatusCache);
        this.rootPaths = (Seq)rootPathsSpecified.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSink$.MODULE$.ancestorIsMetadataDirectory(x$1, this.hadoopConf())));
        this.refresh0();
    }
}

