/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.xml;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.xml.XPathExtract;
import org.apache.spark.sql.catalyst.expressions.xml.XPathInt$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(xml, xpath) - Returns an integer value, or the value zero if no match is found, or a match is found but the value is non-numeric.", examples="\n    Examples:\n      > SELECT _FUNC_('<a><b>1</b><b>2</b></a>', 'sum(a/b)');\n       3\n  ", since="2.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\r\u001b\u0001&B\u0001b\u0007\u0001\u0003\u0016\u0004%\ta\u000e\u0005\ty\u0001\u0011\t\u0012)A\u0005q!AQ\b\u0001BK\u0002\u0013\u0005q\u0007\u0003\u0005?\u0001\tE\t\u0015!\u00039\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u0015!\u0005\u0001\"\u0011F\u0011\u0015\t\u0006\u0001\"\u0011S\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u001d\u0001\u0007!!A\u0005\u0002\u0005Dq\u0001\u001a\u0001\u0012\u0002\u0013\u0005Q\rC\u0004q\u0001E\u0005I\u0011A3\t\u000fE\u0004\u0011\u0011!C!e\"9!\u0010AA\u0001\n\u0003Y\b\u0002C@\u0001\u0003\u0003%\t!!\u0001\t\u0013\u0005\u001d\u0001!!A\u0005B\u0005%\u0001\"CA\f\u0001\u0005\u0005I\u0011AA\r\u0011%\t\u0019\u0003AA\u0001\n\u0003\n)cB\u0005\u0002Di\t\t\u0011#\u0001\u0002F\u0019A\u0011DGA\u0001\u0012\u0003\t9\u0005\u0003\u0004@'\u0011\u0005\u0011Q\u000b\u0005\n\u0003/\u001a\u0012\u0011!C#\u00033B\u0011\"a\u0017\u0014\u0003\u0003%\t)!\u0018\t\u0013\u0005\r4#!A\u0005\u0002\u0006\u0015\u0004\"CA<'\u0005\u0005I\u0011BA=\u0005!A\u0006+\u0019;i\u0013:$(BA\u000e\u001d\u0003\rAX\u000e\u001c\u0006\u0003;y\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0004I\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0011EI\u0001\u0004gFd'BA\u0012%\u0003\u0015\u0019\b/\u0019:l\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\u0004\u0001M!\u0001A\u000b\u00185!\tYC&D\u0001\u001b\u0013\ti#D\u0001\u0007Y!\u0006$\b.\u0012=ue\u0006\u001cG\u000f\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004GA\u0004Qe>$Wo\u0019;\u0011\u0005=*\u0014B\u0001\u001c1\u00051\u0019VM]5bY&T\u0018M\u00197f+\u0005A\u0004CA\u001d;\u001b\u0005a\u0012BA\u001e\u001d\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0005q6d\u0007%\u0001\u0003qCRD\u0017!\u00029bi\"\u0004\u0013A\u0002\u001fj]&$h\bF\u0002B\u0005\u000e\u0003\"a\u000b\u0001\t\u000bm)\u0001\u0019\u0001\u001d\t\u000bu*\u0001\u0019\u0001\u001d\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001G!\t9eJ\u0004\u0002I\u0019B\u0011\u0011\nM\u0007\u0002\u0015*\u00111\nK\u0001\u0007yI|w\u000e\u001e \n\u00055\u0003\u0014A\u0002)sK\u0012,g-\u0003\u0002P!\n11\u000b\u001e:j]\u001eT!!\u0014\u0019\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012a\u0015\t\u0003)^k\u0011!\u0016\u0006\u0003-\u0002\nQ\u0001^=qKNL!\u0001W+\u0003\u0011\u0011\u000bG/\u0019+za\u0016\fAB\\;mYN\u000bg-Z#wC2$2a\u00170`!\tyC,\u0003\u0002^a\t\u0019\u0011I\\=\t\u000bmA\u0001\u0019A.\t\u000buB\u0001\u0019A.\u0002\t\r|\u0007/\u001f\u000b\u0004\u0003\n\u001c\u0007bB\u000e\n!\u0003\u0005\r\u0001\u000f\u0005\b{%\u0001\n\u00111\u00019\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012A\u001a\u0016\u0003q\u001d\\\u0013\u0001\u001b\t\u0003S:l\u0011A\u001b\u0006\u0003W2\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u00055\u0004\u0014AC1o]>$\u0018\r^5p]&\u0011qN\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0003M\u0004\"\u0001^=\u000e\u0003UT!A^<\u0002\t1\fgn\u001a\u0006\u0002q\u0006!!.\u0019<b\u0013\tyU/\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001}!\tyS0\u0003\u0002\u007fa\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u00191,a\u0001\t\u0011\u0005\u0015a\"!AA\u0002q\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u0006!\u0015\ti!a\u0005\\\u001b\t\tyAC\u0002\u0002\u0012A\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)\"a\u0004\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u00037\t\t\u0003E\u00020\u0003;I1!a\b1\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\u0002\u0011\u0003\u0003\u0005\raW\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005m\u0011q\u0005\u0005\t\u0003\u000b\t\u0012\u0011!a\u00017\"z\u0001!a\u000b\u00022\u0005M\u0012qGA\u001d\u0003{\ty\u0004E\u0002:\u0003[I1!a\f\u001d\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!\u000e\u0002\u0003#yf)\u0016(D?\"BX\u000e\u001c\u0017!qB\fG\u000f[\u0015![\u0001\u0012V\r^;s]N\u0004\u0013M\u001c\u0011j]R,w-\u001a:!m\u0006dW/\u001a\u0017!_J\u0004C\u000f[3!m\u0006dW/\u001a\u0011{KJ|\u0007%\u001b4!]>\u0004S.\u0019;dQ\u0002J7\u000f\t4pk:$G\u0006I8sA\u0005\u0004S.\u0019;dQ\u0002J7\u000f\t4pk:$\u0007EY;uAQDW\r\t<bYV,\u0007%[:!]>tWF\\;nKJL7ML\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u00111H\u0001Y\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":C(\u0019 =Ez\nDh\f2?y\tt$\u0007P\u0018c}qz\u0013MP\u0014-A\u001d\u001aX/\u001c\u0015b_\tLs%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!g)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002B\u0005)!G\f\u0019/a\u0005A\u0001\fU1uQ&sG\u000f\u0005\u0002,'M!1#!\u00135!\u001d\tY%!\u00159q\u0005k!!!\u0014\u000b\u0007\u0005=\u0003'A\u0004sk:$\u0018.\\3\n\t\u0005M\u0013Q\n\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DCAA#\u0003!!xn\u0015;sS:<G#A:\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b\u0005\u000by&!\u0019\t\u000bm1\u0002\u0019\u0001\u001d\t\u000bu2\u0002\u0019\u0001\u001d\u0002\u000fUt\u0017\r\u001d9msR!\u0011qMA:!\u0015y\u0013\u0011NA7\u0013\r\tY\u0007\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b=\ny\u0007\u000f\u001d\n\u0007\u0005E\u0004G\u0001\u0004UkBdWM\r\u0005\t\u0003k:\u0012\u0011!a\u0001\u0003\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003w\u00022\u0001^A?\u0013\r\ty(\u001e\u0002\u0007\u001f\nTWm\u0019;")
public class XPathInt
extends XPathExtract
implements Serializable {
    private final Expression xml;
    private final Expression path;

    public static Option<Tuple2<Expression, Expression>> unapply(XPathInt xPathInt) {
        return XPathInt$.MODULE$.unapply(xPathInt);
    }

    public static Function1<Tuple2<Expression, Expression>, XPathInt> tupled() {
        return XPathInt$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, XPathInt>> curried() {
        return XPathInt$.MODULE$.curried();
    }

    @Override
    public Expression xml() {
        return this.xml;
    }

    @Override
    public Expression path() {
        return this.path;
    }

    @Override
    public String prettyName() {
        return "xpath_int";
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object xml, Object path) {
        Double ret = this.xpathUtil().evalNumber(((UTF8String)xml).toString(), this.pathString());
        return ret == null ? null : BoxesRunTime.boxToInteger((int)ret.intValue());
    }

    public XPathInt copy(Expression xml, Expression path) {
        return new XPathInt(xml, path);
    }

    public Expression copy$default$1() {
        return this.xml();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "XPathInt";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.xml();
                break;
            }
            case 1: {
                expression = this.path();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XPathInt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XPathInt)) return false;
        boolean bl = true;
        if (!bl) return false;
        XPathInt xPathInt = (XPathInt)x$1;
        Expression expression = this.xml();
        Expression expression2 = xPathInt.xml();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = xPathInt.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!xPathInt.canEqual(this)) return false;
        return true;
    }

    public XPathInt(Expression xml, Expression path) {
        this.xml = xml;
        this.path = path;
    }
}

