/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HashExpression;
import org.apache.spark.sql.catalyst.expressions.XXH64;
import org.apache.spark.sql.catalyst.expressions.XxHash64$;
import org.apache.spark.sql.catalyst.expressions.XxHash64Function$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr1, expr2, ...) - Returns a 64-bit hash value of the arguments.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark', array(123), 2);\n       5602566077635097486\n  ", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001B\u000e\u001d\u0001&B\u0001B\u000f\u0001\u0003\u0016\u0004%\ta\u000f\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005y!AA\n\u0001BK\u0002\u0013\u0005Q\n\u0003\u0005O\u0001\tE\t\u0015!\u0003/\u0011\u0015y\u0005\u0001\"\u0001Q\u0011\u0015y\u0005\u0001\"\u0001U\u0011\u00159\u0006\u0001\"\u0011Y\u0011\u0015y\u0006\u0001\"\u0011a\u0011\u0015I\u0007\u0001\"\u0015a\u0011\u0015Q\u0007\u0001\"\u0015l\u0011\u001d\u0019\b!!A\u0005\u0002QDqa\u001e\u0001\u0012\u0002\u0013\u0005\u0001\u0010C\u0005\u0002\b\u0001\t\n\u0011\"\u0001\u0002\n!I\u0011Q\u0002\u0001\u0002\u0002\u0013\u0005\u0013q\u0002\u0005\n\u0003?\u0001\u0011\u0011!C\u0001\u0003CA\u0011\"!\u000b\u0001\u0003\u0003%\t!a\u000b\t\u0013\u0005E\u0002!!A\u0005B\u0005M\u0002\"CA!\u0001\u0005\u0005I\u0011AA\"\u0011%\ti\u0005AA\u0001\n\u0003\nyeB\u0005\u0002nq\t\t\u0011#\u0001\u0002p\u0019A1\u0004HA\u0001\u0012\u0003\t\t\b\u0003\u0004P+\u0011\u0005\u0011q\u0010\u0005\n\u0003\u0003+\u0012\u0011!C#\u0003\u0007C\u0011\"!\"\u0016\u0003\u0003%\t)a\"\t\u0013\u00055U#!A\u0005\u0002\u0006=\u0005\"CAQ+\u0005\u0005I\u0011BAR\u0005!A\u0006\u0010S1tQZ\"$BA\u000f\u001f\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005}\u0001\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0005\u0012\u0013aA:rY*\u00111\u0005J\u0001\u0006gB\f'o\u001b\u0006\u0003K\u0019\na!\u00199bG\",'\"A\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001QCg\u000e\t\u0004W1rS\"\u0001\u000f\n\u00055b\"A\u0004%bg\",\u0005\u0010\u001d:fgNLwN\u001c\t\u0003_Ij\u0011\u0001\r\u0006\u0002c\u0005)1oY1mC&\u00111\u0007\r\u0002\u0005\u0019>tw\r\u0005\u00020k%\u0011a\u0007\r\u0002\b!J|G-^2u!\ty\u0003(\u0003\u0002:a\ta1+\u001a:jC2L'0\u00192mK\u0006A1\r[5mIJ,g.F\u0001=!\riT\t\u0013\b\u0003}\rs!a\u0010\"\u000e\u0003\u0001S!!\u0011\u0015\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0014B\u0001#1\u0003\u001d\u0001\u0018mY6bO\u0016L!AR$\u0003\u0007M+\u0017O\u0003\u0002EaA\u00111&S\u0005\u0003\u0015r\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003%\u0019\u0007.\u001b7ee\u0016t\u0007%\u0001\u0003tK\u0016$W#\u0001\u0018\u0002\u000bM,W\r\u001a\u0011\u0002\rqJg.\u001b;?)\r\t&k\u0015\t\u0003W\u0001AQAO\u0003A\u0002qBQ\u0001T\u0003A\u00029\"\"!U+\t\u000bY3\u0001\u0019\u0001\u001f\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003e\u0003\"AW/\u000e\u0003mS!\u0001\u0018\u0011\u0002\u000bQL\b/Z:\n\u0005y[&\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001b!\t\u0011gM\u0004\u0002dIB\u0011q\bM\u0005\u0003KB\na\u0001\u0015:fI\u00164\u0017BA4i\u0005\u0019\u0019FO]5oO*\u0011Q\rM\u0001\u0010Q\u0006\u001c\b.\u001a:DY\u0006\u001c8OT1nK\u0006Y1m\\7qkR,\u0007*Y:i)\u0011qC.\u001d:\t\u000b5T\u0001\u0019\u00018\u0002\u000bY\fG.^3\u0011\u0005=z\u0017B\u000191\u0005\r\te.\u001f\u0005\u0006/*\u0001\r!\u0017\u0005\u0006\u0019*\u0001\rAL\u0001\u0005G>\u0004\u0018\u0010F\u0002RkZDqAO\u0006\u0011\u0002\u0003\u0007A\bC\u0004M\u0017A\u0005\t\u0019\u0001\u0018\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\t\u0011P\u000b\u0002=u.\n1\u0010E\u0002}\u0003\u0007i\u0011! \u0006\u0003}~\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005\u0001'\u0001\u0006b]:|G/\u0019;j_:L1!!\u0002~\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tYA\u000b\u0002/u\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u0005\u0011\t\u0005M\u0011QD\u0007\u0003\u0003+QA!a\u0006\u0002\u001a\u0005!A.\u00198h\u0015\t\tY\"\u0001\u0003kCZ\f\u0017bA4\u0002\u0016\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\u0005\t\u0004_\u0005\u0015\u0012bAA\u0014a\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019a.!\f\t\u0013\u0005=\u0002#!AA\u0002\u0005\r\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00026A)\u0011qGA\u001f]6\u0011\u0011\u0011\b\u0006\u0004\u0003w\u0001\u0014AC2pY2,7\r^5p]&!\u0011qHA\u001d\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u0015\u00131\n\t\u0004_\u0005\u001d\u0013bAA%a\t9!i\\8mK\u0006t\u0007\u0002CA\u0018%\u0005\u0005\t\u0019\u00018\u0002\r\u0015\fX/\u00197t)\u0011\t)%!\u0015\t\u0011\u0005=2#!AA\u00029Ds\u0002AA+\u00037\ni&!\u0019\u0002d\u0005\u001d\u0014\u0011\u000e\t\u0004W\u0005]\u0013bAA-9\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA0\u0003%{f)\u0016(D?\"*\u0007\u0010\u001d:2Y\u0001*\u0007\u0010\u001d:3Y\u0001rcFL\u0015![\u0001\u0012V\r^;s]N\u0004\u0013\r\t\u001c5[\tLG\u000f\t5bg\"\u0004c/\u00197vK\u0002zg\r\t;iK\u0002\n'oZ;nK:$8OL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011QM\u0001\\\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":3\u000b]1sW\u001eb\u0003%\u0019:sCfD\u0013GM\u001a*Y\u0001\u0012\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00116mA\u0012TG\u000e\u001c1o]24'\u000e\u0019:oQBdG\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\tY'A\u00034]Ar\u0003'\u0001\u0005Yq\"\u000b7\u000f\u001b\u001c5!\tYSc\u0005\u0003\u0016\u0003g:\u0004cBA;\u0003wbd&U\u0007\u0003\u0003oR1!!\u001f1\u0003\u001d\u0011XO\u001c;j[\u0016LA!! \u0002x\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\u0005=\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005E\u0011!B1qa2LH#B)\u0002\n\u0006-\u0005\"\u0002\u001e\u0019\u0001\u0004a\u0004\"\u0002'\u0019\u0001\u0004q\u0013aB;oCB\u0004H.\u001f\u000b\u0005\u0003#\u000bi\nE\u00030\u0003'\u000b9*C\u0002\u0002\u0016B\u0012aa\u00149uS>t\u0007#B\u0018\u0002\u001arr\u0013bAANa\t1A+\u001e9mKJB\u0001\"a(\u001a\u0003\u0003\u0005\r!U\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!*\u0011\t\u0005M\u0011qU\u0005\u0005\u0003S\u000b)B\u0001\u0004PE*,7\r\u001e")
public class XxHash64
extends HashExpression<Object>
implements Serializable {
    private final Seq<Expression> children;
    private final long seed;

    public static Option<Tuple2<Seq<Expression>, Object>> unapply(XxHash64 xxHash64) {
        return XxHash64$.MODULE$.unapply(xxHash64);
    }

    public static Function1<Tuple2<Seq<Expression>, Object>, XxHash64> tupled() {
        return XxHash64$.MODULE$.tupled();
    }

    public static Function1<Seq<Expression>, Function1<Object, XxHash64>> curried() {
        return XxHash64$.MODULE$.curried();
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    @Override
    public long seed() {
        return this.seed;
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "xxhash64";
    }

    @Override
    public String hasherClassName() {
        return XXH64.class.getName();
    }

    @Override
    public long computeHash(Object value, DataType dataType, long seed) {
        return XxHash64Function$.MODULE$.hash(value, dataType, seed);
    }

    public XxHash64 copy(Seq<Expression> children2, long seed) {
        return new XxHash64(children2, seed);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    public long copy$default$2() {
        return this.seed();
    }

    @Override
    public String productPrefix() {
        return "XxHash64";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.children();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToLong((long)this.seed());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XxHash64;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XxHash64)) return false;
        boolean bl = true;
        if (!bl) return false;
        XxHash64 xxHash64 = (XxHash64)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = xxHash64.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (this.seed() != xxHash64.seed()) return false;
        if (!xxHash64.canEqual(this)) return false;
        return true;
    }

    public XxHash64(Seq<Expression> children2, long seed) {
        this.children = children2;
        this.seed = seed;
    }

    public XxHash64(Seq<Expression> arguments) {
        this(arguments, 42L);
    }
}

