/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic;
import org.apache.spark.sql.catalyst.expressions.Stateful;
import org.apache.spark.sql.catalyst.expressions.Uuid$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.RandomUUIDGenerator;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_() - Returns an universally unique identifier (UUID) string. The value is returned as a canonical UUID 36-character string.", examples="\n    Examples:\n      > SELECT _FUNC_();\n       46707d92-02f4-4817-8116-a4c3b23e6266\n  ", note="\n    The function is non-deterministic.\n  ", since="2.3.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001B\u0010!\u00016B\u0001\"\u0011\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005\u0007\")!\n\u0001C\u0001\u0017\")!\n\u0001C\u0001\u001d\")q\n\u0001C!!\"A1\u000b\u0001EC\u0002\u0013\u0005C\u000bC\u0003Y\u0001\u0011\u0005C\u000bC\u0003Z\u0001\u0011\u0005#\fC\u0005b\u0001\u0001\u0007\t\u0011)Q\u0005E\")A\u000e\u0001C)[\")a\u000f\u0001C)o\"9\u00111\u0001\u0001\u0005B\u0005\u0015\u0001BBA\u0011\u0001\u0011\u0005c\nC\u0005\u0002$\u0001\t\t\u0011\"\u0001\u0002&!I\u0011\u0011\u0006\u0001\u0012\u0002\u0013\u0005\u00111\u0006\u0005\n\u0003\u0003\u0002\u0011\u0011!C!\u0003\u0007B\u0011\"!\u0016\u0001\u0003\u0003%\t!a\u0016\t\u0013\u0005e\u0003!!A\u0005\u0002\u0005m\u0003\"CA1\u0001\u0005\u0005I\u0011IA2\u0011%\t\t\bAA\u0001\n\u0003\t\u0019\bC\u0005\u0002x\u0001\t\t\u0011\"\u0011\u0002z\u001dI\u0011Q\u0014\u0011\u0002\u0002#\u0005\u0011q\u0014\u0004\t?\u0001\n\t\u0011#\u0001\u0002\"\"1!j\u0006C\u0001\u0003_C\u0011\"!-\u0018\u0003\u0003%)%a-\t\u0013\u0005Uv#!A\u0005\u0002\u0006]\u0006\"CA^/E\u0005I\u0011AA\u0016\u0011%\tilFA\u0001\n\u0003\u000by\fC\u0005\u0002H^\t\n\u0011\"\u0001\u0002,!I\u0011\u0011Z\f\u0002\u0002\u0013%\u00111\u001a\u0002\u0005+VLGM\u0003\u0002\"E\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u0019C%\u0001\u0005dCR\fG._:u\u0015\t)c%A\u0002tc2T!a\n\u0015\u0002\u000bM\u0004\u0018M]6\u000b\u0005%R\u0013AB1qC\u000eDWMC\u0001,\u0003\ry'oZ\u0002\u0001'\u0019\u0001aFM\u001b9}A\u0011q\u0006M\u0007\u0002A%\u0011\u0011\u0007\t\u0002\u000f\u0019\u0016\fg-\u0012=qe\u0016\u001c8/[8o!\ty3'\u0003\u00025A\tA1\u000b^1uK\u001a,H\u000e\u0005\u00020m%\u0011q\u0007\t\u0002\u0019\u000bb\u0004(/Z:tS>tw+\u001b;i%\u0006tGm\\7TK\u0016$\u0007CA\u001d=\u001b\u0005Q$\"A\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uR$a\u0002)s_\u0012,8\r\u001e\t\u0003s}J!\u0001\u0011\u001e\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0015I\fg\u000eZ8n'\u0016,G-F\u0001D!\rIDIR\u0005\u0003\u000bj\u0012aa\u00149uS>t\u0007CA\u001dH\u0013\tA%H\u0001\u0003M_:<\u0017a\u0003:b]\u0012|WnU3fI\u0002\na\u0001P5oSRtDC\u0001'N!\ty\u0003\u0001C\u0004B\u0007A\u0005\t\u0019A\"\u0015\u00031\u000b1b^5uQ:+woU3fIR\u0011A*\u0015\u0005\u0006%\u0016\u0001\rAR\u0001\u0005g\u0016,G-\u0001\u0005sKN|GN^3e+\u0005)\u0006CA\u001dW\u0013\t9&HA\u0004C_>dW-\u00198\u0002\u00119,H\u000e\\1cY\u0016\f\u0001\u0002Z1uCRK\b/Z\u000b\u00027B\u0011AlX\u0007\u0002;*\u0011a\fJ\u0001\u0006if\u0004Xm]\u0005\u0003Av\u0013\u0001\u0002R1uCRK\b/Z\u0001\u0010e\u0006tGm\\7HK:,'/\u0019;peB\u00111MZ\u0007\u0002I*\u0011QMI\u0001\u0005kRLG.\u0003\u0002hI\n\u0019\"+\u00198e_6,V+\u0013#HK:,'/\u0019;pe\"\u0012\u0011\"\u001b\t\u0003s)L!a\u001b\u001e\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018AE5oSRL\u0017\r\\5{K&sG/\u001a:oC2$\"A\\9\u0011\u0005ez\u0017B\u00019;\u0005\u0011)f.\u001b;\t\u000bIT\u0001\u0019A:\u0002\u001dA\f'\u000f^5uS>t\u0017J\u001c3fqB\u0011\u0011\b^\u0005\u0003kj\u00121!\u00138u\u00031)g/\u00197J]R,'O\\1m)\tA8\u0010\u0005\u0002:s&\u0011!P\u000f\u0002\u0004\u0003:L\b\"\u0002?\f\u0001\u0004i\u0018!B5oaV$\bC\u0001@\u0000\u001b\u0005\u0011\u0013bAA\u0001E\tY\u0011J\u001c;fe:\fGNU8x\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002\b\u0005M\u0011Q\u0004\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011Q\u0002\u0011\u0002\u000f\r|G-Z4f]&!\u0011\u0011CA\u0006\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA\u000b\u0019\u0001\u0007\u0011qC\u0001\u0004GRD\b\u0003BA\u0005\u00033IA!a\u0007\u0002\f\tq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBA\u0010\u0019\u0001\u0007\u0011qA\u0001\u0003KZ\f\u0011B\u001a:fg\"\u001cu\u000e]=\u0002\t\r|\u0007/\u001f\u000b\u0004\u0019\u0006\u001d\u0002bB!\u000f!\u0003\u0005\raQ\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tiCK\u0002D\u0003_Y#!!\r\u0011\t\u0005M\u0012QH\u0007\u0003\u0003kQA!a\u000e\u0002:\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003wQ\u0014AC1o]>$\u0018\r^5p]&!\u0011qHA\u001b\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u0015\u0003\u0003BA$\u0003#j!!!\u0013\u000b\t\u0005-\u0013QJ\u0001\u0005Y\u0006twM\u0003\u0002\u0002P\u0005!!.\u0019<b\u0013\u0011\t\u0019&!\u0013\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\u0005\u0019\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004q\u0006u\u0003\u0002CA0%\u0005\u0005\t\u0019A:\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\u0007E\u0003\u0002h\u00055\u00040\u0004\u0002\u0002j)\u0019\u00111\u000e\u001e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002p\u0005%$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2!VA;\u0011!\ty\u0006FA\u0001\u0002\u0004A\u0018AB3rk\u0006d7\u000fF\u0002V\u0003wB\u0001\"a\u0018\u0016\u0003\u0003\u0005\r\u0001\u001f\u0015\u0014\u0001\u0005}\u0014QQAD\u0003\u0017\u000bi)!%\u0002\u0014\u0006]\u0015\u0011\u0014\t\u0004_\u0005\u0005\u0015bAABA\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAE\u0003\u0005\rqLR+O\u0007~C\u0013\u0006I\u0017!%\u0016$XO\u001d8tA\u0005t\u0007%\u001e8jm\u0016\u00148/\u00197ms\u0002*h.[9vK\u0002JG-\u001a8uS\u001aLWM\u001d\u0011)+VKE)\u000b\u0011tiJLgn\u001a\u0018!)\",\u0007E^1mk\u0016\u0004\u0013n\u001d\u0011sKR,(O\\3eA\u0005\u001c\b%\u0019\u0011dC:|g.[2bY\u0002*V+\u0013#!gYj3\r[1sC\u000e$XM\u001d\u0011tiJLgn\u001a\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a$\u0002-*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00115m]\u0002t\u0007Z\u001d3[A\u0012d\rN\u00175qE:T\u0006O\u00192m5\nGgY\u001aceM*gG\r\u001c7\u0015\u0001\u0002\u0013\u0001\u00028pi\u0016\f#!!&\u0002U)\u0001\u0003\u0005\t\u0011UQ\u0016\u0004c-\u001e8di&|g\u000eI5tA9|g.\f3fi\u0016\u0014X.\u001b8jgRL7M\f\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u00111T\u0001\u0006e9\u001ad\u0006M\u0001\u0005+VLG\r\u0005\u00020/M!q#a)?!\u0019\t)+a+D\u00196\u0011\u0011q\u0015\u0006\u0004\u0003SS\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003[\u000b9KA\tBEN$(/Y2u\rVt7\r^5p]F\"\"!a(\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0012\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u00071\u000bI\fC\u0004B5A\u0005\t\u0019A\"\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIE\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002B\u0006\r\u0007cA\u001dE\u0007\"A\u0011Q\u0019\u000f\u0002\u0002\u0003\u0007A*A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!4\u0011\t\u0005\u001d\u0013qZ\u0005\u0005\u0003#\fIE\u0001\u0004PE*,7\r\u001e")
public class Uuid
extends LeafExpression
implements Stateful,
ExpressionWithRandomSeed,
Serializable {
    private boolean resolved;
    private final Option<Object> randomSeed;
    private transient RandomUUIDGenerator randomGenerator;
    private boolean deterministic;
    private transient boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    private volatile byte bitmap$0;

    public static Option<Object> $lessinit$greater$default$1() {
        return Uuid$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<Option<Object>> unapply(Uuid uuid) {
        return Uuid$.MODULE$.unapply(uuid);
    }

    public static Option<Object> apply$default$1() {
        return Uuid$.MODULE$.apply$default$1();
    }

    public static <A> Function1<Option<Object>, A> andThen(Function1<Uuid, A> function1) {
        return Uuid$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, Uuid> compose(Function1<A, Option<Object>> function1) {
        return Uuid$.MODULE$.compose(function1);
    }

    @Override
    public boolean fastEquals(TreeNode<?> other) {
        return Stateful.fastEquals$(this, other);
    }

    @Override
    public final boolean foldable() {
        return Nondeterministic.foldable$(this);
    }

    @Override
    public final void initialize(int partitionIndex) {
        Nondeterministic.initialize$(this, partitionIndex);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Nondeterministic.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Nondeterministic.eval$default$1$(this);
    }

    private boolean deterministic$lzycompute() {
        Uuid uuid = this;
        synchronized (uuid) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.deterministic = Nondeterministic.deterministic$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.deterministic;
    }

    @Override
    public final boolean deterministic() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.deterministic$lzycompute() : this.deterministic;
    }

    @Override
    public boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized() {
        return this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized_$eq(boolean x$1) {
        this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized = x$1;
    }

    public Option<Object> randomSeed() {
        return this.randomSeed;
    }

    @Override
    public Uuid withNewSeed(long seed) {
        return new Uuid((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)seed)));
    }

    private boolean resolved$lzycompute() {
        Uuid uuid = this;
        synchronized (uuid) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.resolved = this.randomSeed().isDefined();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public void initializeInternal(int partitionIndex) {
        this.randomGenerator = new RandomUUIDGenerator(BoxesRunTime.unboxToLong((Object)this.randomSeed().get()) + (long)partitionIndex);
    }

    @Override
    public Object evalInternal(InternalRow input) {
        return this.randomGenerator.getNextUUIDUTF8String();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String randomGen = ctx.freshName("randomGen");
        String x$1 = "org.apache.spark.sql.catalyst.util.RandomUUIDGenerator";
        String x$2 = randomGen;
        boolean x$3 = true;
        boolean x$4 = false;
        Function1<String, String> x$5 = ctx.addMutableState$default$3();
        ctx.addMutableState(x$1, x$2, x$5, x$3, x$4);
        ctx.addPartitionInitializationStatement(new StringBuilder(82).append(randomGen).append(" = ").append("new org.apache.spark.sql.catalyst.util.RandomUUIDGenerator(").append(this.randomSeed().get()).append("L + partitionIndex);").toString());
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"final UTF8String ", " = ", ".getNextUUIDUTF8String();"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.value(), randomGen})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public Uuid freshCopy() {
        return new Uuid(this.randomSeed());
    }

    public Uuid copy(Option<Object> randomSeed) {
        return new Uuid(randomSeed);
    }

    public Option<Object> copy$default$1() {
        return this.randomSeed();
    }

    @Override
    public String productPrefix() {
        return "Uuid";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.randomSeed();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Uuid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Uuid)) return false;
        boolean bl = true;
        if (!bl) return false;
        Uuid uuid = (Uuid)x$1;
        Option<Object> option = this.randomSeed();
        Option<Object> option2 = uuid.randomSeed();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!uuid.canEqual(this)) return false;
        return true;
    }

    public Uuid(Option<Object> randomSeed) {
        this.randomSeed = randomSeed;
        Nondeterministic.$init$(this);
        Stateful.$init$(this);
    }

    public Uuid() {
        this((Option<Object>)None$.MODULE$);
    }
}

