/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.StringRepeat$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, n) - Returns the string which repeats the given string value n times.", examples="\n    Examples:\n      > SELECT _FUNC_('123', 2);\n       123123\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001B\u000f\u001f\u0001.B\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t\u0011\u0002\u0011\t\u0012)A\u0005\u000b\"A\u0011\n\u0001BK\u0002\u0013\u0005A\t\u0003\u0005K\u0001\tE\t\u0015!\u0003F\u0011\u0015Y\u0005\u0001\"\u0001M\u0011\u0015\u0001\u0006\u0001\"\u0011E\u0011\u0015\t\u0006\u0001\"\u0011E\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0011\u0015Q\u0006\u0001\"\u0011\\\u0011\u00159\u0007\u0001\"\u0011i\u0011\u0015\u0001\b\u0001\"\u0011r\u0011\u0015Q\b\u0001\"\u0011|\u0011%\t\u0019\u0002AA\u0001\n\u0003\t)\u0002C\u0005\u0002\u001c\u0001\t\n\u0011\"\u0001\u0002\u001e!I\u00111\u0007\u0001\u0012\u0002\u0013\u0005\u0011Q\u0004\u0005\n\u0003k\u0001\u0011\u0011!C!\u0003oA\u0011\"a\u0012\u0001\u0003\u0003%\t!!\u0013\t\u0013\u0005E\u0003!!A\u0005\u0002\u0005M\u0003\"CA-\u0001\u0005\u0005I\u0011IA.\u0011%\tI\u0007AA\u0001\n\u0003\tY\u0007C\u0005\u0002v\u0001\t\t\u0011\"\u0011\u0002x\u001dI\u0011Q\u0013\u0010\u0002\u0002#\u0005\u0011q\u0013\u0004\t;y\t\t\u0011#\u0001\u0002\u001a\"11j\u0006C\u0001\u0003OC\u0011\"!+\u0018\u0003\u0003%)%a+\t\u0013\u00055v#!A\u0005\u0002\u0006=\u0006\"CA[/\u0005\u0005I\u0011QA\\\u0011%\tImFA\u0001\n\u0013\tYM\u0001\u0007TiJLgn\u001a*fa\u0016\fGO\u0003\u0002 A\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\t#%\u0001\u0005dCR\fG._:u\u0015\t\u0019C%A\u0002tc2T!!\n\u0014\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dB\u0013AB1qC\u000eDWMC\u0001*\u0003\ry'oZ\u0002\u0001'\u0019\u0001A\u0006M\u001a;\u0001B\u0011QFL\u0007\u0002=%\u0011qF\b\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"!L\u0019\n\u0005Ir\"AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005Q:dBA\u00176\u0013\t1d$A\u0004qC\u000e\\\u0017mZ3\n\u0005aJ$A\u0004(vY2Le\u000e^8mKJ\fg\u000e\u001e\u0006\u0003my\u0001\"a\u000f \u000e\u0003qR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002<\u0003&\u0011!\t\u0010\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0004gR\u0014X#A#\u0011\u000552\u0015BA$\u001f\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0005gR\u0014\b%A\u0003uS6,7/\u0001\u0004uS6,7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00075su\n\u0005\u0002.\u0001!)1)\u0002a\u0001\u000b\")\u0011*\u0002a\u0001\u000b\u0006!A.\u001a4u\u0003\u0015\u0011\u0018n\u001a5u\u0003!!\u0017\r^1UsB,W#\u0001+\u0011\u0005UCV\"\u0001,\u000b\u0005]\u0013\u0013!\u0002;za\u0016\u001c\u0018BA-W\u0005!!\u0015\r^1UsB,\u0017AC5oaV$H+\u001f9fgV\tA\fE\u0002^IRs!AX2\u000f\u0005}\u0013W\"\u00011\u000b\u0005\u0005T\u0013A\u0002\u001fs_>$h(C\u0001>\u0013\t1D(\u0003\u0002fM\n\u00191+Z9\u000b\u0005Yb\u0014\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGcA5m]B\u00111H[\u0005\u0003Wr\u00121!\u00118z\u0011\u0015i'\u00021\u0001j\u0003\u0019\u0019HO]5oO\")qN\u0003a\u0001S\u0006\ta.\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012A\u001d\t\u0003g^t!\u0001^;\u0011\u0005}c\u0014B\u0001<=\u0003\u0019\u0001&/\u001a3fM&\u0011\u00010\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Yd\u0014!\u00033p\u000f\u0016t7i\u001c3f)\u0015a\u0018QAA\b!\ri\u0018\u0011A\u0007\u0002}*\u0011qPH\u0001\bG>$WmZ3o\u0013\r\t\u0019A \u0002\t\u000bb\u0004(oQ8eK\"9\u0011q\u0001\u0007A\u0002\u0005%\u0011aA2uqB\u0019Q0a\u0003\n\u0007\u00055aP\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\r\u0005EA\u00021\u0001}\u0003\t)g/\u0001\u0003d_BLH#B'\u0002\u0018\u0005e\u0001bB\"\u000e!\u0003\u0005\r!\u0012\u0005\b\u00136\u0001\n\u00111\u0001F\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\b+\u0007\u0015\u000b\tc\u000b\u0002\u0002$A!\u0011QEA\u0018\u001b\t\t9C\u0003\u0003\u0002*\u0005-\u0012!C;oG\",7m[3e\u0015\r\ti\u0003P\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0019\u0003O\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u001d!\u0011\tY$!\u0012\u000e\u0005\u0005u\"\u0002BA \u0003\u0003\nA\u0001\\1oO*\u0011\u00111I\u0001\u0005U\u00064\u0018-C\u0002y\u0003{\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u0013\u0011\u0007m\ni%C\u0002\u0002Pq\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2![A+\u0011%\t9FEA\u0001\u0002\u0004\tY%A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003;\u0002R!a\u0018\u0002f%l!!!\u0019\u000b\u0007\u0005\rD(\u0001\u0006d_2dWm\u0019;j_:LA!a\u001a\u0002b\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ti'a\u001d\u0011\u0007m\ny'C\u0002\u0002rq\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002XQ\t\t\u00111\u0001j\u0003\u0019)\u0017/^1mgR!\u0011QNA=\u0011!\t9&FA\u0001\u0002\u0004I\u0007f\u0004\u0001\u0002~\u0005\r\u0015QQAE\u0003\u0017\u000by)!%\u0011\u00075\ny(C\u0002\u0002\u0002z\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\b\u0006\tvLR+O\u0007~C3\u000f\u001e:-A9L\u0003%\f\u0011SKR,(O\\:!i\",\u0007e\u001d;sS:<\u0007e\u001e5jG\"\u0004#/\u001a9fCR\u001c\b\u0005\u001e5fA\u001dLg/\u001a8!gR\u0014\u0018N\\4!m\u0006dW/\u001a\u0011oAQLW.Z:/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAG\u0003\u0001S\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ\u00193g\u001db\u0003EM\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AE\u00124'\r\u001a4\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAJ\u0003\u0015\td&\u000e\u00181\u00031\u0019FO]5oOJ+\u0007/Z1u!\tisc\u0005\u0003\u0018\u00037\u0003\u0005cBAO\u0003G+U)T\u0007\u0003\u0003?S1!!)=\u0003\u001d\u0011XO\u001c;j[\u0016LA!!*\u0002 \n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\u0005]\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005e\u0012!B1qa2LH#B'\u00022\u0006M\u0006\"B\"\u001b\u0001\u0004)\u0005\"B%\u001b\u0001\u0004)\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003s\u000b)\rE\u0003<\u0003w\u000by,C\u0002\u0002>r\u0012aa\u00149uS>t\u0007#B\u001e\u0002B\u0016+\u0015bAAby\t1A+\u001e9mKJB\u0001\"a2\u001c\u0003\u0003\u0005\r!T\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!4\u0011\t\u0005m\u0012qZ\u0005\u0005\u0003#\fiD\u0001\u0004PE*,7\r\u001e")
public class StringRepeat
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression str;
    private final Expression times;

    public static Option<Tuple2<Expression, Expression>> unapply(StringRepeat stringRepeat) {
        return StringRepeat$.MODULE$.unapply(stringRepeat);
    }

    public static Function1<Tuple2<Expression, Expression>, StringRepeat> tupled() {
        return StringRepeat$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, StringRepeat>> curried() {
        return StringRepeat$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression times() {
        return this.times;
    }

    @Override
    public Expression left() {
        return this.str();
    }

    @Override
    public Expression right() {
        return this.times();
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object string, Object n) {
        return ((UTF8String)string).repeat(Predef$.MODULE$.Integer2int((Integer)n));
    }

    @Override
    public String prettyName() {
        return "repeat";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(l, r) -> new StringBuilder(11).append("(").append((String)l).append(").repeat(").append((String)r).append(")").toString());
    }

    public StringRepeat copy(Expression str, Expression times) {
        return new StringRepeat(str, times);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.times();
    }

    @Override
    public String productPrefix() {
        return "StringRepeat";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.str();
                break;
            }
            case 1: {
                expression = this.times();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringRepeat;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringRepeat)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringRepeat stringRepeat = (StringRepeat)x$1;
        Expression expression = this.str();
        Expression expression2 = stringRepeat.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.times();
        Expression expression4 = stringRepeat.times();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!stringRepeat.canEqual(this)) return false;
        return true;
    }

    public StringRepeat(Expression str, Expression times) {
        this.str = str;
        this.times = times;
        ExpectsInputTypes.$init$(this);
    }
}

