/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FindInSet$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str, str_array) - Returns the index (1-based) of the given string (`str`) in the comma-delimited list (`str_array`).\n      Returns 0, if the string was not found or if the given string (`str`) contains a comma.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('ab','abc,b,ab,c,def');\n       3\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001B\u000e\u001d\u0001&B\u0001\"\u0011\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\r\u0002\u0011\t\u0012)A\u0005\u0007\"Aq\t\u0001BK\u0002\u0013\u0005!\t\u0003\u0005I\u0001\tE\t\u0015!\u0003D\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u0015q\u0005\u0001\"\u0011P\u0011\u0015\t\u0007\u0001\"\u0015c\u0011\u0015Q\u0007\u0001\"\u0011l\u0011\u0015I\b\u0001\"\u0011{\u0011\u0015q\b\u0001\"\u0011\u0000\u0011%\t\t\u0002AA\u0001\n\u0003\t\u0019\u0002C\u0005\u0002\u001a\u0001\t\n\u0011\"\u0001\u0002\u001c!I\u0011\u0011\u0007\u0001\u0012\u0002\u0013\u0005\u00111\u0004\u0005\n\u0003g\u0001\u0011\u0011!C!\u0003kA\u0011\"!\u0012\u0001\u0003\u0003%\t!a\u0012\t\u0013\u0005=\u0003!!A\u0005\u0002\u0005E\u0003\"CA,\u0001\u0005\u0005I\u0011IA-\u0011%\t9\u0007AA\u0001\n\u0003\tI\u0007C\u0005\u0002t\u0001\t\t\u0011\"\u0011\u0002v\u001dI\u00111\u0013\u000f\u0002\u0002#\u0005\u0011Q\u0013\u0004\t7q\t\t\u0011#\u0001\u0002\u0018\"1\u0011*\u0006C\u0001\u0003KC\u0011\"a*\u0016\u0003\u0003%)%!+\t\u0013\u0005-V#!A\u0005\u0002\u00065\u0006\"CAZ+\u0005\u0005I\u0011QA[\u0011%\t9-FA\u0001\n\u0013\tIMA\u0005GS:$\u0017J\\*fi*\u0011QDH\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002 A\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\"E\u0005\u00191/\u001d7\u000b\u0005\r\"\u0013!B:qCJ\\'BA\u0013'\u0003\u0019\t\u0007/Y2iK*\tq%A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001U9\n\u0004H\u0010\t\u0003W1j\u0011\u0001H\u0005\u0003[q\u0011\u0001CQ5oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005-z\u0013B\u0001\u0019\u001d\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001\u001a6\u001d\tY3'\u0003\u000259\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u001c8\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!\u0001\u000e\u000f\u0011\u0005ebT\"\u0001\u001e\u000b\u0003m\nQa]2bY\u0006L!!\u0010\u001e\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0011hP\u0005\u0003\u0001j\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fA\u0001\\3giV\t1\t\u0005\u0002,\t&\u0011Q\t\b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!\u00027fMR\u0004\u0013!\u0002:jO\"$\u0018A\u0002:jO\"$\b%\u0001\u0004=S:LGO\u0010\u000b\u0004\u00172k\u0005CA\u0016\u0001\u0011\u0015\tU\u00011\u0001D\u0011\u00159U\u00011\u0001D\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002!B\u0019\u0011\u000bW.\u000f\u0005I;fBA*W\u001b\u0005!&BA+)\u0003\u0019a$o\\8u}%\t1(\u0003\u00025u%\u0011\u0011L\u0017\u0002\u0004'\u0016\f(B\u0001\u001b;!\tav,D\u0001^\u0015\tq\u0006%A\u0003usB,7/\u0003\u0002a;\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0004G\u001aD\u0007CA\u001de\u0013\t)'HA\u0002B]fDQaZ\u0004A\u0002\r\fAa^8sI\")\u0011n\u0002a\u0001G\u0006\u00191/\u001a;\u0002\u0013\u0011|w)\u001a8D_\u0012,Gc\u00017soB\u0011Q\u000e]\u0007\u0002]*\u0011q\u000eH\u0001\bG>$WmZ3o\u0013\t\thN\u0001\u0005FqB\u00148i\u001c3f\u0011\u0015\u0019\b\u00021\u0001u\u0003\r\u0019G\u000f\u001f\t\u0003[VL!A\u001e8\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\")\u0001\u0010\u0003a\u0001Y\u0006\u0011QM^\u0001\tI\u0006$\u0018\rV=qKV\t1\u0010\u0005\u0002]y&\u0011Q0\u0018\u0002\t\t\u0006$\u0018\rV=qK\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0005\u0005\u0005\u0001\u0003BA\u0002\u0003\u0017qA!!\u0002\u0002\bA\u00111KO\u0005\u0004\u0003\u0013Q\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\u000e\u0005=!AB*ue&twMC\u0002\u0002\ni\nAaY8qsR)1*!\u0006\u0002\u0018!9\u0011i\u0003I\u0001\u0002\u0004\u0019\u0005bB$\f!\u0003\u0005\raQ\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tiBK\u0002D\u0003?Y#!!\t\u0011\t\u0005\r\u0012QF\u0007\u0003\u0003KQA!a\n\u0002*\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003WQ\u0014AC1o]>$\u0018\r^5p]&!\u0011qFA\u0013\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u0007\t\u0005\u0003s\t\u0019%\u0004\u0002\u0002<)!\u0011QHA \u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0005\u0013\u0001\u00026bm\u0006LA!!\u0004\u0002<\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\n\t\u0004s\u0005-\u0013bAA'u\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u00191-a\u0015\t\u0013\u0005U\u0003#!AA\u0002\u0005%\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\\A)\u0011QLA2G6\u0011\u0011q\f\u0006\u0004\u0003CR\u0014AC2pY2,7\r^5p]&!\u0011QMA0\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005-\u0014\u0011\u000f\t\u0004s\u00055\u0014bAA8u\t9!i\\8mK\u0006t\u0007\u0002CA+%\u0005\u0005\t\u0019A2\u0002\r\u0015\fX/\u00197t)\u0011\tY'a\u001e\t\u0011\u0005U3#!AA\u0002\rDs\u0002AA>\u0003\u0003\u000b\u0019)a\"\u0002\n\u00065\u0015q\u0012\t\u0004W\u0005u\u0014bAA@9\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAC\u0003\u0005\r'\u0002\t\u0011!A}3UKT\"`QM$(\u000f\f\u0011tiJ|\u0016M\u001d:bs&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004\u0013N\u001c3fq\u0002B\u0013'\f2bg\u0016$\u0017\u0006I8gAQDW\rI4jm\u0016t\u0007e\u001d;sS:<\u0007\u0005\u000b1tiJ\u0004\u0017\u0006I5oAQDW\rI2p[6\fW\u0006Z3mS6LG/\u001a3!Y&\u001cH\u000f\t\u0015agR\u0014x,\u0019:sCf\u0004\u0017F\f\u0006!A\u0001\u0002\u0003\u0005\t*fiV\u0014hn\u001d\u00111Y\u0001Jg\r\t;iK\u0002\u001aHO]5oO\u0002:\u0018m\u001d\u0011o_R\u0004cm\\;oI\u0002z'\u000fI5gAQDW\rI4jm\u0016t\u0007e\u001d;sS:<\u0007\u0005\u000b1tiJ\u0004\u0017\u0006I2p]R\f\u0017N\\:!C\u0002\u001aw.\\7b])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\tY)\u0001%\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\n'm\n\u0017(C\n\u001cGF\u0019\u0017bE2\u001aG\u0006Z3gO%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\r\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011\u0011S\u0001\u0006c9*d\u0006M\u0001\n\r&tG-\u00138TKR\u0004\"aK\u000b\u0014\tU\tIJ\u0010\t\b\u00037\u000b\tkQ\"L\u001b\t\tiJC\u0002\u0002 j\nqA];oi&lW-\u0003\u0003\u0002$\u0006u%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011\u0011QS\u0001\ti>\u001cFO]5oOR\u0011\u0011qG\u0001\u0006CB\u0004H.\u001f\u000b\u0006\u0017\u0006=\u0016\u0011\u0017\u0005\u0006\u0003b\u0001\ra\u0011\u0005\u0006\u000fb\u0001\raQ\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t9,a1\u0011\u000be\nI,!0\n\u0007\u0005m&H\u0001\u0004PaRLwN\u001c\t\u0006s\u0005}6iQ\u0005\u0004\u0003\u0003T$A\u0002+va2,'\u0007\u0003\u0005\u0002Ff\t\t\u00111\u0001L\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002LB!\u0011\u0011HAg\u0013\u0011\ty-a\u000f\u0003\r=\u0013'.Z2u\u0001")
public class FindInSet
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(FindInSet findInSet) {
        return FindInSet$.MODULE$.unapply(findInSet);
    }

    public static Function1<Tuple2<Expression, Expression>, FindInSet> tupled() {
        return FindInSet$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, FindInSet>> curried() {
        return FindInSet$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object word, Object set) {
        return BoxesRunTime.boxToInteger((int)((UTF8String)set).findInSet((UTF8String)word));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(word, set) -> new StringBuilder(16).append(ev.value()).append(" = ").append((String)set).append(".findInSet(").append((String)word).append(");").toString());
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "find_in_set";
    }

    public FindInSet copy(Expression left, Expression right) {
        return new FindInSet(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "FindInSet";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FindInSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FindInSet)) return false;
        boolean bl = true;
        if (!bl) return false;
        FindInSet findInSet = (FindInSet)x$1;
        Expression expression = this.left();
        Expression expression2 = findInSet.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = findInSet.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!findInSet.canEqual(this)) return false;
        return true;
    }

    public FindInSet(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

