/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ArrayRepeat$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(element, count) - Returns the array containing element count times.", examples="\n    Examples:\n      > SELECT _FUNC_('123', 2);\n       [\"123\",\"123\"]\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\tMa\u0001B\u0010!\u00016B\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005\u0001\"AA\t\u0001BK\u0002\u0013\u0005q\b\u0003\u0005F\u0001\tE\t\u0015!\u0003A\u0011\u00151\u0005\u0001\"\u0001H\u0011\u0015Y\u0005\u0001\"\u0011M\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0011\u0015!\u0007\u0001\"\u0011f\u0011\u0015I\u0007\u0001\"\u0011k\u0011\u0015!\b\u0001\"\u0011v\u0011\u0015q\b\u0001\"\u0011\u0000\u0011\u001d\tY\u0002\u0001C\u0005\u0003;Aq!!\u000b\u0001\t\u0013\tY\u0003C\u0004\u0002:\u0001!I!a\u000f\t\u0013\u0005]\u0003!!A\u0005\u0002\u0005e\u0003\"CA0\u0001E\u0005I\u0011AA1\u0011%\t9\bAI\u0001\n\u0003\t\t\u0007C\u0005\u0002z\u0001\t\t\u0011\"\u0011\u0002|!I\u00111\u0012\u0001\u0002\u0002\u0013\u0005\u0011Q\u0012\u0005\n\u0003+\u0003\u0011\u0011!C\u0001\u0003/C\u0011\"!(\u0001\u0003\u0003%\t%a(\t\u0013\u00055\u0006!!A\u0005\u0002\u0005=\u0006\"CAZ\u0001\u0005\u0005I\u0011IA[\u000f%\tI\u000eIA\u0001\u0012\u0003\tYN\u0002\u0005 A\u0005\u0005\t\u0012AAo\u0011\u00191\u0015\u0004\"\u0001\u0002l\"I\u0011Q^\r\u0002\u0002\u0013\u0015\u0013q\u001e\u0005\n\u0003cL\u0012\u0011!CA\u0003gD\u0011\"!?\u001a\u0003\u0003%\t)a?\t\u0013\t%\u0011$!A\u0005\n\t-!aC!se\u0006L(+\u001a9fCRT!!\t\u0012\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003G\u0011\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003K\u0019\n1a]9m\u0015\t9\u0003&A\u0003ta\u0006\u00148N\u0003\u0002*U\u00051\u0011\r]1dQ\u0016T\u0011aK\u0001\u0004_J<7\u0001A\n\u0006\u00019\u0012Tg\u000f\t\u0003_Aj\u0011\u0001I\u0005\u0003c\u0001\u0012\u0001CQ5oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005=\u001a\u0014B\u0001\u001b!\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u0003mej\u0011a\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!h\u000e\u0002\b!J|G-^2u!\t1D(\u0003\u0002>o\ta1+\u001a:jC2L'0\u00192mK\u0006!A.\u001a4u+\u0005\u0001\u0005CA\u0018B\u0013\t\u0011\u0005E\u0001\u0006FqB\u0014Xm]:j_:\fQ\u0001\\3gi\u0002\nQA]5hQR\faA]5hQR\u0004\u0013A\u0002\u001fj]&$h\bF\u0002I\u0013*\u0003\"a\f\u0001\t\u000by*\u0001\u0019\u0001!\t\u000b\u0011+\u0001\u0019\u0001!\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012!\u0014\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!\u0012\nQ\u0001^=qKNL!AU(\u0003\u0013\u0005\u0013(/Y=UsB,\u0017AC5oaV$H+\u001f9fgV\tQ\u000bE\u0002W=\u0006t!a\u0016/\u000f\u0005a[V\"A-\u000b\u0005ic\u0013A\u0002\u001fs_>$h(C\u00019\u0013\tiv'A\u0004qC\u000e\\\u0017mZ3\n\u0005}\u0003'aA*fc*\u0011Ql\u000e\t\u0003\u001d\nL!aY(\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00038vY2\f'\r\\3\u0016\u0003\u0019\u0004\"AN4\n\u0005!<$a\u0002\"p_2,\u0017M\\\u0001\u0005KZ\fG\u000e\u0006\u0002l]B\u0011a\u0007\\\u0005\u0003[^\u00121!\u00118z\u0011\u001dy\u0017\u0002%AA\u0002A\fQ!\u001b8qkR\u0004\"!\u001d:\u000e\u0003\tJ!a\u001d\u0012\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\u000baJ,G\u000f^=OC6,W#\u0001<\u0011\u0005]\\hB\u0001=z!\tAv'\u0003\u0002{o\u00051\u0001K]3eK\u001aL!\u0001`?\u0003\rM#(/\u001b8h\u0015\tQx'A\u0005e_\u001e+gnQ8eKR1\u0011\u0011AA\u0007\u0003/\u0001B!a\u0001\u0002\n5\u0011\u0011Q\u0001\u0006\u0004\u0003\u000f\u0001\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003\u0017\t)A\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\tya\u0003a\u0001\u0003#\t1a\u0019;y!\u0011\t\u0019!a\u0005\n\t\u0005U\u0011Q\u0001\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\tIb\u0003a\u0001\u0003\u0003\t!!\u001a<\u0002-9,H\u000e\\#mK6,g\u000e^:Qe>$Xm\u0019;j_:$rA^A\u0010\u0003C\t)\u0003C\u0004\u0002\u001a1\u0001\r!!\u0001\t\r\u0005\rB\u00021\u0001w\u0003-\u0011\u0018n\u001a5u\u0013NtU\u000f\u001c7\t\r\u0005\u001dB\u00021\u0001w\u0003%\u0019wN]3M_\u001eL7-\u0001\u000ehK:\u001cu\u000eZ3G_JtU/\u001c2fe>3W\t\\3nK:$8\u000f\u0006\u0004\u0002.\u0005M\u0012Q\u0007\t\u0006m\u0005=bO^\u0005\u0004\u0003c9$A\u0002+va2,'\u0007C\u0004\u0002\u00105\u0001\r!!\u0005\t\r\u0005]R\u00021\u0001w\u0003\u0015\u0019w.\u001e8u\u0003E9WM\\\"pI\u00164uN]#mK6,g\u000e\u001e\u000b\u000em\u0006u\u0012qHA%\u0003\u001b\ny%a\u0015\t\u000f\u0005=a\u00021\u0001\u0002\u0012!9\u0011\u0011\t\bA\u0002\u0005\r\u0013aC3mK6,g\u000e\u001e+za\u0016\u00042ATA#\u0013\r\t9e\u0014\u0002\t\t\u0006$\u0018\rV=qK\"1\u00111\n\bA\u0002Y\fq!\u001a7f[\u0016tG\u000f\u0003\u0004\u000289\u0001\rA\u001e\u0005\u0007\u0003#r\u0001\u0019\u0001<\u0002\u00151,g\r^%t\u001dVdG\u000e\u0003\u0004\u0002V9\u0001\rA^\u0001\u000eCJ\u0014\u0018-\u001f#bi\u0006t\u0015-\\3\u0002\t\r|\u0007/\u001f\u000b\u0006\u0011\u0006m\u0013Q\f\u0005\b}=\u0001\n\u00111\u0001A\u0011\u001d!u\u0002%AA\u0002\u0001\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002d)\u001a\u0001)!\u001a,\u0005\u0005\u001d\u0004\u0003BA5\u0003gj!!a\u001b\u000b\t\u00055\u0014qN\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u001d8\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003k\nYGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003{\u0002B!a \u0002\n6\u0011\u0011\u0011\u0011\u0006\u0005\u0003\u0007\u000b))\u0001\u0003mC:<'BAAD\u0003\u0011Q\u0017M^1\n\u0007q\f\t)\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\u0010B\u0019a'!%\n\u0007\u0005MuGA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002l\u00033C\u0011\"a'\u0015\u0003\u0003\u0005\r!a$\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\t\u000bE\u0003\u0002$\u0006%6.\u0004\u0002\u0002&*\u0019\u0011qU\u001c\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002,\u0006\u0015&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2AZAY\u0011!\tYJFA\u0001\u0002\u0004Y\u0017AB3rk\u0006d7\u000fF\u0002g\u0003oC\u0001\"a'\u0018\u0003\u0003\u0005\ra\u001b\u0015\u0014\u0001\u0005m\u0016\u0011YAb\u0003\u000f\fI-!4\u0002P\u0006M\u0017Q\u001b\t\u0004_\u0005u\u0016bAA`A\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAc\u0003){f)\u0016(D?\"*G.Z7f]Rd\u0003eY8v]RL\u0003%\f\u0011SKR,(O\\:!i\",\u0007%\u0019:sCf\u00043m\u001c8uC&t\u0017N\\4!K2,W.\u001a8uA\r|WO\u001c;!i&lWm\u001d\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a3\u0002\u000f*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%\r\u001a4O1\u0002#'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7\n\n$g\r\u0012-EE\u00124GI/\u000bA\u0001\nQa\u001a:pkB\f#!!5\u0002\u0017\u0005\u0014(/Y=`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0003/\fQA\r\u00185]A\n1\"\u0011:sCf\u0014V\r]3biB\u0011q&G\n\u00053\u0005}7\bE\u0004\u0002b\u0006\u001d\b\t\u0011%\u000e\u0005\u0005\r(bAAso\u00059!/\u001e8uS6,\u0017\u0002BAu\u0003G\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\tY.\u0001\u0005u_N#(/\u001b8h)\t\ti(A\u0003baBd\u0017\u0010F\u0003I\u0003k\f9\u0010C\u0003?9\u0001\u0007\u0001\tC\u0003E9\u0001\u0007\u0001)A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005u(Q\u0001\t\u0006m\u0005}(1A\u0005\u0004\u0005\u00039$AB(qi&|g\u000eE\u00037\u0003_\u0001\u0005\t\u0003\u0005\u0003\bu\t\t\u00111\u0001I\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003\u000eA!\u0011q\u0010B\b\u0013\u0011\u0011\t\"!!\u0003\r=\u0013'.Z2u\u0001")
public class ArrayRepeat
extends BinaryExpression
implements ExpectsInputTypes,
scala.Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayRepeat arrayRepeat) {
        return ArrayRepeat$.MODULE$.unapply(arrayRepeat);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayRepeat> tupled() {
        return ArrayRepeat$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayRepeat>> curried() {
        return ArrayRepeat$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public ArrayType dataType() {
        return new ArrayType(this.left().dataType(), this.left().nullable());
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{AnyDataType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public boolean nullable() {
        return this.right().nullable();
    }

    @Override
    public Object eval(InternalRow input) {
        GenericArrayData genericArrayData;
        Object count = this.right().eval(input);
        if (count == null) {
            genericArrayData = null;
        } else {
            if (BoxesRunTime.unboxToInt((Object)count) > ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH) {
                throw new RuntimeException(new StringBuilder(87).append("Unsuccessful try to create array with ").append(count).append(" elements ").append("due to exceeding the array size limit ").append(ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH).append(".").toString());
            }
            Object element = this.left().eval(input);
            genericArrayData = new GenericArrayData((Object[])Array$.MODULE$.fill(BoxesRunTime.unboxToInt((Object)count), (Function0 & Serializable & scala.Serializable)() -> element, ClassTag$.MODULE$.Any()));
        }
        return genericArrayData;
    }

    @Override
    public String prettyName() {
        return "array_repeat";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode leftGen = this.left().genCode(ctx);
        ExprCode rightGen = this.right().genCode(ctx);
        ExprValue element = leftGen.value();
        ExprValue count = rightGen.value();
        DataType et = this.dataType().elementType();
        String coreLogic = this.genCodeForElement(ctx, et, ExprValue$.MODULE$.exprValueToString(element), ExprValue$.MODULE$.exprValueToString(count), ExprValue$.MODULE$.exprValueToString(leftGen.isNull()), ExprValue$.MODULE$.exprValueToString(ev.value()));
        String resultCode = this.nullElementsProtection(ev, ExprValue$.MODULE$.exprValueToString(rightGen.isNull()), coreLogic);
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |boolean ", " = false;\n         |", "\n         |", "\n         |", " ", " =\n         |  ", ";\n         |", "\n       "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), leftGen.code(), rightGen.code(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), resultCode})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    private String nullElementsProtection(ExprCode ev, String rightIsNull, String coreLogic) {
        return this.nullable() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(91).append("\n         |if (").append(rightIsNull).append(") {\n         |  ").append(ev.isNull()).append(" = true;\n         |} else {\n         |  ").append(coreLogic).append("\n         |}\n       ").toString())).stripMargin() : coreLogic;
    }

    private Tuple2<String, String> genCodeForNumberOfElements(CodegenContext ctx, String count) {
        String numElements = ctx.freshName("numElements");
        String numElementsCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(79).append("\n         |int ").append(numElements).append(" = 0;\n         |if (").append(count).append(" > 0) {\n         |  ").append(numElements).append(" = ").append(count).append(";\n         |}\n       ").toString())).stripMargin();
        return new Tuple2((Object)numElements, (Object)numElementsCode);
    }

    private String genCodeForElement(CodegenContext ctx, DataType elementType, String element, String count, String leftIsNull, String arrayDataName) {
        String tempArrayDataName = ctx.freshName("tempArrayData");
        String k = ctx.freshName("k");
        Tuple2<String, String> tuple2 = this.genCodeForNumberOfElements(ctx, count);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String numElemName = (String)tuple2._1();
        String numElemCode = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)numElemName, (Object)numElemCode);
        Tuple2 tuple23 = tuple22;
        String numElemName2 = (String)tuple23._1();
        String numElemCode2 = (String)tuple23._2();
        String allocation = CodeGenerator$.MODULE$.createArrayData(tempArrayDataName, elementType, numElemName2, new StringBuilder(9).append(" ").append(this.prettyName()).append(" failed.").toString());
        String assignment = CodeGenerator$.MODULE$.setArrayElement(tempArrayDataName, elementType, k, element, CodeGenerator$.MODULE$.setArrayElement$default$5());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(244).append("\n       |").append(numElemCode2).append("\n       |").append(allocation).append("\n       |if (!").append(leftIsNull).append(") {\n       |  for (int ").append(k).append(" = 0; ").append(k).append(" < ").append(tempArrayDataName).append(".numElements(); ").append(k).append("++) {\n       |    ").append(assignment).append("\n       |  }\n       |} else {\n       |  for (int ").append(k).append(" = 0; ").append(k).append(" < ").append(tempArrayDataName).append(".numElements(); ").append(k).append("++) {\n       |    ").append(tempArrayDataName).append(".setNullAt(").append(k).append(");\n       |  }\n       |}\n       |").append(arrayDataName).append(" = ").append(tempArrayDataName).append(";\n     ").toString())).stripMargin();
    }

    public ArrayRepeat copy(Expression left, Expression right) {
        return new ArrayRepeat(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayRepeat";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayRepeat;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayRepeat)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayRepeat arrayRepeat = (ArrayRepeat)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayRepeat.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayRepeat.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayRepeat.canEqual(this)) return false;
        return true;
    }

    public ArrayRepeat(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

