/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import com.github.fommil.netlib.BLAS;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.feature.Word2VecModel$;
import org.apache.spark.mllib.feature.Word2VecModel$SaveLoadV1_0$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.util.BoundedPriorityQueue;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t%f\u0001B\u001f?\u0001%C\u0011\"\u0017\u0001\u0003\u0006\u0004%\tA\u0011.\t\u00111\u0004!\u0011!Q\u0001\nmC\u0011\"\u001c\u0001\u0003\u0006\u0004%\tA\u00118\t\u0011U\u0004!\u0011!Q\u0001\n=DaA\u001e\u0001\u0005\u0002\t;\bb\u0002?\u0001\u0005\u0004%I! \u0005\u0007}\u0002\u0001\u000b\u0011B5\t\u000f}\u0004!\u0019!C\u0005{\"9\u0011\u0011\u0001\u0001!\u0002\u0013I\u0007\"CA\u0002\u0001\t\u0007I\u0011BA\u0003\u0011!\tI\u0001\u0001Q\u0001\n\u0005\u001d\u0001\u0002CA\u0006\u0001\t\u0007I\u0011\u00028\t\u000f\u00055\u0001\u0001)A\u0005_\"1a\u000f\u0001C\u0001\u0003\u001fAq!!\u000b\u0001\t\u0003\tY\u0003C\u0004\u0002J\u0001!\t!a\u0013\t\u000f\u0005\r\u0004\u0001\"\u0001\u0002f!9\u00111\r\u0001\u0005\u0002\u0005u\u0004bBA2\u0001\u0011%\u0011q\u0011\u0005\b\u0003/\u0003A\u0011AAM\u000f\u001d\t\u0019K\u0010E\u0001\u0003K3a!\u0010 \t\u0002\u0005\u001d\u0006B\u0002<\u0017\t\u0003\ty\u000bC\u0004\u00022Z!I!a-\t\u000f\u0005]f\u0003\"\u0003\u0002:\u001e9\u0011Q\u0018\f\t\n\u0005}faBAb-!%\u0011Q\u0019\u0005\u0007mn!\t!a2\t\u0013\u0005%7D1A\u0005\u0002\u0005-\u0007\u0002CAn7\u0001\u0006I!!4\t\u0013\u0005u7D1A\u0005\u0002\u0005-\u0007\u0002CAp7\u0001\u0006I!!4\u0007\r\u0005\u00058\u0004QAr\u0011)\tY&\tBK\u0002\u0013\u0005\u00111\u001e\u0005\n\u0003[\f#\u0011#Q\u0001\n\u0019D\u0011\"!!\"\u0005+\u0007I\u0011\u00018\t\u0013\u0005=\u0018E!E!\u0002\u0013y\u0007B\u0002<\"\t\u0003\t\t\u0010C\u0005\u0002|\u0006\n\t\u0011\"\u0001\u0002~\"I!1A\u0011\u0012\u0002\u0013\u0005!Q\u0001\u0005\n\u00053\t\u0013\u0013!C\u0001\u00057A\u0011Ba\b\"\u0003\u0003%\t%a3\t\u0011\t\u0005\u0012%!A\u0005\u0002uD\u0011Ba\t\"\u0003\u0003%\tA!\n\t\u0013\tE\u0012%!A\u0005B\tM\u0002\"\u0003B!C\u0005\u0005I\u0011\u0001B\"\u0011%\u0011i%IA\u0001\n\u0003\u0012y\u0005C\u0005\u0003R\u0005\n\t\u0011\"\u0011\u0003T!I!QK\u0011\u0002\u0002\u0013\u0005#qK\u0004\n\u00057Z\u0012\u0011!E\u0001\u0005;2\u0011\"!9\u001c\u0003\u0003E\tAa\u0018\t\rY\u001cD\u0011\u0001B7\u0011%\u0011\tfMA\u0001\n\u000b\u0012\u0019\u0006C\u0005\u0003pM\n\t\u0011\"!\u0003r!I!qO\u001a\u0002\u0002\u0013\u0005%\u0011\u0010\u0005\n\u0005\u0007\u001b\u0014\u0011!C\u0005\u0005\u000bCqA!$\u001c\t\u0003\u0011y\tC\u0004\u0002*m!\tA!&\t\u000f\t5e\u0003\"\u0011\u0003\u001e\"I!1\u0011\f\u0002\u0002\u0013%!Q\u0011\u0002\u000e/>\u0014HM\r,fG6{G-\u001a7\u000b\u0005}\u0002\u0015a\u00024fCR,(/\u001a\u0006\u0003\u0003\n\u000bQ!\u001c7mS\nT!a\u0011#\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u00153\u0015AB1qC\u000eDWMC\u0001H\u0003\ry'oZ\u0002\u0001'\u0011\u0001!\nU*\u0011\u0005-sU\"\u0001'\u000b\u00035\u000bQa]2bY\u0006L!a\u0014'\u0003\r\u0005s\u0017PU3g!\tY\u0015+\u0003\u0002S\u0019\na1+\u001a:jC2L'0\u00192mKB\u0011AkV\u0007\u0002+*\u0011a\u000bQ\u0001\u0005kRLG.\u0003\u0002Y+\nA1+\u0019<fC\ndW-A\u0005x_J$\u0017J\u001c3fqV\t1\f\u0005\u0003]G\u001aLgBA/b!\tqF*D\u0001`\u0015\t\u0001\u0007*\u0001\u0004=e>|GOP\u0005\u0003E2\u000ba\u0001\u0015:fI\u00164\u0017B\u00013f\u0005\ri\u0015\r\u001d\u0006\u0003E2\u0003\"\u0001X4\n\u0005!,'AB*ue&tw\r\u0005\u0002LU&\u00111\u000e\u0014\u0002\u0004\u0013:$\u0018AC<pe\u0012Le\u000eZ3yA\u0005Yqo\u001c:e-\u0016\u001cGo\u001c:t+\u0005y\u0007cA&qe&\u0011\u0011\u000f\u0014\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u0017NL!\u0001\u001e'\u0003\u000b\u0019cw.\u0019;\u0002\u0019]|'\u000f\u001a,fGR|'o\u001d\u0011\u0002\rqJg.\u001b;?)\rA(p\u001f\t\u0003s\u0002i\u0011A\u0010\u0005\u00063\u0016\u0001\ra\u0017\u0005\u0006[\u0016\u0001\ra\\\u0001\t]Vlwk\u001c:egV\t\u0011.A\u0005ok6<vN\u001d3tA\u0005Qa/Z2u_J\u001c\u0016N_3\u0002\u0017Y,7\r^8s'&TX\rI\u0001\to>\u0014H\rT5tiV\u0011\u0011q\u0001\t\u0004\u0017B4\u0017!C<pe\u0012d\u0015n\u001d;!\u000319xN\u001d3WK\u000etuN]7t\u000359xN\u001d3WK\u000etuN]7tAQ\u0019\u00010!\u0005\t\u000f\u0005Ma\u00021\u0001\u0002\u0016\u0005)Qn\u001c3fYB!Al\u00194pQ\u0015q\u0011\u0011DA\u0013!\u0011\tY\"!\t\u000e\u0005\u0005u!bAA\u0010\u0005\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0012Q\u0004\u0002\u0006'&t7-Z\u0011\u0003\u0003O\tQ!\r\u00186]A\nAa]1wKR1\u0011QFA\u001a\u0003\u007f\u00012aSA\u0018\u0013\r\t\t\u0004\u0014\u0002\u0005+:LG\u000fC\u0004\u00026=\u0001\r!a\u000e\u0002\u0005M\u001c\u0007\u0003BA\u001d\u0003wi\u0011AQ\u0005\u0004\u0003{\u0011%\u0001D*qCJ\\7i\u001c8uKb$\bBBA!\u001f\u0001\u0007a-\u0001\u0003qCRD\u0007&B\b\u0002\u001a\u0005\u0015\u0013EAA$\u0003\u0015\td\u0006\u000e\u00181\u0003%!(/\u00198tM>\u0014X\u000e\u0006\u0003\u0002N\u0005e\u0003\u0003BA(\u0003+j!!!\u0015\u000b\u0007\u0005M\u0003)\u0001\u0004mS:\fGnZ\u0005\u0005\u0003/\n\tF\u0001\u0004WK\u000e$xN\u001d\u0005\u0007\u00037\u0002\u0002\u0019\u00014\u0002\t]|'\u000f\u001a\u0015\u0006!\u0005e\u0011qL\u0011\u0003\u0003C\nQ!\r\u00182]A\nABZ5oINKhn\u001c8z[N$b!a\u001a\u0002v\u0005]\u0004\u0003B&q\u0003S\u0002baSA6M\u0006=\u0014bAA7\u0019\n1A+\u001e9mKJ\u00022aSA9\u0013\r\t\u0019\b\u0014\u0002\u0007\t>,(\r\\3\t\r\u0005m\u0013\u00031\u0001g\u0011\u0019\tI(\u0005a\u0001S\u0006\u0019a.^7)\u000bE\tI\"a\u0018\u0015\r\u0005\u001d\u0014qPAB\u0011\u001d\t\tI\u0005a\u0001\u0003\u001b\naA^3di>\u0014\bBBA=%\u0001\u0007\u0011\u000eK\u0003\u0013\u00033\ty\u0006\u0006\u0005\u0002h\u0005%\u00151RAG\u0011\u001d\t\ti\u0005a\u0001\u0003\u001bBa!!\u001f\u0014\u0001\u0004I\u0007bBAH'\u0001\u0007\u0011\u0011S\u0001\bo>\u0014Hm\u00149u!\u0011Y\u00151\u00134\n\u0007\u0005UEJ\u0001\u0004PaRLwN\\\u0001\u000bO\u0016$h+Z2u_J\u001cXCAA\u000bQ\u0015!\u0012\u0011DAOC\t\ty*A\u00032]Ir\u0003\u0007K\u0003\u0001\u00033\ty&A\u0007X_J$'GV3d\u001b>$W\r\u001c\t\u0003sZ\u0019RA\u0006&\u0002*B\u0003B\u0001VAVq&\u0019\u0011QV+\u0003\r1{\u0017\rZ3s)\t\t)+\u0001\bck&dGmV8sI&sG-\u001a=\u0015\u0007m\u000b)\fC\u0004\u0002\u0014a\u0001\r!!\u0006\u0002!\t,\u0018\u000e\u001c3X_J$g+Z2u_J\u001cHcA8\u0002<\"9\u00111C\rA\u0002\u0005U\u0011\u0001D*bm\u0016du.\u00193Wc}\u0003\u0004cAAa75\taC\u0001\u0007TCZ,Gj\\1e-Fz\u0006g\u0005\u0002\u001c\u0015R\u0011\u0011qX\u0001\u0012M>\u0014X.\u0019;WKJ\u001c\u0018n\u001c8Wc}\u0003TCAAg!\u0011\ty-!7\u000e\u0005\u0005E'\u0002BAj\u0003+\fA\u0001\\1oO*\u0011\u0011q[\u0001\u0005U\u00064\u0018-C\u0002i\u0003#\f!CZ8s[\u0006$h+\u001a:tS>tg+M01A\u0005i1\r\\1tg:\u000bW.\u001a,2?B\nab\u00197bgNt\u0015-\\3Wc}\u0003\u0004E\u0001\u0003ECR\f7#B\u0011K\u0003K\u0004\u0006cA&\u0002h&\u0019\u0011\u0011\u001e'\u0003\u000fA\u0013x\u000eZ;diV\ta-A\u0003x_J$\u0007%A\u0004wK\u000e$xN\u001d\u0011\u0015\r\u0005M\u0018q_A}!\r\t)0I\u0007\u00027!1\u00111\f\u0014A\u0002\u0019Da!!!'\u0001\u0004y\u0017\u0001B2paf$b!a=\u0002\u0000\n\u0005\u0001\u0002CA.OA\u0005\t\u0019\u00014\t\u0011\u0005\u0005u\u0005%AA\u0002=\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\b)\u001aaM!\u0003,\u0005\t-\u0001\u0003\u0002B\u0007\u0005+i!Aa\u0004\u000b\t\tE!1C\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\bM\u0013\u0011\u00119Ba\u0004\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\tu!fA8\u0003\n\u0005i\u0001O]8ek\u000e$\bK]3gSb\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003(\t5\u0002cA&\u0003*%\u0019!1\u0006'\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u000301\n\t\u00111\u0001j\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!Q\u0007\t\u0007\u0005o\u0011iDa\n\u000e\u0005\te\"b\u0001B\u001e\u0019\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t}\"\u0011\b\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003F\t-\u0003cA&\u0003H%\u0019!\u0011\n'\u0003\u000f\t{w\u000e\\3b]\"I!q\u0006\u0018\u0002\u0002\u0003\u0007!qE\u0001\tQ\u0006\u001c\bnQ8eKR\t\u0011.\u0001\u0005u_N#(/\u001b8h)\t\ti-\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005\u000b\u0012I\u0006C\u0005\u00030E\n\t\u00111\u0001\u0003(\u0005!A)\u0019;b!\r\t)pM\n\u0005g\t\u0005\u0004\u000b\u0005\u0005\u0003d\t%dm\\Az\u001b\t\u0011)GC\u0002\u0003h1\u000bqA];oi&lW-\u0003\u0003\u0003l\t\u0015$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011!QL\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0003g\u0014\u0019H!\u001e\t\r\u0005mc\u00071\u0001g\u0011\u0019\t\tI\u000ea\u0001_\u00069QO\\1qa2LH\u0003\u0002B>\u0005\u007f\u0002RaSAJ\u0005{\u0002RaSA6M>D\u0011B!!8\u0003\u0003\u0005\r!a=\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001BD!\u0011\tyM!#\n\t\t-\u0015\u0011\u001b\u0002\u0007\u001f\nTWm\u0019;\u0002\t1|\u0017\r\u001a\u000b\u0006q\nE%1\u0013\u0005\b\u0003kI\u0004\u0019AA\u001c\u0011\u0019\t\t%\u000fa\u0001MRA\u0011Q\u0006BL\u00053\u0013Y\nC\u0004\u00026i\u0002\r!a\u000e\t\r\u0005\u0005#\b1\u0001g\u0011\u001d\t\u0019B\u000fa\u0001\u0003+!R\u0001\u001fBP\u0005CCq!!\u000e<\u0001\u0004\t9\u0004\u0003\u0004\u0002Bm\u0002\rA\u001a\u0015\u0006w\u0005e\u0011Q\t\u0015\u0006-\u0005e\u0011Q\t\u0015\u0006+\u0005e\u0011Q\t")
public class Word2VecModel
implements scala.Serializable,
Saveable {
    private final Map<String, Object> wordIndex;
    private final float[] wordVectors;
    private final int numWords;
    private final int vectorSize;
    private final String[] wordList;
    private final float[] wordVecNorms;

    public static Word2VecModel load(SparkContext sparkContext, String string) {
        return Word2VecModel$.MODULE$.load(sparkContext, string);
    }

    public Map<String, Object> wordIndex() {
        return this.wordIndex;
    }

    public float[] wordVectors() {
        return this.wordVectors;
    }

    private int numWords() {
        return this.numWords;
    }

    private int vectorSize() {
        return this.vectorSize;
    }

    private String[] wordList() {
        return this.wordList;
    }

    private float[] wordVecNorms() {
        return this.wordVecNorms;
    }

    @Override
    public void save(SparkContext sc, String path) {
        Word2VecModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.getVectors());
    }

    public Vector transform(String word) {
        Option option = this.wordIndex().get((Object)word);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException(new StringBuilder(18).append(word).append(" not in vocabulary").toString());
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        int ind = BoxesRunTime.unboxToInt((Object)some.value());
        float[] vec = (float[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(this.wordVectors())).slice(ind * this.vectorSize(), ind * this.vectorSize() + this.vectorSize());
        Vector vector = Vectors$.MODULE$.dense((double[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(vec)).map((Function1)(JFunction1.mcDF.sp & Serializable & scala.Serializable)x$9 -> x$9, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
        return vector;
    }

    public Tuple2<String, Object>[] findSynonyms(String word, int num) {
        Vector vector = this.transform(word);
        return this.findSynonyms(vector, num, (Option<String>)new Some((Object)word));
    }

    public Tuple2<String, Object>[] findSynonyms(Vector vector, int num) {
        return this.findSynonyms(vector, num, (Option<String>)None$.MODULE$);
    }

    private Tuple2<String, Object>[] findSynonyms(Vector vector, int num, Option<String> wordOpt) {
        Seq seq;
        Predef$.MODULE$.require(num > 0, (Function0 & Serializable & scala.Serializable)() -> "Number of similar words should > 0");
        float[] fVector = (float[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(vector.toArray())).map((Function1)(JFunction1.mcFD.sp & Serializable & scala.Serializable)x$10 -> (float)x$10, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
        float[] cosineVec = new float[this.numWords()];
        float alpha = 1.0f;
        float beta = 0.0f;
        float vecNorm = BLAS.getInstance().snrm2(this.vectorSize(), fVector, 1);
        if (vecNorm != 0.0f) {
            BLAS.getInstance().sscal(this.vectorSize(), 1.0f / vecNorm, fVector, 0, 1);
        }
        BLAS.getInstance().sgemv("T", this.vectorSize(), this.numWords(), alpha, this.wordVectors(), this.vectorSize(), fVector, 1, beta, cosineVec, 1);
        for (int i = 0; i < this.numWords(); ++i) {
            float norm = this.wordVecNorms()[i];
            if (norm == 0.0f) {
                cosineVec[i] = 0.0f;
                continue;
            }
            int n = i;
            cosineVec[n] = cosineVec[n] / norm;
        }
        BoundedPriorityQueue pq = new BoundedPriorityQueue(num + 1, package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToFloat((float)Word2VecModel.$anonfun$findSynonyms$3(x$11)), (Ordering)Ordering.Float$.MODULE$));
        for (int j = 0; j < this.numWords(); ++j) {
            pq.$plus$eq((Object)new Tuple2((Object)this.wordList()[j], (Object)BoxesRunTime.boxToFloat((float)cosineVec[j])));
        }
        Seq scored = (Seq)pq.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToFloat((float)Word2VecModel.$anonfun$findSynonyms$4(x$12)), (Ordering)Ordering.Float$.MODULE$);
        Option<String> option = wordOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            String w = (String)some.value();
            seq = (Seq)scored.filter((Function1 & Serializable & scala.Serializable)tup -> BoxesRunTime.boxToBoolean((boolean)Word2VecModel.$anonfun$findSynonyms$5(w, tup)));
        } else if (None$.MODULE$.equals(option)) {
            seq = scored;
        } else {
            throw new MatchError(option);
        }
        Seq filtered = seq;
        return (Tuple2[])((TraversableOnce)((TraversableLike)filtered.take(num)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String word = (String)tuple2._1();
            float score = BoxesRunTime.unboxToFloat((Object)tuple2._2());
            Tuple2 tuple22 = new Tuple2((Object)word, (Object)BoxesRunTime.boxToDouble((double)score));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public Map<String, float[]> getVectors() {
        return (Map)this.wordIndex().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String word = (String)tuple2._1();
            int ind = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)word, new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(this.wordVectors())).slice(this.vectorSize() * ind, this.vectorSize() * ind + this.vectorSize()));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ float $anonfun$findSynonyms$3(Tuple2 x$11) {
        return BoxesRunTime.unboxToFloat((Object)x$11._2());
    }

    public static final /* synthetic */ float $anonfun$findSynonyms$4(Tuple2 x$12) {
        return -BoxesRunTime.unboxToFloat((Object)x$12._2());
    }

    public static final /* synthetic */ boolean $anonfun$findSynonyms$5(String w$1, Tuple2 tup) {
        String string = w$1;
        Object object = tup._1();
        return string == null ? object != null : !string.equals(object);
    }

    public Word2VecModel(Map<String, Object> wordIndex, float[] wordVectors) {
        Seq wl;
        this.wordIndex = wordIndex;
        this.wordVectors = wordVectors;
        this.numWords = wordIndex.size();
        this.vectorSize = wordVectors.length / this.numWords();
        Tuple2 tuple2 = ((GenericTraversableTemplate)wordIndex.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8._2$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq seq = wl = (Seq)tuple2._1();
        Seq wl2 = seq;
        this.wordList = (String[])wl2.toArray(ClassTag$.MODULE$.apply(String.class));
        float[] wordVecNorms = new float[this.numWords()];
        for (int i = 0; i < this.numWords(); ++i) {
            float[] vec = (float[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(wordVectors)).slice(i * this.vectorSize(), i * this.vectorSize() + this.vectorSize());
            wordVecNorms[i] = BLAS.getInstance().snrm2(this.vectorSize(), vec, 1);
        }
        this.wordVecNorms = wordVecNorms;
    }

    public Word2VecModel(Map<String, float[]> model) {
        this(Word2VecModel$.MODULE$.org$apache$spark$mllib$feature$Word2VecModel$$buildWordIndex(model), Word2VecModel$.MODULE$.org$apache$spark$mllib$feature$Word2VecModel$$buildWordVectors(model));
    }
}

