/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.linalg;

import java.io.Serializable;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.DenseVector$;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.SparseVector$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.UserDefinedType;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r4Q\u0001D\u0007\u0001#]AQ\u0001\n\u0001\u0005\u0002\u0019BQ\u0001\u000b\u0001\u0005F%BQ!\f\u0001\u0005B9BQa\u000e\u0001\u0005BaBQ!\u0011\u0001\u0005B\tCQA\u0014\u0001\u0005B=CQa\u0015\u0001\u0005BQCQA\u0017\u0001\u0005BmCQa\u0018\u0001\u0005B\tCa\u0001\u0019\u0001\u0005BE\t\u0007B\u00022\u0001A\u0003%!FA\u0005WK\u000e$xN]+E)*\u0011abD\u0001\u0007Y&t\u0017\r\\4\u000b\u0005A\t\u0012AA7m\u0015\t\u00112#A\u0003ta\u0006\u00148N\u0003\u0002\u0015+\u00051\u0011\r]1dQ\u0016T\u0011AF\u0001\u0004_J<7C\u0001\u0001\u0019!\rIb\u0004I\u0007\u00025)\u00111\u0004H\u0001\u0006if\u0004Xm\u001d\u0006\u0003;E\t1a]9m\u0013\ty\"DA\bVg\u0016\u0014H)\u001a4j]\u0016$G+\u001f9f!\t\t#%D\u0001\u000e\u0013\t\u0019SB\u0001\u0004WK\u000e$xN]\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\tq\u0005\u0005\u0002\"\u0001\u000591/\u001d7UsB,W#\u0001\u0016\u0011\u0005eY\u0013B\u0001\u0017\u001b\u0005)\u0019FO];diRK\b/Z\u0001\ng\u0016\u0014\u0018.\u00197ju\u0016$\"aL\u001b\u0011\u0005A\u001aT\"A\u0019\u000b\u0005Ib\u0012\u0001C2bi\u0006d\u0017p\u001d;\n\u0005Q\n$aC%oi\u0016\u0014h.\u00197S_^DQAN\u0002A\u0002\u0001\n1a\u001c2k\u0003-!Wm]3sS\u0006d\u0017N_3\u0015\u0005\u0001J\u0004\"\u0002\u001e\u0005\u0001\u0004Y\u0014!\u00023biVl\u0007C\u0001\u001f@\u001b\u0005i$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k$aA!os\u0006)\u0001/_+E)V\t1\t\u0005\u0002E\u0017:\u0011Q)\u0013\t\u0003\rvj\u0011a\u0012\u0006\u0003\u0011\u0016\na\u0001\u0010:p_Rt\u0014B\u0001&>\u0003\u0019\u0001&/\u001a3fM&\u0011A*\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005)k\u0014!C;tKJ\u001cE.Y:t+\u0005\u0001\u0006c\u0001#RA%\u0011!+\u0014\u0002\u0006\u00072\f7o]\u0001\u0007KF,\u0018\r\\:\u0015\u0005UC\u0006C\u0001\u001fW\u0013\t9VHA\u0004C_>dW-\u00198\t\u000be;\u0001\u0019A\u001e\u0002\u0003=\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u00029B\u0011A(X\u0005\u0003=v\u00121!\u00138u\u0003!!\u0018\u0010]3OC6,\u0017AC1t\u001dVdG.\u00192mKV\tq%\u0001\u0005`gFdG+\u001f9f\u0001")
public class VectorUDT
extends UserDefinedType<Vector> {
    private final StructType _sqlType = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("type", (DataType)ByteType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("size", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("indices", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), new StructField("values", (DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4())})));

    public final StructType sqlType() {
        return this._sqlType;
    }

    public InternalRow serialize(Vector obj) {
        DenseVector denseVector;
        Option option;
        GenericInternalRow genericInternalRow;
        SparseVector sparseVector;
        Option option2;
        Vector vector = obj;
        if (vector instanceof SparseVector && !(option2 = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector)).isEmpty()) {
            int size = BoxesRunTime.unboxToInt((Object)((Tuple3)option2.get())._1());
            int[] indices = (int[])((Tuple3)option2.get())._2();
            double[] values = (double[])((Tuple3)option2.get())._3();
            GenericInternalRow row = new GenericInternalRow(4);
            row.setByte(0, (byte)0);
            row.setInt(1, size);
            row.update(2, (Object)UnsafeArrayData.fromPrimitiveArray((int[])indices));
            row.update(3, (Object)UnsafeArrayData.fromPrimitiveArray((double[])values));
            genericInternalRow = row;
        } else if (vector instanceof DenseVector && !(option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector)).isEmpty()) {
            double[] values = (double[])option.get();
            GenericInternalRow row = new GenericInternalRow(4);
            row.setByte(0, (byte)1);
            row.setNullAt(1);
            row.setNullAt(2);
            row.update(3, (Object)UnsafeArrayData.fromPrimitiveArray((double[])values));
            genericInternalRow = row;
        } else {
            throw new IllegalArgumentException(new StringBuilder(21).append("Unknown vector type ").append(vector.getClass()).append(".").toString());
        }
        return genericInternalRow;
    }

    public Vector deserialize(Object datum) {
        DenseVector denseVector;
        Object object = datum;
        if (object instanceof InternalRow) {
            byte tpe;
            InternalRow internalRow = (InternalRow)object;
            Predef$.MODULE$.require(internalRow.numFields() == 4, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("VectorUDT.deserialize given row with length ").append(internalRow.numFields()).append(" but requires length == 4").toString());
            byte by = tpe = internalRow.getByte(0);
            switch (by) {
                case 0: {
                    int size = internalRow.getInt(1);
                    int[] indices = internalRow.getArray(2).toIntArray();
                    double[] values = internalRow.getArray(3).toDoubleArray();
                    denseVector = new SparseVector(size, indices, values);
                    break;
                }
                case 1: {
                    double[] values = internalRow.getArray(3).toDoubleArray();
                    denseVector = new DenseVector(values);
                    break;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
                }
            }
        } else {
            throw new MatchError(object);
        }
        DenseVector denseVector2 = denseVector;
        return denseVector2;
    }

    public String pyUDT() {
        return "pyspark.ml.linalg.VectorUDT";
    }

    public Class<Vector> userClass() {
        return Vector.class;
    }

    public boolean equals(Object o) {
        Object object = o;
        boolean bl = object instanceof VectorUDT;
        return bl;
    }

    public int hashCode() {
        return VectorUDT.class.getName().hashCode();
    }

    public String typeName() {
        return "vector";
    }

    public VectorUDT asNullable() {
        return this;
    }
}

