/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.attribute;

import java.io.Serializable;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.attribute.AttributeKeys$;
import org.apache.spark.ml.attribute.AttributeType$;
import org.apache.spark.ml.attribute.BinaryAttribute;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.attribute.NumericAttribute$;
import org.apache.spark.ml.attribute.UnresolvedAttribute$;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001\u0002\u0012$\u00019B\u0001\u0002\u000f\u0001\u0003\u0006\u0004%\t!\u000f\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005u!Aa\t\u0001BC\u0002\u0013\u0005q\t\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003I\u0011!y\u0005A!A!\u0002\u0013\u0001\u0006\"\u0002-\u0001\t\u0013I\u0006\"\u0002-\u0001\t\u0003q\u0006\"\u0002-\u0001\t\u0003\u0001\u0007\"\u0002-\u0001\t\u0003\u0019\u0007b\u00024\u0001\u0005\u0004%\ta\u001a\u0005\u0007Q\u0002\u0001\u000b\u0011\u0002)\t\u0011%\u0004\u0001R1A\u0005\n)DQA\u001c\u0001\u0005\u0002=DQ\u0001\u001d\u0001\u0005\u0002EDQa\u001e\u0001\u0005\u0002aDQA\u001f\u0001\u0005\u0002mDQ! \u0001\u0005\u0002yDaA\u001f\u0001\u0005\u0002\u0005\u0005\u0001BB?\u0001\t\u0003\t9\u0001\u0003\u0005\u0002\f\u0001!\taIA\u0007\u0011\u001d\ty\u0002\u0001C\u0001\u0003CAq!a\b\u0001\t\u0003\t9\u0003C\u0004\u0002*\u0001!\t!a\u000b\t\u000f\u0005%\u0002\u0001\"\u0001\u00026!9\u0011q\u0007\u0001\u0005B\u0005e\u0002bBA#\u0001\u0011\u0005\u0013q\t\u0005\b\u0003\u0013\u0002A\u0011IA&\u000f\u001d\tie\tE\u0001\u0003\u001f2aAI\u0012\t\u0002\u0005E\u0003B\u0002-\u001e\t\u0003\t\u0019\u0006\u0003\u0005\u0002Vu!\taIA,\u0011\u001d\ty&\bC\u0001\u0003CB\u0011\"a\u001a\u001e\u0003\u0003%I!!\u001b\u0003\u001d\u0005#HO]5ckR,wI]8va*\u0011A%J\u0001\nCR$(/\u001b2vi\u0016T!AJ\u0014\u0002\u00055d'B\u0001\u0015*\u0003\u0015\u0019\b/\u0019:l\u0015\tQ3&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Y\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aL\u001b\u0011\u0005A\u001aT\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0003\r\u0005s\u0017PU3g!\t\u0001d'\u0003\u00028c\ta1+\u001a:jC2L'0\u00192mK\u0006!a.Y7f+\u0005Q\u0004CA\u001eC\u001d\ta\u0004\t\u0005\u0002>c5\taH\u0003\u0002@[\u00051AH]8pizJ!!Q\u0019\u0002\rA\u0013X\rZ3g\u0013\t\u0019EI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0003F\nQA\\1nK\u0002\nQB\\;n\u0003R$(/\u001b2vi\u0016\u001cX#\u0001%\u0011\u0007AJ5*\u0003\u0002Kc\t1q\n\u001d;j_:\u0004\"\u0001\r'\n\u00055\u000b$aA%oi\u0006qa.^7BiR\u0014\u0018NY;uKN\u0004\u0013!B1uiJ\u001c\bc\u0001\u0019J#B\u0019\u0001G\u0015+\n\u0005M\u000b$!B!se\u0006L\bCA+W\u001b\u0005\u0019\u0013BA,$\u0005%\tE\u000f\u001e:jEV$X-\u0001\u0004=S:LGO\u0010\u000b\u00055ncV\f\u0005\u0002V\u0001!)\u0001H\u0002a\u0001u!)aI\u0002a\u0001\u0011\")qJ\u0002a\u0001!R\u0011!l\u0018\u0005\u0006q\u001d\u0001\rA\u000f\u000b\u00045\u0006\u0014\u0007\"\u0002\u001d\t\u0001\u0004Q\u0004\"\u0002$\t\u0001\u0004YEc\u0001.eK\")\u0001(\u0003a\u0001u!)q*\u0003a\u0001#\u0006Q\u0011\r\u001e;sS\n,H/Z:\u0016\u0003A\u000b1\"\u0019;ue&\u0014W\u000f^3tA\u0005Ya.Y7f)>Le\u000eZ3y+\u0005Y\u0007\u0003B\u001emu-K!!\u001c#\u0003\u00075\u000b\u0007/\u0001\u0003tSj,W#A&\u0002\u000f!\f7/\u0011;ueR\u0011!/\u001e\t\u0003aML!\u0001^\u0019\u0003\u000f\t{w\u000e\\3b]\")aO\u0004a\u0001u\u0005A\u0011\r\u001e;s\u001d\u0006lW-A\u0004j]\u0012,\u0007p\u00144\u0015\u0005-K\b\"\u0002<\u0010\u0001\u0004Q\u0014!B1qa2LHC\u0001+}\u0011\u00151\b\u00031\u0001;\u0003\u001d9W\r^!uiJ$\"\u0001V@\t\u000bY\f\u0002\u0019\u0001\u001e\u0015\u0007Q\u000b\u0019\u0001\u0003\u0004\u0002\u0006I\u0001\raS\u0001\nCR$(/\u00138eKb$2\u0001VA\u0005\u0011\u0019\t)a\u0005a\u0001\u0017\u0006qAo\\'fi\u0006$\u0017\r^1J[BdWCAA\b!\u0011\t\t\"a\u0007\u000e\u0005\u0005M!\u0002BA\u000b\u0003/\tQ\u0001^=qKNT1!!\u0007(\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003;\t\u0019B\u0001\u0005NKR\fG-\u0019;b\u0003)!x.T3uC\u0012\fG/\u0019\u000b\u0005\u0003\u001f\t\u0019\u0003C\u0004\u0002&U\u0001\r!a\u0004\u0002!\u0015D\u0018n\u001d;j]\u001elU\r^1eCR\fGCAA\b\u00035!xn\u0015;sk\u000e$h)[3mIR!\u0011QFA\u001a!\u0011\t\t\"a\f\n\t\u0005E\u00121\u0003\u0002\f'R\u0014Xo\u0019;GS\u0016dG\rC\u0004\u0002&]\u0001\r!a\u0004\u0015\u0005\u00055\u0012AB3rk\u0006d7\u000fF\u0002s\u0003wAq!!\u0010\u001a\u0001\u0004\ty$A\u0003pi\",'\u000fE\u00021\u0003\u0003J1!a\u00112\u0005\r\te._\u0001\tQ\u0006\u001c\bnQ8eKR\t1*\u0001\u0005u_N#(/\u001b8h)\u0005Q\u0014AD!uiJL'-\u001e;f\u000fJ|W\u000f\u001d\t\u0003+v\u00192!H\u00186)\t\ty%\u0001\u0007ge>lW*\u001a;bI\u0006$\u0018\rF\u0003[\u00033\ni\u0006C\u0004\u0002\\}\u0001\r!a\u0004\u0002\u00115,G/\u00193bi\u0006DQ\u0001O\u0010A\u0002i\nqB\u001a:p[N#(/^2u\r&,G\u000e\u001a\u000b\u00045\u0006\r\u0004bBA3A\u0001\u0007\u0011QF\u0001\u0006M&,G\u000eZ\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002lA!\u0011QNA<\u001b\t\tyG\u0003\u0003\u0002r\u0005M\u0014\u0001\u00027b]\u001eT!!!\u001e\u0002\t)\fg/Y\u0005\u0005\u0003s\nyG\u0001\u0004PE*,7\r\u001e")
public class AttributeGroup
implements scala.Serializable {
    private Map<String, Object> nameToIndex;
    private final String name;
    private final Option<Object> numAttributes;
    private final Option<Attribute[]> attributes;
    private volatile boolean bitmap$0;

    public static AttributeGroup fromStructField(StructField structField) {
        return AttributeGroup$.MODULE$.fromStructField(structField);
    }

    public String name() {
        return this.name;
    }

    public Option<Object> numAttributes() {
        return this.numAttributes;
    }

    public Option<Attribute[]> attributes() {
        return this.attributes;
    }

    private Map<String, Object> nameToIndex$lzycompute() {
        AttributeGroup attributeGroup = this;
        synchronized (attributeGroup) {
            if (!this.bitmap$0) {
                this.nameToIndex = (Map)this.attributes().map((Function1 & Serializable & scala.Serializable)x$2 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2)).iterator().flatMap((Function1 & Serializable & scala.Serializable)attr -> Option$.MODULE$.option2Iterable(attr.name().map((Function1 & Serializable & scala.Serializable)x$3 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$3), attr.index().get())))).toMap(Predef$.MODULE$.$conforms())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
                this.bitmap$0 = true;
            }
        }
        return this.nameToIndex;
    }

    private Map<String, Object> nameToIndex() {
        return !this.bitmap$0 ? this.nameToIndex$lzycompute() : this.nameToIndex;
    }

    public int size() {
        return this.numAttributes().isDefined() ? BoxesRunTime.unboxToInt((Object)this.numAttributes().get()) : (this.attributes().isDefined() ? ((Attribute[])this.attributes().get()).length : -1);
    }

    public boolean hasAttr(String attrName) {
        return this.nameToIndex().contains((Object)attrName);
    }

    public int indexOf(String attrName) {
        return BoxesRunTime.unboxToInt((Object)this.nameToIndex().apply((Object)attrName));
    }

    public Attribute apply(String attrName) {
        return ((Attribute[])this.attributes().get())[this.indexOf(attrName)];
    }

    public Attribute getAttr(String attrName) {
        return this.apply(attrName);
    }

    public Attribute apply(int attrIndex) {
        return ((Attribute[])this.attributes().get())[attrIndex];
    }

    public Attribute getAttr(int attrIndex) {
        return this.apply(attrIndex);
    }

    public Metadata toMetadataImpl() {
        Object object;
        MetadataBuilder bldr = new MetadataBuilder();
        if (this.attributes().isDefined()) {
            ArrayBuffer numericMetadata = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            ArrayBuffer nominalMetadata = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            ArrayBuffer binaryMetadata = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.attributes().get())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ArrayBuffer arrayBuffer;
                Attribute attribute = x0$1;
                if (attribute instanceof NumericAttribute) {
                    NumericAttribute numericAttribute = (NumericAttribute)attribute;
                    NumericAttribute numericAttribute2 = numericAttribute.withoutIndex();
                    NumericAttribute numericAttribute3 = NumericAttribute$.MODULE$.defaultAttr();
                    arrayBuffer = (numericAttribute2 == null ? numericAttribute3 != null : !((Object)numericAttribute2).equals(numericAttribute3)) ? numericMetadata.$plus$eq((Object)numericAttribute.toMetadataImpl(false)) : BoxedUnit.UNIT;
                } else if (attribute instanceof NominalAttribute) {
                    NominalAttribute nominalAttribute = (NominalAttribute)attribute;
                    arrayBuffer = nominalMetadata.$plus$eq((Object)nominalAttribute.toMetadataImpl(false));
                } else if (attribute instanceof BinaryAttribute) {
                    BinaryAttribute binaryAttribute = (BinaryAttribute)attribute;
                    arrayBuffer = binaryMetadata.$plus$eq((Object)binaryAttribute.toMetadataImpl(false));
                } else if (UnresolvedAttribute$.MODULE$.equals(attribute)) {
                    arrayBuffer = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)attribute);
                }
                return arrayBuffer;
            });
            MetadataBuilder attrBldr = new MetadataBuilder();
            Object object2 = numericMetadata.nonEmpty() ? attrBldr.putMetadataArray(AttributeType$.MODULE$.Numeric().name(), (Metadata[])numericMetadata.toArray(ClassTag$.MODULE$.apply(Metadata.class))) : BoxedUnit.UNIT;
            Object object3 = nominalMetadata.nonEmpty() ? attrBldr.putMetadataArray(AttributeType$.MODULE$.Nominal().name(), (Metadata[])nominalMetadata.toArray(ClassTag$.MODULE$.apply(Metadata.class))) : BoxedUnit.UNIT;
            Object object4 = binaryMetadata.nonEmpty() ? attrBldr.putMetadataArray(AttributeType$.MODULE$.Binary().name(), (Metadata[])binaryMetadata.toArray(ClassTag$.MODULE$.apply(Metadata.class))) : BoxedUnit.UNIT;
            bldr.putMetadata(AttributeKeys$.MODULE$.ATTRIBUTES(), attrBldr.build());
            object = bldr.putLong(AttributeKeys$.MODULE$.NUM_ATTRIBUTES(), (long)((Attribute[])this.attributes().get()).length);
        } else {
            object = this.numAttributes().isDefined() ? bldr.putLong(AttributeKeys$.MODULE$.NUM_ATTRIBUTES(), (long)BoxesRunTime.unboxToInt((Object)this.numAttributes().get())) : BoxedUnit.UNIT;
        }
        return bldr.build();
    }

    public Metadata toMetadata(Metadata existingMetadata) {
        return new MetadataBuilder().withMetadata(existingMetadata).putMetadata(AttributeKeys$.MODULE$.ML_ATTR(), this.toMetadataImpl()).build();
    }

    public Metadata toMetadata() {
        return this.toMetadata(Metadata$.MODULE$.empty());
    }

    public StructField toStructField(Metadata existingMetadata) {
        return new StructField(this.name(), (DataType)new VectorUDT(), false, this.toMetadata(existingMetadata));
    }

    public StructField toStructField() {
        return this.toStructField(Metadata$.MODULE$.empty());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof AttributeGroup)) return false;
        AttributeGroup attributeGroup = (AttributeGroup)object;
        String string = this.name();
        String string2 = attributeGroup.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Option<Object> option = this.numAttributes();
        Option<Object> option2 = attributeGroup.numAttributes();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option option3 = this.attributes().map((Function1 & Serializable & scala.Serializable)x$4 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$4)).toSeq());
        Option option4 = attributeGroup.attributes().map((Function1 & Serializable & scala.Serializable)x$5 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$5)).toSeq());
        if (option3 == null) {
            if (option4 == null) return true;
            return false;
        } else {
            if (!option3.equals(option4)) return false;
            return true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int sum = 17;
        sum = 37 * sum + this.name().hashCode();
        sum = 37 * sum + this.numAttributes().hashCode();
        sum = 37 * sum + this.attributes().map((Function1 & Serializable & scala.Serializable)x$6 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$6)).toSeq()).hashCode();
        return (int)var1_1;
    }

    public String toString() {
        return this.toMetadata().toString();
    }

    private AttributeGroup(String name, Option<Object> numAttributes, Option<Attribute[]> attrs) {
        this.name = name;
        this.numAttributes = numAttributes;
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(name)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Cannot have an empty string for name.");
        Predef$.MODULE$.require(!numAttributes.isDefined() || !attrs.isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Cannot have both numAttributes and attrs defined.");
        this.attributes = attrs.map((Function1 & Serializable & scala.Serializable)x$1 -> (Attribute[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1)).iterator().zipWithIndex().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Attribute attr = (Attribute)tuple2._1();
            int i = tuple2._2$mcI$sp();
            Attribute attribute = attr.withIndex(i);
            return attribute;
        }).toArray(ClassTag$.MODULE$.apply(Attribute.class)));
    }

    public AttributeGroup(String name) {
        this(name, (Option<Object>)None$.MODULE$, (Option<Attribute[]>)None$.MODULE$);
    }

    public AttributeGroup(String name, int numAttributes) {
        this(name, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)numAttributes)), (Option<Attribute[]>)None$.MODULE$);
    }

    public AttributeGroup(String name, Attribute[] attrs) {
        this(name, (Option<Object>)None$.MODULE$, (Option<Attribute[]>)new Some((Object)attrs));
    }
}

