/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;
import org.apache.spark.ExceptionFailure;
import org.apache.spark.ExceptionFailure$;
import org.apache.spark.ExecutorLostFailure;
import org.apache.spark.FetchFailed;
import org.apache.spark.InternalAccumulator$;
import org.apache.spark.Resubmitted$;
import org.apache.spark.Success$;
import org.apache.spark.TaskCommitDenied;
import org.apache.spark.TaskEndReason;
import org.apache.spark.TaskKilled;
import org.apache.spark.TaskKilled$;
import org.apache.spark.TaskResultLost$;
import org.apache.spark.ThrowableSerializationWrapper;
import org.apache.spark.UnknownReason$;
import org.apache.spark.executor.ExecutorMetrics;
import org.apache.spark.executor.InputMetrics;
import org.apache.spark.executor.OutputMetrics;
import org.apache.spark.executor.ShuffleWriteMetrics;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.executor.TaskMetrics$;
import org.apache.spark.executor.TempShuffleReadMetrics;
import org.apache.spark.metrics.ExecutorMetricType$;
import org.apache.spark.package$;
import org.apache.spark.rdd.RDDOperationScope;
import org.apache.spark.rdd.RDDOperationScope$;
import org.apache.spark.resource.ExecutorResourceRequest;
import org.apache.spark.resource.ResourceInformation;
import org.apache.spark.resource.ResourceInformation$;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.resource.TaskResourceRequest;
import org.apache.spark.scheduler.AccumulableInfo;
import org.apache.spark.scheduler.JobFailed;
import org.apache.spark.scheduler.JobResult;
import org.apache.spark.scheduler.JobSucceeded$;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerApplicationStart;
import org.apache.spark.scheduler.SparkListenerBlockManagerAdded;
import org.apache.spark.scheduler.SparkListenerBlockManagerRemoved;
import org.apache.spark.scheduler.SparkListenerBlockUpdated;
import org.apache.spark.scheduler.SparkListenerEnvironmentUpdate;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerExecutorAdded;
import org.apache.spark.scheduler.SparkListenerExecutorMetricsUpdate;
import org.apache.spark.scheduler.SparkListenerExecutorRemoved;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerLogStart;
import org.apache.spark.scheduler.SparkListenerResourceProfileAdded;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerStageExecutorMetrics;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.SparkListenerTaskGettingResult;
import org.apache.spark.scheduler.SparkListenerTaskStart;
import org.apache.spark.scheduler.SparkListenerUnpersistRDD;
import org.apache.spark.scheduler.StageInfo;
import org.apache.spark.scheduler.StageInfo$;
import org.apache.spark.scheduler.TaskInfo;
import org.apache.spark.scheduler.TaskLocality$;
import org.apache.spark.scheduler.TaskLocation;
import org.apache.spark.scheduler.cluster.ExecutorInfo;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockId$;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockManagerId$;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.BlockUpdatedInfo;
import org.apache.spark.storage.RDDInfo;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.JsonProtocol$JOB_RESULT_FORMATTED_CLASS_NAMES$;
import org.apache.spark.util.JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$;
import org.apache.spark.util.JsonProtocol$TASK_END_REASON_FORMATTED_CLASS_NAMES$;
import org.apache.spark.util.Utils$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.jackson.JsonMethods$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class JsonProtocol$ {
    public static JsonProtocol$ MODULE$;
    private Set<String> accumulableExcludeList;
    private final DefaultFormats$ format;
    private final ObjectMapper mapper;
    private volatile boolean bitmap$0;

    static {
        new JsonProtocol$();
    }

    private DefaultFormats$ format() {
        return this.format;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    public JsonAST.JValue sparkEventToJson(SparkListenerEvent event) {
        JsonAST.JValue jValue;
        SparkListenerEvent sparkListenerEvent = event;
        if (sparkListenerEvent instanceof SparkListenerStageSubmitted) {
            SparkListenerStageSubmitted sparkListenerStageSubmitted = (SparkListenerStageSubmitted)sparkListenerEvent;
            jValue = this.stageSubmittedToJson(sparkListenerStageSubmitted);
        } else if (sparkListenerEvent instanceof SparkListenerStageCompleted) {
            SparkListenerStageCompleted sparkListenerStageCompleted = (SparkListenerStageCompleted)sparkListenerEvent;
            jValue = this.stageCompletedToJson(sparkListenerStageCompleted);
        } else if (sparkListenerEvent instanceof SparkListenerTaskStart) {
            SparkListenerTaskStart sparkListenerTaskStart = (SparkListenerTaskStart)sparkListenerEvent;
            jValue = this.taskStartToJson(sparkListenerTaskStart);
        } else if (sparkListenerEvent instanceof SparkListenerTaskGettingResult) {
            SparkListenerTaskGettingResult sparkListenerTaskGettingResult = (SparkListenerTaskGettingResult)sparkListenerEvent;
            jValue = this.taskGettingResultToJson(sparkListenerTaskGettingResult);
        } else if (sparkListenerEvent instanceof SparkListenerTaskEnd) {
            SparkListenerTaskEnd sparkListenerTaskEnd = (SparkListenerTaskEnd)sparkListenerEvent;
            jValue = this.taskEndToJson(sparkListenerTaskEnd);
        } else if (sparkListenerEvent instanceof SparkListenerJobStart) {
            SparkListenerJobStart sparkListenerJobStart = (SparkListenerJobStart)sparkListenerEvent;
            jValue = this.jobStartToJson(sparkListenerJobStart);
        } else if (sparkListenerEvent instanceof SparkListenerJobEnd) {
            SparkListenerJobEnd sparkListenerJobEnd = (SparkListenerJobEnd)sparkListenerEvent;
            jValue = this.jobEndToJson(sparkListenerJobEnd);
        } else if (sparkListenerEvent instanceof SparkListenerEnvironmentUpdate) {
            SparkListenerEnvironmentUpdate sparkListenerEnvironmentUpdate = (SparkListenerEnvironmentUpdate)sparkListenerEvent;
            jValue = this.environmentUpdateToJson(sparkListenerEnvironmentUpdate);
        } else if (sparkListenerEvent instanceof SparkListenerBlockManagerAdded) {
            SparkListenerBlockManagerAdded sparkListenerBlockManagerAdded = (SparkListenerBlockManagerAdded)sparkListenerEvent;
            jValue = this.blockManagerAddedToJson(sparkListenerBlockManagerAdded);
        } else if (sparkListenerEvent instanceof SparkListenerBlockManagerRemoved) {
            SparkListenerBlockManagerRemoved sparkListenerBlockManagerRemoved = (SparkListenerBlockManagerRemoved)sparkListenerEvent;
            jValue = this.blockManagerRemovedToJson(sparkListenerBlockManagerRemoved);
        } else if (sparkListenerEvent instanceof SparkListenerUnpersistRDD) {
            SparkListenerUnpersistRDD sparkListenerUnpersistRDD = (SparkListenerUnpersistRDD)sparkListenerEvent;
            jValue = this.unpersistRDDToJson(sparkListenerUnpersistRDD);
        } else if (sparkListenerEvent instanceof SparkListenerApplicationStart) {
            SparkListenerApplicationStart sparkListenerApplicationStart = (SparkListenerApplicationStart)sparkListenerEvent;
            jValue = this.applicationStartToJson(sparkListenerApplicationStart);
        } else if (sparkListenerEvent instanceof SparkListenerApplicationEnd) {
            SparkListenerApplicationEnd sparkListenerApplicationEnd = (SparkListenerApplicationEnd)sparkListenerEvent;
            jValue = this.applicationEndToJson(sparkListenerApplicationEnd);
        } else if (sparkListenerEvent instanceof SparkListenerExecutorAdded) {
            SparkListenerExecutorAdded sparkListenerExecutorAdded = (SparkListenerExecutorAdded)sparkListenerEvent;
            jValue = this.executorAddedToJson(sparkListenerExecutorAdded);
        } else if (sparkListenerEvent instanceof SparkListenerExecutorRemoved) {
            SparkListenerExecutorRemoved sparkListenerExecutorRemoved = (SparkListenerExecutorRemoved)sparkListenerEvent;
            jValue = this.executorRemovedToJson(sparkListenerExecutorRemoved);
        } else if (sparkListenerEvent instanceof SparkListenerLogStart) {
            SparkListenerLogStart sparkListenerLogStart = (SparkListenerLogStart)sparkListenerEvent;
            jValue = this.logStartToJson(sparkListenerLogStart);
        } else if (sparkListenerEvent instanceof SparkListenerExecutorMetricsUpdate) {
            SparkListenerExecutorMetricsUpdate sparkListenerExecutorMetricsUpdate = (SparkListenerExecutorMetricsUpdate)sparkListenerEvent;
            jValue = this.executorMetricsUpdateToJson(sparkListenerExecutorMetricsUpdate);
        } else if (sparkListenerEvent instanceof SparkListenerStageExecutorMetrics) {
            SparkListenerStageExecutorMetrics sparkListenerStageExecutorMetrics = (SparkListenerStageExecutorMetrics)sparkListenerEvent;
            jValue = this.stageExecutorMetricsToJson(sparkListenerStageExecutorMetrics);
        } else if (sparkListenerEvent instanceof SparkListenerBlockUpdated) {
            SparkListenerBlockUpdated sparkListenerBlockUpdated = (SparkListenerBlockUpdated)sparkListenerEvent;
            jValue = this.blockUpdateToJson(sparkListenerBlockUpdated);
        } else if (sparkListenerEvent instanceof SparkListenerResourceProfileAdded) {
            SparkListenerResourceProfileAdded sparkListenerResourceProfileAdded = (SparkListenerResourceProfileAdded)sparkListenerEvent;
            jValue = this.resourceProfileAddedToJson(sparkListenerResourceProfileAdded);
        } else {
            jValue = JsonMethods$.MODULE$.parse(org.json4s.package$.MODULE$.string2JsonInput(this.mapper().writeValueAsString((Object)event)), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
        }
        return jValue;
    }

    public JsonAST.JValue stageSubmittedToJson(SparkListenerStageSubmitted stageSubmitted) {
        JsonAST.JValue stageInfo = this.stageInfoToJson(stageSubmitted.stageInfo());
        JsonAST.JValue properties = this.propertiesToJson(stageSubmitted.properties());
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Event"), (Object)JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.stageSubmitted()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Stage Info"), (Object)stageInfo), (Function1)Predef$.MODULE$.$conforms())).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Properties"), (Object)properties));
    }

    public JsonAST.JValue stageCompletedToJson(SparkListenerStageCompleted stageCompleted) {
        JsonAST.JValue stageInfo = this.stageInfoToJson(stageCompleted.stageInfo());
        return JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Event"), (Object)JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.stageCompleted()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Stage Info"), (Object)stageInfo), (Function1)Predef$.MODULE$.$conforms());
    }

    public JsonAST.JValue taskStartToJson(SparkListenerTaskStart taskStart) {
        TaskInfo taskInfo = taskStart.taskInfo();
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Event"), (Object)JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.taskStart()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Stage ID"), (Object)BoxesRunTime.boxToInteger((int)taskStart.stageId())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Stage Attempt ID"), (Object)BoxesRunTime.boxToInteger((int)taskStart.stageAttemptId())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Task Info"), (Object)this.taskInfoToJson(taskInfo)));
    }

    public JsonAST.JValue taskGettingResultToJson(SparkListenerTaskGettingResult taskGettingResult) {
        TaskInfo taskInfo = taskGettingResult.taskInfo();
        return JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Event"), (Object)JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.taskGettingResult()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Task Info"), (Object)this.taskInfoToJson(taskInfo)), (Function1)Predef$.MODULE$.$conforms());
    }

    public JsonAST.JValue taskEndToJson(SparkListenerTaskEnd taskEnd) {
        JsonAST.JValue taskEndReason = this.taskEndReasonToJson(taskEnd.reason());
        TaskInfo taskInfo = taskEnd.taskInfo();
        ExecutorMetrics executorMetrics = taskEnd.taskExecutorMetrics();
        TaskMetrics taskMetrics = taskEnd.taskMetrics();
        JsonAST.JNothing$ taskMetricsJson = taskMetrics != null ? this.taskMetricsToJson(taskMetrics) : JsonAST.JNothing$.MODULE$;
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Event"), (Object)JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.taskEnd()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Stage ID"), (Object)BoxesRunTime.boxToInteger((int)taskEnd.stageId())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Stage Attempt ID"), (Object)BoxesRunTime.boxToInteger((int)taskEnd.stageAttemptId())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Task Type"), (Object)taskEnd.taskType()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Task End Reason"), (Object)taskEndReason))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Task Info"), (Object)this.taskInfoToJson(taskInfo)))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Task Executor Metrics"), (Object)this.executorMetricsToJson(executorMetrics)))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Task Metrics"), (Object)taskMetricsJson));
    }

    public JsonAST.JValue jobStartToJson(SparkListenerJobStart jobStart) {
        JsonAST.JValue properties = this.propertiesToJson(jobStart.properties());
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Event"), (Object)JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.jobStart()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Job ID"), (Object)BoxesRunTime.boxToInteger((int)jobStart.jobId())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Submission Time"), (Object)BoxesRunTime.boxToLong((long)jobStart.time())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Stage Infos"), jobStart.stageInfos().map((Function1 & Serializable & scala.Serializable)stageInfo -> MODULE$.stageInfoToJson((StageInfo)stageInfo), Seq$.MODULE$.canBuildFrom())), (Function1 & Serializable & scala.Serializable)s -> JsonDSL$.MODULE$.seq2jvalue(s, (Function1)Predef$.MODULE$.$conforms())))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Stage IDs"), jobStart.stageIds()), (Function1 & Serializable & scala.Serializable)s -> JsonDSL$.MODULE$.seq2jvalue(s, (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Properties"), (Object)properties));
    }

    public JsonAST.JValue jobEndToJson(SparkListenerJobEnd jobEnd) {
        JsonAST.JValue jobResult = this.jobResultToJson(jobEnd.jobResult());
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Event"), (Object)JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.jobEnd()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Job ID"), (Object)BoxesRunTime.boxToInteger((int)jobEnd.jobId())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Completion Time"), (Object)BoxesRunTime.boxToLong((long)jobEnd.time())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Job Result"), (Object)jobResult));
    }

    public JsonAST.JValue environmentUpdateToJson(SparkListenerEnvironmentUpdate environmentUpdate) {
        Map<String, Seq<Tuple2<String, String>>> environmentDetails = environmentUpdate.environmentDetails();
        JsonAST.JValue jvmInformation = this.mapToJson((Map<String, String>)((TraversableOnce)environmentDetails.apply((Object)"JVM Information")).toMap(Predef$.MODULE$.$conforms()));
        JsonAST.JValue sparkProperties = this.mapToJson((Map<String, String>)((TraversableOnce)environmentDetails.apply((Object)"Spark Properties")).toMap(Predef$.MODULE$.$conforms()));
        JsonAST.JValue hadoopProperties = this.mapToJson((Map<String, String>)((TraversableOnce)environmentDetails.apply((Object)"Hadoop Properties")).toMap(Predef$.MODULE$.$conforms()));
        JsonAST.JValue systemProperties = this.mapToJson((Map<String, String>)((TraversableOnce)environmentDetails.apply((Object)"System Properties")).toMap(Predef$.MODULE$.$conforms()));
        JsonAST.JValue classpathEntries = this.mapToJson((Map<String, String>)((TraversableOnce)environmentDetails.apply((Object)"Classpath Entries")).toMap(Predef$.MODULE$.$conforms()));
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Event"), (Object)JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.environmentUpdate()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"JVM Information"), (Object)jvmInformation), (Function1)Predef$.MODULE$.$conforms())).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Spark Properties"), (Object)sparkProperties))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Hadoop Properties"), (Object)hadoopProperties))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"System Properties"), (Object)systemProperties))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Classpath Entries"), (Object)classpathEntries));
    }

    public JsonAST.JValue blockManagerAddedToJson(SparkListenerBlockManagerAdded blockManagerAdded) {
        JsonAST.JValue blockManagerId = this.blockManagerIdToJson(blockManagerAdded.blockManagerId());
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Event"), (Object)JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.blockManagerAdded()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Block Manager ID"), (Object)blockManagerId), (Function1)Predef$.MODULE$.$conforms())).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Maximum Memory"), (Object)BoxesRunTime.boxToLong((long)blockManagerAdded.maxMem())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Timestamp"), (Object)BoxesRunTime.boxToLong((long)blockManagerAdded.time())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Maximum Onheap Memory"), blockManagerAdded.maxOnHeapMem()), (Function1 & Serializable & scala.Serializable)opt -> JsonDSL$.MODULE$.option2jvalue(opt, (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x)))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Maximum Offheap Memory"), blockManagerAdded.maxOffHeapMem()), (Function1 & Serializable & scala.Serializable)opt -> JsonDSL$.MODULE$.option2jvalue(opt, (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x)))));
    }

    public JsonAST.JValue blockManagerRemovedToJson(SparkListenerBlockManagerRemoved blockManagerRemoved) {
        JsonAST.JValue blockManagerId = this.blockManagerIdToJson(blockManagerRemoved.blockManagerId());
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Event"), (Object)JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.blockManagerRemoved()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Block Manager ID"), (Object)blockManagerId), (Function1)Predef$.MODULE$.$conforms())).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Timestamp"), (Object)BoxesRunTime.boxToLong((long)blockManagerRemoved.time())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))));
    }

    public JsonAST.JValue unpersistRDDToJson(SparkListenerUnpersistRDD unpersistRDD) {
        return JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Event"), (Object)JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.unpersistRDD()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"RDD ID"), (Object)BoxesRunTime.boxToInteger((int)unpersistRDD.rddId())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)));
    }

    public JsonAST.JValue applicationStartToJson(SparkListenerApplicationStart applicationStart) {
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Event"), (Object)JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.applicationStart()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"App Name"), (Object)applicationStart.appName()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"App ID"), applicationStart.appId().map((Function1 & Serializable & scala.Serializable)x$1 -> new JsonAST.JString(x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> JsonAST.JNothing$.MODULE$)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Timestamp"), (Object)BoxesRunTime.boxToLong((long)applicationStart.time())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"User"), (Object)applicationStart.sparkUser()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"App Attempt ID"), applicationStart.appAttemptId().map((Function1 & Serializable & scala.Serializable)x$2 -> new JsonAST.JString(x$2)).getOrElse((Function0 & Serializable & scala.Serializable)() -> JsonAST.JNothing$.MODULE$)))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Driver Logs"), applicationStart.driverLogs().map((Function1 & Serializable & scala.Serializable)m -> MODULE$.mapToJson((Map<String, String>)m)).getOrElse((Function0 & Serializable & scala.Serializable)() -> JsonAST.JNothing$.MODULE$)))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Driver Attributes"), applicationStart.driverAttributes().map((Function1 & Serializable & scala.Serializable)m -> MODULE$.mapToJson((Map<String, String>)m)).getOrElse((Function0 & Serializable & scala.Serializable)() -> JsonAST.JNothing$.MODULE$)));
    }

    public JsonAST.JValue applicationEndToJson(SparkListenerApplicationEnd applicationEnd) {
        return JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Event"), (Object)JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.applicationEnd()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Timestamp"), (Object)BoxesRunTime.boxToLong((long)applicationEnd.time())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x)));
    }

    public JsonAST.JValue resourceProfileAddedToJson(SparkListenerResourceProfileAdded profileAdded) {
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Event"), (Object)JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.resourceProfileAdded()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Resource Profile Id"), (Object)BoxesRunTime.boxToInteger((int)profileAdded.resourceProfile().id())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Executor Resource Requests"), (Object)this.executorResourceRequestMapToJson((Map<String, ExecutorResourceRequest>)profileAdded.resourceProfile().executorResources())))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Task Resource Requests"), (Object)this.taskResourceRequestMapToJson((Map<String, TaskResourceRequest>)profileAdded.resourceProfile().taskResources())));
    }

    public JsonAST.JValue executorAddedToJson(SparkListenerExecutorAdded executorAdded) {
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Event"), (Object)JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.executorAdded()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Timestamp"), (Object)BoxesRunTime.boxToLong((long)executorAdded.time())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Executor ID"), (Object)executorAdded.executorId()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Executor Info"), (Object)this.executorInfoToJson(executorAdded.executorInfo())));
    }

    public JsonAST.JValue executorRemovedToJson(SparkListenerExecutorRemoved executorRemoved) {
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Event"), (Object)JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.executorRemoved()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Timestamp"), (Object)BoxesRunTime.boxToLong((long)executorRemoved.time())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Executor ID"), (Object)executorRemoved.executorId()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Removed Reason"), (Object)executorRemoved.reason()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)));
    }

    public JsonAST.JValue logStartToJson(SparkListenerLogStart logStart) {
        return JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Event"), (Object)JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.logStart()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Spark Version"), (Object)package$.MODULE$.SPARK_VERSION()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x));
    }

    public JsonAST.JValue executorMetricsUpdateToJson(SparkListenerExecutorMetricsUpdate metricsUpdate) {
        String execId = metricsUpdate.execId();
        Seq<Tuple4<Object, Object, Object, Seq<AccumulableInfo>>> accumUpdates = metricsUpdate.accumUpdates();
        Map<Tuple2<Object, Object>, ExecutorMetrics> executorUpdates = metricsUpdate.executorUpdates();
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Event"), (Object)JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.metricsUpdate()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Executor ID"), (Object)execId), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Metrics Updated"), accumUpdates.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple4 tuple4 = x0$1;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            long taskId = BoxesRunTime.unboxToLong((Object)tuple4._1());
            int stageId = BoxesRunTime.unboxToInt((Object)tuple4._2());
            int stageAttemptId = BoxesRunTime.unboxToInt((Object)tuple4._3());
            Seq updates = (Seq)tuple4._4();
            JsonAST.JObject jObject = JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Task ID"), (Object)BoxesRunTime.boxToLong((long)taskId)), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Stage ID"), (Object)BoxesRunTime.boxToInteger((int)stageId)), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Stage Attempt ID"), (Object)BoxesRunTime.boxToInteger((int)stageAttemptId)), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Accumulator Updates"), (Object)new JsonAST.JArray(((TraversableOnce)updates.map((Function1 & Serializable & scala.Serializable)accumulableInfo -> MODULE$.accumulableInfoToJson((AccumulableInfo)accumulableInfo), Seq$.MODULE$.canBuildFrom())).toList())));
            return jObject;
        }, Seq$.MODULE$.canBuildFrom())), (Function1 & Serializable & scala.Serializable)s -> JsonDSL$.MODULE$.seq2jvalue(s, (Function1)Predef$.MODULE$.$conforms())))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Executor Metrics Updated"), executorUpdates.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ExecutorMetrics metrics;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$2;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    metrics = (ExecutorMetrics)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            int stageId = tuple2._1$mcI$sp();
            int stageAttemptId = tuple2._2$mcI$sp();
            JsonAST.JObject jObject = JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Stage ID"), (Object)BoxesRunTime.boxToInteger((int)stageId)), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Stage Attempt ID"), (Object)BoxesRunTime.boxToInteger((int)stageAttemptId)), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Executor Metrics"), (Object)MODULE$.executorMetricsToJson(metrics)));
            return jObject;
        }, Iterable$.MODULE$.canBuildFrom())), (Function1 & Serializable & scala.Serializable)s -> JsonDSL$.MODULE$.seq2jvalue(s, (Function1)Predef$.MODULE$.$conforms())));
    }

    public JsonAST.JValue stageExecutorMetricsToJson(SparkListenerStageExecutorMetrics metrics) {
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Event"), (Object)JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.stageExecutorMetrics()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Executor ID"), (Object)metrics.execId()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Stage ID"), (Object)BoxesRunTime.boxToInteger((int)metrics.stageId())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Stage Attempt ID"), (Object)BoxesRunTime.boxToInteger((int)metrics.stageAttemptId())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Executor Metrics"), (Object)this.executorMetricsToJson(metrics.executorMetrics())));
    }

    public JsonAST.JValue blockUpdateToJson(SparkListenerBlockUpdated blockUpdate) {
        JsonAST.JValue blockUpdatedInfo = this.blockUpdatedInfoToJson(blockUpdate.blockUpdatedInfo());
        return JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Event"), (Object)JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.blockUpdate()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Block Updated Info"), (Object)blockUpdatedInfo), (Function1)Predef$.MODULE$.$conforms());
    }

    public JsonAST.JValue stageInfoToJson(StageInfo stageInfo) {
        JsonAST.JArray rddInfo2 = new JsonAST.JArray(((TraversableOnce)stageInfo.rddInfos().map((Function1 & Serializable & scala.Serializable)rddInfo -> MODULE$.rddInfoToJson((RDDInfo)rddInfo), Seq$.MODULE$.canBuildFrom())).toList());
        JsonAST.JArray parentIds = new JsonAST.JArray(((TraversableOnce)stageInfo.parentIds().map((Function1 & Serializable & scala.Serializable)x$3 -> JsonProtocol$.$anonfun$stageInfoToJson$2(BoxesRunTime.unboxToInt((Object)x$3)), Seq$.MODULE$.canBuildFrom())).toList());
        JsonAST.JValue submissionTime = (JsonAST.JValue)stageInfo.submissionTime().map((Function1 & Serializable & scala.Serializable)x$4 -> JsonProtocol$.$anonfun$stageInfoToJson$3(BoxesRunTime.unboxToLong((Object)x$4))).getOrElse((Function0 & Serializable & scala.Serializable)() -> JsonAST.JNothing$.MODULE$);
        JsonAST.JValue completionTime = (JsonAST.JValue)stageInfo.completionTime().map((Function1 & Serializable & scala.Serializable)x$5 -> JsonProtocol$.$anonfun$stageInfoToJson$5(BoxesRunTime.unboxToLong((Object)x$5))).getOrElse((Function0 & Serializable & scala.Serializable)() -> JsonAST.JNothing$.MODULE$);
        JsonAST.JValue failureReason = (JsonAST.JValue)stageInfo.failureReason().map((Function1 & Serializable & scala.Serializable)x$6 -> new JsonAST.JString(x$6)).getOrElse((Function0 & Serializable & scala.Serializable)() -> JsonAST.JNothing$.MODULE$);
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Stage ID"), (Object)BoxesRunTime.boxToInteger((int)stageInfo.stageId())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Stage Attempt ID"), (Object)BoxesRunTime.boxToInteger((int)stageInfo.attemptNumber())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Stage Name"), (Object)stageInfo.name()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Number of Tasks"), (Object)BoxesRunTime.boxToInteger((int)stageInfo.numTasks())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"RDD Info"), (Object)rddInfo2))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Parent IDs"), (Object)parentIds))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Details"), (Object)stageInfo.details()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Submission Time"), (Object)submissionTime))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Completion Time"), (Object)completionTime))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Failure Reason"), (Object)failureReason))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Accumulables"), (Object)this.accumulablesToJson((Iterable<AccumulableInfo>)stageInfo.accumulables().values())))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Resource Profile Id"), (Object)BoxesRunTime.boxToInteger((int)stageInfo.resourceProfileId())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))));
    }

    public JsonAST.JValue taskInfoToJson(TaskInfo taskInfo) {
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Task ID"), (Object)BoxesRunTime.boxToLong((long)taskInfo.taskId())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Index"), (Object)BoxesRunTime.boxToInteger((int)taskInfo.index())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Attempt"), (Object)BoxesRunTime.boxToInteger((int)taskInfo.attemptNumber())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Launch Time"), (Object)BoxesRunTime.boxToLong((long)taskInfo.launchTime())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Executor ID"), (Object)taskInfo.executorId()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Host"), (Object)taskInfo.host()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Locality"), (Object)taskInfo.taskLocality().toString()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Speculative"), (Object)BoxesRunTime.boxToBoolean((boolean)taskInfo.speculative())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.boolean2jvalue(BoxesRunTime.unboxToBoolean((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Getting Result Time"), (Object)BoxesRunTime.boxToLong((long)taskInfo.gettingResultTime())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Finish Time"), (Object)BoxesRunTime.boxToLong((long)taskInfo.finishTime())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Failed"), (Object)BoxesRunTime.boxToBoolean((boolean)taskInfo.failed())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.boolean2jvalue(BoxesRunTime.unboxToBoolean((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Killed"), (Object)BoxesRunTime.boxToBoolean((boolean)taskInfo.killed())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.boolean2jvalue(BoxesRunTime.unboxToBoolean((Object)x))))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Accumulables"), (Object)this.accumulablesToJson((Iterable<AccumulableInfo>)taskInfo.accumulables())));
    }

    private Set<String> accumulableExcludeList$lzycompute() {
        JsonProtocol$ jsonProtocol$ = this;
        synchronized (jsonProtocol$) {
            if (!this.bitmap$0) {
                this.accumulableExcludeList = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"internal.metrics.updatedBlockStatuses"}));
                this.bitmap$0 = true;
            }
        }
        return this.accumulableExcludeList;
    }

    private Set<String> accumulableExcludeList() {
        return !this.bitmap$0 ? this.accumulableExcludeList$lzycompute() : this.accumulableExcludeList;
    }

    public JsonAST.JArray accumulablesToJson(Iterable<AccumulableInfo> accumulables) {
        return new JsonAST.JArray((List)((List)((TraversableOnce)accumulables.filterNot((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)JsonProtocol$.$anonfun$accumulablesToJson$1(x$7)))).toList().sortBy((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.id()), (Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable & scala.Serializable)accumulableInfo -> MODULE$.accumulableInfoToJson((AccumulableInfo)accumulableInfo), List$.MODULE$.canBuildFrom()));
    }

    public JsonAST.JValue accumulableInfoToJson(AccumulableInfo accumulableInfo) {
        Option<String> name = accumulableInfo.name();
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ID"), (Object)BoxesRunTime.boxToLong((long)accumulableInfo.id())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Name"), name), (Function1 & Serializable & scala.Serializable)opt -> JsonDSL$.MODULE$.option2jvalue(opt, (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Update"), (Object)accumulableInfo.update().map((Function1 & Serializable & scala.Serializable)v -> MODULE$.accumValueToJson(name, v))), (Function1 & Serializable & scala.Serializable)opt -> JsonDSL$.MODULE$.option2jvalue(opt, (Function1)Predef$.MODULE$.$conforms())))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Value"), (Object)accumulableInfo.value().map((Function1 & Serializable & scala.Serializable)v -> MODULE$.accumValueToJson(name, v))), (Function1 & Serializable & scala.Serializable)opt -> JsonDSL$.MODULE$.option2jvalue(opt, (Function1)Predef$.MODULE$.$conforms())))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Internal"), (Object)BoxesRunTime.boxToBoolean((boolean)accumulableInfo.internal())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.boolean2jvalue(BoxesRunTime.unboxToBoolean((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Count Failed Values"), (Object)BoxesRunTime.boxToBoolean((boolean)accumulableInfo.countFailedValues())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.boolean2jvalue(BoxesRunTime.unboxToBoolean((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Metadata"), accumulableInfo.metadata()), (Function1 & Serializable & scala.Serializable)opt -> JsonDSL$.MODULE$.option2jvalue(opt, (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x))));
    }

    public JsonAST.JValue accumValueToJson(Option<String> name, Object value) {
        JsonAST.JString jString;
        if (name.exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.startsWith(InternalAccumulator$.MODULE$.METRICS_PREFIX())))) {
            JsonAST.JInt jInt;
            Object object = value;
            if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                jInt = new JsonAST.JInt(BigInt$.MODULE$.int2bigInt(n));
            } else if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                jInt = new JsonAST.JInt(BigInt$.MODULE$.long2bigInt(l));
            } else if (object instanceof java.util.List) {
                java.util.List list = (java.util.List)object;
                jInt = new JsonAST.JArray((List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).toList().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Object object = x0$1;
                    if (!(object instanceof Tuple2)) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    Tuple2 tuple2 = (Tuple2)object;
                    Object id = tuple2._1();
                    Object status = tuple2._2();
                    if (!(id instanceof BlockId)) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    BlockId blockId = (BlockId)id;
                    if (!(status instanceof BlockStatus)) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    BlockStatus blockStatus = (BlockStatus)status;
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Block ID"), (Object)blockId.toString()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Status"), (Object)MODULE$.blockStatusToJson(blockStatus)), (Function1)Predef$.MODULE$.$conforms())));
                }, List$.MODULE$.canBuildFrom()));
            } else {
                jInt = JsonAST.JNothing$.MODULE$;
            }
            jString = jInt;
        } else {
            jString = new JsonAST.JString(value.toString());
        }
        return jString;
    }

    public JsonAST.JValue taskMetricsToJson(TaskMetrics taskMetrics) {
        JsonAST.JObject shuffleReadMetrics = JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Remote Blocks Fetched"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.shuffleReadMetrics().remoteBlocksFetched())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Local Blocks Fetched"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.shuffleReadMetrics().localBlocksFetched())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Fetch Wait Time"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.shuffleReadMetrics().fetchWaitTime())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Remote Bytes Read"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.shuffleReadMetrics().remoteBytesRead())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Remote Bytes Read To Disk"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.shuffleReadMetrics().remoteBytesReadToDisk())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Local Bytes Read"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.shuffleReadMetrics().localBytesRead())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Total Records Read"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.shuffleReadMetrics().recordsRead())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))));
        JsonAST.JObject shuffleWriteMetrics = JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Shuffle Bytes Written"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.shuffleWriteMetrics().bytesWritten())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Shuffle Write Time"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.shuffleWriteMetrics().writeTime())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Shuffle Records Written"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.shuffleWriteMetrics().recordsWritten())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))));
        JsonAST.JObject inputMetrics = JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Bytes Read"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.inputMetrics().bytesRead())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Records Read"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.inputMetrics().recordsRead())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x)));
        JsonAST.JObject outputMetrics = JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Bytes Written"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.outputMetrics().bytesWritten())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Records Written"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.outputMetrics().recordsWritten())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x)));
        JsonAST.JArray updatedBlocks = new JsonAST.JArray((List)taskMetrics.updatedBlockStatuses().toList().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BlockId id = (BlockId)tuple2._1();
            BlockStatus status = (BlockStatus)tuple2._2();
            JsonAST.JObject jObject = JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Block ID"), (Object)id.toString()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Status"), (Object)MODULE$.blockStatusToJson(status)), (Function1)Predef$.MODULE$.$conforms());
            return jObject;
        }, List$.MODULE$.canBuildFrom()));
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Executor Deserialize Time"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.executorDeserializeTime())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Executor Deserialize CPU Time"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.executorDeserializeCpuTime())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Executor Run Time"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.executorRunTime())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Executor CPU Time"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.executorCpuTime())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Peak Execution Memory"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.peakExecutionMemory())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Result Size"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.resultSize())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"JVM GC Time"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.jvmGCTime())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Result Serialization Time"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.resultSerializationTime())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Memory Bytes Spilled"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.memoryBytesSpilled())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Disk Bytes Spilled"), (Object)BoxesRunTime.boxToLong((long)taskMetrics.diskBytesSpilled())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Shuffle Read Metrics"), (Object)shuffleReadMetrics))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Shuffle Write Metrics"), (Object)shuffleWriteMetrics))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Input Metrics"), (Object)inputMetrics))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Output Metrics"), (Object)outputMetrics))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Updated Blocks"), (Object)updatedBlocks));
    }

    public JsonAST.JValue executorMetricsToJson(ExecutorMetrics executorMetrics) {
        LinkedHashMap metrics = (LinkedHashMap)ExecutorMetricType$.MODULE$.metricToOffset().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String m = (String)tuple2._1();
            Tuple2 tuple22 = JsonAST.JField$.MODULE$.apply(m, JsonDSL$.MODULE$.long2jvalue(executorMetrics.getMetricValue(m)));
            return tuple22;
        }, LinkedHashMap$.MODULE$.canBuildFrom());
        return JsonAST.JObject$.MODULE$.apply(metrics.toSeq());
    }

    public JsonAST.JValue taskEndReasonToJson(TaskEndReason taskEndReason) {
        JsonAST.JObject jObject;
        String reason = Utils$.MODULE$.getFormattedClassName(taskEndReason);
        TaskEndReason taskEndReason2 = taskEndReason;
        if (taskEndReason2 instanceof FetchFailed) {
            FetchFailed fetchFailed = (FetchFailed)taskEndReason2;
            JsonAST.JValue blockManagerAddress = (JsonAST.JValue)Option$.MODULE$.apply((Object)fetchFailed.bmAddress()).map((Function1 & Serializable & scala.Serializable)blockManagerId -> MODULE$.blockManagerIdToJson((BlockManagerId)blockManagerId)).getOrElse((Function0 & Serializable & scala.Serializable)() -> JsonAST.JNothing$.MODULE$);
            jObject = JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Block Manager Address"), (Object)blockManagerAddress), (Function1)Predef$.MODULE$.$conforms()).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Shuffle ID"), (Object)BoxesRunTime.boxToInteger((int)fetchFailed.shuffleId())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Map ID"), (Object)BoxesRunTime.boxToLong((long)fetchFailed.mapId())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Map Index"), (Object)BoxesRunTime.boxToInteger((int)fetchFailed.mapIndex())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Reduce ID"), (Object)BoxesRunTime.boxToInteger((int)fetchFailed.reduceId())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Message"), (Object)fetchFailed.message()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)));
        } else if (taskEndReason2 instanceof ExceptionFailure) {
            ExceptionFailure exceptionFailure = (ExceptionFailure)taskEndReason2;
            JsonAST.JValue stackTrace = this.stackTraceToJson(exceptionFailure.stackTrace());
            JsonAST.JArray accumUpdates = this.accumulablesToJson((Iterable<AccumulableInfo>)exceptionFailure.accumUpdates());
            jObject = JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Class Name"), (Object)exceptionFailure.className()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Description"), (Object)exceptionFailure.description()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Stack Trace"), (Object)stackTrace))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Full Stack Trace"), (Object)exceptionFailure.fullStackTrace()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Accumulator Updates"), (Object)accumUpdates));
        } else if (taskEndReason2 instanceof TaskCommitDenied) {
            TaskCommitDenied taskCommitDenied = (TaskCommitDenied)taskEndReason2;
            jObject = JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Job ID"), (Object)BoxesRunTime.boxToInteger((int)taskCommitDenied.jobID())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Partition ID"), (Object)BoxesRunTime.boxToInteger((int)taskCommitDenied.partitionID())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Attempt Number"), (Object)BoxesRunTime.boxToInteger((int)taskCommitDenied.attemptNumber())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))));
        } else if (taskEndReason2 instanceof ExecutorLostFailure) {
            ExecutorLostFailure executorLostFailure = (ExecutorLostFailure)taskEndReason2;
            String executorId = executorLostFailure.execId();
            boolean exitCausedByApp = executorLostFailure.exitCausedByApp();
            Option<String> reason2 = executorLostFailure.reason();
            jObject = JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Executor ID"), (Object)executorId), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Exit Caused By App"), (Object)BoxesRunTime.boxToBoolean((boolean)exitCausedByApp)), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.boolean2jvalue(BoxesRunTime.unboxToBoolean((Object)x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Loss Reason"), (Object)reason2.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.toString())), (Function1 & Serializable & scala.Serializable)opt -> JsonDSL$.MODULE$.option2jvalue(opt, (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x))));
        } else if (taskEndReason2 instanceof TaskKilled) {
            TaskKilled taskKilled = (TaskKilled)taskEndReason2;
            JsonAST.JArray accumUpdates = new JsonAST.JArray(((TraversableOnce)taskKilled.accumUpdates().map((Function1 & Serializable & scala.Serializable)accumulableInfo -> MODULE$.accumulableInfoToJson((AccumulableInfo)accumulableInfo), Seq$.MODULE$.canBuildFrom())).toList());
            jObject = JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Kill Reason"), (Object)taskKilled.reason()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Accumulator Updates"), (Object)accumUpdates), (Function1)Predef$.MODULE$.$conforms());
        } else {
            jObject = this.emptyJson();
        }
        JsonAST.JObject json = jObject;
        return JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Reason"), (Object)reason), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(json);
    }

    public JsonAST.JValue blockManagerIdToJson(BlockManagerId blockManagerId) {
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Executor ID"), (Object)blockManagerId.executorId()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Host"), (Object)blockManagerId.host()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Port"), (Object)BoxesRunTime.boxToInteger((int)blockManagerId.port())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))));
    }

    public JsonAST.JValue jobResultToJson(JobResult jobResult) {
        JsonAST.JObject jObject;
        String result = Utils$.MODULE$.getFormattedClassName(jobResult);
        JobResult jobResult2 = jobResult;
        if (JobSucceeded$.MODULE$.equals(jobResult2)) {
            jObject = this.emptyJson();
        } else if (jobResult2 instanceof JobFailed) {
            JobFailed jobFailed = (JobFailed)jobResult2;
            jObject = JsonAST.JObject$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Exception"), (Object)this.exceptionToJson(jobFailed.exception()))}));
        } else {
            throw new MatchError((Object)jobResult2);
        }
        JsonAST.JObject json = jObject;
        return JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Result"), (Object)result), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(json);
    }

    public JsonAST.JValue rddInfoToJson(RDDInfo rddInfo) {
        JsonAST.JValue storageLevel = this.storageLevelToJson(rddInfo.storageLevel());
        JsonAST.JArray parentIds = new JsonAST.JArray(((TraversableOnce)rddInfo.parentIds().map((Function1 & Serializable & scala.Serializable)x$11 -> JsonProtocol$.$anonfun$rddInfoToJson$1(BoxesRunTime.unboxToInt((Object)x$11)), Seq$.MODULE$.canBuildFrom())).toList());
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"RDD ID"), (Object)BoxesRunTime.boxToInteger((int)rddInfo.id())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Name"), (Object)rddInfo.name()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Scope"), (Object)rddInfo.scope().map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.toJson())), (Function1 & Serializable & scala.Serializable)opt -> JsonDSL$.MODULE$.option2jvalue(opt, (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Callsite"), (Object)rddInfo.callSite()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Parent IDs"), (Object)parentIds))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Storage Level"), (Object)storageLevel))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Barrier"), (Object)BoxesRunTime.boxToBoolean((boolean)rddInfo.isBarrier())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.boolean2jvalue(BoxesRunTime.unboxToBoolean((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Number of Partitions"), (Object)BoxesRunTime.boxToInteger((int)rddInfo.numPartitions())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Number of Cached Partitions"), (Object)BoxesRunTime.boxToInteger((int)rddInfo.numCachedPartitions())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Memory Size"), (Object)BoxesRunTime.boxToLong((long)rddInfo.memSize())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Disk Size"), (Object)BoxesRunTime.boxToLong((long)rddInfo.diskSize())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))));
    }

    public JsonAST.JValue storageLevelToJson(StorageLevel storageLevel) {
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Use Disk"), (Object)BoxesRunTime.boxToBoolean((boolean)storageLevel.useDisk())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.boolean2jvalue(BoxesRunTime.unboxToBoolean((Object)x))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Use Memory"), (Object)BoxesRunTime.boxToBoolean((boolean)storageLevel.useMemory())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.boolean2jvalue(BoxesRunTime.unboxToBoolean((Object)x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Deserialized"), (Object)BoxesRunTime.boxToBoolean((boolean)storageLevel.deserialized())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.boolean2jvalue(BoxesRunTime.unboxToBoolean((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Replication"), (Object)BoxesRunTime.boxToInteger((int)storageLevel.replication())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))));
    }

    public JsonAST.JValue blockStatusToJson(BlockStatus blockStatus) {
        JsonAST.JValue storageLevel = this.storageLevelToJson(blockStatus.storageLevel());
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Storage Level"), (Object)storageLevel), (Function1)Predef$.MODULE$.$conforms()).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Memory Size"), (Object)BoxesRunTime.boxToLong((long)blockStatus.memSize())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Disk Size"), (Object)BoxesRunTime.boxToLong((long)blockStatus.diskSize())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))));
    }

    public JsonAST.JValue executorInfoToJson(ExecutorInfo executorInfo) {
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Host"), (Object)executorInfo.executorHost()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Total Cores"), (Object)BoxesRunTime.boxToInteger((int)executorInfo.totalCores())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Log Urls"), (Object)this.mapToJson((Map<String, String>)executorInfo.logUrlMap())))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Attributes"), (Object)this.mapToJson((Map<String, String>)executorInfo.attributes())))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Resources"), (Object)this.resourcesMapToJson((Map<String, ResourceInformation>)executorInfo.resourcesInfo())))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Resource Profile Id"), (Object)BoxesRunTime.boxToInteger((int)executorInfo.resourceProfileId())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))));
    }

    public JsonAST.JValue resourcesMapToJson(Map<String, ResourceInformation> m) {
        Map jsonFields = (Map)m.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            ResourceInformation v = (ResourceInformation)tuple2._2();
            Tuple2 tuple22 = JsonAST.JField$.MODULE$.apply(k, v.toJson());
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        return new JsonAST.JObject(jsonFields.toList());
    }

    public JsonAST.JValue blockUpdatedInfoToJson(BlockUpdatedInfo blockUpdatedInfo) {
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Block Manager ID"), (Object)this.blockManagerIdToJson(blockUpdatedInfo.blockManagerId())), (Function1)Predef$.MODULE$.$conforms()).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Block ID"), (Object)blockUpdatedInfo.blockId().toString()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Storage Level"), (Object)this.storageLevelToJson(blockUpdatedInfo.storageLevel())))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Memory Size"), (Object)BoxesRunTime.boxToLong((long)blockUpdatedInfo.memSize())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Disk Size"), (Object)BoxesRunTime.boxToLong((long)blockUpdatedInfo.diskSize())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))));
    }

    public JsonAST.JValue executorResourceRequestToJson(ExecutorResourceRequest execReq) {
        return JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Resource Name"), (Object)execReq.resourceName()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Amount"), (Object)BoxesRunTime.boxToLong((long)execReq.amount())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Discovery Script"), (Object)execReq.discoveryScript()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Vendor"), (Object)execReq.vendor()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)));
    }

    public JsonAST.JValue executorResourceRequestMapToJson(Map<String, ExecutorResourceRequest> m) {
        Map jsonFields = (Map)m.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            ExecutorResourceRequest execReq = (ExecutorResourceRequest)tuple2._2();
            Tuple2 tuple22 = JsonAST.JField$.MODULE$.apply(k, MODULE$.executorResourceRequestToJson(execReq));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        return new JsonAST.JObject(jsonFields.toList());
    }

    public JsonAST.JValue taskResourceRequestToJson(TaskResourceRequest taskReq) {
        return JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Resource Name"), (Object)taskReq.resourceName()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Amount"), (Object)BoxesRunTime.boxToDouble((double)taskReq.amount())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.double2jvalue(BoxesRunTime.unboxToDouble((Object)x)));
    }

    public JsonAST.JValue taskResourceRequestMapToJson(Map<String, TaskResourceRequest> m) {
        Map jsonFields = (Map)m.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            TaskResourceRequest taskReq = (TaskResourceRequest)tuple2._2();
            Tuple2 tuple22 = JsonAST.JField$.MODULE$.apply(k, MODULE$.taskResourceRequestToJson(taskReq));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        return new JsonAST.JObject(jsonFields.toList());
    }

    public JsonAST.JValue mapToJson(Map<String, String> m) {
        Map jsonFields = (Map)m.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Tuple2 tuple22 = JsonAST.JField$.MODULE$.apply(k, (JsonAST.JValue)new JsonAST.JString(v));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        return new JsonAST.JObject(jsonFields.toList());
    }

    public JsonAST.JValue propertiesToJson(Properties properties) {
        return (JsonAST.JValue)Option$.MODULE$.apply((Object)properties).map((Function1 & Serializable & scala.Serializable)p -> MODULE$.mapToJson((Map<String, String>)((Map)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(p).asScala()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> JsonAST.JNothing$.MODULE$);
    }

    public JsonAST.JValue UUIDToJson(UUID id) {
        return JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Least Significant Bits"), (Object)BoxesRunTime.boxToLong((long)id.getLeastSignificantBits())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x))).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Most Significant Bits"), (Object)BoxesRunTime.boxToLong((long)id.getMostSignificantBits())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x)));
    }

    public JsonAST.JValue stackTraceToJson(StackTraceElement[] stackTrace) {
        return new JsonAST.JArray(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stackTrace)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StackTraceElement stackTraceElement = x0$1;
            JsonAST.JObject jObject = JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Declaring Class"), (Object)stackTraceElement.getClassName()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Method Name"), (Object)stackTraceElement.getMethodName()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"File Name"), (Object)stackTraceElement.getFileName()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Line Number"), (Object)BoxesRunTime.boxToInteger((int)stackTraceElement.getLineNumber())), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))));
            return jObject;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(JsonAST.JObject.class))))).toList());
    }

    public JsonAST.JValue exceptionToJson(Exception exception) {
        return JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Message"), (Object)exception.getMessage()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Stack Trace"), (Object)this.stackTraceToJson(exception.getStackTrace())), (Function1)Predef$.MODULE$.$conforms());
    }

    public SparkListenerEvent sparkEventFromJson(JsonAST.JValue json) {
        SparkListenerEvent sparkListenerEvent;
        String string = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Event")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(String.class));
        String string2 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.stageSubmitted();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            sparkListenerEvent = this.stageSubmittedFromJson(json);
        } else {
            String string4 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.stageCompleted();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                sparkListenerEvent = this.stageCompletedFromJson(json);
            } else {
                String string6 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.taskStart();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    sparkListenerEvent = this.taskStartFromJson(json);
                } else {
                    String string8 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.taskGettingResult();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        sparkListenerEvent = this.taskGettingResultFromJson(json);
                    } else {
                        String string10 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.taskEnd();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            sparkListenerEvent = this.taskEndFromJson(json);
                        } else {
                            String string12 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.jobStart();
                            String string13 = string;
                            if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                                sparkListenerEvent = this.jobStartFromJson(json);
                            } else {
                                String string14 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.jobEnd();
                                String string15 = string;
                                if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                                    sparkListenerEvent = this.jobEndFromJson(json);
                                } else {
                                    String string16 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.environmentUpdate();
                                    String string17 = string;
                                    if (!(string16 != null ? !string16.equals(string17) : string17 != null)) {
                                        sparkListenerEvent = this.environmentUpdateFromJson(json);
                                    } else {
                                        String string18 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.blockManagerAdded();
                                        String string19 = string;
                                        if (!(string18 != null ? !string18.equals(string19) : string19 != null)) {
                                            sparkListenerEvent = this.blockManagerAddedFromJson(json);
                                        } else {
                                            String string20 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.blockManagerRemoved();
                                            String string21 = string;
                                            if (!(string20 != null ? !string20.equals(string21) : string21 != null)) {
                                                sparkListenerEvent = this.blockManagerRemovedFromJson(json);
                                            } else {
                                                String string22 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.unpersistRDD();
                                                String string23 = string;
                                                if (!(string22 != null ? !string22.equals(string23) : string23 != null)) {
                                                    sparkListenerEvent = this.unpersistRDDFromJson(json);
                                                } else {
                                                    String string24 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.applicationStart();
                                                    String string25 = string;
                                                    if (!(string24 != null ? !string24.equals(string25) : string25 != null)) {
                                                        sparkListenerEvent = this.applicationStartFromJson(json);
                                                    } else {
                                                        String string26 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.applicationEnd();
                                                        String string27 = string;
                                                        if (!(string26 != null ? !string26.equals(string27) : string27 != null)) {
                                                            sparkListenerEvent = this.applicationEndFromJson(json);
                                                        } else {
                                                            String string28 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.executorAdded();
                                                            String string29 = string;
                                                            if (!(string28 != null ? !string28.equals(string29) : string29 != null)) {
                                                                sparkListenerEvent = this.executorAddedFromJson(json);
                                                            } else {
                                                                String string30 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.executorRemoved();
                                                                String string31 = string;
                                                                if (!(string30 != null ? !string30.equals(string31) : string31 != null)) {
                                                                    sparkListenerEvent = this.executorRemovedFromJson(json);
                                                                } else {
                                                                    String string32 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.logStart();
                                                                    String string33 = string;
                                                                    if (!(string32 != null ? !string32.equals(string33) : string33 != null)) {
                                                                        sparkListenerEvent = this.logStartFromJson(json);
                                                                    } else {
                                                                        String string34 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.metricsUpdate();
                                                                        String string35 = string;
                                                                        if (!(string34 != null ? !string34.equals(string35) : string35 != null)) {
                                                                            sparkListenerEvent = this.executorMetricsUpdateFromJson(json);
                                                                        } else {
                                                                            String string36 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.stageExecutorMetrics();
                                                                            String string37 = string;
                                                                            if (!(string36 != null ? !string36.equals(string37) : string37 != null)) {
                                                                                sparkListenerEvent = this.stageExecutorMetricsFromJson(json);
                                                                            } else {
                                                                                String string38 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.blockUpdate();
                                                                                String string39 = string;
                                                                                if (!(string38 != null ? !string38.equals(string39) : string39 != null)) {
                                                                                    sparkListenerEvent = this.blockUpdateFromJson(json);
                                                                                } else {
                                                                                    String string40 = JsonProtocol$SPARK_LISTENER_EVENT_FORMATTED_CLASS_NAMES$.MODULE$.resourceProfileAdded();
                                                                                    String string41 = string;
                                                                                    sparkListenerEvent = !(string40 != null ? !string40.equals(string41) : string41 != null) ? this.resourceProfileAddedFromJson(json) : (SparkListenerEvent)this.mapper().readValue(JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(json, (Formats)this.format())), Utils$.MODULE$.classForName(string, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()));
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return sparkListenerEvent;
    }

    public SparkListenerStageSubmitted stageSubmittedFromJson(JsonAST.JValue json) {
        StageInfo stageInfo = this.stageInfoFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Stage Info"));
        Properties properties = this.propertiesFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Properties"));
        return new SparkListenerStageSubmitted(stageInfo, properties);
    }

    public SparkListenerStageCompleted stageCompletedFromJson(JsonAST.JValue json) {
        StageInfo stageInfo = this.stageInfoFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Stage Info"));
        return new SparkListenerStageCompleted(stageInfo);
    }

    public SparkListenerTaskStart taskStartFromJson(JsonAST.JValue json) {
        int stageId = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Stage ID")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
        int stageAttemptId = BoxesRunTime.unboxToInt((Object)this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Stage Attempt ID")).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)JsonProtocol$.$anonfun$taskStartFromJson$1(x$13))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        TaskInfo taskInfo = this.taskInfoFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Task Info"));
        return new SparkListenerTaskStart(stageId, stageAttemptId, taskInfo);
    }

    public SparkListenerTaskGettingResult taskGettingResultFromJson(JsonAST.JValue json) {
        TaskInfo taskInfo = this.taskInfoFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Task Info"));
        return new SparkListenerTaskGettingResult(taskInfo);
    }

    public ExecutorMetrics executorMetricsFromJson(JsonAST.JValue json) {
        LinkedHashMap metrics = (LinkedHashMap)ExecutorMetricType$.MODULE$.metricToOffset().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String metric = (String)tuple2._1();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)metric), MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash(metric)).map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$executorMetricsFromJson$2(x$14))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            return tuple22;
        }, LinkedHashMap$.MODULE$.canBuildFrom());
        return new ExecutorMetrics((scala.collection.immutable.Map<String, Object>)metrics.toMap(Predef$.MODULE$.$conforms()));
    }

    public SparkListenerTaskEnd taskEndFromJson(JsonAST.JValue json) {
        int stageId = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Stage ID")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
        int stageAttemptId = BoxesRunTime.unboxToInt((Object)this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Stage Attempt ID")).map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)JsonProtocol$.$anonfun$taskEndFromJson$1(x$15))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        String taskType = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Task Type")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(String.class));
        TaskEndReason taskEndReason = this.taskEndReasonFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Task End Reason"));
        TaskInfo taskInfo = this.taskInfoFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Task Info"));
        ExecutorMetrics executorMetrics = this.executorMetricsFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Task Executor Metrics"));
        TaskMetrics taskMetrics = this.taskMetricsFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Task Metrics"));
        return new SparkListenerTaskEnd(stageId, stageAttemptId, taskType, taskEndReason, taskInfo, executorMetrics, taskMetrics);
    }

    public SparkListenerJobStart jobStartFromJson(JsonAST.JValue json) {
        int jobId = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Job ID")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
        long submissionTime = BoxesRunTime.unboxToLong((Object)this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Submission Time")).map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$jobStartFromJson$1(x$16))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
        List stageIds = (List)((List)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Stage IDs")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(JsonAST.JValue.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)JsonProtocol$.$anonfun$jobStartFromJson$3(x$17)), List$.MODULE$.canBuildFrom());
        Properties properties = this.propertiesFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Properties"));
        Seq stageInfos = (Seq)this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Stage Infos")).map((Function1 & Serializable & scala.Serializable)x$18 -> (Seq)((TraversableLike)org.json4s.package$.MODULE$.jvalue2extractable(x$18).extract((Formats)MODULE$.format(), ManifestFactory$.MODULE$.classType(Seq.class, ManifestFactory$.MODULE$.classType(JsonAST.JValue.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).map((Function1 & Serializable & scala.Serializable)json -> MODULE$.stageInfoFromJson((JsonAST.JValue)json), Seq$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (List)stageIds.map((Function1 & Serializable & scala.Serializable)id -> JsonProtocol$.$anonfun$jobStartFromJson$7(BoxesRunTime.unboxToInt((Object)id)), List$.MODULE$.canBuildFrom()));
        return new SparkListenerJobStart(jobId, submissionTime, (Seq<StageInfo>)stageInfos, properties);
    }

    public SparkListenerJobEnd jobEndFromJson(JsonAST.JValue json) {
        int jobId = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Job ID")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
        long completionTime = BoxesRunTime.unboxToLong((Object)this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Completion Time")).map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$jobEndFromJson$1(x$19))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
        JobResult jobResult = this.jobResultFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Job Result"));
        return new SparkListenerJobEnd(jobId, completionTime, jobResult);
    }

    public SparkListenerResourceProfileAdded resourceProfileAddedFromJson(JsonAST.JValue json) {
        int profId = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Resource Profile Id")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
        Map<String, ExecutorResourceRequest> executorReqs = this.executorResourceRequestMapFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Executor Resource Requests"));
        Map<String, TaskResourceRequest> taskReqs = this.taskResourceRequestMapFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Task Resource Requests"));
        ResourceProfile rp = new ResourceProfile((scala.collection.immutable.Map<String, ExecutorResourceRequest>)executorReqs.toMap(Predef$.MODULE$.$conforms()), (scala.collection.immutable.Map<String, TaskResourceRequest>)taskReqs.toMap(Predef$.MODULE$.$conforms()));
        rp.setResourceProfileId(profId);
        return new SparkListenerResourceProfileAdded(rp);
    }

    public ExecutorResourceRequest executorResourceRequestFromJson(JsonAST.JValue json) {
        String rName = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Resource Name")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(String.class));
        int amount = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Amount")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
        String discoveryScript = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Discovery Script")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(String.class));
        String vendor = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Vendor")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(String.class));
        return new ExecutorResourceRequest(rName, amount, discoveryScript, vendor);
    }

    public TaskResourceRequest taskResourceRequestFromJson(JsonAST.JValue json) {
        String rName = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Resource Name")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(String.class));
        int amount = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Amount")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
        return new TaskResourceRequest(rName, amount);
    }

    public Map<String, TaskResourceRequest> taskResourceRequestMapFromJson(JsonAST.JValue json) {
        List jsonFields = ((JsonAST.JObject)json).obj();
        return ((TraversableOnce)jsonFields.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<String, JsonAST.JValue>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Tuple2 tuple2 = JsonAST.JField$.MODULE$.unapply(A1);
                if (!JsonAST.JField$.OptionStringJValue$.MODULE$.isEmpty$extension(tuple2)) {
                    String k = (String)tuple2._1();
                    JsonAST.JValue v = (JsonAST.JValue)tuple2._2();
                    TaskResourceRequest req = JsonProtocol$.MODULE$.taskResourceRequestFromJson(v);
                    object = new Tuple2((Object)k, (Object)req);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<String, JsonAST.JValue> x1) {
                Tuple2<String, JsonAST.JValue> tuple2 = x1;
                Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
                boolean bl = !JsonAST.JField$.OptionStringJValue$.MODULE$.isEmpty$extension(tuple22);
                return bl;
            }
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, ExecutorResourceRequest> executorResourceRequestMapFromJson(JsonAST.JValue json) {
        List jsonFields = ((JsonAST.JObject)json).obj();
        return ((TraversableOnce)jsonFields.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<String, JsonAST.JValue>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Tuple2 tuple2 = JsonAST.JField$.MODULE$.unapply(A1);
                if (!JsonAST.JField$.OptionStringJValue$.MODULE$.isEmpty$extension(tuple2)) {
                    String k = (String)tuple2._1();
                    JsonAST.JValue v = (JsonAST.JValue)tuple2._2();
                    ExecutorResourceRequest req = JsonProtocol$.MODULE$.executorResourceRequestFromJson(v);
                    object = new Tuple2((Object)k, (Object)req);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<String, JsonAST.JValue> x1) {
                Tuple2<String, JsonAST.JValue> tuple2 = x1;
                Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
                boolean bl = !JsonAST.JField$.OptionStringJValue$.MODULE$.isEmpty$extension(tuple22);
                return bl;
            }
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public SparkListenerEnvironmentUpdate environmentUpdateFromJson(JsonAST.JValue json) {
        Seq hadoopProperties = (Seq)this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Hadoop Properties")).map((Function1 & Serializable & scala.Serializable)x$20 -> MODULE$.mapFromJson((JsonAST.JValue)x$20).toSeq()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
        Map environmentDetails = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"JVM Information"), (Object)this.mapFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("JVM Information")).toSeq()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Spark Properties"), (Object)this.mapFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Spark Properties")).toSeq()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Hadoop Properties"), (Object)hadoopProperties), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"System Properties"), (Object)this.mapFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("System Properties")).toSeq()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Classpath Entries"), (Object)this.mapFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Classpath Entries")).toSeq())}));
        return new SparkListenerEnvironmentUpdate((Map<String, Seq<Tuple2<String, String>>>)environmentDetails);
    }

    public SparkListenerBlockManagerAdded blockManagerAddedFromJson(JsonAST.JValue json) {
        BlockManagerId blockManagerId = this.blockManagerIdFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Block Manager ID"));
        long maxMem = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Maximum Memory")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        long time = BoxesRunTime.unboxToLong((Object)this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Timestamp")).map((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$blockManagerAddedFromJson$1(x$21))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
        Option maxOnHeapMem = this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Maximum Onheap Memory")).map((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$blockManagerAddedFromJson$3(x$22)));
        Option maxOffHeapMem = this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Maximum Offheap Memory")).map((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$blockManagerAddedFromJson$4(x$23)));
        return new SparkListenerBlockManagerAdded(time, blockManagerId, maxMem, (Option<Object>)maxOnHeapMem, (Option<Object>)maxOffHeapMem);
    }

    public SparkListenerBlockManagerRemoved blockManagerRemovedFromJson(JsonAST.JValue json) {
        BlockManagerId blockManagerId = this.blockManagerIdFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Block Manager ID"));
        long time = BoxesRunTime.unboxToLong((Object)this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Timestamp")).map((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$blockManagerRemovedFromJson$1(x$24))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
        return new SparkListenerBlockManagerRemoved(time, blockManagerId);
    }

    public SparkListenerUnpersistRDD unpersistRDDFromJson(JsonAST.JValue json) {
        return new SparkListenerUnpersistRDD(BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("RDD ID")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Int())));
    }

    public SparkListenerApplicationStart applicationStartFromJson(JsonAST.JValue json2) {
        String appName = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("App Name")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(String.class));
        Option appId = this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("App ID")).map((Function1 & Serializable & scala.Serializable)x$25 -> (String)org.json4s.package$.MODULE$.jvalue2extractable(x$25).extract((Formats)MODULE$.format(), ManifestFactory$.MODULE$.classType(String.class)));
        long time = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("Timestamp")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        String sparkUser = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("User")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(String.class));
        Option appAttemptId = this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("App Attempt ID")).map((Function1 & Serializable & scala.Serializable)x$26 -> (String)org.json4s.package$.MODULE$.jvalue2extractable(x$26).extract((Formats)MODULE$.format(), ManifestFactory$.MODULE$.classType(String.class)));
        Option driverLogs = this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("Driver Logs")).map((Function1 & Serializable & scala.Serializable)json -> MODULE$.mapFromJson((JsonAST.JValue)json));
        Option driverAttributes = this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("Driver Attributes")).map((Function1 & Serializable & scala.Serializable)json -> MODULE$.mapFromJson((JsonAST.JValue)json));
        return new SparkListenerApplicationStart(appName, (Option<String>)appId, time, sparkUser, (Option<String>)appAttemptId, (Option<Map<String, String>>)driverLogs, (Option<Map<String, String>>)driverAttributes);
    }

    public SparkListenerApplicationEnd applicationEndFromJson(JsonAST.JValue json) {
        return new SparkListenerApplicationEnd(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Timestamp")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Long())));
    }

    public SparkListenerExecutorAdded executorAddedFromJson(JsonAST.JValue json) {
        long time = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Timestamp")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        String executorId = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Executor ID")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(String.class));
        ExecutorInfo executorInfo = this.executorInfoFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Executor Info"));
        return new SparkListenerExecutorAdded(time, executorId, executorInfo);
    }

    public SparkListenerExecutorRemoved executorRemovedFromJson(JsonAST.JValue json) {
        long time = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Timestamp")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        String executorId = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Executor ID")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(String.class));
        String reason = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Removed Reason")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(String.class));
        return new SparkListenerExecutorRemoved(time, executorId, reason);
    }

    public SparkListenerLogStart logStartFromJson(JsonAST.JValue json) {
        String sparkVersion = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Spark Version")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(String.class));
        return new SparkListenerLogStart(sparkVersion);
    }

    public SparkListenerExecutorMetricsUpdate executorMetricsUpdateFromJson(JsonAST.JValue json3) {
        scala.collection.immutable.Map map;
        String execInfo = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json3).$bslash("Executor ID")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(String.class));
        List accumUpdates = (List)((List)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json3).$bslash("Metrics Updated")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(JsonAST.JValue.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).map((Function1 & Serializable & scala.Serializable)json2 -> {
            long taskId = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("Task ID")).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
            int stageId = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("Stage ID")).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
            int stageAttemptId = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("Stage Attempt ID")).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
            List updates = (List)((List)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("Accumulator Updates")).extract((Formats)MODULE$.format(), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(JsonAST.JValue.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).map((Function1 & Serializable & scala.Serializable)json -> MODULE$.accumulableInfoFromJson((JsonAST.JValue)json), List$.MODULE$.canBuildFrom());
            return new Tuple4((Object)BoxesRunTime.boxToLong((long)taskId), (Object)BoxesRunTime.boxToInteger((int)stageId), (Object)BoxesRunTime.boxToInteger((int)stageAttemptId), (Object)updates);
        }, List$.MODULE$.canBuildFrom());
        JsonAST.JValue jValue = org.json4s.package$.MODULE$.jvalue2monadic(json3).$bslash("Executor Metrics Updated");
        if (JsonAST.JNothing$.MODULE$.equals(jValue)) {
            map = Map$.MODULE$.empty();
        } else if (jValue != null) {
            JsonAST.JValue jValue2 = jValue;
            map = ((TraversableOnce)((List)org.json4s.package$.MODULE$.jvalue2extractable(jValue2).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(JsonAST.JValue.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).map((Function1 & Serializable & scala.Serializable)json -> {
                int stageId = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Stage ID")).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
                int stageAttemptId = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Stage Attempt ID")).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
                ExecutorMetrics executorMetrics = MODULE$.executorMetricsFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Executor Metrics"));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(stageId, stageAttemptId)), (Object)executorMetrics);
            }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        } else {
            throw new MatchError((Object)jValue);
        }
        scala.collection.immutable.Map executorUpdates = map;
        return new SparkListenerExecutorMetricsUpdate(execInfo, (Seq<Tuple4<Object, Object, Object, Seq<AccumulableInfo>>>)accumUpdates, (Map<Tuple2<Object, Object>, ExecutorMetrics>)executorUpdates);
    }

    public SparkListenerStageExecutorMetrics stageExecutorMetricsFromJson(JsonAST.JValue json) {
        String execId = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Executor ID")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(String.class));
        int stageId = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Stage ID")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
        int stageAttemptId = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Stage Attempt ID")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
        ExecutorMetrics executorMetrics = this.executorMetricsFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Executor Metrics"));
        return new SparkListenerStageExecutorMetrics(execId, stageId, stageAttemptId, executorMetrics);
    }

    public SparkListenerBlockUpdated blockUpdateFromJson(JsonAST.JValue json) {
        BlockUpdatedInfo blockUpdatedInfo = this.blockUpdatedInfoFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Block Updated Info"));
        return new SparkListenerBlockUpdated(blockUpdatedInfo);
    }

    public StageInfo stageInfoFromJson(JsonAST.JValue json2) {
        Seq seq;
        int stageId = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("Stage ID")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
        int attemptId = BoxesRunTime.unboxToInt((Object)this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("Stage Attempt ID")).map((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToInteger((int)JsonProtocol$.$anonfun$stageInfoFromJson$1(x$27))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        String stageName = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("Stage Name")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(String.class));
        int numTasks = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("Number of Tasks")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
        List rddInfos = (List)((List)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("RDD Info")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(JsonAST.JValue.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).map((Function1 & Serializable & scala.Serializable)json -> MODULE$.rddInfoFromJson((JsonAST.JValue)json), List$.MODULE$.canBuildFrom());
        Seq parentIds = (Seq)this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("Parent IDs")).map((Function1 & Serializable & scala.Serializable)l -> (List)((List)org.json4s.package$.MODULE$.jvalue2extractable(l).extract((Formats)MODULE$.format(), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(JsonAST.JValue.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).map((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToInteger((int)JsonProtocol$.$anonfun$stageInfoFromJson$5(x$28)), List$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
        String details = (String)this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("Details")).map((Function1 & Serializable & scala.Serializable)x$29 -> (String)org.json4s.package$.MODULE$.jvalue2extractable(x$29).extract((Formats)MODULE$.format(), ManifestFactory$.MODULE$.classType(String.class))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        Option submissionTime = this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("Submission Time")).map((Function1 & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$stageInfoFromJson$9(x$30)));
        Option completionTime = this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("Completion Time")).map((Function1 & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$stageInfoFromJson$10(x$31)));
        Option failureReason = this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("Failure Reason")).map((Function1 & Serializable & scala.Serializable)x$32 -> (String)org.json4s.package$.MODULE$.jvalue2extractable(x$32).extract((Formats)MODULE$.format(), ManifestFactory$.MODULE$.classType(String.class)));
        Option option = this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("Accumulables")).map((Function1 & Serializable & scala.Serializable)x$33 -> (List)org.json4s.package$.MODULE$.jvalue2extractable(x$33).extract((Formats)MODULE$.format(), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(JsonAST.JValue.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0]))));
        if (option instanceof Some) {
            Some some = (Some)option;
            List values = (List)some.value();
            seq = (Seq)values.map((Function1 & Serializable & scala.Serializable)json -> MODULE$.accumulableInfoFromJson((JsonAST.JValue)json), List$.MODULE$.canBuildFrom());
        } else if (None$.MODULE$.equals(option)) {
            seq = (Seq)Seq$.MODULE$.empty();
        } else {
            throw new MatchError((Object)option);
        }
        Seq accumulatedValues = seq;
        Option rpId = this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("Resource Profile Id")).map((Function1 & Serializable & scala.Serializable)x$34 -> BoxesRunTime.boxToInteger((int)JsonProtocol$.$anonfun$stageInfoFromJson$14(x$34)));
        int stageProf = BoxesRunTime.unboxToInt((Object)rpId.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID()));
        int x$1 = stageId;
        int x$2 = attemptId;
        String x$3 = stageName;
        int x$4 = numTasks;
        List x$5 = rddInfos;
        Seq x$6 = parentIds;
        String x$7 = details;
        int x$8 = stageProf;
        TaskMetrics x$9 = StageInfo$.MODULE$.$lessinit$greater$default$8();
        Seq<Seq<TaskLocation>> x$10 = StageInfo$.MODULE$.$lessinit$greater$default$9();
        Option<Object> x$11 = StageInfo$.MODULE$.$lessinit$greater$default$10();
        StageInfo stageInfo = new StageInfo(x$1, x$2, x$3, x$4, (Seq<RDDInfo>)x$5, (Seq<Object>)x$6, x$7, x$9, x$10, x$11, x$8);
        stageInfo.submissionTime_$eq((Option<Object>)submissionTime);
        stageInfo.completionTime_$eq((Option<Object>)completionTime);
        stageInfo.failureReason_$eq((Option<String>)failureReason);
        accumulatedValues.foreach((Function1 & Serializable & scala.Serializable)accInfo -> {
            JsonProtocol$.$anonfun$stageInfoFromJson$16(stageInfo, accInfo);
            return BoxedUnit.UNIT;
        });
        return stageInfo;
    }

    public TaskInfo taskInfoFromJson(JsonAST.JValue json2) {
        Seq seq;
        long taskId = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("Task ID")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        int index = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("Index")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
        int attempt = BoxesRunTime.unboxToInt((Object)this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("Attempt")).map((Function1 & Serializable & scala.Serializable)x$35 -> BoxesRunTime.boxToInteger((int)JsonProtocol$.$anonfun$taskInfoFromJson$1(x$35))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1));
        long launchTime = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("Launch Time")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        String executorId = ((String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("Executor ID")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(String.class))).intern();
        String host = ((String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("Host")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(String.class))).intern();
        Enumeration.Value taskLocality = TaskLocality$.MODULE$.withName((String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("Locality")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(String.class)));
        boolean speculative = this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("Speculative")).exists((Function1 & Serializable & scala.Serializable)x$36 -> BoxesRunTime.boxToBoolean((boolean)JsonProtocol$.$anonfun$taskInfoFromJson$3(x$36)));
        long gettingResultTime = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("Getting Result Time")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        long finishTime = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("Finish Time")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        boolean failed = BoxesRunTime.unboxToBoolean((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("Failed")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Boolean()));
        boolean killed = this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("Killed")).exists((Function1 & Serializable & scala.Serializable)x$37 -> BoxesRunTime.boxToBoolean((boolean)JsonProtocol$.$anonfun$taskInfoFromJson$4(x$37)));
        Option option = this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json2).$bslash("Accumulables")).map((Function1 & Serializable & scala.Serializable)x$38 -> (Seq)org.json4s.package$.MODULE$.jvalue2extractable(x$38).extract((Formats)MODULE$.format(), ManifestFactory$.MODULE$.classType(Seq.class, ManifestFactory$.MODULE$.classType(JsonAST.JValue.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0]))));
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq values = (Seq)some.value();
            seq = (Seq)values.map((Function1 & Serializable & scala.Serializable)json -> MODULE$.accumulableInfoFromJson((JsonAST.JValue)json), Seq$.MODULE$.canBuildFrom());
        } else if (None$.MODULE$.equals(option)) {
            seq = (Seq)Seq$.MODULE$.empty();
        } else {
            throw new MatchError((Object)option);
        }
        Seq accumulables = seq;
        TaskInfo taskInfo = new TaskInfo(taskId, index, attempt, launchTime, executorId, host, taskLocality, speculative);
        taskInfo.gettingResultTime_$eq(gettingResultTime);
        taskInfo.finishTime_$eq(finishTime);
        taskInfo.failed_$eq(failed);
        taskInfo.killed_$eq(killed);
        taskInfo.setAccumulables((Seq<AccumulableInfo>)accumulables);
        return taskInfo;
    }

    public AccumulableInfo accumulableInfoFromJson(JsonAST.JValue json) {
        long id = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("ID")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        Option name = this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Name")).map((Function1 & Serializable & scala.Serializable)x$39 -> (String)org.json4s.package$.MODULE$.jvalue2extractable(x$39).extract((Formats)MODULE$.format(), ManifestFactory$.MODULE$.classType(String.class)));
        Option update = this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Update")).map((Function1 & Serializable & scala.Serializable)v -> MODULE$.accumValueFromJson((Option<String>)name, (JsonAST.JValue)v));
        Option value = this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Value")).map((Function1 & Serializable & scala.Serializable)v -> MODULE$.accumValueFromJson((Option<String>)name, (JsonAST.JValue)v));
        boolean internal = this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Internal")).exists((Function1 & Serializable & scala.Serializable)x$40 -> BoxesRunTime.boxToBoolean((boolean)JsonProtocol$.$anonfun$accumulableInfoFromJson$4(x$40)));
        boolean countFailedValues = this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Count Failed Values")).exists((Function1 & Serializable & scala.Serializable)x$41 -> BoxesRunTime.boxToBoolean((boolean)JsonProtocol$.$anonfun$accumulableInfoFromJson$5(x$41)));
        Option metadata = this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Metadata")).map((Function1 & Serializable & scala.Serializable)x$42 -> (String)org.json4s.package$.MODULE$.jvalue2extractable(x$42).extract((Formats)MODULE$.format(), ManifestFactory$.MODULE$.classType(String.class)));
        return new AccumulableInfo(id, (Option<String>)name, (Option<Object>)update, (Option<Object>)value, internal, countFailedValues, (Option<String>)metadata);
    }

    public Object accumValueFromJson(Option<String> name, JsonAST.JValue value) {
        Object object;
        if (name.exists((Function1 & Serializable & scala.Serializable)x$43 -> BoxesRunTime.boxToBoolean((boolean)x$43.startsWith(InternalAccumulator$.MODULE$.METRICS_PREFIX())))) {
            Object object2;
            JsonAST.JValue jValue = value;
            if (jValue instanceof JsonAST.JInt) {
                JsonAST.JInt jInt = (JsonAST.JInt)jValue;
                BigInt v = jInt.num();
                object2 = BoxesRunTime.boxToLong((long)v.toLong());
            } else if (jValue instanceof JsonAST.JArray) {
                JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                List v = jArray.arr();
                object2 = JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)v.map((Function1 & Serializable & scala.Serializable)blockJson -> {
                    BlockId id = BlockId$.MODULE$.apply((String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(blockJson).$bslash("Block ID")).extract((Formats)MODULE$.format(), ManifestFactory$.MODULE$.classType(String.class)));
                    BlockStatus status = MODULE$.blockStatusFromJson(org.json4s.package$.MODULE$.jvalue2monadic(blockJson).$bslash("Status"));
                    return new Tuple2((Object)id, (Object)status);
                }, List$.MODULE$.canBuildFrom())).asJava();
            } else {
                throw new IllegalArgumentException(new StringBuilder(39).append("unexpected json value ").append(value).append(" for ").append("accumulator ").append(name.get()).toString());
            }
            object = object2;
        } else {
            object = org.json4s.package$.MODULE$.jvalue2extractable(value).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(String.class));
        }
        return object;
    }

    public TaskMetrics taskMetricsFromJson(JsonAST.JValue json) {
        TaskMetrics metrics = TaskMetrics$.MODULE$.empty();
        JsonAST.JValue jValue = json;
        JsonAST.JNothing$ jNothing$ = JsonAST.JNothing$.MODULE$;
        if (!(jValue != null ? !jValue.equals(jNothing$) : jNothing$ != null)) {
            return metrics;
        }
        metrics.setExecutorDeserializeTime(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Executor Deserialize Time")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Long())));
        JsonAST.JValue jValue2 = org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Executor Deserialize CPU Time");
        long l = JsonAST.JNothing$.MODULE$.equals(jValue2) ? 0L : BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(jValue2).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        metrics.setExecutorDeserializeCpuTime(l);
        metrics.setExecutorRunTime(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Executor Run Time")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Long())));
        JsonAST.JValue jValue3 = org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Executor CPU Time");
        long l2 = JsonAST.JNothing$.MODULE$.equals(jValue3) ? 0L : BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(jValue3).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        metrics.setExecutorCpuTime(l2);
        JsonAST.JValue jValue4 = org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Peak Execution Memory");
        long l3 = JsonAST.JNothing$.MODULE$.equals(jValue4) ? 0L : BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(jValue4).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        metrics.setPeakExecutionMemory(l3);
        metrics.setResultSize(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Result Size")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Long())));
        metrics.setJvmGCTime(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("JVM GC Time")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Long())));
        metrics.setResultSerializationTime(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Result Serialization Time")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Long())));
        metrics.incMemoryBytesSpilled(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Memory Bytes Spilled")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Long())));
        metrics.incDiskBytesSpilled(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Disk Bytes Spilled")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Long())));
        this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Shuffle Read Metrics")).foreach((Function1 & Serializable & scala.Serializable)readJson -> {
            JsonProtocol$.$anonfun$taskMetricsFromJson$1(metrics, readJson);
            return BoxedUnit.UNIT;
        });
        this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Shuffle Write Metrics")).foreach((Function1 & Serializable & scala.Serializable)writeJson -> {
            JsonProtocol$.$anonfun$taskMetricsFromJson$7(metrics, writeJson);
            return BoxedUnit.UNIT;
        });
        this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Output Metrics")).foreach((Function1 & Serializable & scala.Serializable)outJson -> {
            JsonProtocol$.$anonfun$taskMetricsFromJson$10(metrics, outJson);
            return BoxedUnit.UNIT;
        });
        this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Input Metrics")).foreach((Function1 & Serializable & scala.Serializable)inJson -> {
            JsonProtocol$.$anonfun$taskMetricsFromJson$13(metrics, inJson);
            return BoxedUnit.UNIT;
        });
        this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Updated Blocks")).foreach((Function1 & Serializable & scala.Serializable)blocksJson -> {
            metrics.setUpdatedBlockStatuses((Seq<Tuple2<BlockId, BlockStatus>>)((Seq)((List)org.json4s.package$.MODULE$.jvalue2extractable(blocksJson).extract((Formats)JsonProtocol$.MODULE$.format(), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(JsonAST.JValue.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).map((Function1 & Serializable & scala.Serializable)blockJson -> {
                BlockId id = BlockId$.MODULE$.apply((String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(blockJson).$bslash("Block ID")).extract((Formats)JsonProtocol$.MODULE$.format(), ManifestFactory$.MODULE$.classType(String.class)));
                BlockStatus status = JsonProtocol$.MODULE$.blockStatusFromJson(org.json4s.package$.MODULE$.jvalue2monadic(blockJson).$bslash("Status"));
                return new Tuple2((Object)id, (Object)status);
            }, List$.MODULE$.canBuildFrom())));
            return BoxedUnit.UNIT;
        });
        return metrics;
    }

    public TaskEndReason taskEndReasonFromJson(JsonAST.JValue json) {
        Product product;
        String string = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Reason")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(String.class));
        String string2 = JsonProtocol$TASK_END_REASON_FORMATTED_CLASS_NAMES$.MODULE$.success();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            product = Success$.MODULE$;
        } else {
            String string4 = JsonProtocol$TASK_END_REASON_FORMATTED_CLASS_NAMES$.MODULE$.resubmitted();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                product = Resubmitted$.MODULE$;
            } else {
                String string6 = JsonProtocol$TASK_END_REASON_FORMATTED_CLASS_NAMES$.MODULE$.fetchFailed();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    BlockManagerId blockManagerAddress = this.blockManagerIdFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Block Manager Address"));
                    int shuffleId = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Shuffle ID")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
                    long mapId = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Map ID")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
                    JsonAST.JValue jValue = org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Map Index");
                    int n = JsonAST.JNothing$.MODULE$.equals(jValue) ? Integer.MIN_VALUE : BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(jValue).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
                    int mapIndex = n;
                    int reduceId = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Reduce ID")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
                    Option message = this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Message")).map((Function1 & Serializable & scala.Serializable)x$49 -> (String)org.json4s.package$.MODULE$.jvalue2extractable(x$49).extract((Formats)MODULE$.format(), ManifestFactory$.MODULE$.classType(String.class)));
                    product = new FetchFailed(blockManagerAddress, shuffleId, mapId, mapIndex, reduceId, (String)message.getOrElse((Function0 & Serializable & scala.Serializable)() -> "Unknown reason"));
                } else {
                    String string8 = JsonProtocol$TASK_END_REASON_FORMATTED_CLASS_NAMES$.MODULE$.exceptionFailure();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        String className = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Class Name")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(String.class));
                        String description = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Description")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(String.class));
                        StackTraceElement[] stackTrace = this.stackTraceFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Stack Trace"));
                        String fullStackTrace = (String)this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Full Stack Trace")).map((Function1 & Serializable & scala.Serializable)x$50 -> (String)org.json4s.package$.MODULE$.jvalue2extractable(x$50).extract((Formats)MODULE$.format(), ManifestFactory$.MODULE$.classType(String.class))).orNull(Predef$.MODULE$.$conforms());
                        Seq accumUpdates = (Seq)this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Accumulator Updates")).map((Function1 & Serializable & scala.Serializable)x$51 -> (List)((List)org.json4s.package$.MODULE$.jvalue2extractable(x$51).extract((Formats)MODULE$.format(), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(JsonAST.JValue.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).map((Function1 & Serializable & scala.Serializable)json -> MODULE$.accumulableInfoFromJson((JsonAST.JValue)json), List$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)MODULE$.taskMetricsFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Metrics")).accumulators().map((Function1 & Serializable & scala.Serializable)acc -> acc.toInfo((Option<Object>)new Some(acc.value()), (Option<Object>)None$.MODULE$), Seq$.MODULE$.canBuildFrom()));
                        product = new ExceptionFailure(className, description, stackTrace, fullStackTrace, (Option<ThrowableSerializationWrapper>)None$.MODULE$, (Seq<AccumulableInfo>)accumUpdates, ExceptionFailure$.MODULE$.apply$default$7(), ExceptionFailure$.MODULE$.apply$default$8());
                    } else {
                        String string10 = JsonProtocol$TASK_END_REASON_FORMATTED_CLASS_NAMES$.MODULE$.taskResultLost();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            product = TaskResultLost$.MODULE$;
                        } else {
                            String string12 = JsonProtocol$TASK_END_REASON_FORMATTED_CLASS_NAMES$.MODULE$.taskKilled();
                            String string13 = string;
                            if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                                String killReason = (String)this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Kill Reason")).map((Function1 & Serializable & scala.Serializable)x$52 -> (String)org.json4s.package$.MODULE$.jvalue2extractable(x$52).extract((Formats)MODULE$.format(), ManifestFactory$.MODULE$.classType(String.class))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "unknown reason");
                                Seq accumUpdates = (Seq)this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Accumulator Updates")).map((Function1 & Serializable & scala.Serializable)x$53 -> (List)((List)org.json4s.package$.MODULE$.jvalue2extractable(x$53).extract((Formats)MODULE$.format(), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(JsonAST.JValue.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).map((Function1 & Serializable & scala.Serializable)json -> MODULE$.accumulableInfoFromJson((JsonAST.JValue)json), List$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                                product = new TaskKilled(killReason, (Seq<AccumulableInfo>)accumUpdates, TaskKilled$.MODULE$.apply$default$3(), TaskKilled$.MODULE$.apply$default$4());
                            } else {
                                String string14 = JsonProtocol$TASK_END_REASON_FORMATTED_CLASS_NAMES$.MODULE$.taskCommitDenied();
                                String string15 = string;
                                if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                                    int jobId = BoxesRunTime.unboxToInt((Object)this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Job ID")).map((Function1 & Serializable & scala.Serializable)x$54 -> BoxesRunTime.boxToInteger((int)JsonProtocol$.$anonfun$taskEndReasonFromJson$13(x$54))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1));
                                    int partitionId = BoxesRunTime.unboxToInt((Object)this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Partition ID")).map((Function1 & Serializable & scala.Serializable)x$55 -> BoxesRunTime.boxToInteger((int)JsonProtocol$.$anonfun$taskEndReasonFromJson$15(x$55))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1));
                                    int attemptNo = BoxesRunTime.unboxToInt((Object)this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Attempt Number")).map((Function1 & Serializable & scala.Serializable)x$56 -> BoxesRunTime.boxToInteger((int)JsonProtocol$.$anonfun$taskEndReasonFromJson$17(x$56))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1));
                                    product = new TaskCommitDenied(jobId, partitionId, attemptNo);
                                } else {
                                    String string16 = JsonProtocol$TASK_END_REASON_FORMATTED_CLASS_NAMES$.MODULE$.executorLostFailure();
                                    String string17 = string;
                                    if (!(string16 != null ? !string16.equals(string17) : string17 != null)) {
                                        Option exitCausedByApp = this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Exit Caused By App")).map((Function1 & Serializable & scala.Serializable)x$57 -> BoxesRunTime.boxToBoolean((boolean)JsonProtocol$.$anonfun$taskEndReasonFromJson$19(x$57)));
                                        Option executorId = this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Executor ID")).map((Function1 & Serializable & scala.Serializable)x$58 -> (String)org.json4s.package$.MODULE$.jvalue2extractable(x$58).extract((Formats)MODULE$.format(), ManifestFactory$.MODULE$.classType(String.class)));
                                        Option reason = this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Loss Reason")).map((Function1 & Serializable & scala.Serializable)x$59 -> (String)org.json4s.package$.MODULE$.jvalue2extractable(x$59).extract((Formats)MODULE$.format(), ManifestFactory$.MODULE$.classType(String.class)));
                                        product = new ExecutorLostFailure((String)executorId.getOrElse((Function0 & Serializable & scala.Serializable)() -> "Unknown"), BoxesRunTime.unboxToBoolean((Object)exitCausedByApp.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true)), (Option<String>)reason);
                                    } else {
                                        String string18 = JsonProtocol$TASK_END_REASON_FORMATTED_CLASS_NAMES$.MODULE$.unknownReason();
                                        String string19 = string;
                                        if (!(string18 != null ? !string18.equals(string19) : string19 != null)) {
                                            product = UnknownReason$.MODULE$;
                                        } else {
                                            throw new MatchError((Object)string);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return product;
    }

    public BlockManagerId blockManagerIdFromJson(JsonAST.JValue json) {
        JsonAST.JValue jValue = json;
        JsonAST.JNothing$ jNothing$ = JsonAST.JNothing$.MODULE$;
        if (!(jValue != null ? !jValue.equals(jNothing$) : jNothing$ != null)) {
            return null;
        }
        String executorId = ((String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Executor ID")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(String.class))).intern();
        String host = ((String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Host")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(String.class))).intern();
        int port = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Port")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
        return BlockManagerId$.MODULE$.apply(executorId, host, port, BlockManagerId$.MODULE$.apply$default$4());
    }

    public JobResult jobResultFromJson(JsonAST.JValue json) {
        Product product;
        String string = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Result")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(String.class));
        String string2 = JsonProtocol$JOB_RESULT_FORMATTED_CLASS_NAMES$.MODULE$.jobSucceeded();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            product = JobSucceeded$.MODULE$;
        } else {
            String string4 = JsonProtocol$JOB_RESULT_FORMATTED_CLASS_NAMES$.MODULE$.jobFailed();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                Exception exception = this.exceptionFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Exception"));
                product = new JobFailed(exception);
            } else {
                throw new MatchError((Object)string);
            }
        }
        return product;
    }

    public RDDInfo rddInfoFromJson(JsonAST.JValue json) {
        int rddId = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("RDD ID")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
        String name = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Name")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(String.class));
        Option scope = this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Scope")).map((Function1 & Serializable & scala.Serializable)x$60 -> (String)org.json4s.package$.MODULE$.jvalue2extractable(x$60).extract((Formats)MODULE$.format(), ManifestFactory$.MODULE$.classType(String.class))).map((Function1 & Serializable & scala.Serializable)s -> RDDOperationScope$.MODULE$.fromJson((String)s));
        String callsite = (String)this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Callsite")).map((Function1 & Serializable & scala.Serializable)x$61 -> (String)org.json4s.package$.MODULE$.jvalue2extractable(x$61).extract((Formats)MODULE$.format(), ManifestFactory$.MODULE$.classType(String.class))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        Seq parentIds = (Seq)this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Parent IDs")).map((Function1 & Serializable & scala.Serializable)l -> (List)((List)org.json4s.package$.MODULE$.jvalue2extractable(l).extract((Formats)MODULE$.format(), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(JsonAST.JValue.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).map((Function1 & Serializable & scala.Serializable)x$62 -> BoxesRunTime.boxToInteger((int)JsonProtocol$.$anonfun$rddInfoFromJson$6(x$62)), List$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
        StorageLevel storageLevel = this.storageLevelFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Storage Level"));
        boolean isBarrier = BoxesRunTime.unboxToBoolean((Object)this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Barrier")).map((Function1 & Serializable & scala.Serializable)x$63 -> BoxesRunTime.boxToBoolean((boolean)JsonProtocol$.$anonfun$rddInfoFromJson$8(x$63))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        int numPartitions = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Number of Partitions")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
        int numCachedPartitions = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Number of Cached Partitions")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
        long memSize = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Memory Size")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        long diskSize = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Disk Size")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        RDDInfo rddInfo = new RDDInfo(rddId, name, numPartitions, storageLevel, isBarrier, (Seq<Object>)parentIds, callsite, (Option<RDDOperationScope>)scope);
        rddInfo.numCachedPartitions_$eq(numCachedPartitions);
        rddInfo.memSize_$eq(memSize);
        rddInfo.diskSize_$eq(diskSize);
        return rddInfo;
    }

    public StorageLevel storageLevelFromJson(JsonAST.JValue json) {
        boolean useDisk = BoxesRunTime.unboxToBoolean((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Use Disk")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Boolean()));
        boolean useMemory = BoxesRunTime.unboxToBoolean((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Use Memory")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Boolean()));
        boolean deserialized = BoxesRunTime.unboxToBoolean((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Deserialized")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Boolean()));
        int replication = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Replication")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
        return StorageLevel$.MODULE$.apply(useDisk, useMemory, deserialized, replication);
    }

    public BlockStatus blockStatusFromJson(JsonAST.JValue json) {
        StorageLevel storageLevel = this.storageLevelFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Storage Level"));
        long memorySize = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Memory Size")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        long diskSize = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Disk Size")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        return new BlockStatus(storageLevel, memorySize, diskSize);
    }

    public ExecutorInfo executorInfoFromJson(JsonAST.JValue json) {
        int n;
        scala.collection.immutable.Map map;
        scala.collection.immutable.Map map2;
        String executorHost = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Host")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(String.class));
        int totalCores = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Total Cores")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
        scala.collection.immutable.Map logUrls = this.mapFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Log Urls")).toMap(Predef$.MODULE$.$conforms());
        Option<JsonAST.JValue> option = this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Attributes"));
        if (option instanceof Some) {
            Some some = (Some)option;
            JsonAST.JValue attr = (JsonAST.JValue)some.value();
            map2 = this.mapFromJson(attr).toMap(Predef$.MODULE$.$conforms());
        } else if (None$.MODULE$.equals(option)) {
            map2 = Map$.MODULE$.empty();
        } else {
            throw new MatchError(option);
        }
        scala.collection.immutable.Map attributes = map2;
        Option<JsonAST.JValue> option2 = this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Resources"));
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            JsonAST.JValue resources = (JsonAST.JValue)some.value();
            map = this.resourcesMapFromJson(resources).toMap(Predef$.MODULE$.$conforms());
        } else if (None$.MODULE$.equals(option2)) {
            map = Map$.MODULE$.empty();
        } else {
            throw new MatchError(option2);
        }
        scala.collection.immutable.Map resources = map;
        Option<JsonAST.JValue> option3 = this.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Resource Profile Id"));
        if (option3 instanceof Some) {
            Some some = (Some)option3;
            JsonAST.JValue id = (JsonAST.JValue)some.value();
            n = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(id).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
        } else if (None$.MODULE$.equals(option3)) {
            n = ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID();
        } else {
            throw new MatchError(option3);
        }
        int resourceProfileId = n;
        return new ExecutorInfo(executorHost, totalCores, (scala.collection.immutable.Map<String, String>)logUrls, (scala.collection.immutable.Map<String, String>)attributes.toMap(Predef$.MODULE$.$conforms()), (scala.collection.immutable.Map<String, ResourceInformation>)resources.toMap(Predef$.MODULE$.$conforms()), resourceProfileId);
    }

    public BlockUpdatedInfo blockUpdatedInfoFromJson(JsonAST.JValue json) {
        BlockManagerId blockManagerId = this.blockManagerIdFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Block Manager ID"));
        BlockId blockId = BlockId$.MODULE$.apply((String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Block ID")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(String.class)));
        StorageLevel storageLevel = this.storageLevelFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Storage Level"));
        long memorySize = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Memory Size")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        long diskSize = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Disk Size")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        return new BlockUpdatedInfo(blockManagerId, blockId, storageLevel, memorySize, diskSize);
    }

    public Map<String, ResourceInformation> resourcesMapFromJson(JsonAST.JValue json) {
        List jsonFields = ((JsonAST.JObject)json).obj();
        return ((TraversableOnce)jsonFields.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<String, JsonAST.JValue>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Tuple2 tuple2 = JsonAST.JField$.MODULE$.unapply(A1);
                if (!JsonAST.JField$.OptionStringJValue$.MODULE$.isEmpty$extension(tuple2)) {
                    String k = (String)tuple2._1();
                    JsonAST.JValue v = (JsonAST.JValue)tuple2._2();
                    ResourceInformation resourceInfo = ResourceInformation$.MODULE$.parseJson(v);
                    object = new Tuple2((Object)k, (Object)resourceInfo);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<String, JsonAST.JValue> x1) {
                Tuple2<String, JsonAST.JValue> tuple2 = x1;
                Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
                boolean bl = !JsonAST.JField$.OptionStringJValue$.MODULE$.isEmpty$extension(tuple22);
                return bl;
            }
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, String> mapFromJson(JsonAST.JValue json) {
        List jsonFields = ((JsonAST.JObject)json).obj();
        return ((TraversableOnce)jsonFields.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, JsonAST.JValue>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Tuple2 tuple2 = JsonAST.JField$.MODULE$.unapply(A1);
                if (!JsonAST.JField$.OptionStringJValue$.MODULE$.isEmpty$extension(tuple2)) {
                    String k = (String)tuple2._1();
                    JsonAST.JValue jValue = (JsonAST.JValue)tuple2._2();
                    if (jValue instanceof JsonAST.JString) {
                        JsonAST.JString jString = (JsonAST.JString)jValue;
                        String v = jString.s();
                        object = new Tuple2((Object)k, (Object)v);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<String, JsonAST.JValue> x1) {
                JsonAST.JValue jValue;
                Tuple2<String, JsonAST.JValue> tuple2 = x1;
                Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
                boolean bl = !JsonAST.JField$.OptionStringJValue$.MODULE$.isEmpty$extension(tuple22) && (jValue = (JsonAST.JValue)tuple22._2()) instanceof JsonAST.JString;
                return bl;
            }
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Properties propertiesFromJson(JsonAST.JValue json) {
        return (Properties)this.jsonOption(json).map((Function1 & Serializable & scala.Serializable)value -> {
            void var2_2;
            Properties properties = new Properties();
            MODULE$.mapFromJson(json).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                Object object = properties.setProperty(k, v);
                return object;
            });
            return var2_2;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> null);
    }

    public UUID UUIDFromJson(JsonAST.JValue json) {
        long leastSignificantBits = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Least Significant Bits")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        long mostSignificantBits = BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Most Significant Bits")).extract((Formats)this.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
        return new UUID(leastSignificantBits, mostSignificantBits);
    }

    public StackTraceElement[] stackTraceFromJson(JsonAST.JValue json) {
        return (StackTraceElement[])((TraversableOnce)((List)org.json4s.package$.MODULE$.jvalue2extractable(json).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(JsonAST.JValue.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).map((Function1 & Serializable & scala.Serializable)line -> {
            String declaringClass = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(line).$bslash("Declaring Class")).extract((Formats)MODULE$.format(), ManifestFactory$.MODULE$.classType(String.class));
            String methodName = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(line).$bslash("Method Name")).extract((Formats)MODULE$.format(), ManifestFactory$.MODULE$.classType(String.class));
            String fileName = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(line).$bslash("File Name")).extract((Formats)MODULE$.format(), ManifestFactory$.MODULE$.classType(String.class));
            int lineNumber = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(line).$bslash("Line Number")).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
            return new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
        }, List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(StackTraceElement.class));
    }

    /*
     * WARNING - void declaration
     */
    public Exception exceptionFromJson(JsonAST.JValue json) {
        void var2_2;
        Exception e = new Exception((String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Message")).extract((Formats)this.format(), ManifestFactory$.MODULE$.classType(String.class)));
        e.setStackTrace(this.stackTraceFromJson(org.json4s.package$.MODULE$.jvalue2monadic(json).$bslash("Stack Trace")));
        return var2_2;
    }

    private Option<JsonAST.JValue> jsonOption(JsonAST.JValue json) {
        None$ none$;
        JsonAST.JValue jValue = json;
        if (JsonAST.JNothing$.MODULE$.equals(jValue)) {
            none$ = None$.MODULE$;
        } else if (jValue != null) {
            JsonAST.JValue jValue2 = jValue;
            none$ = new Some((Object)jValue2);
        } else {
            throw new MatchError((Object)jValue);
        }
        return none$;
    }

    private JsonAST.JObject emptyJson() {
        return new JsonAST.JObject((List)Nil$.MODULE$);
    }

    public static final /* synthetic */ JsonAST.JInt $anonfun$stageInfoToJson$2(int x$3) {
        return new JsonAST.JInt(BigInt$.MODULE$.int2bigInt(x$3));
    }

    public static final /* synthetic */ JsonAST.JInt $anonfun$stageInfoToJson$3(long x$4) {
        return new JsonAST.JInt(BigInt$.MODULE$.long2bigInt(x$4));
    }

    public static final /* synthetic */ JsonAST.JInt $anonfun$stageInfoToJson$5(long x$5) {
        return new JsonAST.JInt(BigInt$.MODULE$.long2bigInt(x$5));
    }

    public static final /* synthetic */ boolean $anonfun$accumulablesToJson$2(String elem) {
        return MODULE$.accumulableExcludeList().contains((Object)elem);
    }

    public static final /* synthetic */ boolean $anonfun$accumulablesToJson$1(AccumulableInfo x$7) {
        return x$7.name().exists((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)JsonProtocol$.$anonfun$accumulablesToJson$2(elem)));
    }

    public static final /* synthetic */ JsonAST.JInt $anonfun$rddInfoToJson$1(int x$11) {
        return new JsonAST.JInt(BigInt$.MODULE$.int2bigInt(x$11));
    }

    public static final /* synthetic */ int $anonfun$taskStartFromJson$1(JsonAST.JValue x$13) {
        return BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$13).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
    }

    public static final /* synthetic */ long $anonfun$executorMetricsFromJson$2(JsonAST.JValue x$14) {
        return BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$14).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
    }

    public static final /* synthetic */ int $anonfun$taskEndFromJson$1(JsonAST.JValue x$15) {
        return BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$15).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
    }

    public static final /* synthetic */ long $anonfun$jobStartFromJson$1(JsonAST.JValue x$16) {
        return BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$16).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
    }

    public static final /* synthetic */ int $anonfun$jobStartFromJson$3(JsonAST.JValue x$17) {
        return BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$17).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
    }

    public static final /* synthetic */ StageInfo $anonfun$jobStartFromJson$7(int id) {
        int x$1 = id;
        int x$2 = 0;
        String x$3 = "unknown";
        int x$4 = 0;
        Seq x$5 = (Seq)Seq$.MODULE$.empty();
        Seq x$6 = (Seq)Seq$.MODULE$.empty();
        String x$7 = "unknown";
        int x$8 = ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID();
        TaskMetrics x$9 = StageInfo$.MODULE$.$lessinit$greater$default$8();
        Seq<Seq<TaskLocation>> x$10 = StageInfo$.MODULE$.$lessinit$greater$default$9();
        Option<Object> x$11 = StageInfo$.MODULE$.$lessinit$greater$default$10();
        return new StageInfo(x$1, x$2, x$3, x$4, (Seq<RDDInfo>)x$5, (Seq<Object>)x$6, x$7, x$9, x$10, x$11, x$8);
    }

    public static final /* synthetic */ long $anonfun$jobEndFromJson$1(JsonAST.JValue x$19) {
        return BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$19).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
    }

    public static final /* synthetic */ long $anonfun$blockManagerAddedFromJson$1(JsonAST.JValue x$21) {
        return BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$21).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
    }

    public static final /* synthetic */ long $anonfun$blockManagerAddedFromJson$3(JsonAST.JValue x$22) {
        return BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$22).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
    }

    public static final /* synthetic */ long $anonfun$blockManagerAddedFromJson$4(JsonAST.JValue x$23) {
        return BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$23).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
    }

    public static final /* synthetic */ long $anonfun$blockManagerRemovedFromJson$1(JsonAST.JValue x$24) {
        return BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$24).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
    }

    public static final /* synthetic */ int $anonfun$stageInfoFromJson$1(JsonAST.JValue x$27) {
        return BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$27).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
    }

    public static final /* synthetic */ int $anonfun$stageInfoFromJson$5(JsonAST.JValue x$28) {
        return BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$28).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
    }

    public static final /* synthetic */ long $anonfun$stageInfoFromJson$9(JsonAST.JValue x$30) {
        return BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$30).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
    }

    public static final /* synthetic */ long $anonfun$stageInfoFromJson$10(JsonAST.JValue x$31) {
        return BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$31).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
    }

    public static final /* synthetic */ int $anonfun$stageInfoFromJson$14(JsonAST.JValue x$34) {
        return BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$34).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
    }

    public static final /* synthetic */ void $anonfun$stageInfoFromJson$16(StageInfo stageInfo$1, AccumulableInfo accInfo) {
        stageInfo$1.accumulables().update((Object)BoxesRunTime.boxToLong((long)accInfo.id()), (Object)accInfo);
    }

    public static final /* synthetic */ int $anonfun$taskInfoFromJson$1(JsonAST.JValue x$35) {
        return BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$35).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
    }

    public static final /* synthetic */ boolean $anonfun$taskInfoFromJson$3(JsonAST.JValue x$36) {
        return BoxesRunTime.unboxToBoolean((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$36).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Boolean()));
    }

    public static final /* synthetic */ boolean $anonfun$taskInfoFromJson$4(JsonAST.JValue x$37) {
        return BoxesRunTime.unboxToBoolean((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$37).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Boolean()));
    }

    public static final /* synthetic */ boolean $anonfun$accumulableInfoFromJson$4(JsonAST.JValue x$40) {
        return BoxesRunTime.unboxToBoolean((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$40).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Boolean()));
    }

    public static final /* synthetic */ boolean $anonfun$accumulableInfoFromJson$5(JsonAST.JValue x$41) {
        return BoxesRunTime.unboxToBoolean((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$41).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Boolean()));
    }

    public static final /* synthetic */ long $anonfun$taskMetricsFromJson$3(JsonAST.JValue x$44) {
        return BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$44).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
    }

    public static final /* synthetic */ long $anonfun$taskMetricsFromJson$5(JsonAST.JValue x$45) {
        return BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$45).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
    }

    public static final /* synthetic */ void $anonfun$taskMetricsFromJson$1(TaskMetrics metrics$1, JsonAST.JValue readJson) {
        TempShuffleReadMetrics readMetrics = metrics$1.createTempShuffleReadMetrics();
        readMetrics.incRemoteBlocksFetched(BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(readJson).$bslash("Remote Blocks Fetched")).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Int())));
        readMetrics.incLocalBlocksFetched(BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(readJson).$bslash("Local Blocks Fetched")).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Int())));
        readMetrics.incRemoteBytesRead(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(readJson).$bslash("Remote Bytes Read")).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Long())));
        MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(readJson).$bslash("Remote Bytes Read To Disk")).foreach((Function1 & Serializable & scala.Serializable)v -> {
            readMetrics.incRemoteBytesReadToDisk(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(v).extract((Formats)JsonProtocol$.MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Long())));
            return BoxedUnit.UNIT;
        });
        readMetrics.incLocalBytesRead(BoxesRunTime.unboxToLong((Object)MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(readJson).$bslash("Local Bytes Read")).map((Function1 & Serializable & scala.Serializable)x$44 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$taskMetricsFromJson$3(x$44))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        readMetrics.incFetchWaitTime(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(readJson).$bslash("Fetch Wait Time")).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Long())));
        readMetrics.incRecordsRead(BoxesRunTime.unboxToLong((Object)MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(readJson).$bslash("Total Records Read")).map((Function1 & Serializable & scala.Serializable)x$45 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$taskMetricsFromJson$5(x$45))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        metrics$1.mergeShuffleReadMetrics();
    }

    public static final /* synthetic */ long $anonfun$taskMetricsFromJson$8(JsonAST.JValue x$46) {
        return BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$46).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
    }

    public static final /* synthetic */ void $anonfun$taskMetricsFromJson$7(TaskMetrics metrics$1, JsonAST.JValue writeJson) {
        ShuffleWriteMetrics writeMetrics = metrics$1.shuffleWriteMetrics();
        writeMetrics.incBytesWritten(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(writeJson).$bslash("Shuffle Bytes Written")).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Long())));
        writeMetrics.incRecordsWritten(BoxesRunTime.unboxToLong((Object)MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(writeJson).$bslash("Shuffle Records Written")).map((Function1 & Serializable & scala.Serializable)x$46 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$taskMetricsFromJson$8(x$46))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        writeMetrics.incWriteTime(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(writeJson).$bslash("Shuffle Write Time")).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Long())));
    }

    public static final /* synthetic */ long $anonfun$taskMetricsFromJson$11(JsonAST.JValue x$47) {
        return BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$47).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
    }

    public static final /* synthetic */ void $anonfun$taskMetricsFromJson$10(TaskMetrics metrics$1, JsonAST.JValue outJson) {
        OutputMetrics outputMetrics = metrics$1.outputMetrics();
        outputMetrics.setBytesWritten(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(outJson).$bslash("Bytes Written")).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Long())));
        outputMetrics.setRecordsWritten(BoxesRunTime.unboxToLong((Object)MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(outJson).$bslash("Records Written")).map((Function1 & Serializable & scala.Serializable)x$47 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$taskMetricsFromJson$11(x$47))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
    }

    public static final /* synthetic */ long $anonfun$taskMetricsFromJson$14(JsonAST.JValue x$48) {
        return BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$48).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Long()));
    }

    public static final /* synthetic */ void $anonfun$taskMetricsFromJson$13(TaskMetrics metrics$1, JsonAST.JValue inJson) {
        InputMetrics inputMetrics = metrics$1.inputMetrics();
        inputMetrics.incBytesRead(BoxesRunTime.unboxToLong((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(inJson).$bslash("Bytes Read")).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Long())));
        inputMetrics.incRecordsRead(BoxesRunTime.unboxToLong((Object)MODULE$.jsonOption(org.json4s.package$.MODULE$.jvalue2monadic(inJson).$bslash("Records Read")).map((Function1 & Serializable & scala.Serializable)x$48 -> BoxesRunTime.boxToLong((long)JsonProtocol$.$anonfun$taskMetricsFromJson$14(x$48))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
    }

    public static final /* synthetic */ int $anonfun$taskEndReasonFromJson$13(JsonAST.JValue x$54) {
        return BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$54).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
    }

    public static final /* synthetic */ int $anonfun$taskEndReasonFromJson$15(JsonAST.JValue x$55) {
        return BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$55).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
    }

    public static final /* synthetic */ int $anonfun$taskEndReasonFromJson$17(JsonAST.JValue x$56) {
        return BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$56).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
    }

    public static final /* synthetic */ boolean $anonfun$taskEndReasonFromJson$19(JsonAST.JValue x$57) {
        return BoxesRunTime.unboxToBoolean((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$57).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Boolean()));
    }

    public static final /* synthetic */ int $anonfun$rddInfoFromJson$6(JsonAST.JValue x$62) {
        return BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$62).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Int()));
    }

    public static final /* synthetic */ boolean $anonfun$rddInfoFromJson$8(JsonAST.JValue x$63) {
        return BoxesRunTime.unboxToBoolean((Object)org.json4s.package$.MODULE$.jvalue2extractable(x$63).extract((Formats)MODULE$.format(), (Manifest)ManifestFactory$.MODULE$.Boolean()));
    }

    private JsonProtocol$() {
        MODULE$ = this;
        this.format = DefaultFormats$.MODULE$;
        this.mapper = new ObjectMapper().registerModule((Module)DefaultScalaModule$.MODULE$).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

