/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.CachedDNSToSwitchMapping;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.net.ScriptBasedMapping;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MAPREDUCE"})
public final class RackResolver {
    private static DNSToSwitchMapping dnsToSwitchMapping;
    private static boolean initCalled;
    private static final Logger LOG;

    private RackResolver() {
    }

    public static synchronized void init(Configuration conf) {
        if (initCalled) {
            return;
        }
        initCalled = true;
        Class dnsToSwitchMappingClass = conf.getClass("net.topology.node.switch.mapping.impl", ScriptBasedMapping.class, DNSToSwitchMapping.class);
        try {
            DNSToSwitchMapping newInstance = (DNSToSwitchMapping)ReflectionUtils.newInstance((Class)dnsToSwitchMappingClass, (Configuration)conf);
            dnsToSwitchMapping = newInstance instanceof CachedDNSToSwitchMapping ? newInstance : new CachedDNSToSwitchMapping(newInstance);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Node resolve(Configuration conf, String hostName) {
        RackResolver.init(conf);
        return RackResolver.coreResolve(hostName);
    }

    public static Node resolve(String hostName) {
        if (!initCalled) {
            throw new IllegalStateException("RackResolver class not yet initialized");
        }
        return RackResolver.coreResolve(hostName);
    }

    private static Node coreResolve(String hostName) {
        List<String> tmpList = Collections.singletonList(hostName);
        List rNameList = dnsToSwitchMapping.resolve(tmpList);
        String rName = "/default-rack";
        if (rNameList == null || rNameList.get(0) == null) {
            LOG.debug("Could not resolve {}. Falling back to {}", (Object)hostName, (Object)"/default-rack");
        } else {
            rName = (String)rNameList.get(0);
            LOG.debug("Resolved {} to {}", (Object)hostName, (Object)rName);
        }
        return new NodeBase(hostName, rName);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    static DNSToSwitchMapping getDnsToSwitchMapping() {
        return dnsToSwitchMapping;
    }

    static {
        initCalled = false;
        LOG = LoggerFactory.getLogger(RackResolver.class);
    }
}

