/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.graphx;

import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.EdgeContext;
import org.apache.spark.graphx.EdgeDirection;
import org.apache.spark.graphx.EdgeDirection$;
import org.apache.spark.graphx.EdgeTriplet;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.Pregel$;
import org.apache.spark.graphx.TripletFields;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.graphx.lib.ConnectedComponents$;
import org.apache.spark.graphx.lib.PageRank$;
import org.apache.spark.graphx.lib.StronglyConnectedComponents$;
import org.apache.spark.graphx.lib.TriangleCount$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction2;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015h\u0001\u0002\u0015*\u0001IB\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t!\u0002\u0011\u0019\u0011)A\u0006#\"Aq\u000b\u0001B\u0002B\u0003-\u0001\fC\u0003Z\u0001\u0011\u0005!\f\u0003\u0005a\u0001!\u0015\r\u0011\"\u0001b\u0011!I\u0007\u0001#b\u0001\n\u0003\t\u0007\u0002C6\u0001\u0011\u000b\u0007I\u0011\u00017\t\u0011Q\u0004\u0001R1A\u0005\u00021D\u0001B\u001e\u0001\t\u0006\u0004%\t\u0001\u001c\u0005\u0006q\u0002!I!\u001f\u0005\u0007\u007f\u0002!\t!!\u0001\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e!9\u00111\u0006\u0001\u0005\u0002\u00055\u0002bBA\u001e\u0001\u0011\u0005\u0011Q\b\u0005\b\u0003\u007f\u0001A\u0011AA!\u0011\u001d\t\t\b\u0001C\u0001\u0003gB\u0011\"!/\u0001#\u0003%\t!a/\t\u0013\u0005}\u0007!%A\u0005\u0002\u0005\u0005\bbBAx\u0001\u0011\u0005\u0011\u0011\u001f\u0005\b\u0003g\u0004A\u0011AA{\u0011%\ti\u0010AI\u0001\n\u0003\ty\u0010C\u0004\u0003\u0004\u0001!\tA!\u0002\t\u0013\tE\u0003!%A\u0005\u0002\tM\u0003\"\u0003B.\u0001E\u0005I\u0011\u0001B/\u0011\u001d\u0011)\u0007\u0001C\u0001\u0005OB\u0011B!\u001f\u0001#\u0003%\tAa\u001f\t\u000f\t}\u0004\u0001\"\u0001\u0003\u0002\"I!1\u0012\u0001\u0012\u0002\u0013\u0005!1\u0010\u0005\b\u0005\u001b\u0003A\u0011\u0001BH\u0011%\u0011i\u000bAI\u0001\n\u0003\u0011Y\bC\u0004\u00030\u0002!\tA!-\t\u0013\te\u0006!%A\u0005\u0002\tm\u0004b\u0002B^\u0001\u0011\u0005!Q\u0018\u0005\n\u0005\u0007\u0004\u0011\u0013!C\u0001\u0005wBqAa/\u0001\t\u0003\u0011)\rC\u0004\u0003P\u0002!\tA!5\t\u000f\t=\u0007\u0001\"\u0001\u0003V\"9!\u0011\u001c\u0001\u0005\u0002\tm\u0007b\u0002Bp\u0001\u0011\u0005!\u0011\u001d\u0002\t\u000fJ\f\u0007\u000f[(qg*\u0011!fK\u0001\u0007OJ\f\u0007\u000f\u001b=\u000b\u00051j\u0013!B:qCJ\\'B\u0001\u00180\u0003\u0019\t\u0007/Y2iK*\t\u0001'A\u0002pe\u001e\u001c\u0001!F\u00024\t:\u001b2\u0001\u0001\u001b;!\t)\u0004(D\u00017\u0015\u00059\u0014!B:dC2\f\u0017BA\u001d7\u0005\u0019\te.\u001f*fMB\u0011QgO\u0005\u0003yY\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fQa\u001a:ba\"\u0004Ba\u0010!C\u001b6\t\u0011&\u0003\u0002BS\t)qI]1qQB\u00111\t\u0012\u0007\u0001\t\u0015)\u0005A1\u0001G\u0005\t1F)\u0005\u0002H\u0015B\u0011Q\u0007S\u0005\u0003\u0013Z\u0012qAT8uQ&tw\r\u0005\u00026\u0017&\u0011AJ\u000e\u0002\u0004\u0003:L\bCA\"O\t\u0015y\u0005A1\u0001G\u0005\t)E)\u0001\u0006fm&$WM\\2fIE\u00022AU+C\u001b\u0005\u0019&B\u0001+7\u0003\u001d\u0011XM\u001a7fGRL!AV*\u0003\u0011\rc\u0017m]:UC\u001e\f!\"\u001a<jI\u0016t7-\u001a\u00133!\r\u0011V+T\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005m{Fc\u0001/^=B!q\b\u0001\"N\u0011\u0015\u0001F\u0001q\u0001R\u0011\u00159F\u0001q\u0001Y\u0011\u0015iD\u00011\u0001?\u0003!qW/\\#eO\u0016\u001cX#\u00012\u0011\u0005U\u001a\u0017B\u000137\u0005\u0011auN\\4)\u0005\u00151\u0007CA\u001bh\u0013\tAgGA\u0005ue\u0006t7/[3oi\u0006Ya.^7WKJ$\u0018nY3tQ\t1a-A\u0005j]\u0012+wM]3fgV\tQ\u000eE\u0002@]BL!a\\\u0015\u0003\u0013Y+'\u000f^3y%\u0012#\u0005CA\u001br\u0013\t\u0011hGA\u0002J]RD#a\u00024\u0002\u0015=,H\u000fR3he\u0016,7\u000f\u000b\u0002\tM\u00069A-Z4sK\u0016\u001c\bFA\u0005g\u0003)!Wm\u001a:fKN\u0014F\t\u0012\u000b\u0003[jDQa\u001f\u0006A\u0002q\fQ\"\u001a3hK\u0012K'/Z2uS>t\u0007CA ~\u0013\tq\u0018FA\u0007FI\u001e,G)\u001b:fGRLwN\\\u0001\u0013G>dG.Z2u\u001d\u0016Lw\r\u001b2pe&#7\u000f\u0006\u0003\u0002\u0004\u0005e\u0001\u0003B o\u0003\u000b\u0001R!NA\u0004\u0003\u0017I1!!\u00037\u0005\u0015\t%O]1z!\u0011\ti!a\u0005\u000f\u0007}\ny!C\u0002\u0002\u0012%\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0016\u0005]!\u0001\u0003,feR,\u00070\u00133\u000b\u0007\u0005E\u0011\u0006C\u0003|\u0017\u0001\u0007A0\u0001\td_2dWm\u0019;OK&<\u0007NY8sgR!\u0011qDA\u0015!\u0011yd.!\t\u0011\u000bU\n9!a\t\u0011\rU\n)#a\u0003C\u0013\r\t9C\u000e\u0002\u0007)V\u0004H.\u001a\u001a\t\u000bmd\u0001\u0019\u0001?\u0002\u0019\r|G\u000e\\3di\u0016#w-Z:\u0015\t\u0005=\u0012\u0011\b\t\u0005\u007f9\f\t\u0004E\u00036\u0003\u000f\t\u0019\u0004\u0005\u0003@\u0003ki\u0015bAA\u001cS\t!Q\tZ4f\u0011\u0015YX\u00021\u0001}\u0003=\u0011X-\\8wKN+GNZ#eO\u0016\u001cH#\u0001 \u0002\u0019)|\u0017N\u001c,feRL7-Z:\u0016\t\u0005\r\u0013\u0011\u000b\u000b\u0005\u0003\u000b\ny\u0006\u0006\u0003\u0002H\u0005UCc\u0001 \u0002J!I\u00111J\b\u0002\u0002\u0003\u000f\u0011QJ\u0001\u000bKZLG-\u001a8dK\u0012\u001a\u0004\u0003\u0002*V\u0003\u001f\u00022aQA)\t\u0019\t\u0019f\u0004b\u0001\r\n\tQ\u000bC\u0004\u0002X=\u0001\r!!\u0017\u0002\u000f5\f\u0007OR;oGBIQ'a\u0017\u0002\f\t\u000byEQ\u0005\u0004\u0003;2$!\u0003$v]\u000e$\u0018n\u001c84\u0011\u001d\t\tg\u0004a\u0001\u0003G\nQ\u0001^1cY\u0016\u0004b!!\u001a\u0002l\u0005=TBAA4\u0015\r\tIgK\u0001\u0004e\u0012$\u0017\u0002BA7\u0003O\u00121A\u0015#E!\u001d)\u0014QEA\u0006\u0003\u001f\naAZ5mi\u0016\u0014XCBA;\u0003\u0003\u000bi\t\u0006\u0005\u0002x\u0005E\u0015QTAX)\u0015q\u0014\u0011PAC\u0011%\tY\bEA\u0001\u0002\b\ti(\u0001\u0006fm&$WM\\2fIQ\u0002BAU+\u0002\u0000A\u00191)!!\u0005\r\u0005\r\u0005C1\u0001G\u0005\r1FI\r\u0005\n\u0003\u000f\u0003\u0012\u0011!a\u0002\u0003\u0013\u000b!\"\u001a<jI\u0016t7-\u001a\u00136!\u0011\u0011V+a#\u0011\u0007\r\u000bi\t\u0002\u0004\u0002\u0010B\u0011\rA\u0012\u0002\u0004\u000b\u0012\u0013\u0004bBAJ!\u0001\u0007\u0011QS\u0001\u000baJ,\u0007O]8dKN\u001c\bCB\u001b\u0002\u0018z\nY*C\u0002\u0002\u001aZ\u0012\u0011BR;oGRLwN\\\u0019\u0011\r}\u0002\u0015qPAF\u0011%\ty\n\u0005I\u0001\u0002\u0004\t\t+A\u0003faJ,G\rE\u00046\u0003/\u000b\u0019+!+\u0011\u000f}\n)+a \u0002\f&\u0019\u0011qU\u0015\u0003\u0017\u0015#w-\u001a+sSBdW\r\u001e\t\u0004k\u0005-\u0016bAAWm\t9!i\\8mK\u0006t\u0007\"CAY!A\u0005\t\u0019AAZ\u0003\u00151\bO]3e!%)\u0014QWA\u0006\u0003\u007f\nI+C\u0002\u00028Z\u0012\u0011BR;oGRLwN\u001c\u001a\u0002!\u0019LG\u000e^3sI\u0011,g-Y;mi\u0012\u0012TCBA_\u0003\u000f\fY-\u0006\u0002\u0002@*\"\u0011\u0011YAg!\u001d)\u0014qSAb\u0003S\u0003raPAS\u0003\u000b\fI\rE\u0002D\u0003\u000f$a!a!\u0012\u0005\u00041\u0005cA\"\u0002L\u00121\u0011qR\tC\u0002\u0019[#!a4\u0011\t\u0005E\u00171\\\u0007\u0003\u0003'TA!!6\u0002X\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u000334\u0014AC1o]>$\u0018\r^5p]&!\u0011Q\\Aj\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0011M&dG/\u001a:%I\u00164\u0017-\u001e7uIM*b!a9\u0002l\u00065XCAAsU\u0011\t9/!4\u0011\u0013U\n),a\u0003\u0002j\u0006%\u0006cA\"\u0002l\u00121\u00111\u0011\nC\u0002\u0019#a!a$\u0013\u0005\u00041\u0015\u0001\u00059jG.\u0014\u0016M\u001c3p[Z+'\u000f^3y)\t\tY!A\fd_:4XM\u001d;U_\u000e\u000bgn\u001c8jG\u0006dW\tZ4fgR\u0019a(a>\t\u0013\u0005eH\u0003%AA\u0002\u0005m\u0018!C7fe\u001e,g)\u001e8d!\u0019)\u0014QW'N\u001b\u0006\t3m\u001c8wKJ$Hk\\\"b]>t\u0017nY1m\u000b\u0012<Wm\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!\u0011\u0001\u0016\u0005\u0003w\fi-\u0001\u0004qe\u0016<W\r\\\u000b\u0005\u0005\u000f\u0011)\u0002\u0006\u0005\u0003\n\t\u0015#\u0011\nB')!\u0011YA!\u0007\u0003 \t}Bc\u0001 \u0003\u000e!I!q\u0002\f\u0002\u0002\u0003\u000f!\u0011C\u0001\u000bKZLG-\u001a8dK\u00122\u0004\u0003\u0002*V\u0005'\u00012a\u0011B\u000b\t\u0019\u00119B\u0006b\u0001\r\n\t\u0011\tC\u0004\u0003\u001cY\u0001\rA!\b\u0002\u000bY\u0004(o\\4\u0011\u0013U\nY&a\u0003C\u0005'\u0011\u0005b\u0002B\u0011-\u0001\u0007!1E\u0001\bg\u0016tG-T:h!\u001d)\u0014q\u0013B\u0013\u0005O\u0001RaPAS\u00056\u0003bA!\u000b\u00038\tub\u0002\u0002B\u0016\u0005kqAA!\f\u000345\u0011!q\u0006\u0006\u0004\u0005c\t\u0014A\u0002\u001fs_>$h(C\u00018\u0013\r\t\tBN\u0005\u0005\u0005s\u0011YD\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\r\t\tB\u000e\t\bk\u0005\u0015\u00121\u0002B\n\u0011\u001d\u0011\tE\u0006a\u0001\u0005\u0007\n\u0001\"\\3sO\u0016l5o\u001a\t\nk\u0005U&1\u0003B\n\u0005'AqAa\u0012\u0017\u0001\u0004\u0011\u0019\"\u0001\u0006j]&$\u0018.\u00197Ng\u001eD\u0001Ba\u0013\u0017!\u0003\u0005\r\u0001]\u0001\u000e[\u0006D\u0018\n^3sCRLwN\\:\t\u0011\t=c\u0003%AA\u0002q\fq\"Y2uSZ,G)\u001b:fGRLwN\\\u0001\u0011aJ,w-\u001a7%I\u00164\u0017-\u001e7uII*BA!\u0016\u0003ZU\u0011!q\u000b\u0016\u0004a\u00065GA\u0002B\f/\t\u0007a)\u0001\tqe\u0016<W\r\u001c\u0013eK\u001a\fW\u000f\u001c;%gU!!q\fB2+\t\u0011\tGK\u0002}\u0003\u001b$aAa\u0006\u0019\u0005\u00041\u0015\u0001\u00039bO\u0016\u0014\u0016M\\6\u0015\r\t%$\u0011\u000fB;!\u0019y\u0004Ia\u001b\u0003lA\u0019QG!\u001c\n\u0007\t=dG\u0001\u0004E_V\u0014G.\u001a\u0005\b\u0005gJ\u0002\u0019\u0001B6\u0003\r!x\u000e\u001c\u0005\n\u0005oJ\u0002\u0013!a\u0001\u0005W\n\u0011B]3tKR\u0004&o\u001c2\u0002%A\fw-\u001a*b].$C-\u001a4bk2$HEM\u000b\u0003\u0005{RCAa\u001b\u0002N\u0006!\u0002/\u001a:t_:\fG.\u001b>fIB\u000bw-\u001a*b].$\u0002B!\u001b\u0003\u0004\n\u001d%\u0011\u0012\u0005\b\u0005\u000b[\u0002\u0019AA\u0006\u0003\r\u0019(o\u0019\u0005\b\u0005gZ\u0002\u0019\u0001B6\u0011%\u00119h\u0007I\u0001\u0002\u0004\u0011Y'\u0001\u0010qKJ\u001cxN\\1mSj,G\rU1hKJ\u000bgn\u001b\u0013eK\u001a\fW\u000f\u001c;%g\u0005\u00113\u000f^1uS\u000e\u0004\u0016M]1mY\u0016d\u0007+\u001a:t_:\fG.\u001b>fIB\u000bw-\u001a*b].$\u0002B!%\u0003$\n\u001d&1\u0016\t\u0007\u007f\u0001\u0013\u0019Ja\u001b\u0011\t\tU%qT\u0007\u0003\u0005/SAA!'\u0003\u001c\u00061A.\u001b8bY\u001eT1A!(,\u0003\tiG.\u0003\u0003\u0003\"\n]%A\u0002,fGR|'\u000fC\u0004\u0003&v\u0001\r!!\u0002\u0002\u000fM|WO]2fg\"1!\u0011V\u000fA\u0002A\fqA\\;n\u0013R,'\u000fC\u0005\u0003xu\u0001\n\u00111\u0001\u0003l\u0005a3\u000f^1uS\u000e\u0004\u0016M]1mY\u0016d\u0007+\u001a:t_:\fG.\u001b>fIB\u000bw-\u001a*b].$C-\u001a4bk2$HeM\u0001\u001bgR\fG/[2QKJ\u001cxN\\1mSj,G\rU1hKJ\u000bgn\u001b\u000b\t\u0005S\u0012\u0019L!.\u00038\"9!QQ\u0010A\u0002\u0005-\u0001B\u0002BU?\u0001\u0007\u0001\u000fC\u0005\u0003x}\u0001\n\u00111\u0001\u0003l\u0005!3\u000f^1uS\u000e\u0004VM]:p]\u0006d\u0017N_3e!\u0006<WMU1oW\u0012\"WMZ1vYR$3'\u0001\bti\u0006$\u0018n\u0019)bO\u0016\u0014\u0016M\\6\u0015\r\t%$q\u0018Ba\u0011\u0019\u0011I+\ta\u0001a\"I!qO\u0011\u0011\u0002\u0003\u0007!1N\u0001\u0019gR\fG/[2QC\u001e,'+\u00198lI\u0011,g-Y;mi\u0012\u0012D\u0003\u0003B5\u0005\u000f\u0014IMa3\t\r\t%6\u00051\u0001q\u0011\u001d\u00119h\ta\u0001\u0005WBqA!4$\u0001\u0004\u0011I'A\u0006qe\u0016\u0004\u0016mZ3SC:\\\u0017aE2p]:,7\r^3e\u0007>l\u0007o\u001c8f]R\u001cHC\u0001Bj!\u0015y\u0004)a\u0003N)\u0011\u0011\u0019Na6\t\r\t-S\u00051\u0001q\u00035!(/[1oO2,7i\\;oiR\u0011!Q\u001c\t\u0005\u007f\u0001\u0003X*A\u000etiJ|gn\u001a7z\u0007>tg.Z2uK\u0012\u001cu.\u001c9p]\u0016tGo\u001d\u000b\u0005\u0005'\u0014\u0019\u000f\u0003\u0004\u0003*\u001e\u0002\r\u0001\u001d")
public class GraphOps<VD, ED>
implements scala.Serializable {
    private transient long numEdges;
    private transient long numVertices;
    private transient VertexRDD<Object> inDegrees;
    private transient VertexRDD<Object> outDegrees;
    private transient VertexRDD<Object> degrees;
    private final Graph<VD, ED> graph;
    private final ClassTag<VD> evidence$1;
    private final ClassTag<ED> evidence$2;
    private volatile transient byte bitmap$trans$0;

    private long numEdges$lzycompute() {
        GraphOps graphOps = this;
        synchronized (graphOps) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.numEdges = this.graph.edges().count();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.numEdges;
    }

    public long numEdges() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.numEdges$lzycompute() : this.numEdges;
    }

    private long numVertices$lzycompute() {
        GraphOps graphOps = this;
        synchronized (graphOps) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.numVertices = this.graph.vertices().count();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.numVertices;
    }

    public long numVertices() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.numVertices$lzycompute() : this.numVertices;
    }

    private VertexRDD<Object> inDegrees$lzycompute() {
        GraphOps graphOps = this;
        synchronized (graphOps) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.inDegrees = (VertexRDD)this.degreesRDD(EdgeDirection$.MODULE$.In()).setName("GraphOps.inDegrees");
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.inDegrees;
    }

    public VertexRDD<Object> inDegrees() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.inDegrees$lzycompute() : this.inDegrees;
    }

    private VertexRDD<Object> outDegrees$lzycompute() {
        GraphOps graphOps = this;
        synchronized (graphOps) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.outDegrees = (VertexRDD)this.degreesRDD(EdgeDirection$.MODULE$.Out()).setName("GraphOps.outDegrees");
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.outDegrees;
    }

    public VertexRDD<Object> outDegrees() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.outDegrees$lzycompute() : this.outDegrees;
    }

    private VertexRDD<Object> degrees$lzycompute() {
        GraphOps graphOps = this;
        synchronized (graphOps) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.degrees = (VertexRDD)this.degreesRDD(EdgeDirection$.MODULE$.Either()).setName("GraphOps.degrees");
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.degrees;
    }

    public VertexRDD<Object> degrees() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.degrees$lzycompute() : this.degrees;
    }

    private VertexRDD<Object> degreesRDD(EdgeDirection edgeDirection) {
        VertexRDD<Object> vertexRDD;
        EdgeDirection edgeDirection2 = edgeDirection;
        EdgeDirection edgeDirection3 = EdgeDirection$.MODULE$.In();
        if (!(edgeDirection2 != null ? !((Object)edgeDirection2).equals(edgeDirection3) : edgeDirection3 != null)) {
            vertexRDD = this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.sendToDst(BoxesRunTime.boxToInteger((int)1));
                return BoxedUnit.UNIT;
            }, (JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$2, x$3) -> x$2 + x$3, TripletFields.None, ClassTag$.MODULE$.Int());
        } else {
            EdgeDirection edgeDirection4 = edgeDirection;
            EdgeDirection edgeDirection5 = EdgeDirection$.MODULE$.Out();
            vertexRDD = !(edgeDirection4 != null ? !((Object)edgeDirection4).equals(edgeDirection5) : edgeDirection5 != null) ? this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.sendToSrc(BoxesRunTime.boxToInteger((int)1));
                return BoxedUnit.UNIT;
            }, (JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$5, x$6) -> x$5 + x$6, TripletFields.None, ClassTag$.MODULE$.Int()) : this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
                GraphOps.$anonfun$degreesRDD$5(ctx);
                return BoxedUnit.UNIT;
            }, (JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$7, x$8) -> x$7 + x$8, TripletFields.None, ClassTag$.MODULE$.Int());
        }
        return vertexRDD;
    }

    public VertexRDD<long[]> collectNeighborIds(EdgeDirection edgeDirection) {
        VertexRDD vertexRDD;
        EdgeDirection edgeDirection2 = edgeDirection;
        EdgeDirection edgeDirection3 = EdgeDirection$.MODULE$.Either();
        if (!(edgeDirection2 != null ? !((Object)edgeDirection2).equals(edgeDirection3) : edgeDirection3 != null)) {
            vertexRDD = this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
                GraphOps.$anonfun$collectNeighborIds$1(ctx);
                return BoxedUnit.UNIT;
            }, (Function2 & Serializable & scala.Serializable)(x$9, x$10) -> (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(x$9)).$plus$plus((GenTraversableOnce)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(x$10)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Long.TYPE))), TripletFields.None, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)));
        } else {
            EdgeDirection edgeDirection4 = edgeDirection;
            EdgeDirection edgeDirection5 = EdgeDirection$.MODULE$.Out();
            if (!(edgeDirection4 != null ? !((Object)edgeDirection4).equals(edgeDirection5) : edgeDirection5 != null)) {
                vertexRDD = this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
                    ctx.sendToSrc(new long[]{ctx.dstId()});
                    return BoxedUnit.UNIT;
                }, (Function2 & Serializable & scala.Serializable)(x$11, x$12) -> (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(x$11)).$plus$plus((GenTraversableOnce)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(x$12)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Long.TYPE))), TripletFields.None, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)));
            } else {
                EdgeDirection edgeDirection6 = edgeDirection;
                EdgeDirection edgeDirection7 = EdgeDirection$.MODULE$.In();
                if (!(edgeDirection6 != null ? !((Object)edgeDirection6).equals(edgeDirection7) : edgeDirection7 != null)) {
                    vertexRDD = this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
                        ctx.sendToDst(new long[]{ctx.srcId()});
                        return BoxedUnit.UNIT;
                    }, (Function2 & Serializable & scala.Serializable)(x$13, x$14) -> (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(x$13)).$plus$plus((GenTraversableOnce)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(x$14)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Long.TYPE))), TripletFields.None, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)));
                } else {
                    throw new SparkException("It doesn't make sense to collect neighbor ids without a direction. (EdgeDirection.Both is not supported; use EdgeDirection.Either instead.)");
                }
            }
        }
        VertexRDD nbrs = vertexRDD;
        return this.graph.vertices().leftZipJoin(nbrs, (Function3 & Serializable & scala.Serializable)(vid, vdata, nbrsOpt) -> GraphOps.$anonfun$collectNeighborIds$7(BoxesRunTime.unboxToLong((Object)vid), vdata, nbrsOpt), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)));
    }

    public VertexRDD<Tuple2<Object, VD>[]> collectNeighbors(EdgeDirection edgeDirection) {
        VertexRDD vertexRDD;
        EdgeDirection edgeDirection2 = edgeDirection;
        EdgeDirection edgeDirection3 = EdgeDirection$.MODULE$.Either();
        EdgeDirection edgeDirection4 = edgeDirection2;
        if (!(edgeDirection3 != null ? !((Object)edgeDirection3).equals(edgeDirection4) : edgeDirection4 != null)) {
            vertexRDD = this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
                GraphOps.$anonfun$collectNeighbors$1(ctx);
                return BoxedUnit.UNIT;
            }, (Function2 & Serializable & scala.Serializable)(a, b) -> (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])a)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))), TripletFields.All, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
        } else {
            EdgeDirection edgeDirection5 = EdgeDirection$.MODULE$.In();
            EdgeDirection edgeDirection6 = edgeDirection2;
            if (!(edgeDirection5 != null ? !((Object)edgeDirection5).equals(edgeDirection6) : edgeDirection6 != null)) {
                vertexRDD = this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
                    ctx.sendToDst((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)ctx.srcId()), ctx.srcAttr())});
                    return BoxedUnit.UNIT;
                }, (Function2 & Serializable & scala.Serializable)(a, b) -> (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])a)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))), TripletFields.Src, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
            } else {
                EdgeDirection edgeDirection7 = EdgeDirection$.MODULE$.Out();
                EdgeDirection edgeDirection8 = edgeDirection2;
                if (!(edgeDirection7 != null ? !((Object)edgeDirection7).equals(edgeDirection8) : edgeDirection8 != null)) {
                    vertexRDD = this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
                        ctx.sendToSrc((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)ctx.dstId()), ctx.dstAttr())});
                        return BoxedUnit.UNIT;
                    }, (Function2 & Serializable & scala.Serializable)(a, b) -> (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])a)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))), TripletFields.Dst, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
                } else {
                    EdgeDirection edgeDirection9 = EdgeDirection$.MODULE$.Both();
                    EdgeDirection edgeDirection10 = edgeDirection2;
                    if (!(edgeDirection9 != null ? !((Object)edgeDirection9).equals(edgeDirection10) : edgeDirection10 != null)) {
                        throw new SparkException("collectEdges does not support EdgeDirection.Both. UseEdgeDirection.Either instead.");
                    }
                    throw new MatchError((Object)edgeDirection2);
                }
            }
        }
        VertexRDD nbrs = vertexRDD;
        return this.graph.vertices().leftJoin(nbrs, (Function3 & Serializable & scala.Serializable)(vid, vdata, nbrsOpt) -> GraphOps.$anonfun$collectNeighbors$7(BoxesRunTime.unboxToLong((Object)vid), vdata, nbrsOpt), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
    }

    public VertexRDD<Edge<ED>[]> collectEdges(EdgeDirection edgeDirection) {
        VertexRDD<Object> vertexRDD;
        EdgeDirection edgeDirection2 = edgeDirection;
        EdgeDirection edgeDirection3 = EdgeDirection$.MODULE$.Either();
        EdgeDirection edgeDirection4 = edgeDirection2;
        if (!(edgeDirection3 != null ? !((Object)edgeDirection3).equals(edgeDirection4) : edgeDirection4 != null)) {
            vertexRDD = this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
                GraphOps.$anonfun$collectEdges$1(ctx);
                return BoxedUnit.UNIT;
            }, (Function2 & Serializable & scala.Serializable)(a, b) -> (Edge[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])a)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Edge.class))), TripletFields.EdgeOnly, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Edge.class)));
        } else {
            EdgeDirection edgeDirection5 = EdgeDirection$.MODULE$.In();
            EdgeDirection edgeDirection6 = edgeDirection2;
            if (!(edgeDirection5 != null ? !((Object)edgeDirection5).equals(edgeDirection6) : edgeDirection6 != null)) {
                vertexRDD = this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
                    ctx.sendToDst((Object[])new Edge[]{new Edge(ctx.srcId(), ctx.dstId(), ctx.attr())});
                    return BoxedUnit.UNIT;
                }, (Function2 & Serializable & scala.Serializable)(a, b) -> (Edge[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])a)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Edge.class))), TripletFields.EdgeOnly, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Edge.class)));
            } else {
                EdgeDirection edgeDirection7 = EdgeDirection$.MODULE$.Out();
                EdgeDirection edgeDirection8 = edgeDirection2;
                if (!(edgeDirection7 != null ? !((Object)edgeDirection7).equals(edgeDirection8) : edgeDirection8 != null)) {
                    vertexRDD = this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
                        ctx.sendToSrc((Object[])new Edge[]{new Edge(ctx.srcId(), ctx.dstId(), ctx.attr())});
                        return BoxedUnit.UNIT;
                    }, (Function2 & Serializable & scala.Serializable)(a, b) -> (Edge[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])a)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Edge.class))), TripletFields.EdgeOnly, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Edge.class)));
                } else {
                    EdgeDirection edgeDirection9 = EdgeDirection$.MODULE$.Both();
                    EdgeDirection edgeDirection10 = edgeDirection2;
                    if (!(edgeDirection9 != null ? !((Object)edgeDirection9).equals(edgeDirection10) : edgeDirection10 != null)) {
                        throw new SparkException("collectEdges does not support EdgeDirection.Both. UseEdgeDirection.Either instead.");
                    }
                    throw new MatchError((Object)edgeDirection2);
                }
            }
        }
        return vertexRDD;
    }

    public Graph<VD, ED> removeSelfEdges() {
        return this.graph.subgraph((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)GraphOps.$anonfun$removeSelfEdges$1(e)), this.graph.subgraph$default$2());
    }

    public <U> Graph<VD, ED> joinVertices(RDD<Tuple2<Object, U>> table, Function3<Object, VD, U, VD> mapFunc, ClassTag<U> evidence$3) {
        Function3 & Serializable & scala.Serializable uf = (Function3 & Serializable & scala.Serializable)(id, data, o) -> GraphOps.$anonfun$joinVertices$1(mapFunc, BoxesRunTime.unboxToLong((Object)id), data, o);
        return this.graph.outerJoinVertices(table, uf, evidence$3, this.evidence$1, Predef.$eq$colon$eq$.MODULE$.tpEquals());
    }

    public <VD2, ED2> Graph<VD, ED> filter(Function1<Graph<VD, ED>, Graph<VD2, ED2>> preprocess, Function1<EdgeTriplet<VD2, ED2>, Object> epred, Function2<Object, VD2, Object> vpred, ClassTag<VD2> evidence$4, ClassTag<ED2> evidence$5) {
        return this.graph.mask(((Graph)preprocess.apply(this.graph)).subgraph(epred, vpred), evidence$4, evidence$5);
    }

    public <VD2, ED2> Function1<EdgeTriplet<VD2, ED2>, Object> filter$default$2() {
        return (Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)GraphOps.$anonfun$filter$default$2$1(x));
    }

    public <VD2, ED2> Function2<Object, VD2, Object> filter$default$3() {
        return (Function2 & Serializable & scala.Serializable)(v, d) -> BoxesRunTime.boxToBoolean((boolean)GraphOps.$anonfun$filter$default$3$1(BoxesRunTime.unboxToLong((Object)v), d));
    }

    public long pickRandomVertex() {
        double probability = 50.0 / (double)Graph$.MODULE$.graphToGraphOps(this.graph, this.evidence$1, this.evidence$2).numVertices();
        boolean found = false;
        long retVal = BoxesRunTime.unboxToLong(null);
        while (!found) {
            RDD selectedVertices = this.graph.vertices().flatMap((Function1 & Serializable & scala.Serializable)vidVvals -> Random$.MODULE$.nextDouble() < probability ? Option$.MODULE$.option2Iterable((Option)new Some((Object)BoxesRunTime.boxToLong((long)vidVvals._1$mcJ$sp()))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$), ClassTag$.MODULE$.apply(Long.TYPE));
            if (selectedVertices.count() <= 0L) continue;
            found = true;
            long[] collectedVertices = (long[])selectedVertices.collect();
            retVal = collectedVertices[Random$.MODULE$.nextInt(collectedVertices.length)];
        }
        return retVal;
    }

    public Graph<VD, ED> convertToCanonicalEdges(Function2<ED, ED, ED> mergeFunc) {
        RDD newEdges = RDD$.MODULE$.rddToPairRDDFunctions(this.graph.edges().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Edge edge = x0$1;
            Tuple2 tuple2 = edge.srcId() < edge.dstId() ? new Tuple2((Object)new Tuple2.mcJJ.sp(edge.srcId(), edge.dstId()), edge.attr()) : new Tuple2((Object)new Tuple2.mcJJ.sp(edge.dstId(), edge.srcId()), edge.attr());
            return tuple2;
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), this.evidence$2, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$)).reduceByKey(mergeFunc).map((Function1 & Serializable & scala.Serializable)e -> new Edge<Object>(((Tuple2)e._1())._1$mcJ$sp(), ((Tuple2)e._1())._2$mcJ$sp(), e._2()), ClassTag$.MODULE$.apply(Edge.class));
        return Graph$.MODULE$.apply(this.graph.vertices(), newEdges, Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), this.evidence$1, this.evidence$2);
    }

    public Function2<ED, ED, ED> convertToCanonicalEdges$default$1() {
        return (Function2 & Serializable & scala.Serializable)(e1, e2) -> e1;
    }

    public <A> Graph<VD, ED> pregel(A initialMsg, int maxIterations, EdgeDirection activeDirection, Function3<Object, VD, A, VD> vprog, Function1<EdgeTriplet<VD, ED>, Iterator<Tuple2<Object, A>>> sendMsg, Function2<A, A, A> mergeMsg, ClassTag<A> evidence$6) {
        return Pregel$.MODULE$.apply(this.graph, initialMsg, maxIterations, activeDirection, vprog, sendMsg, mergeMsg, this.evidence$1, this.evidence$2, evidence$6);
    }

    public <A> int pregel$default$2() {
        return Integer.MAX_VALUE;
    }

    public <A> EdgeDirection pregel$default$3() {
        return EdgeDirection$.MODULE$.Either();
    }

    public Graph<Object, Object> pageRank(double tol, double resetProb) {
        return PageRank$.MODULE$.runUntilConvergence(this.graph, tol, resetProb, this.evidence$1, this.evidence$2);
    }

    public double pageRank$default$2() {
        return 0.15;
    }

    public Graph<Object, Object> personalizedPageRank(long src, double tol, double resetProb) {
        return PageRank$.MODULE$.runUntilConvergenceWithOptions(this.graph, tol, resetProb, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)src)), this.evidence$1, this.evidence$2);
    }

    public double personalizedPageRank$default$3() {
        return 0.15;
    }

    public Graph<Vector, Object> staticParallelPersonalizedPageRank(long[] sources, int numIter, double resetProb) {
        return PageRank$.MODULE$.runParallelPersonalizedPageRank(this.graph, numIter, resetProb, sources, this.evidence$1, this.evidence$2);
    }

    public double staticParallelPersonalizedPageRank$default$3() {
        return 0.15;
    }

    public Graph<Object, Object> staticPersonalizedPageRank(long src, int numIter, double resetProb) {
        return PageRank$.MODULE$.runWithOptions(this.graph, numIter, resetProb, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)src)), this.evidence$1, this.evidence$2);
    }

    public double staticPersonalizedPageRank$default$3() {
        return 0.15;
    }

    public Graph<Object, Object> staticPageRank(int numIter, double resetProb) {
        return PageRank$.MODULE$.run(this.graph, numIter, resetProb, this.evidence$1, this.evidence$2);
    }

    public Graph<Object, Object> staticPageRank(int numIter, double resetProb, Graph<Object, Object> prePageRank) {
        return PageRank$.MODULE$.runWithOptionsWithPreviousPageRank(this.graph, numIter, resetProb, (Option<Object>)None$.MODULE$, prePageRank, this.evidence$1, this.evidence$2);
    }

    public double staticPageRank$default$2() {
        return 0.15;
    }

    public Graph<Object, ED> connectedComponents() {
        return ConnectedComponents$.MODULE$.run(this.graph, this.evidence$1, this.evidence$2);
    }

    public Graph<Object, ED> connectedComponents(int maxIterations) {
        return ConnectedComponents$.MODULE$.run(this.graph, maxIterations, this.evidence$1, this.evidence$2);
    }

    public Graph<Object, ED> triangleCount() {
        return TriangleCount$.MODULE$.run(this.graph, this.evidence$1, this.evidence$2);
    }

    public Graph<Object, ED> stronglyConnectedComponents(int numIter) {
        return StronglyConnectedComponents$.MODULE$.run(this.graph, numIter, this.evidence$1, this.evidence$2);
    }

    public static final /* synthetic */ void $anonfun$degreesRDD$5(EdgeContext ctx) {
        ctx.sendToSrc(BoxesRunTime.boxToInteger((int)1));
        ctx.sendToDst(BoxesRunTime.boxToInteger((int)1));
    }

    public static final /* synthetic */ void $anonfun$collectNeighborIds$1(EdgeContext ctx) {
        ctx.sendToSrc(new long[]{ctx.dstId()});
        ctx.sendToDst(new long[]{ctx.srcId()});
    }

    public static final /* synthetic */ long[] $anonfun$collectNeighborIds$7(long vid, Object vdata, Option nbrsOpt) {
        return (long[])nbrsOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> (long[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Long.TYPE)));
    }

    public static final /* synthetic */ void $anonfun$collectNeighbors$1(EdgeContext ctx) {
        ctx.sendToSrc((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)ctx.dstId()), ctx.dstAttr())});
        ctx.sendToDst((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)ctx.srcId()), ctx.srcAttr())});
    }

    public static final /* synthetic */ Tuple2[] $anonfun$collectNeighbors$7(long vid, Object vdata, Option nbrsOpt) {
        return (Tuple2[])nbrsOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> (Tuple2[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    public static final /* synthetic */ void $anonfun$collectEdges$1(EdgeContext ctx) {
        ctx.sendToSrc((Object[])new Edge[]{new Edge(ctx.srcId(), ctx.dstId(), ctx.attr())});
        ctx.sendToDst((Object[])new Edge[]{new Edge(ctx.srcId(), ctx.dstId(), ctx.attr())});
    }

    public static final /* synthetic */ boolean $anonfun$removeSelfEdges$1(EdgeTriplet e) {
        return e.srcId() != e.dstId();
    }

    public static final /* synthetic */ Object $anonfun$joinVertices$1(Function3 mapFunc$1, long id, Object data, Option o) {
        Object object;
        Option option = o;
        if (option instanceof Some) {
            Some some = (Some)option;
            Object u = some.value();
            object = mapFunc$1.apply((Object)BoxesRunTime.boxToLong((long)id), data, u);
        } else if (None$.MODULE$.equals(option)) {
            object = data;
        } else {
            throw new MatchError((Object)option);
        }
        return object;
    }

    public static final /* synthetic */ boolean $anonfun$filter$default$2$1(EdgeTriplet x) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$filter$default$3$1(long v, Object d) {
        return true;
    }

    public GraphOps(Graph<VD, ED> graph, ClassTag<VD> evidence$1, ClassTag<ED> evidence$2) {
        this.graph = graph;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
    }
}

