## RabbitMQ 3.13.1

RabbitMQ `3.13.1` is a maintenance release in the `3.13.x` [release series](https://www.rabbitmq.com/release-information).

Starting June 1st, 2024, community support for this series will only be provided to [regularly contributing users](https://github.com/rabbitmq/rabbitmq-server/blob/main/COMMUNITY_SUPPORT.md) and those
who hold a valid [commercial support license](https://tanzu.vmware.com/rabbitmq/oss).

Please refer to the upgrade section from the [3.13.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.13.0)
if upgrading from a version prior to 3.13.0.

This release requires Erlang 26 and supports Erlang versions up to `26.2.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/docs/which-erlang) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.13.0, RabbitMQ requires Erlang 26. Nodes **will fail to start** on older Erlang releases.

Users upgrading from 3.12.x (or older releases) on Erlang 25 to 3.13.x on Erlang 26
(both RabbitMQ *and* Erlang are upgraded at the same time) **must** consult
the [v3.12.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.0) and [v3.13.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.13.0) first.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.13.x/release-notes).


### Core Broker

#### Bug Fixes

 * Classic queue v2 message store compaction could fail behind under high enough load,
   significantly increasing node's disk space footprint.

   GitHub issues: [#10696](https://github.com/rabbitmq/rabbitmq-server/pull/10696), [#10681](https://github.com/rabbitmq/rabbitmq-server/discussions/10681)

 * Improved quorum queue safety in mixed version clusters.

   GitHub issue: [#10664](https://github.com/rabbitmq/rabbitmq-server/pull/10664)

 * When Khepri was enabled and virtual host recovery failed, subsequent recovery
   attempts also failed.

   GitHub issue: [#10742](https://github.com/rabbitmq/rabbitmq-server/pull/10742)

 * Messages published without any headers set on them did not have a header property
   set on them. This change compared to 3.12.x was not intentional.

   GitHub issues: [#10623](https://github.com/rabbitmq/rabbitmq-server/pull/10623), [#10620](https://github.com/rabbitmq/rabbitmq-server/discussions/10620)

 * Free disk space monitor on Windows ran into an exception if external call
   to `win32sysinfo.exe` timed out.

   GitHub issue: [#10597](https://github.com/rabbitmq/rabbitmq-server/issues/10597)

#### Enhancements

 * `channel_max_per_node` is a new per-node limit that allows to put a cap on the number
   of AMQP 0-9-1 channels that can be concurrently open by all clients connected to a node:

   ``` ini
   # rabbitmq.conf
   channel_max_per_node = 5000
   ```

   This is a guardrail mean to protect nodes from [application-level channel leaks](https://www.rabbitmq.com/docs/channels#channel-leaks).

   Contributed by @illotum (AWS).

   GitHub issue: [#10754](https://github.com/rabbitmq/rabbitmq-server/pull/10754)


### Stream Plugin

#### Bug Fixes

 * Avoids a Windows-specific stream log corruption that affected some deployments.

   GitHub issue: [#10822](https://github.com/rabbitmq/rabbitmq-server/pull/10822)

 * When a [super stream](https://www.rabbitmq.com/blog/2022/07/13/rabbitmq-3-11-feature-preview-super-streams) cannot be created because of a duplicate partition name,
   a more informative error message is now used.

   GitHub issue: [#10535](https://github.com/rabbitmq/rabbitmq-server/issues/10535)


### CLI Tools

#### Bug Fixes

 * `rabbitmq-plugins list --formatter=json --silent` will no longer emit any warnings
   when some of the plugins in the [enabled plugins file](https://www.rabbitmq.com/docs/plugins#enabled-plugins-file) are missing.

   Contributed by @Ayanda-D.

   GitHub issue: [#10870](https://github.com/rabbitmq/rabbitmq-server/pull/10870)


### OAuth 2 Plugin

#### Bug Fixes

 * Configuring a JWKS URL without specifying a CA certificate resulted
   in an exception with Erlang 26's TLS implementation.

   GitHub issue: [#8547](https://github.com/rabbitmq/rabbitmq-server/issues/8547)


### Management Plugin

#### Bug Fixes

 * Set default `sort` query parameter value for better compatibility with an external
   Prometheus scraper. Note that the [built-in Prometheus plugin](https://www.rabbitmq.com/docs/prometheus)
   is the recommended way of [monitoring](https://www.rabbitmq.com/docs/monitoring) RabbitMQ using Prometheus-compatible tools.

   GitHub issue: [#10610](https://github.com/rabbitmq/rabbitmq-server/pull/10610)

 * When a tab (Connections, Queues and Streams, etc) is switched, a table configuration pane
   from the previously selected tab is now hidden.

   Contributed by @ackepenek.

   GitHub issue: [#10799](https://github.com/rabbitmq/rabbitmq-server/pull/10799)

#### Enhancements

 * `GET /api/queues/{vhost}/{name}` now supports `enable_queue_totals` as well as `disable_stats`.
   This combination of query parameters can be used to retrieve message counters while
   greatly reducing the number of metrics returned by the endpoints.

   Contributed by @aaron-seo (AWS).

   GitHub issue: [#10839](https://github.com/rabbitmq/rabbitmq-server/pull/10839)


### Federation Plugin

#### Enhancements

 * Exchange federation now can be configured to use a custom queue type for their internal buffers.

   To use a quorum queue, set the `queue-type` federation policy key to `quorum`.

   GitHub issues: [#4683](https://github.com/rabbitmq/rabbitmq-server/issues/4683), [#10663](https://github.com/rabbitmq/rabbitmq-server/pull/10663)

 * `rabbitmq_federation_running_link_count` is a new metric provided via Prometheus.

   GitHub issue: [#10345](https://github.com/rabbitmq/rabbitmq-server/issues/10345)


### Dependency Changes

 * `osiris` was updated to [`1.8.1`](https://github.com/rabbitmq/osiris/releases)
 * `khepri` was upgraded to [`0.13.0`](https://github.com/rabbitmq/khepri/releases)
 * `cowboy` was updated to [`2.12.0`](https://ninenines.eu/docs/en/cowboy/2.12/guide/migrating_from_2.11/)

## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.13.1.tar.xz`
instead of the source tarball produced by GitHub.
