# Contributing to the Checker Framework

Thank you for contributing to the Checker Framework!  This project is a
community effort of [more than 110
developers](https://checkerframework.org/manual/#credits), plus countless
more people who have contributed bug reports and feature suggestions.  We
couldn't do it without your help.


## Reporting bugs

Please see the [bug
reporting](https://checkerframework.org/manual/#reporting-bugs) section of
the Checker Framework manual.

If the documentation is incorrect, incomplete, or confusing, that is a
bug, and we want to fix it.  Please report it.


## Submitting changes

Please see the [pull
requests](https://checkerframework.org/manual/developer-manual.html#pull-requests)
section of the Developer Manual.

Submit changes to the annotated JDK at https://github.com/typetools/jdk/pulls .
Annotations for other libraries can be contributed as stub files in this
repository, in a fork of the library in https://github.com/typetools/, or
in the library's own repository.

Do you want to contribute to the project, but you are not sure what issue
to fix or what feature to add?  Use the tool in your daily work, and when
you encounter a limitation that bothers you, fix that one.  The ["help
wanted"](https://github.com/typetools/checker-framework/issues?q=is%3Aissue+is%3Aopen+label%3A%22help+wanted%22)
label marks issues that require less deep knowledge and may be appropriate
for a newcomer to the codebase.


## License

By contributing, you agree that your contributions will be licensed under the
existing [license](LICENSE.txt), usually GPL2 or MIT License.


## Code of conduct

When interacting with other people, please abide by the [Contributor
Covenant](https://www.contributor-covenant.org/version/2/1/code_of_conduct).
