/*
 * dis_type.h --- types for distance package for Natch
 *
 * Copyright (c) 2000, 2001 by Pascal Wassong All Rights Reserved.
 *
 * Time-stamp: <2001-04-16 18:16:36 Pascal>
 *
 * This file is part of Natch.
 *
 * Natch is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Natch is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


#ifndef	DIS_TYPE_H
#define	DIS_TYPE_H

#define	NUMBER_OF_ORIGIN_SQUARES	64
#define	NUMBER_OF_DESTINATION_SQUARES	64
#define	NUMBER_OF_COLORS		2 /* Black color currently only used for Pawns */
#define	NUMBER_OF_BYTES_PER_INFO	2 /* Not consecutive. Only the 1st is used */

#define	SIZE_ECHIQUIER	(NUMBER_OF_DESTINATION_SQUARES * NUMBER_OF_BYTES_PER_INFO)
#define	SIZE_PIECE	(NUMBER_OF_ORIGIN_SQUARES * SIZE_ECHIQUIER * NUMBER_OF_COLORS)

#define	INFINI		(100)

typedef	unsigned char	distance_t ;

typedef	distance_t	distance_tables_t[ 6 * SIZE_PIECE ];

#endif /* DIS_TYPE_H */

