.TH  CHSEQR 1 "November 2006" " LAPACK driver routine (version 3.1) " " LAPACK driver routine (version 3.1) " 
.SH NAME
CHSEQR - compute the eigenvalues of a Hessenberg matrix H  and, optionally, the matrices T and Z from the Schur decomposition  H = Z T Z**H, where T is an upper triangular matrix (the  Schur form), and Z is the unitary matrix of Schur vectors
.SH SYNOPSIS
.TP 19
SUBROUTINE CHSEQR(
JOB, COMPZ, N, ILO, IHI, H, LDH, W, Z, LDZ,
WORK, LWORK, INFO )
.TP 19
.ti +4
INTEGER
IHI, ILO, INFO, LDH, LDZ, LWORK, N
.TP 19
.ti +4
CHARACTER
COMPZ, JOB
.TP 19
.ti +4
COMPLEX
H( LDH, * ), W( * ), WORK( * ), Z( LDZ, * )
.SH PURPOSE
   CHSEQR computes the eigenvalues of a Hessenberg matrix H
   and, optionally, the matrices T and Z from the Schur decomposition
   H = Z T Z**H, where T is an upper triangular matrix (the
   Schur form), and Z is the unitary matrix of Schur vectors.

   Optionally Z may be postmultiplied into an input unitary
   matrix Q so that this routine can give the Schur factorization
   of a matrix A which has been reduced to the Hessenberg form H
   by the unitary matrix Q:  A = Q*H*Q**H = (QZ)*H*(QZ)**H.

.SH ARGUMENTS
.TP 6
JOB   (input) CHARACTER*1
= \(aqE\(aq:  compute eigenvalues only;
.br
= \(aqS\(aq:  compute eigenvalues and the Schur form T.

COMPZ (input) CHARACTER*1
.br
= \(aqN\(aq:  no Schur vectors are computed;
.br
= \(aqI\(aq:  Z is initialized to the unit matrix and the matrix Z
of Schur vectors of H is returned;
= \(aqV\(aq:  Z must contain an unitary matrix Q on entry, and
the product Q*Z is returned.
.TP 6
N     (input) INTEGER
The order of the matrix H.  N .GE. 0.
.TP 6
ILO   (input) INTEGER
IHI   (input) INTEGER
It is assumed that H is already upper triangular in rows
and columns 1:ILO-1 and IHI+1:N. ILO and IHI are normally
set by a previous call to CGEBAL, and then passed to CGEHRD
when the matrix output by CGEBAL is reduced to Hessenberg
form. Otherwise ILO and IHI should be set to 1 and N
respectively.  If N.GT.0, then 1.LE.ILO.LE.IHI.LE.N.
If N = 0, then ILO = 1 and IHI = 0.
.TP 6
H     (input/output) COMPLEX array, dimension (LDH,N)
On entry, the upper Hessenberg matrix H.
On exit, if INFO = 0 and JOB = \(aqS\(aq, H contains the upper
triangular matrix T from the Schur decomposition (the
Schur form). If INFO = 0 and JOB = \(aqE\(aq, the contents of
H are unspecified on exit.  (The output value of H when
INFO.GT.0 is given under the description of INFO below.)

Unlike earlier versions of CHSEQR, this subroutine may
explicitly H(i,j) = 0 for i.GT.j and j = 1, 2, ... ILO-1
or j = IHI+1, IHI+2, ... N.
.TP 6
LDH   (input) INTEGER
The leading dimension of the array H. LDH .GE. max(1,N).
.TP 9
W        (output) COMPLEX array, dimension (N)
The computed eigenvalues. If JOB = \(aqS\(aq, the eigenvalues are
stored in the same order as on the diagonal of the Schur
form returned in H, with W(i) = H(i,i).
.TP 6
Z     (input/output) COMPLEX array, dimension (LDZ,N)
If COMPZ = \(aqN\(aq, Z is not referenced.
If COMPZ = \(aqI\(aq, on entry Z need not be set and on exit,
if INFO = 0, Z contains the unitary matrix Z of the Schur
vectors of H.  If COMPZ = \(aqV\(aq, on entry Z must contain an
N-by-N matrix Q, which is assumed to be equal to the unit
matrix except for the submatrix Z(ILO:IHI,ILO:IHI). On exit,
if INFO = 0, Z contains Q*Z.
Normally Q is the unitary matrix generated by CUNGHR
after the call to CGEHRD which formed the Hessenberg matrix
H. (The output value of Z when INFO.GT.0 is given under
the description of INFO below.)
.TP 6
LDZ   (input) INTEGER
The leading dimension of the array Z.  if COMPZ = \(aqI\(aq or
COMPZ = \(aqV\(aq, then LDZ.GE.MAX(1,N).  Otherwize, LDZ.GE.1.
.TP 6
WORK  (workspace/output) COMPLEX array, dimension (LWORK)
On exit, if INFO = 0, WORK(1) returns an estimate of
the optimal value for LWORK.

LWORK (input) INTEGER
The dimension of the array WORK.  LWORK .GE. max(1,N)
is sufficient, but LWORK typically as large as 6*N may
be required for optimal performance.  A workspace query
to determine the optimal workspace size is recommended.

If LWORK = -1, then CHSEQR does a workspace query.
In this case, CHSEQR checks the input parameters and
estimates the optimal workspace size for the given
values of N, ILO and IHI.  The estimate is returned
in WORK(1).  No error message related to LWORK is
issued by XERBLA.  Neither H nor Z are accessed.
.TP 6
INFO  (output) INTEGER
=  0:  successful exit
.br
.LT. 0:  if INFO = -i, the i-th argument had an illegal
value
.GT. 0:  if INFO = i, CHSEQR failed to compute all of
.br
the eigenvalues.  Elements 1:ilo-1 and i+1:n of WR
and WI contain those eigenvalues which have been
successfully computed.  (Failures are rare.)

If INFO .GT. 0 and JOB = \(aqE\(aq, then on exit, the
remaining unconverged eigenvalues are the eigen-
values of the upper Hessenberg matrix rows and
columns ILO through INFO of the final, output
value of H.

If INFO .GT. 0 and JOB   = \(aqS\(aq, then on exit
.TP 5
(*)  (initial value of H)*U  = U*(final value of H)

where U is a unitary matrix.  The final
value of  H is upper Hessenberg and triangular in
rows and columns INFO+1 through IHI.

If INFO .GT. 0 and COMPZ = \(aqV\(aq, then on exit

(final value of Z)  =  (initial value of Z)*U

where U is the unitary matrix in (*) (regard-
less of the value of JOB.)

If INFO .GT. 0 and COMPZ = \(aqI\(aq, then on exit
(final value of Z)  = U
where U is the unitary matrix in (*) (regard-
less of the value of JOB.)

If INFO .GT. 0 and COMPZ = \(aqN\(aq, then Z is not
accessed.
